/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.palette;

import com.android.tools.adtui.ImageUtils;
import com.android.tools.idea.common.surface.DesignSurface;
import com.android.tools.idea.common.surface.SceneView;
import com.android.tools.idea.uibuilder.model.DnDTransferComponent;
import com.android.tools.idea.uibuilder.model.DnDTransferItem;
import com.android.tools.idea.uibuilder.model.ItemTransferable;
import com.android.tools.idea.uibuilder.palette.DependencyManager;
import com.android.tools.idea.uibuilder.palette.IconPreviewFactory;
import com.android.tools.idea.uibuilder.palette.Palette;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.image.BufferedImage;
import java.util.function.Supplier;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemTransferHandler
extends TransferHandler {
    private final DesignSurface myDesignSurface;
    private final DependencyManager myDependencyManager;
    private final Supplier<Palette.Item> myItemSupplier;
    private final IconPreviewFactory myIconFactory;

    public ItemTransferHandler(@NotNull DesignSurface designSurface, @NotNull DependencyManager dependencyManager, @NotNull Supplier<Palette.Item> itemSupplier, @NotNull IconPreviewFactory iconFactory) {
        if (designSurface == null) {
            ItemTransferHandler.$$$reportNull$$$0(0);
        }
        if (dependencyManager == null) {
            ItemTransferHandler.$$$reportNull$$$0(1);
        }
        if (itemSupplier == null) {
            ItemTransferHandler.$$$reportNull$$$0(2);
        }
        if (iconFactory == null) {
            ItemTransferHandler.$$$reportNull$$$0(3);
        }
        this.myDesignSurface = designSurface;
        this.myDependencyManager = dependencyManager;
        this.myItemSupplier = itemSupplier;
        this.myIconFactory = iconFactory;
    }

    @Override
    public int getSourceActions(@NotNull JComponent component2) {
        if (component2 == null) {
            ItemTransferHandler.$$$reportNull$$$0(4);
        }
        return 3;
    }

    @Override
    @Nullable
    protected Transferable createTransferable(@NotNull JComponent component2) {
        Dimension size;
        BufferedImage image;
        Palette.Item item;
        if (component2 == null) {
            ItemTransferHandler.$$$reportNull$$$0(5);
        }
        if ((item = this.myItemSupplier.get()) == null) {
            return null;
        }
        SceneView sceneView = this.myDesignSurface.getCurrentSceneView();
        if (sceneView == null) {
            return null;
        }
        BufferedImage bufferedImage = image = this.myDependencyManager.needsLibraryLoad(item) ? null : this.myIconFactory.renderDragImage(item, sceneView);
        if (image != null) {
            size = new Dimension(image.getWidth(), image.getHeight());
            double scale = this.myDesignSurface.getScale();
            image = ImageUtils.scale((BufferedImage)image, (double)scale);
        } else {
            Icon icon = item.getIcon();
            image = new BufferedImage(icon.getIconWidth(), icon.getIconHeight(), 2);
            Graphics2D g2 = (Graphics2D)image.getGraphics();
            icon.paintIcon(component2, g2, 0, 0);
            g2.dispose();
            double scale = this.myDesignSurface.getScale();
            size = new Dimension((int)((double)image.getWidth() / scale), (int)((double)image.getHeight() / scale));
        }
        this.setDragImage(image);
        this.setDragImageOffset(new Point(-image.getWidth() / 2, -image.getHeight() / 2));
        DnDTransferComponent dndComponent = new DnDTransferComponent(item.getTagName(), item.getXml(), size.width, size.height);
        return new ItemTransferable(new DnDTransferItem(dndComponent));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designSurface";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dependencyManager";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemSupplier";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "iconFactory";
                break;
            }
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/android/tools/idea/uibuilder/palette/ItemTransferHandler";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "getSourceActions";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "createTransferable";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

