/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.property.editors;

import com.android.resources.ResourceType;
import com.android.tools.adtui.ptable.PTable;
import com.android.tools.idea.ui.resourcechooser.ChooseResourceDialog;
import com.android.tools.idea.uibuilder.handlers.ViewEditorImpl;
import com.android.tools.idea.uibuilder.property.NlProperty;
import com.android.tools.idea.uibuilder.property.editors.NlComponentEditor;
import com.android.tools.idea.uibuilder.property.editors.PropertyDesignState;
import com.google.common.collect.ImmutableSet;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.impl.ActionButton;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiClass;
import com.intellij.util.ArrayUtil;
import icons.AndroidIcons;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Locale;
import java.util.Set;
import javax.swing.BoxLayout;
import javax.swing.JPanel;
import org.jetbrains.android.dom.AndroidDomUtil;
import org.jetbrains.android.dom.attrs.AttributeDefinition;
import org.jetbrains.android.dom.attrs.AttributeFormat;
import org.jetbrains.android.uipreview.ChooseClassDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BrowsePanel
extends JPanel {
    private final Context myContext;
    private final ActionButton myBrowseButton;
    private final ActionButton myDesignButton;
    private PropertyDesignState myDesignState;

    public BrowsePanel() {
        this((Context)null, true);
    }

    public BrowsePanel(@Nullable Context context, boolean showDesignButton) {
        this.myContext = context;
        this.myBrowseButton = BrowsePanel.createActionButton(new BrowseAction(context));
        this.myDesignButton = showDesignButton ? BrowsePanel.createActionButton(this.createDesignAction()) : null;
        this.setLayout(new BoxLayout(this, 0));
        this.add((Component)this.myBrowseButton);
        this.myBrowseButton.setFocusable(true);
        if (this.myDesignButton != null) {
            this.add((Component)this.myDesignButton);
            this.myDesignButton.setFocusable(true);
        }
    }

    public void setDesignState(@NotNull PropertyDesignState designState) {
        if (designState == null) {
            BrowsePanel.$$$reportNull$$$0(0);
        }
        this.myDesignState = designState;
    }

    public void setProperty(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(1);
        }
        this.myBrowseButton.setVisible(BrowsePanel.hasBrowseDialog(property));
    }

    public void mousePressed(@NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (event == null) {
            BrowsePanel.$$$reportNull$$$0(2);
        }
        if (rectRightColumn == null) {
            BrowsePanel.$$$reportNull$$$0(3);
        }
        if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth()) {
            this.myDesignButton.click();
        } else if ((double)event.getX() > rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth()) {
            this.myBrowseButton.click();
        }
    }

    public void mouseMoved(@NotNull PTable table, @NotNull MouseEvent event, @NotNull Rectangle rectRightColumn) {
        if (table == null) {
            BrowsePanel.$$$reportNull$$$0(4);
        }
        if (event == null) {
            BrowsePanel.$$$reportNull$$$0(5);
        }
        if (rectRightColumn == null) {
            BrowsePanel.$$$reportNull$$$0(6);
        }
        table.setExpandableItemsEnabled((double)event.getX() < rectRightColumn.getX() + rectRightColumn.getWidth() - (double)this.getDesignButtonWidth() - (double)this.getBrowseButtonWidth());
    }

    private int getDesignButtonWidth() {
        return this.myDesignButton != null ? this.myDesignButton.getWidth() : 0;
    }

    private int getBrowseButtonWidth() {
        return this.myBrowseButton.isVisible() ? this.myBrowseButton.getWidth() : 0;
    }

    @NotNull
    private static ActionButton createActionButton(@NotNull AnAction action) {
        if (action == null) {
            BrowsePanel.$$$reportNull$$$0(7);
        }
        ActionButton actionButton = new ActionButton(action, action.getTemplatePresentation().clone(), "unknown", ActionToolbar.NAVBAR_MINIMUM_BUTTON_SIZE);
        if (actionButton == null) {
            BrowsePanel.$$$reportNull$$$0(8);
        }
        return actionButton;
    }

    private static ChooseResourceDialog showResourceChooser(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(9);
        }
        Module module = property.getModel().getModule();
        EnumSet<ResourceType> types = BrowsePanel.getResourceTypes(property);
        ResourceType defaultResourceType = BrowsePanel.getDefaultResourceType(property.getName());
        return ChooseResourceDialog.builder().setModule(module).setTypes(types).setCurrentValue(property.getValue()).setTag(property.getTag()).setDefaultType(defaultResourceType).build();
    }

    @Nullable
    private static String showClassChooser(@NotNull NlProperty property, boolean includeSystemClasses, @NotNull Set<String> classes) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(10);
        }
        if (classes == null) {
            BrowsePanel.$$$reportNull$$$0(11);
        }
        Condition psiFilter = psiClass -> {
            if (ViewEditorImpl.isRestricted(psiClass)) {
                return false;
            }
            if (includeSystemClasses) {
                return true;
            }
            String qualifiedName = psiClass.getQualifiedName();
            if (qualifiedName == null) {
                return false;
            }
            return !qualifiedName.startsWith("android.") && !qualifiedName.startsWith("android.support.");
        };
        return ChooseClassDialog.openDialog(property.getModel().getModule(), "Classes", true, (Condition<PsiClass>)psiFilter, ArrayUtil.toStringArray(classes));
    }

    public static boolean hasBrowseDialog(@NotNull NlProperty property) {
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(12);
        }
        return property.getName().equals("class") || property.getName().equals("name") || !BrowsePanel.getResourceTypes(property).isEmpty();
    }

    @Nullable
    public static String showBrowseDialog(@NotNull NlProperty property) {
        ChooseResourceDialog dialog;
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(13);
        }
        if (property.getName().equals("class")) {
            return BrowsePanel.showClassChooser(property, false, Collections.singleton("android.view.View"));
        }
        if (property.getName().equals("name")) {
            return BrowsePanel.showClassChooser(property, true, (Set<String>)ImmutableSet.of((Object)"android.app.Fragment", (Object)"android.support.v4.app.Fragment"));
        }
        if (!BrowsePanel.getResourceTypes(property).isEmpty() && (dialog = BrowsePanel.showResourceChooser(property)).showAndGet()) {
            return dialog.getResourceName();
        }
        return null;
    }

    @NotNull
    public static EnumSet<ResourceType> getResourceTypes(@NotNull NlProperty property) {
        String propertyName;
        if (property == null) {
            BrowsePanel.$$$reportNull$$$0(14);
        }
        if ((propertyName = property.getName()).equals("id")) {
            EnumSet<ResourceType> enumSet = EnumSet.noneOf(ResourceType.class);
            if (enumSet == null) {
                BrowsePanel.$$$reportNull$$$0(15);
            }
            return enumSet;
        }
        AttributeDefinition definition = property.getDefinition();
        Set<AttributeFormat> formats = definition != null ? definition.getFormats() : EnumSet.allOf(AttributeFormat.class);
        Collection<ResourceType> types = AndroidDomUtil.getSpecialResourceTypes(propertyName);
        EnumSet<ResourceType> enumSet = types.isEmpty() ? AttributeFormat.convertTypes(formats) : EnumSet.copyOf(types);
        if (enumSet == null) {
            BrowsePanel.$$$reportNull$$$0(16);
        }
        return enumSet;
    }

    @Nullable
    public static ResourceType getDefaultResourceType(@NotNull String propertyName) {
        String lowerCaseProperty;
        if (propertyName == null) {
            BrowsePanel.$$$reportNull$$$0(17);
        }
        if ((lowerCaseProperty = propertyName.toLowerCase(Locale.ENGLISH)).contains("color") || lowerCaseProperty.contains("tint")) {
            return ResourceType.COLOR;
        }
        if (lowerCaseProperty.contains("drawable") || propertyName.equals("src") || propertyName.equals("srcCompat")) {
            return ResourceType.DRAWABLE;
        }
        return null;
    }

    private AnAction createDesignAction() {
        return new AnAction(){

            public void update(AnActionEvent event) {
                Presentation presentation = event.getPresentation();
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        presentation.setIcon(AndroidIcons.NeleIcons.DesignProperty);
                        presentation.setText("Specify Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        presentation.setIcon(AllIcons.Actions.Delete);
                        presentation.setText("Remove this Design Property");
                        presentation.setVisible(true);
                        presentation.setEnabled(true);
                        break;
                    }
                    default: {
                        presentation.setIcon(null);
                        presentation.setText(null);
                        presentation.setVisible(false);
                        presentation.setEnabled(false);
                    }
                }
            }

            public void actionPerformed(AnActionEvent event) {
                if (BrowsePanel.this.myContext == null) {
                    return;
                }
                switch (BrowsePanel.this.myDesignState) {
                    case MISSING_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.addDesignProperty();
                        break;
                    }
                    case IS_REMOVABLE_DESIGN_PROPERTY: {
                        BrowsePanel.this.myContext.removeDesignProperty();
                        break;
                    }
                }
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "designState";
                break;
            }
            case 1: 
            case 9: 
            case 10: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "property";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rectRightColumn";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "table";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "action";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "propertyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/property/editors/BrowsePanel";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createActionButton";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getResourceTypes";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setDesignState";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setProperty";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "mousePressed";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "mouseMoved";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createActionButton";
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "showResourceChooser";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "showClassChooser";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "hasBrowseDialog";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "showBrowseDialog";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getResourceTypes";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getDefaultResourceType";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class BrowseAction
    extends AnAction {
        private final Context myContext;

        private BrowseAction(@Nullable Context context) {
            this.myContext = context;
            Presentation presentation = this.getTemplatePresentation();
            presentation.setIcon(AllIcons.General.Ellipsis);
            presentation.setText("Pick a Resource");
        }

        public void actionPerformed(AnActionEvent event) {
            if (this.myContext == null) {
                return;
            }
            NlProperty property = this.myContext.getProperty();
            if (property == null) {
                return;
            }
            String newValue = BrowsePanel.showBrowseDialog(property);
            this.myContext.cancelEditing();
            if (newValue != null) {
                this.myContext.stopEditing(newValue);
            }
        }
    }

    public static class ContextDelegate
    implements Context {
        private NlComponentEditor myEditor;

        @Override
        @Nullable
        public NlProperty getProperty() {
            return this.myEditor != null ? this.myEditor.getProperty() : null;
        }

        public void setEditor(@NotNull NlComponentEditor editor) {
            if (editor == null) {
                ContextDelegate.$$$reportNull$$$0(0);
            }
            this.myEditor = editor;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "editor", "com/android/tools/idea/uibuilder/property/editors/BrowsePanel$ContextDelegate", "setEditor"));
        }
    }

    public static interface Context {
        @Nullable
        public NlProperty getProperty();

        default public void cancelEditing() {
        }

        default public void stopEditing(@Nullable Object newValue) {
            NlProperty property = this.getProperty();
            if (property != null) {
                property.setValue(newValue);
            }
        }

        default public void addDesignProperty() {
            throw new UnsupportedOperationException();
        }

        default public void removeDesignProperty() {
            throw new UnsupportedOperationException();
        }
    }
}

