/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.uibuilder.structure;

import com.android.tools.idea.common.command.NlWriteCommandAction;
import com.android.tools.idea.common.lint.LintAnnotationsModel;
import com.android.tools.idea.common.model.NlComponent;
import com.android.tools.idea.common.model.NlModel;
import com.android.tools.idea.common.scene.SceneManager;
import com.android.tools.idea.uibuilder.error.IssuePanel;
import com.android.utils.SdkUtils;
import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.openapi.ui.popup.Balloon;
import com.intellij.ui.HintHint;
import com.intellij.ui.JBColor;
import com.intellij.ui.LightweightHint;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NlTreeBadgeHandler {
    private static final int BADGE_MARGIN = 5;
    private static final int MESSAGE_WIDTH = 50;
    private static final int BADGE_ICON = 0;
    private static final int LOCK_ICON = 1;
    private static final String TOGGLE_LOCK_MESSAGE = "Toggle Tool Locking";
    private final BadgeMouseMotionListener myBadgeMouseMotionListener = new BadgeMouseMotionListener();
    private final JBLabel myHintLabel = new JBLabel();
    private final Point myHintLocation = new Point();
    @Nullable
    private LightweightHint myTooltipHint;
    @Nullable
    private TreePath myHoveredPath;
    private int myHoveredIcon = 0;
    private NlComponent myHoveredComponent;
    @Nullable
    private NlModel myNlModel;
    private int myBadgeX;
    private int myLockIconX;
    @Nullable
    private IssuePanel myIssuePanel;

    public void setNlModel(@Nullable NlModel nlModel) {
        this.myNlModel = nlModel;
    }

    public void setIssuePanel(@Nullable IssuePanel issuePanel) {
        this.myIssuePanel = issuePanel;
    }

    public void paintBadges(@NotNull Graphics2D g, @NotNull JTree tree) {
        if (g == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(0);
        }
        if (tree == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(1);
        }
        this.myBadgeX = Integer.MAX_VALUE;
        if (this.myNlModel == null) {
            return;
        }
        LintAnnotationsModel lintAnnotationsModel = this.myNlModel.getLintAnnotationsModel();
        for (int i = 0; i < tree.getRowCount(); ++i) {
            Icon firstIcon;
            TreePath path = tree.getPathForRow(i);
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) continue;
            NlComponent component2 = (NlComponent)last;
            Rectangle pathBounds = tree.getPathBounds(path);
            if (pathBounds == null) continue;
            int y = pathBounds.y + pathBounds.height / 2;
            if (lintAnnotationsModel == null || (firstIcon = lintAnnotationsModel.getIssueIcon(component2, false, tree.isRowSelected(i) && tree.hasFocus())) == null) continue;
            int x = tree.getWidth() - firstIcon.getIconWidth() - 5;
            int iy = y - firstIcon.getIconHeight() / 2;
            firstIcon.paintIcon(tree, g, x, iy);
            this.myBadgeX = Math.min(x, this.myBadgeX);
        }
    }

    private void showErrorTooltip(@NotNull JTree tree, @NotNull TreePath path, @NotNull String message) {
        Window activeFrame;
        if (tree == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(2);
        }
        if (path == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(3);
        }
        if (message == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(4);
        }
        if ((activeFrame = UIUtil.getWindow((Component)tree)) == null) {
            return;
        }
        Rectangle bounds = tree.getPathBounds(path);
        if (bounds != null) {
            HintHint hint = this.createHint(tree);
            message = SdkUtils.wrap((String)message, (int)50, null);
            message = HintUtil.prepareHintText((String)message, (HintHint)hint);
            this.myHintLabel.setText(message);
            this.myHintLocation.x = tree.getWidth() - 5;
            this.myHintLocation.y = bounds.y + bounds.height / 2;
            hint = this.ensureHintCanBeDisplayed(hint, message, tree, activeFrame);
            if (hint == null) {
                return;
            }
            if (this.myTooltipHint == null) {
                this.myTooltipHint = new LightweightHint((JComponent)this.myHintLabel);
            }
            this.myTooltipHint.show((JComponent)tree, this.myHintLocation.x, this.myHintLocation.y, (JComponent)tree, hint);
        }
    }

    @Nullable
    private HintHint ensureHintCanBeDisplayed(@NotNull HintHint hint, @NotNull String message, @NotNull Component component2, @NotNull Window activeFrame) {
        if (hint == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(5);
        }
        if (message == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(6);
        }
        if (component2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(7);
        }
        if (activeFrame == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(8);
        }
        int labelWidth = this.myHintLabel.getFontMetrics(this.myHintLabel.getFont()).stringWidth(message.substring(0, Math.min(message.length(), 50)));
        int labelRight = component2.getLocationOnScreen().x + component2.getWidth() + labelWidth;
        int frameRight = activeFrame.getLocationOnScreen().x + activeFrame.getWidth();
        if (activeFrame.getWidth() < labelWidth) {
            return null;
        }
        if (frameRight < labelRight) {
            this.myHintLocation.x = 5;
            hint.setPreferredPosition(Balloon.Position.below);
        }
        return hint;
    }

    private HintHint createHint(@NotNull Component component2) {
        if (component2 == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(9);
        }
        return new HintHint(component2, this.myHintLocation).setPreferredPosition(Balloon.Position.atRight).setBorderColor(JBColor.border()).setAwtTooltip(true).setTextBg(HintUtil.getInformationColor()).setShowImmediately(true).setExplicitClose(true).setAnimationEnabled(true);
    }

    @Nullable
    private static String getIssueMessage(@NotNull TreePath path) {
        Object last;
        if (path == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(10);
        }
        if (!((last = path.getLastPathComponent()) instanceof NlComponent)) {
            return null;
        }
        NlComponent component2 = (NlComponent)last;
        LintAnnotationsModel lintAnnotationsModel = component2.getModel().getLintAnnotationsModel();
        if (lintAnnotationsModel != null) {
            return lintAnnotationsModel.getIssueMessage(component2, false);
        }
        return null;
    }

    @NotNull
    public MouseAdapter getBadgeMouseAdapter() {
        BadgeMouseMotionListener badgeMouseMotionListener = this.myBadgeMouseMotionListener;
        if (badgeMouseMotionListener == null) {
            NlTreeBadgeHandler.$$$reportNull$$$0(11);
        }
        return badgeMouseMotionListener;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "g";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 3: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "message";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "hint";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeFrame";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getBadgeMouseAdapter";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "paintBadges";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "showErrorTooltip";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "ensureHintCanBeDisplayed";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createHint";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getIssueMessage";
                break;
            }
            case 11: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private class BadgeMouseMotionListener
    extends MouseAdapter {
        private BadgeMouseMotionListener() {
        }

        @Override
        public void mouseExited(MouseEvent event) {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
                NlTreeBadgeHandler.this.myTooltipHint = null;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = null;
        }

        @Override
        public void mouseMoved(@NotNull MouseEvent event) {
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(0);
            }
            JTree tree = (JTree)event.getSource();
            this.handleShowBadge(event, tree);
        }

        @Override
        public void mouseClicked(MouseEvent event) {
            this.handleMouseClicked(event, (JTree)event.getSource());
        }

        private void handleMouseClicked(MouseEvent event, JTree tree) {
            Rectangle bounds;
            int limit = NlTreeBadgeHandler.this.myBadgeX;
            if (event.getX() < limit || NlTreeBadgeHandler.this.myIssuePanel == null) {
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds = tree.getPathBounds(path)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlComponent component2 = (NlComponent)last;
            if (event.getX() > NlTreeBadgeHandler.this.myBadgeX) {
                NlTreeBadgeHandler.this.myIssuePanel.showIssueForComponent(component2, true);
            }
        }

        private void toggleLocking(@NotNull NlComponent component2) {
            if (component2 == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(1);
            }
            boolean isLocked = SceneManager.isComponentLocked(component2);
            if (component2.getParent() == null) {
                return;
            }
            NlWriteCommandAction.run(component2, "", () -> {
                if (component2 == null) {
                    BadgeMouseMotionListener.$$$reportNull$$$0(4);
                }
                component2.setAttribute("http://schemas.android.com/tools", "locked", isLocked ? null : "true");
            });
        }

        private void handleShowBadge(@NotNull MouseEvent event, @NotNull JTree tree) {
            Rectangle bounds;
            if (event == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(2);
            }
            if (tree == null) {
                BadgeMouseMotionListener.$$$reportNull$$$0(3);
            }
            if (event.getX() < NlTreeBadgeHandler.this.myLockIconX) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            TreePath path = tree.getClosestPathForLocation(event.getX(), event.getY());
            if (path == null || (bounds = tree.getPathBounds(path)) == null || event.getY() < bounds.y || event.getY() > bounds.y + bounds.height) {
                NlTreeBadgeHandler.this.myHoveredPath = null;
                NlTreeBadgeHandler.this.myHoveredComponent = null;
                this.hideTooltip();
                return;
            }
            Object last = path.getLastPathComponent();
            if (!(last instanceof NlComponent)) {
                return;
            }
            NlTreeBadgeHandler.this.myHoveredComponent = (NlComponent)last;
            boolean badgeIcon = true;
            if (NlTreeBadgeHandler.this.myHoveredPath == path) {
                if (badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 0) {
                    return;
                }
                if (!badgeIcon && NlTreeBadgeHandler.this.myHoveredIcon == 1) {
                    return;
                }
            }
            NlTreeBadgeHandler.this.myHoveredPath = path;
            String message = null;
            if (badgeIcon) {
                message = NlTreeBadgeHandler.getIssueMessage(NlTreeBadgeHandler.this.myHoveredPath);
                NlTreeBadgeHandler.this.myHoveredIcon = 0;
            }
            if (message != null) {
                NlTreeBadgeHandler.this.showErrorTooltip(tree, NlTreeBadgeHandler.this.myHoveredPath, message);
            }
        }

        private void hideTooltip() {
            if (NlTreeBadgeHandler.this.myTooltipHint != null) {
                NlTreeBadgeHandler.this.myTooltipHint.hide(true);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 1: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "tree";
                    break;
                }
            }
            objectArray2[1] = "com/android/tools/idea/uibuilder/structure/NlTreeBadgeHandler$BadgeMouseMotionListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "mouseMoved";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "toggleLocking";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "handleShowBadge";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "lambda$toggleLocking$0";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }
}

