/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.updater.configure;

import com.android.repository.impl.meta.TypeDetails;
import com.android.sdklib.AndroidVersion;
import com.android.sdklib.SdkVersionInfo;
import com.android.sdklib.repository.meta.DetailsTypes;
import com.android.tools.idea.updater.configure.DetailsTreeNode;
import com.android.tools.idea.updater.configure.PackageNodeModel;
import com.android.tools.idea.updater.configure.UpdaterTreeNode;
import com.google.common.collect.Sets;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import javax.swing.JTree;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class SummaryTreeNode
extends UpdaterTreeNode {
    private AndroidVersion myVersion;
    private Set<UpdaterTreeNode> myAllChildren;
    private Set<UpdaterTreeNode> myIncludedChildren;
    private UpdaterTreeNode myPrimaryChild;

    public static SummaryTreeNode createNode(@NotNull AndroidVersion version, @NotNull Set<UpdaterTreeNode> children) {
        if (version == null) {
            SummaryTreeNode.$$$reportNull$$$0(0);
        }
        if (children == null) {
            SummaryTreeNode.$$$reportNull$$$0(1);
        }
        HashSet includedChildren = Sets.newHashSet();
        UpdaterTreeNode primaryChild = null;
        for (UpdaterTreeNode child : children) {
            if (child.includeInSummary()) {
                includedChildren.add(child);
            }
            if (!child.isPrimary()) continue;
            primaryChild = child;
        }
        if (!includedChildren.isEmpty()) {
            return new SummaryTreeNode(version, children, includedChildren, primaryChild);
        }
        return null;
    }

    protected SummaryTreeNode(@NotNull AndroidVersion version, @NotNull Set<UpdaterTreeNode> children, @NotNull Set<UpdaterTreeNode> includedChildren, @Nullable UpdaterTreeNode primaryChild) {
        if (version == null) {
            SummaryTreeNode.$$$reportNull$$$0(2);
        }
        if (children == null) {
            SummaryTreeNode.$$$reportNull$$$0(3);
        }
        if (includedChildren == null) {
            SummaryTreeNode.$$$reportNull$$$0(4);
        }
        this.myIncludedChildren = Sets.newHashSet();
        this.myVersion = version;
        this.myAllChildren = children;
        this.myIncludedChildren = includedChildren;
        this.myPrimaryChild = primaryChild;
    }

    private PackageNodeModel.SelectedState getState(@NotNull Function<UpdaterTreeNode, PackageNodeModel.SelectedState> childStateGetter) {
        if (childStateGetter == null) {
            SummaryTreeNode.$$$reportNull$$$0(5);
        }
        boolean hasNeedsUpdate = false;
        for (UpdaterTreeNode summaryNode : this.myIncludedChildren) {
            if (childStateGetter.apply(summaryNode) == PackageNodeModel.SelectedState.NOT_INSTALLED) {
                return PackageNodeModel.SelectedState.NOT_INSTALLED;
            }
            if (childStateGetter.apply(summaryNode) != PackageNodeModel.SelectedState.MIXED) continue;
            hasNeedsUpdate = true;
        }
        return hasNeedsUpdate ? PackageNodeModel.SelectedState.MIXED : PackageNodeModel.SelectedState.INSTALLED;
    }

    @Override
    @NotNull
    public PackageNodeModel.SelectedState getInitialState() {
        PackageNodeModel.SelectedState selectedState = this.getState(UpdaterTreeNode::getInitialState);
        if (selectedState == null) {
            SummaryTreeNode.$$$reportNull$$$0(6);
        }
        return selectedState;
    }

    @Override
    public PackageNodeModel.SelectedState getCurrentState() {
        return this.getState(UpdaterTreeNode::getCurrentState);
    }

    @Override
    public int compareTo(@NotNull UpdaterTreeNode o) {
        if (o == null) {
            SummaryTreeNode.$$$reportNull$$$0(7);
        }
        if (!(o instanceof SummaryTreeNode)) {
            return super.compareTo(o);
        }
        return this.myVersion.compareTo(((SummaryTreeNode)o).myVersion);
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof SummaryTreeNode)) {
            return false;
        }
        return this.myVersion.equals((Object)((SummaryTreeNode)obj).myVersion);
    }

    @Override
    public void customizeRenderer(UpdaterTreeNode.Renderer renderer, JTree tree, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        renderer.getTextRenderer().append(SdkVersionInfo.getVersionWithCodename((AndroidVersion)this.myVersion));
    }

    public AndroidVersion getVersion() {
        return this.myVersion;
    }

    @Override
    protected void setState(PackageNodeModel.SelectedState state) {
        boolean hasOrigNotInstalled = false;
        for (UpdaterTreeNode summaryTreeNode : this.myIncludedChildren) {
            if (summaryTreeNode.getInitialState() != PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            hasOrigNotInstalled = true;
        }
        for (UpdaterTreeNode child : this.myAllChildren) {
            child.resetState();
        }
        if (state == PackageNodeModel.SelectedState.NOT_INSTALLED && !hasOrigNotInstalled) {
            for (UpdaterTreeNode child : this.myAllChildren) {
                child.setState(PackageNodeModel.SelectedState.NOT_INSTALLED);
            }
        }
        if (state == PackageNodeModel.SelectedState.INSTALLED) {
            for (UpdaterTreeNode child : this.myIncludedChildren) {
                child.setState(PackageNodeModel.SelectedState.INSTALLED);
            }
        }
    }

    @Override
    protected boolean canHaveMixedState() {
        for (UpdaterTreeNode child : this.myIncludedChildren) {
            if (!child.canHaveMixedState()) continue;
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public String getStatusString() {
        boolean foundSources = false;
        boolean foundPlatform = false;
        boolean foundUpdate = false;
        for (UpdaterTreeNode child : this.myAllChildren) {
            if (child.getInitialState() == PackageNodeModel.SelectedState.NOT_INSTALLED) continue;
            TypeDetails details = ((DetailsTreeNode)child).getPackage().getTypeDetails();
            if (details instanceof DetailsTypes.SourceDetailsType) {
                foundSources = true;
            } else if (details instanceof DetailsTypes.PlatformDetailsType) {
                foundPlatform = true;
            }
            if (child.getInitialState() != PackageNodeModel.SelectedState.MIXED) continue;
            foundUpdate = true;
        }
        if (foundUpdate) {
            if ("Update available" == null) {
                SummaryTreeNode.$$$reportNull$$$0(8);
            }
            return "Update available";
        }
        if (foundPlatform && (foundSources || this.myVersion.getApiLevel() < 14)) {
            if ("Installed" == null) {
                SummaryTreeNode.$$$reportNull$$$0(9);
            }
            return "Installed";
        }
        if (foundPlatform || foundSources) {
            if ("Partially installed" == null) {
                SummaryTreeNode.$$$reportNull$$$0(10);
            }
            return "Partially installed";
        }
        if ("Not installed" == null) {
            SummaryTreeNode.$$$reportNull$$$0(11);
        }
        return "Not installed";
    }

    @Nullable
    public UpdaterTreeNode getPrimaryChild() {
        return this.myPrimaryChild;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "version";
                break;
            }
            case 1: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "children";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "includedChildren";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "childStateGetter";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/updater/configure/SummaryTreeNode";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "o";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/updater/configure/SummaryTreeNode";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialState";
                break;
            }
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getStatusString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createNode";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getState";
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

