/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android;

import com.android.tools.idea.model.AndroidModuleInfo;
import com.google.common.collect.Maps;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ClassInheritorsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ArrayUtilRt;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.android.facet.AndroidFacet;
import org.jetbrains.android.facet.AndroidFacetScopedService;
import org.jetbrains.android.facet.LayoutViewClassUtils;
import org.jetbrains.annotations.NotNull;

public class ClassMaps
extends AndroidFacetScopedService {
    private static final Key<ClassMaps> KEY = Key.create((String)ClassMaps.class.getName());
    private final Map<String, Map<String, SmartPsiElementPointer<PsiClass>>> myInitialClassMaps;
    private final Map<String, CachedValue<Map<String, PsiClass>>> myClassMaps;

    @NotNull
    public static ClassMaps getInstance(@NotNull AndroidFacet facet) {
        ClassMaps classMaps;
        if (facet == null) {
            ClassMaps.$$$reportNull$$$0(0);
        }
        if ((classMaps = (ClassMaps)facet.getUserData(KEY)) == null) {
            classMaps = new ClassMaps(facet);
            facet.putUserData(KEY, classMaps);
        }
        ClassMaps classMaps2 = classMaps;
        if (classMaps2 == null) {
            ClassMaps.$$$reportNull$$$0(1);
        }
        return classMaps2;
    }

    private ClassMaps(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ClassMaps.$$$reportNull$$$0(2);
        }
        super(facet);
        this.myInitialClassMaps = new HashMap<String, Map<String, SmartPsiElementPointer<PsiClass>>>();
        this.myClassMaps = Maps.newConcurrentMap();
    }

    @NotNull
    public Map<String, PsiClass> getClassMap(@NotNull String className) {
        CachedValue value;
        if (className == null) {
            ClassMaps.$$$reportNull$$$0(3);
        }
        if ((value = this.myClassMaps.get(className)) == null) {
            value = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                if (className == null) {
                    ClassMaps.$$$reportNull$$$0(18);
                }
                Map<String, PsiClass> map = this.computeClassMap(className);
                return CachedValueProvider.Result.create(map, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }, false);
            this.myClassMaps.put(className, (CachedValue<Map<String, PsiClass>>)value);
        }
        Map map = (Map)value.getValue();
        if (map == null) {
            ClassMaps.$$$reportNull$$$0(4);
        }
        return map;
    }

    @NotNull
    private Map<String, PsiClass> computeClassMap(@NotNull String className) {
        PsiClass aClass;
        SmartPsiElementPointer<PsiClass> pointer;
        if (className == null) {
            ClassMaps.$$$reportNull$$$0(5);
        }
        Map<String, SmartPsiElementPointer<PsiClass>> classMap = this.getInitialClassMap(className, false);
        HashMap<String, PsiClass> result = new HashMap<String, PsiClass>();
        boolean shouldRebuildInitialMap = false;
        for (String key : classMap.keySet()) {
            pointer = classMap.get(key);
            if (!ClassMaps.isUpToDate(pointer, key)) {
                shouldRebuildInitialMap = true;
                break;
            }
            aClass = (PsiClass)pointer.getElement();
            if (aClass == null) continue;
            result.put(key, aClass);
        }
        if (shouldRebuildInitialMap) {
            result.clear();
            classMap = this.getInitialClassMap(className, true);
            for (String key : classMap.keySet()) {
                pointer = classMap.get(key);
                aClass = (PsiClass)pointer.getElement();
                if (aClass == null) continue;
                result.put(key, aClass);
            }
        }
        this.fillMap(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), result, false);
        HashMap<String, PsiClass> hashMap = result;
        if (hashMap == null) {
            ClassMaps.$$$reportNull$$$0(6);
        }
        return hashMap;
    }

    private static boolean isUpToDate(@NotNull SmartPsiElementPointer<PsiClass> pointer, String tagName) {
        PsiClass aClass;
        if (pointer == null) {
            ClassMaps.$$$reportNull$$$0(7);
        }
        if ((aClass = (PsiClass)pointer.getElement()) == null) {
            return false;
        }
        Object[] tagNames = LayoutViewClassUtils.getTagNamesByClass(aClass, -1);
        return ArrayUtilRt.find((Object[])tagNames, (Object)tagName) >= 0;
    }

    @NotNull
    private Map<String, SmartPsiElementPointer<PsiClass>> getInitialClassMap(@NotNull String className, boolean forceRebuild) {
        Map<String, SmartPsiElementPointer<PsiClass>> viewClassMap;
        if (className == null) {
            ClassMaps.$$$reportNull$$$0(8);
        }
        if ((viewClassMap = this.myInitialClassMaps.get(className)) != null && !forceRebuild) {
            Map<String, SmartPsiElementPointer<PsiClass>> map = viewClassMap;
            if (map == null) {
                ClassMaps.$$$reportNull$$$0(9);
            }
            return map;
        }
        HashMap<String, PsiClass> map = new HashMap<String, PsiClass>();
        if (this.fillMap(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true), map, true)) {
            viewClassMap = new HashMap<String, SmartPsiElementPointer<PsiClass>>(map.size());
            SmartPointerManager manager = SmartPointerManager.getInstance((Project)this.getProject());
            for (Map.Entry entry : map.entrySet()) {
                viewClassMap.put((String)entry.getKey(), (SmartPsiElementPointer<PsiClass>)manager.createSmartPsiElementPointer((PsiElement)entry.getValue()));
            }
            this.myInitialClassMaps.put(className, viewClassMap);
        }
        Map<String, Object> map2 = viewClassMap != null ? viewClassMap : Collections.emptyMap();
        if (map2 == null) {
            ClassMaps.$$$reportNull$$$0(10);
        }
        return map2;
    }

    private boolean fillMap(@NotNull String className, @NotNull GlobalSearchScope scope, @NotNull Map<String, PsiClass> map, boolean libClassesOnly) {
        if (className == null) {
            ClassMaps.$$$reportNull$$$0(11);
        }
        if (scope == null) {
            ClassMaps.$$$reportNull$$$0(12);
        }
        if (map == null) {
            ClassMaps.$$$reportNull$$$0(13);
        }
        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)this.getProject());
        PsiClass baseClass = (PsiClass)ApplicationManager.getApplication().runReadAction(() -> {
            PsiClass aClass;
            if (className == null) {
                ClassMaps.$$$reportNull$$$0(17);
            }
            try {
                aClass = facade.findClass(className, this.getModule().getModuleWithDependenciesAndLibrariesScope(true));
            }
            catch (IndexNotReadyException e) {
                aClass = null;
            }
            return aClass;
        });
        AndroidModuleInfo androidModuleInfo = AndroidModuleInfo.getInstance(this.getFacet());
        if (baseClass != null) {
            String[] baseClassTagNames;
            for (String tagName : baseClassTagNames = LayoutViewClassUtils.getTagNamesByClass(baseClass, androidModuleInfo.getModuleMinApi())) {
                map.put(tagName, baseClass);
            }
            try {
                ClassInheritorsSearch.search((PsiClass)baseClass, (SearchScope)scope, (boolean)true).forEach(c -> {
                    String[] tagNames;
                    if (map == null) {
                        ClassMaps.$$$reportNull$$$0(16);
                    }
                    if (libClassesOnly && c.getManager().isInProject((PsiElement)c)) {
                        return true;
                    }
                    for (String tagName : tagNames = LayoutViewClassUtils.getTagNamesByClass(c, androidModuleInfo.getModuleMinApi())) {
                        map.put(tagName, (PsiClass)c);
                    }
                    return true;
                });
            }
            catch (IndexNotReadyException e) {
                Logger.getInstance(this.getClass()).info((Throwable)e);
                return false;
            }
        }
        return !map.isEmpty();
    }

    @NotNull
    private Project getProject() {
        Project project = this.getModule().getProject();
        if (project == null) {
            ClassMaps.$$$reportNull$$$0(14);
        }
        return project;
    }

    public void clear() {
        this.myInitialClassMaps.clear();
    }

    @Override
    protected void onServiceDisposal(@NotNull AndroidFacet facet) {
        if (facet == null) {
            ClassMaps.$$$reportNull$$$0(15);
        }
        facet.putUserData(KEY, null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "facet";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/ClassMaps";
                break;
            }
            case 3: 
            case 5: 
            case 8: 
            case 11: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "className";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 13: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/ClassMaps";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getInstance";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassMap";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "computeClassMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getInitialClassMap";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getClassMap";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeClassMap";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isUpToDate";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getInitialClassMap";
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "fillMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "onServiceDisposal";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillMap$2";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "lambda$fillMap$1";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getClassMap$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 4: 
            case 6: 
            case 9: 
            case 10: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

