/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.android.dom.converters;

import com.android.sdklib.IAndroidTarget;
import com.google.common.collect.Lists;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.HashSet;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.GenericDomValue;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jetbrains.android.dom.LookupClass;
import org.jetbrains.android.dom.LookupPrefix;
import org.jetbrains.android.dom.manifest.Action;
import org.jetbrains.android.dom.manifest.Activity;
import org.jetbrains.android.dom.manifest.Category;
import org.jetbrains.android.dom.manifest.IntentFilter;
import org.jetbrains.android.dom.manifest.Receiver;
import org.jetbrains.android.dom.manifest.Service;
import org.jetbrains.android.sdk.AndroidPlatform;
import org.jetbrains.android.sdk.AndroidTargetData;
import org.jetbrains.android.util.AndroidUtils;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConstantFieldConverter
extends Converter<String>
implements CustomReferenceConverter<String> {
    public String fromString(@Nullable @NonNls String s, ConvertContext context) {
        return s;
    }

    public String toString(@Nullable String value, ConvertContext context) {
        return value;
    }

    @NotNull
    public PsiReference[] createReferences(GenericDomValue<String> value, PsiElement element, ConvertContext context) {
        DomElement domElement = context.getInvocationElement();
        LookupClass lookupClass = (LookupClass)domElement.getAnnotation(LookupClass.class);
        LookupPrefix lookupPrefix = (LookupPrefix)domElement.getAnnotation(LookupPrefix.class);
        if (lookupClass == null || lookupPrefix == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                ConstantFieldConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        Module module = context.getModule();
        GlobalSearchScope scope = module != null ? GlobalSearchScope.allScope((Project)module.getProject()) : domElement.getResolveScope();
        JavaPsiFacade javaFacade = JavaPsiFacade.getInstance((Project)context.getPsiManager().getProject());
        String[] classNames = lookupClass.value();
        ArrayList result = Lists.newArrayListWithCapacity((int)classNames.length);
        Set<String> filteringSet = ConstantFieldConverter.getFilteringSet(context);
        for (String className : classNames) {
            PsiClass psiClass = javaFacade.findClass(className, scope);
            if (psiClass == null) continue;
            result.add(new MyReference(element, psiClass, lookupPrefix.value(), filteringSet));
        }
        PsiReference[] psiReferenceArray = result.toArray(new PsiReference[result.size()]);
        if (psiReferenceArray == null) {
            ConstantFieldConverter.$$$reportNull$$$0(1);
        }
        return psiReferenceArray;
    }

    @Nullable
    private static Set<String> getFilteringSet(@NotNull ConvertContext context) {
        Module module;
        if (context == null) {
            ConstantFieldConverter.$$$reportNull$$$0(2);
        }
        if ((module = context.getModule()) == null) {
            return null;
        }
        AndroidPlatform platform = AndroidPlatform.getInstance(module);
        if (platform == null) {
            return null;
        }
        IAndroidTarget target = platform.getTarget();
        AndroidTargetData targetData = platform.getSdkData().getTargetData(target);
        DomElement element = context.getInvocationElement().getParent();
        if (element instanceof Category) {
            return targetData.getStaticConstantsData().getCategories();
        }
        if (element instanceof Action && (element = element.getParent()) instanceof IntentFilter) {
            if ((element = element.getParent()) instanceof Activity) {
                return targetData.getStaticConstantsData().getActivityActions();
            }
            if (element instanceof Service) {
                return targetData.getStaticConstantsData().getServiceActions();
            }
            if (element instanceof Receiver) {
                return targetData.getStaticConstantsData().getReceiverActions();
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/android/dom/converters/ConstantFieldConverter";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "createReferences";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/android/dom/converters/ConstantFieldConverter";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getFilteringSet";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyReference
    extends PsiReferenceBase<PsiElement> {
        private final PsiClass myClass;
        private final String myLookupPrefix;
        private final Set<String> myFilteringSet;

        public MyReference(@NotNull PsiElement element, @NotNull PsiClass aClass, @NotNull String lookupPrefix, @Nullable Set<String> filteringSet) {
            if (element == null) {
                MyReference.$$$reportNull$$$0(0);
            }
            if (aClass == null) {
                MyReference.$$$reportNull$$$0(1);
            }
            if (lookupPrefix == null) {
                MyReference.$$$reportNull$$$0(2);
            }
            super(element, true);
            this.myClass = aClass;
            this.myLookupPrefix = lookupPrefix;
            this.myFilteringSet = filteringSet;
        }

        @Nullable
        public PsiElement resolve() {
            return (PsiElement)ResolveCache.getInstance((Project)this.myElement.getProject()).resolveWithCaching((PsiReference)this, (ResolveCache.AbstractResolver)new ResolveCache.Resolver(){

                @Nullable
                public PsiElement resolve(@NotNull PsiReference reference, boolean incompleteCode) {
                    if (reference == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return this.resolveInner();
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "reference", "org/jetbrains/android/dom/converters/ConstantFieldConverter$MyReference$1", "resolve"));
                }
            }, false, false);
        }

        @Nullable
        private PsiElement resolveInner() {
            final String value = this.getValue();
            if (value.isEmpty()) {
                return null;
            }
            final Ref ref = Ref.create();
            this.processFields(new Processor<Pair<PsiField, String>>(){

                public boolean process(Pair<PsiField, String> pair) {
                    if (value.equals(pair.getSecond())) {
                        ref.set(pair.getFirst());
                        return false;
                    }
                    return true;
                }
            });
            return (PsiElement)ref.get();
        }

        @NotNull
        public Object[] getVariants() {
            ArrayList result = new ArrayList();
            HashSet added = new HashSet();
            this.processFields(new Processor<Pair<PsiField, String>>((Set)added, result){
                final /* synthetic */ Set val$added;
                final /* synthetic */ List val$result;
                {
                    this.val$added = set;
                    this.val$result = list;
                }

                public boolean process(Pair<PsiField, String> pair) {
                    String s = (String)pair.getSecond();
                    if (myFilteringSet != null && !myFilteringSet.contains(s)) {
                        return true;
                    }
                    if (this.val$added.add(s)) {
                        LookupElementBuilder builder = LookupElementBuilder.create((Object)pair.getFirst(), (String)s).withCaseSensitivity(true);
                        String unqualifiedName = AndroidUtils.getUnqualifiedName(s);
                        if (unqualifiedName != null) {
                            builder = builder.withLookupString(unqualifiedName);
                        }
                        this.val$result.add(builder);
                    }
                    return true;
                }
            });
            Object[] objectArray = ArrayUtil.toObjectArray(result);
            if (objectArray == null) {
                MyReference.$$$reportNull$$$0(3);
            }
            return objectArray;
        }

        private void processFields(@NotNull Processor<Pair<PsiField, String>> processor) {
            PsiField[] psiFields;
            if (processor == null) {
                MyReference.$$$reportNull$$$0(4);
            }
            for (PsiField field : psiFields = this.myClass.getFields()) {
                PsiLiteralExpression literalExpression;
                Object o;
                PsiExpression initializer;
                if (!field.hasModifierProperty("static") || !field.hasModifierProperty("public") || !((initializer = field.getInitializer()) instanceof PsiLiteralExpression) || !((o = (literalExpression = (PsiLiteralExpression)initializer).getValue()) instanceof String) || !o.toString().startsWith(this.myLookupPrefix) || processor.process((Object)Pair.create((Object)field, (Object)o.toString()))) continue;
                return;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 3: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 3: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aClass";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "lookupPrefix";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "org/jetbrains/android/dom/converters/ConstantFieldConverter$MyReference";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "processor";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "org/jetbrains/android/dom/converters/ConstantFieldConverter$MyReference";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getVariants";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processFields";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 3: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }
}

