/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.indexing.IdFilter;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PsiShortNamesCache {
    public static final ExtensionPointName<PsiShortNamesCache> EP_NAME = ExtensionPointName.create((String)"com.intellij.java.shortNamesCache");

    public static PsiShortNamesCache getInstance(Project project) {
        return (PsiShortNamesCache)ServiceManager.getService((Project)project, PsiShortNamesCache.class);
    }

    @NotNull
    public PsiFile[] getFilesByName(@NotNull String name) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(0);
        }
        if (PsiFile.EMPTY_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(1);
        }
        return PsiFile.EMPTY_ARRAY;
    }

    @NotNull
    public String[] getAllFileNames() {
        if (ArrayUtil.EMPTY_STRING_ARRAY == null) {
            PsiShortNamesCache.$$$reportNull$$$0(2);
        }
        return ArrayUtil.EMPTY_STRING_ARRAY;
    }

    @NotNull
    public abstract PsiClass[] getClassesByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract String[] getAllClassNames();

    public boolean processAllClassNames(Processor<String> processor) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public boolean processAllClassNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllClassNames(), processor);
    }

    public abstract void getAllClassNames(@NotNull HashSet<String> var1);

    @NotNull
    public abstract PsiMethod[] getMethodsByName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract PsiMethod[] getMethodsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    @NotNull
    public abstract PsiField[] getFieldsByNameIfNotMoreThan(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, int var3);

    public abstract boolean processMethodsWithName(@NonNls @NotNull String var1, @NotNull GlobalSearchScope var2, @NotNull Processor<PsiMethod> var3);

    public boolean processMethodsWithName(@NonNls @NotNull String name, @NotNull Processor<? super PsiMethod> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(3);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(4);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(5);
        }
        return this.processMethodsWithName(name, scope, (Processor<PsiMethod>)((Processor)method -> {
            if (processor == null) {
                PsiShortNamesCache.$$$reportNull$$$0(12);
            }
            return processor.process(method);
        }));
    }

    public boolean processAllMethodNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllMethodNames(), processor);
    }

    public boolean processAllFieldNames(Processor<String> processor, GlobalSearchScope scope, IdFilter filter2) {
        return ContainerUtil.process((Object[])this.getAllFieldNames(), processor);
    }

    @NotNull
    public abstract String[] getAllMethodNames();

    public abstract void getAllMethodNames(@NotNull HashSet<String> var1);

    @NotNull
    public abstract PsiField[] getFieldsByName(@NotNull @NonNls String var1, @NotNull GlobalSearchScope var2);

    @NotNull
    public abstract String[] getAllFieldNames();

    public abstract void getAllFieldNames(@NotNull HashSet<String> var1);

    public boolean processFieldsWithName(@NotNull String name, @NotNull Processor<? super PsiField> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(6);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(7);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(8);
        }
        return ContainerUtil.process((Object[])this.getFieldsByName(name, scope), processor);
    }

    public boolean processClassesWithName(@NotNull String name, @NotNull Processor<? super PsiClass> processor, @NotNull GlobalSearchScope scope, @Nullable IdFilter filter2) {
        if (name == null) {
            PsiShortNamesCache.$$$reportNull$$$0(9);
        }
        if (processor == null) {
            PsiShortNamesCache.$$$reportNull$$$0(10);
        }
        if (scope == null) {
            PsiShortNamesCache.$$$reportNull$$$0(11);
        }
        return ContainerUtil.process((Object[])this.getClassesByName(name, scope), processor);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 4: 
            case 7: 
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/psi/search/PsiShortNamesCache";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFilesByName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllFileNames";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getFilesByName";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "processMethodsWithName";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "processFieldsWithName";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "processClassesWithName";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "lambda$processMethodsWithName$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

