/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider;

import java.io.File;
import java.io.IOException;
import javax.annotation.Nullable;
import org.gradle.api.JavaVersion;
import org.gradle.api.UncheckedIOException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.BuildLayoutParameters;
import org.gradle.initialization.DefaultBuildCancellationToken;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.jvm.UnsupportedJavaRuntimeException;
import org.gradle.internal.logging.services.LoggingServiceRegistry;
import org.gradle.internal.nativeintegration.services.NativeServices;
import org.gradle.internal.service.ServiceRegistry;
import org.gradle.internal.service.ServiceRegistryBuilder;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.protocol.BuildActionRunner;
import org.gradle.tooling.internal.protocol.BuildExceptionVersion1;
import org.gradle.tooling.internal.protocol.BuildOperationParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildParameters;
import org.gradle.tooling.internal.protocol.BuildParametersVersion1;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.ConfigurableConnection;
import org.gradle.tooling.internal.protocol.ConnectionMetaDataVersion1;
import org.gradle.tooling.internal.protocol.ConnectionParameters;
import org.gradle.tooling.internal.protocol.ConnectionVersion4;
import org.gradle.tooling.internal.protocol.InternalBuildAction;
import org.gradle.tooling.internal.protocol.InternalBuildActionExecutor;
import org.gradle.tooling.internal.protocol.InternalBuildActionVersion2;
import org.gradle.tooling.internal.protocol.InternalCancellableConnection;
import org.gradle.tooling.internal.protocol.InternalCancellationToken;
import org.gradle.tooling.internal.protocol.InternalConnection;
import org.gradle.tooling.internal.protocol.InternalParameterAcceptingConnection;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelBuilder;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.internal.protocol.ProjectVersion3;
import org.gradle.tooling.internal.protocol.ShutdownParameters;
import org.gradle.tooling.internal.protocol.StoppableConnection;
import org.gradle.tooling.internal.protocol.exceptions.InternalUnsupportedBuildArgumentException;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionConnection;
import org.gradle.tooling.internal.protocol.test.InternalTestExecutionRequest;
import org.gradle.tooling.internal.provider.ConnectionScopeServices;
import org.gradle.tooling.internal.provider.DefaultConnectionMetaData;
import org.gradle.tooling.internal.provider.InternalCancellationTokenAdapter;
import org.gradle.tooling.internal.provider.ProviderConnection;
import org.gradle.tooling.internal.provider.connection.BuildLogLevelMixIn;
import org.gradle.tooling.internal.provider.connection.ProviderBuildResult;
import org.gradle.tooling.internal.provider.connection.ProviderConnectionParameters;
import org.gradle.tooling.internal.provider.connection.ProviderOperationParameters;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.util.DeprecationLogger;
import org.gradle.util.GradleVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConnection
implements ConnectionVersion4,
InternalConnection,
BuildActionRunner,
ConfigurableConnection,
ModelBuilder,
InternalBuildActionExecutor,
InternalCancellableConnection,
InternalParameterAcceptingConnection,
StoppableConnection,
InternalTestExecutionConnection {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultConnection.class);
    private static final String UNSUPPORTED_MESSAGE = "Support for clients using a tooling API version older than 2.0 was removed in Gradle 3.0. %sYou should upgrade your tooling API client to version 3.0 or later.";
    private static final String DEPRECATION_MESSAGE = "Support for clients using a tooling API version older than 3.0 was deprecated and will be removed in Gradle 5.0. %sYou should upgrade your tooling API client to version 3.0 or later.\n";
    private static final GradleVersion MIN_CLIENT_VERSION = GradleVersion.version((String)"2.0");
    private static final GradleVersion MIN_LTS_CLIENT_VERSION = GradleVersion.version((String)"3.0");
    private ProtocolToModelAdapter adapter;
    private ServiceRegistry services;
    private ProviderConnection connection;
    @Nullable
    private GradleVersion consumerVersion;

    public DefaultConnection() {
        LOGGER.debug("Tooling API provider {} created.", (Object)GradleVersion.current().getVersion());
    }

    public void configure(ConnectionParameters parameters) {
        this.assertUsingJava7();
        ProviderConnectionParameters providerConnectionParameters = (ProviderConnectionParameters)new ProtocolToModelAdapter().adapt(ProviderConnectionParameters.class, (Object)parameters);
        File gradleUserHomeDir = providerConnectionParameters.getGradleUserHomeDir(null);
        if (gradleUserHomeDir == null) {
            gradleUserHomeDir = new BuildLayoutParameters().getGradleUserHomeDir();
        }
        this.initializeServices(gradleUserHomeDir);
        this.connection.configure(providerConnectionParameters);
        this.consumerVersion = GradleVersion.version((String)providerConnectionParameters.getConsumerVersion());
    }

    private void assertUsingJava7() {
        try {
            UnsupportedJavaRuntimeException.assertUsingVersion((String)"Gradle", (JavaVersion)JavaVersion.VERSION_1_7);
        }
        catch (IllegalArgumentException e) {
            DeprecationLogger.nagUserWith((String)e.getMessage());
        }
    }

    private void initializeServices(File gradleUserHomeDir) {
        NativeServices.initialize((File)gradleUserHomeDir);
        LoggingServiceRegistry loggingServices = LoggingServiceRegistry.newEmbeddableLogging();
        this.services = ServiceRegistryBuilder.builder().displayName("Connection services").parent((ServiceRegistry)loggingServices).parent((ServiceRegistry)NativeServices.getInstance()).provider((Object)new ConnectionScopeServices(loggingServices)).build();
        this.adapter = (ProtocolToModelAdapter)this.services.get(ProtocolToModelAdapter.class);
        this.connection = (ProviderConnection)this.services.get(ProviderConnection.class);
    }

    public void configureLogging(boolean verboseLogging) {
    }

    public ConnectionMetaDataVersion1 getMetaData() {
        return new DefaultConnectionMetaData();
    }

    @Deprecated
    public void stop() {
    }

    public void shutdown(ShutdownParameters parameters) {
        CompositeStoppable.stoppable((Object[])new Object[]{this.services}).stop();
    }

    @Deprecated
    public void executeBuild(BuildParametersVersion1 buildParameters, BuildOperationParametersVersion1 operationParameters) {
        throw this.unsupportedConnectionException();
    }

    @Deprecated
    public ProjectVersion3 getModel(Class<? extends ProjectVersion3> type, BuildOperationParametersVersion1 parameters) {
        throw this.unsupportedConnectionException();
    }

    @Deprecated
    public <T> T getTheModel(Class<T> type, BuildOperationParametersVersion1 parameters) {
        throw this.unsupportedConnectionException();
    }

    @Deprecated
    public <T> BuildResult<T> run(Class<T> type, BuildParameters buildParameters) throws UnsupportedOperationException, IllegalStateException {
        throw this.unsupportedConnectionException();
    }

    public BuildResult<?> getModel(ModelIdentifier modelIdentifier, BuildParameters operationParameters) throws UnsupportedOperationException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        Object result = this.connection.run(modelIdentifier.getName(), (BuildCancellationToken)new DefaultBuildCancellationToken(), providerParameters);
        return new ProviderBuildResult<Object>(result);
    }

    public BuildResult<?> getModel(ModelIdentifier modelIdentifier, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedModelException, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object result = this.connection.run(modelIdentifier.getName(), (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(result);
    }

    public <T> BuildResult<T> run(InternalBuildAction<T> action, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        Object results = this.connection.run(action, (BuildCancellationToken)new DefaultBuildCancellationToken(), providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    public <T> BuildResult<T> run(InternalBuildAction<T> action, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.run(action, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    public <T> BuildResult<T> run(InternalBuildActionVersion2<T> action, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.run(action, (BuildCancellationToken)buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    public BuildResult<?> runTests(InternalTestExecutionRequest testExecutionRequest, InternalCancellationToken cancellationToken, BuildParameters operationParameters) throws BuildExceptionVersion1, InternalUnsupportedBuildArgumentException, IllegalStateException {
        ProviderOperationParameters providerParameters = this.validateAndConvert(operationParameters);
        ProviderInternalTestExecutionRequest testExecutionRequestVersion2 = (ProviderInternalTestExecutionRequest)this.adapter.adapt(ProviderInternalTestExecutionRequest.class, (Object)testExecutionRequest);
        InternalCancellationTokenAdapter buildCancellationToken = new InternalCancellationTokenAdapter(cancellationToken);
        Object results = this.connection.runTests(testExecutionRequestVersion2, buildCancellationToken, providerParameters);
        return new ProviderBuildResult<Object>(results);
    }

    private ProviderOperationParameters validateAndConvert(BuildParameters buildParameters) {
        LOGGER.info("Tooling API is using target Gradle version: {}.", (Object)GradleVersion.current().getVersion());
        this.assertUsingJava7();
        this.checkUnsupportedTapiVersion();
        ProviderOperationParameters parameters = (ProviderOperationParameters)this.adapter.builder(ProviderOperationParameters.class).mixInTo(ProviderOperationParameters.class, BuildLogLevelMixIn.class).build((Object)buildParameters);
        this.checkDeprecatedTapiVersion(parameters);
        DeprecationLogger.reset();
        return parameters;
    }

    private UnsupportedVersionException unsupportedConnectionException() {
        return new UnsupportedVersionException(String.format(UNSUPPORTED_MESSAGE, this.createCurrentVersionMessage()));
    }

    private String createCurrentVersionMessage() {
        if (this.consumerVersion == null) {
            return "";
        }
        return String.format("You are currently using tooling API version %s. ", this.consumerVersion.getVersion());
    }

    private void checkUnsupportedTapiVersion() {
        if (this.consumerVersion == null || this.consumerVersion.compareTo(MIN_CLIENT_VERSION) < 0) {
            throw this.unsupportedConnectionException();
        }
    }

    private void checkDeprecatedTapiVersion(ProviderOperationParameters parameters) {
        if (this.consumerVersion.compareTo(MIN_LTS_CLIENT_VERSION) < 0 && parameters.getStandardOutput() != null) {
            try {
                parameters.getStandardOutput().write(String.format(DEPRECATION_MESSAGE, this.createCurrentVersionMessage()).getBytes());
            }
            catch (IOException e) {
                throw new UncheckedIOException((Throwable)e);
            }
        }
    }
}

