/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve;

import com.intellij.psi.PsiElement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.SourceElement;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.diagnostics.DiagnosticSink;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtClass;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.descriptorUtil.DescriptorUtilsKt;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeConstructorSubstitution;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeSubstitutor;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.DFS;

@Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0003\u0015\u0016\u0017B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J+\u0010\u000b\u001a\b\u0012\u0004\u0012\u0002H\r0\f\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\u0006\u0010\u000f\u001a\u0002H\rH\u0002\u00a2\u0006\u0002\u0010\u0010J&\u0010\u0011\u001a\u00020\u0012\"\u0004\b\u0000\u0010\r*\b\u0012\u0004\u0012\u0002H\r0\u000e2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u0002H\r0\u0014H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtClass;", "classDescriptor", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "diagnosticHolder", "Lorg/jetbrains/kotlin/diagnostics/DiagnosticSink;", "collectReachable", "", "T", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "from", "(Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;Ljava/lang/Object;)Ljava/util/List;", "isEdgeInCycle", "", "edge", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "ExpansiveEdge", "Graph", "GraphBuilder", "frontend"})
public final class NonExpansiveInheritanceRestrictionChecker {
    public static final NonExpansiveInheritanceRestrictionChecker INSTANCE;

    /*
     * WARNING - void declaration
     */
    @JvmStatic
    public static final void check(@NotNull KtClass declaration, @NotNull ClassDescriptor classDescriptor, @NotNull DiagnosticSink diagnosticHolder) {
        Object object;
        DeclarationDescriptor it;
        Collection collection;
        Iterable $receiver$iv$iv;
        Object element$iv2;
        boolean bl;
        List problemNodes;
        block12: {
            Iterator<TypeParameterDescriptor> $receiver$iv$iv2;
            Object element$iv$iv2;
            void $receiver$iv$iv3;
            Iterable $receiver$iv;
            TypeConstructor typeConstructor2;
            Intrinsics.checkParameterIsNotNull(declaration, "declaration");
            Intrinsics.checkParameterIsNotNull(classDescriptor, "classDescriptor");
            Intrinsics.checkParameterIsNotNull(diagnosticHolder, "diagnosticHolder");
            TypeConstructor typeConstructor3 = typeConstructor2 = classDescriptor.getTypeConstructor();
            Intrinsics.checkExpressionValueIsNotNull(typeConstructor3, "typeConstructor");
            if (typeConstructor3.getParameters().isEmpty()) {
                return;
            }
            GraphBuilder builder = new GraphBuilder(typeConstructor2);
            Graph<TypeParameterDescriptor> graph2 = builder.build();
            Iterable iterable = $receiver$iv = (Iterable)graph2.getExpansiveEdges();
            Iterable destination$iv$iv = new ArrayList();
            for (Object element$iv$iv2 : $receiver$iv$iv3) {
                ExpansiveEdge it2 = (ExpansiveEdge)element$iv$iv2;
                if (!INSTANCE.isEdgeInCycle(graph2, it2)) continue;
                destination$iv$iv.add(element$iv$iv2);
            }
            List edgesInCycles = (List)destination$iv$iv;
            if (edgesInCycles.isEmpty()) {
                return;
            }
            Iterable $receiver$iv2 = edgesInCycles;
            destination$iv$iv = $receiver$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            element$iv$iv2 = $receiver$iv$iv2.iterator();
            while (element$iv$iv2.hasNext()) {
                Object element$iv$iv3 = element$iv$iv2.next();
                ExpansiveEdge it3 = (ExpansiveEdge)element$iv$iv3;
                Iterable list$iv$iv = SetsKt.setOf(new TypeParameterDescriptor[]{(TypeParameterDescriptor)it3.getFrom(), (TypeParameterDescriptor)it3.getTo()});
                CollectionsKt.addAll(destination$iv$iv2, list$iv$iv);
            }
            problemNodes = (List)destination$iv$iv2;
            for (TypeParameterDescriptor typeParameter : typeConstructor2.getParameters()) {
                if (!problemNodes.contains(typeParameter)) continue;
                TypeParameterDescriptor typeParameterDescriptor = typeParameter;
                Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                PsiElement psiElement = DescriptorToSourceUtils.descriptorToDeclaration(typeParameterDescriptor);
                if (psiElement == null) {
                    psiElement = declaration;
                }
                PsiElement element = psiElement;
                diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE.on(element));
                return;
            }
            $receiver$iv2 = problemNodes;
            if ($receiver$iv2 instanceof Collection && ((Collection)$receiver$iv2).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv2 : $receiver$iv2) {
                    Object it4 = element$iv2;
                    if (!(Intrinsics.areEqual(it4.getSource(), SourceElement.NO_SOURCE) ^ true)) continue;
                    bl = true;
                    break block12;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        Iterable $receiver$iv = problemNodes;
        element$iv2 = $receiver$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            TypeParameterDescriptor $i$a$1$flatMap = (TypeParameterDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            object = it.getContainingDeclaration();
            collection.add(object);
        }
        $receiver$iv = (List)destination$iv$iv;
        $receiver$iv$iv = $receiver$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($receiver$iv, 10));
        for (Object item$iv$iv : $receiver$iv$iv) {
            it = (DeclarationDescriptor)item$iv$iv;
            collection = destination$iv$iv;
            DeclarationDescriptor declarationDescriptor = it;
            Intrinsics.checkExpressionValueIsNotNull(declarationDescriptor, "it");
            object = DescriptorUtilsKt.getFqNameUnsafe(declarationDescriptor).asString();
            collection.add(object);
        }
        SortedSet typeFqNames = CollectionsKt.toSortedSet((List)destination$iv$iv);
        diagnosticHolder.report(Errors.EXPANSIVE_INHERITANCE_IN_JAVA.on(declaration, CollectionsKt.joinToString$default(typeFqNames, ", ", null, null, 0, null, null, 62, null)));
    }

    private final <T> boolean isEdgeInCycle(@NotNull Graph<T> $receiver, ExpansiveEdge<? extends T> edge) {
        return this.collectReachable($receiver, edge.getTo()).contains(edge.getFrom());
    }

    private final <T> List<T> collectReachable(@NotNull Graph<T> $receiver, T from) {
        DFS.NodeHandlerWithListResult handler2 = new DFS.NodeHandlerWithListResult<T, T>(){

            public void afterChildren(@Nullable T current) {
                ((LinkedList)this.result).add(current);
            }
        };
        DFS.Neighbors neighbors2 = new DFS.Neighbors<T>($receiver){
            final /* synthetic */ Graph receiver$0;

            @NotNull
            public Iterable<T> getNeighbors(T current) {
                return this.receiver$0.getNeighbors(current);
            }
            {
                this.receiver$0 = $receiver;
            }
        };
        DFS.dfs((Collection)CollectionsKt.listOf(from), neighbors2, handler2);
        Object object = handler2.result();
        Intrinsics.checkExpressionValueIsNotNull(object, "handler.result()");
        return (List)object;
    }

    private NonExpansiveInheritanceRestrictionChecker() {
    }

    static {
        NonExpansiveInheritanceRestrictionChecker nonExpansiveInheritanceRestrictionChecker;
        INSTANCE = nonExpansiveInheritanceRestrictionChecker = new NonExpansiveInheritanceRestrictionChecker();
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\"\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u00072\b\b\u0002\u0010\u0015\u001a\u00020\u0016H\u0002J\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00070\u0018J\u0010\u0010\u0019\u001a\u00020\u00122\u0006\u0010\u0002\u001a\u00020\u0003H\u0002R6\u0010\u0005\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b0\u0006j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\b`\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\n\u001a\u001e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f0\u000bj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\f`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u000e\u001a\u0012\u0012\u0004\u0012\u00020\u00030\u000bj\b\u0012\u0004\u0012\u00020\u0003`\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$GraphBuilder;", "", "typeConstructor", "Lorg/jetbrains/kotlin/types/TypeConstructor;", "(Lorg/jetbrains/kotlin/types/TypeConstructor;)V", "edgeLists", "Ljava/util/HashMap;", "Lorg/jetbrains/kotlin/descriptors/TypeParameterDescriptor;", "", "Lkotlin/collections/HashMap;", "expansiveEdges", "Ljava/util/HashSet;", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "Lkotlin/collections/HashSet;", "processedTypeConstructors", "getTypeConstructor", "()Lorg/jetbrains/kotlin/types/TypeConstructor;", "addEdge", "", "from", "to", "expansive", "", "build", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "doBuildGraph", "frontend"})
    private static final class GraphBuilder {
        private final HashSet<TypeConstructor> processedTypeConstructors;
        private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
        private final HashMap<TypeParameterDescriptor, Set<TypeParameterDescriptor>> edgeLists;
        @NotNull
        private final TypeConstructor typeConstructor;

        @NotNull
        public final Graph<TypeParameterDescriptor> build() {
            this.doBuildGraph(this.typeConstructor);
            return new Graph<TypeParameterDescriptor>(this){
                @NotNull
                private final HashSet<ExpansiveEdge<TypeParameterDescriptor>> expansiveEdges;
                final /* synthetic */ GraphBuilder this$0;

                @NotNull
                public Collection<TypeParameterDescriptor> getNeighbors(@NotNull TypeParameterDescriptor node) {
                    Intrinsics.checkParameterIsNotNull(node, "node");
                    Set set = (Set)GraphBuilder.access$getEdgeLists$p(this.this$0).get(node);
                    return set != null ? (Collection)set : (Collection)CollectionsKt.emptyList();
                }

                @NotNull
                public HashSet<ExpansiveEdge<TypeParameterDescriptor>> getExpansiveEdges() {
                    return this.expansiveEdges;
                }
                {
                    this.this$0 = $outer;
                    this.expansiveEdges = GraphBuilder.access$getExpansiveEdges$p($outer);
                }
            };
        }

        private final void addEdge(TypeParameterDescriptor from, TypeParameterDescriptor to, boolean expansive) {
            Object object;
            Map $receiver$iv = this.edgeLists;
            Object value$iv = $receiver$iv.get(from);
            if (value$iv == null) {
                LinkedHashSet answer$iv = new LinkedHashSet();
                $receiver$iv.put(from, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Set)object).add(to);
            if (expansive) {
                this.expansiveEdges.add(new ExpansiveEdge<TypeParameterDescriptor>(from, to));
            }
        }

        /*
         * WARNING - void declaration
         */
        private final void doBuildGraph(TypeConstructor typeConstructor2) {
            if (typeConstructor2.getParameters().isEmpty()) {
                return;
            }
            List<TypeParameterDescriptor> typeParameters2 = typeConstructor2.getParameters();
            Collection<KotlinType> collection = typeConstructor2.getSupertypes();
            Intrinsics.checkExpressionValueIsNotNull(collection, "typeConstructor.supertypes");
            for (KotlinType constituentType : TypeUtilsKt.constituentTypes(collection)) {
                TypeConstructor constituentTypeConstructor = constituentType.getConstructor();
                if (!this.processedTypeConstructors.contains(constituentTypeConstructor)) {
                    this.processedTypeConstructors.add(constituentTypeConstructor);
                    this.doBuildGraph(constituentTypeConstructor);
                }
                if (constituentTypeConstructor.getParameters().size() != constituentType.getArguments().size()) continue;
                Iterable $receiver$iv = constituentType.getArguments();
                int index$iv = 0;
                for (Object item$iv : $receiver$iv) {
                    void $receiver$iv$iv;
                    Iterable $receiver$iv2;
                    void typeProjection;
                    int n = index$iv++;
                    TypeProjection typeProjection2 = (TypeProjection)item$iv;
                    int i = n;
                    if (Intrinsics.areEqual((Object)typeProjection.getProjectionKind(), (Object)Variance.INVARIANT)) {
                        Collection<KotlinType> constituents = TypeUtilsKt.constituentTypes((Collection<? extends KotlinType>)SetsKt.setOf(typeProjection.getType()));
                        Iterator<TypeParameterDescriptor> iterator2 = typeParameters2.iterator();
                        while (iterator2.hasNext()) {
                            TypeParameterDescriptor typeParameter;
                            TypeParameterDescriptor typeParameterDescriptor = typeParameter = iterator2.next();
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "typeParameter");
                            if (!constituents.contains(typeParameterDescriptor.getDefaultType()) && !constituents.contains(typeParameter.getDefaultType().makeNullableAsSpecified(true))) continue;
                            TypeParameterDescriptor typeParameterDescriptor2 = constituentTypeConstructor.getParameters().get(i);
                            Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor2, "constituentTypeConstructor.parameters[i]");
                            this.addEdge(typeParameter, typeParameterDescriptor2, !TypeUtils.isTypeParameter(typeProjection.getType()));
                        }
                        continue;
                    }
                    TypeParameterDescriptor originalTypeParameter = constituentTypeConstructor.getParameters().get(i);
                    HashSet<KotlinType> bounds = new HashSet<KotlinType>();
                    TypeSubstitutor substitutor2 = TypeConstructorSubstitution.Companion.create(constituentType).buildSubstitutor();
                    TypeParameterDescriptor typeParameterDescriptor = originalTypeParameter;
                    Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor, "originalTypeParameter");
                    List<KotlinType> list2 = typeParameterDescriptor.getUpperBounds();
                    Intrinsics.checkExpressionValueIsNotNull(list2, "originalTypeParameter.upperBounds");
                    Iterable iterable = $receiver$iv2 = (Iterable)list2;
                    Collection destination$iv$iv = new ArrayList();
                    void $receiver$iv$iv$iv = $receiver$iv$iv;
                    for (Object element$iv$iv$iv : $receiver$iv$iv$iv) {
                        KotlinType kotlinType;
                        Object element$iv$iv = element$iv$iv$iv;
                        KotlinType it = (KotlinType)element$iv$iv;
                        if (substitutor2.substitute(it, Variance.INVARIANT) == null) continue;
                        KotlinType it$iv$iv = kotlinType;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    List adaptedUpperBounds = (List)destination$iv$iv;
                    bounds.addAll(adaptedUpperBounds);
                    if (!typeProjection.isStarProjection()) {
                        bounds.add(typeProjection.getType());
                    }
                    Collection<KotlinType> boundClosure2 = TypeUtilsKt.boundClosure((Collection<? extends KotlinType>)bounds);
                    Collection<KotlinType> constituentTypes = TypeUtilsKt.constituentTypes(boundClosure2);
                    Iterator<TypeParameterDescriptor> iterator3 = typeParameters2.iterator();
                    while (iterator3.hasNext()) {
                        TypeParameterDescriptor typeParameter;
                        TypeParameterDescriptor typeParameterDescriptor3 = typeParameter = iterator3.next();
                        Intrinsics.checkExpressionValueIsNotNull(typeParameterDescriptor3, "typeParameter");
                        if (!constituentTypes.contains(typeParameterDescriptor3.getDefaultType()) && !constituentTypes.contains(typeParameter.getDefaultType().makeNullableAsSpecified(true))) continue;
                        this.addEdge(typeParameter, originalTypeParameter, true);
                    }
                }
            }
        }

        @NotNull
        public final TypeConstructor getTypeConstructor() {
            return this.typeConstructor;
        }

        public GraphBuilder(@NotNull TypeConstructor typeConstructor2) {
            Intrinsics.checkParameterIsNotNull(typeConstructor2, "typeConstructor");
            this.typeConstructor = typeConstructor2;
            GraphBuilder graphBuilder = this;
            Cloneable cloneable2 = new HashSet();
            graphBuilder.processedTypeConstructors = cloneable2;
            graphBuilder = this;
            cloneable2 = new HashSet();
            graphBuilder.expansiveEdges = cloneable2;
            graphBuilder = this;
            cloneable2 = new HashMap();
            graphBuilder.edgeLists = cloneable2;
        }

        @NotNull
        public static final /* synthetic */ HashMap access$getEdgeLists$p(GraphBuilder $this) {
            return $this.edgeLists;
        }

        @NotNull
        public static final /* synthetic */ HashSet access$getExpansiveEdges$p(GraphBuilder $this) {
            return $this.expansiveEdges;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0006\b\u0000\u0010\u0001 \u00012\u00020\u0002B\u0015\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J\u000e\u0010\n\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000b\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u0007J(\u0010\f\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00028\u0000H\u00c6\u0001\u00a2\u0006\u0002\u0010\rJ\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0012H\u00d6\u0001J\t\u0010\u0013\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\t\u0010\u0007\u00a8\u0006\u0015"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "T", "", "from", "to", "(Ljava/lang/Object;Ljava/lang/Object;)V", "getFrom", "()Ljava/lang/Object;", "Ljava/lang/Object;", "getTo", "component1", "component2", "copy", "(Ljava/lang/Object;Ljava/lang/Object;)Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "equals", "", "other", "hashCode", "", "toString", "", "frontend"})
    private static final class ExpansiveEdge<T> {
        private final T from;
        private final T to;

        public final T getFrom() {
            return this.from;
        }

        public final T getTo() {
            return this.to;
        }

        public ExpansiveEdge(T from, T to) {
            this.from = from;
            this.to = to;
        }

        public final T component1() {
            return this.from;
        }

        public final T component2() {
            return this.to;
        }

        @NotNull
        public final ExpansiveEdge<T> copy(T from, T to) {
            return new ExpansiveEdge<T>(from, to);
        }

        @NotNull
        public static /* bridge */ /* synthetic */ ExpansiveEdge copy$default(ExpansiveEdge expansiveEdge, Object object, Object object2, int n, Object object3) {
            if ((n & 1) != 0) {
                object = expansiveEdge.from;
            }
            if ((n & 2) != 0) {
                object2 = expansiveEdge.to;
            }
            return expansiveEdge.copy(object, object2);
        }

        public String toString() {
            return "ExpansiveEdge(from=" + this.from + ", to=" + this.to + ")";
        }

        public int hashCode() {
            T t = this.from;
            T t2 = this.to;
            return (t != null ? t.hashCode() : 0) * 31 + (t2 != null ? t2.hashCode() : 0);
        }

        public boolean equals(Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof ExpansiveEdge)) break block3;
                    ExpansiveEdge expansiveEdge = (ExpansiveEdge)object;
                    if (!Intrinsics.areEqual(this.from, expansiveEdge.from) || !Intrinsics.areEqual(this.to, expansiveEdge.to)) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 9}, bv={1, 0, 2}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\bb\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002J\u001b\u0010\b\u001a\b\u0012\u0004\u0012\u00028\u00000\t2\u0006\u0010\n\u001a\u00028\u0000H&\u00a2\u0006\u0002\u0010\u000bR\u001e\u0010\u0003\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00028\u00000\u00050\u0004X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\f"}, d2={"Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$Graph;", "T", "", "expansiveEdges", "", "Lorg/jetbrains/kotlin/resolve/NonExpansiveInheritanceRestrictionChecker$ExpansiveEdge;", "getExpansiveEdges", "()Ljava/util/Set;", "getNeighbors", "", "node", "(Ljava/lang/Object;)Ljava/util/Collection;", "frontend"})
    private static interface Graph<T> {
        @NotNull
        public Collection<T> getNeighbors(T var1);

        @NotNull
        public Set<ExpansiveEdge<T>> getExpansiveEdges();
    }
}

