/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.webflow.model.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReferenceBase;
import com.intellij.psi.xml.XmlFile;
import com.intellij.spring.webflow.model.converters.WebflowConverterUtil;
import com.intellij.spring.webflow.model.converters.WebflowLookupUtil;
import com.intellij.spring.webflow.model.xml.Flow;
import com.intellij.spring.webflow.resources.WebflowBundle;
import com.intellij.spring.webflow.util.WebflowUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.GenericDomValue;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParentStateFlowReference
extends PsiReferenceBase<PsiElement>
implements EmptyResolveMessageProvider {
    @NotNull
    private final List<Flow> relatedFlows;
    @Nullable
    private final Flow flow;

    ParentStateFlowReference(PsiElement element, TextRange range, @NotNull GenericDomValue<String> value) {
        if (value == null) {
            ParentStateFlowReference.$$$reportNull$$$0(0);
        }
        super(element, range, true);
        this.relatedFlows = ParentStateFlowReference.getAllRelatedFlows(value);
        this.flow = this.findFlow();
    }

    @Nullable
    public Flow getFlow() {
        return this.flow;
    }

    @Nullable
    private Flow findFlow() {
        String flowName = this.getValue();
        return (Flow)ContainerUtil.find(this.relatedFlows, flow1 -> {
            String name = WebflowUtil.getFlowName(flow1);
            return Comparing.equal((String)name, (String)flowName);
        });
    }

    public PsiElement resolve() {
        if (this.getValue().isEmpty()) {
            return this.myElement;
        }
        if (this.flow == null) {
            return null;
        }
        return WebflowUtil.resolveFlow(this.flow);
    }

    @NotNull
    public Object[] getVariants() {
        Object[] objectArray = WebflowLookupUtil.forFlows(this.relatedFlows);
        if (objectArray == null) {
            ParentStateFlowReference.$$$reportNull$$$0(1);
        }
        return objectArray;
    }

    @NotNull
    public String getUnresolvedMessagePattern() {
        String string = WebflowBundle.message("parent.state.converter.can.not.resolve.flow", new Object[0]);
        if (string == null) {
            ParentStateFlowReference.$$$reportNull$$$0(2);
        }
        return string;
    }

    public boolean isReferenceTo(PsiElement element) {
        return super.isReferenceTo(element) || WebflowConverterUtil.isCustomFlowIdReference(element);
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        if (this.resolve() instanceof XmlFile) {
            String name = FileUtil.getNameWithoutExtension((String)newElementName);
            return super.handleElementRename(name);
        }
        return super.handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        VirtualFile file;
        if (element == null) {
            ParentStateFlowReference.$$$reportNull$$$0(3);
        }
        if (element instanceof XmlFile && (file = ((XmlFile)element).getVirtualFile()) != null) {
            return super.handleElementRename(file.getNameWithoutExtension());
        }
        return this.getElement();
    }

    @NotNull
    private static List<Flow> getAllRelatedFlows(@NotNull GenericDomValue<String> value) {
        Flow flow;
        if (value == null) {
            ParentStateFlowReference.$$$reportNull$$$0(4);
        }
        if ((flow = (Flow)value.getParentOfType(Flow.class, true)) == null) {
            List<Flow> list = Collections.emptyList();
            if (list == null) {
                ParentStateFlowReference.$$$reportNull$$$0(5);
            }
            return list;
        }
        List<Flow> list = flow.getAllRelatedFlows();
        if (list == null) {
            ParentStateFlowReference.$$$reportNull$$$0(6);
        }
        return list;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "value";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/webflow/model/converters/ParentStateFlowReference";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/webflow/model/converters/ParentStateFlowReference";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getUnresolvedMessagePattern";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllRelatedFlows";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "bindToElement";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getAllRelatedFlows";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

