/*
 * Decompiled with CFR 0.152.
 */
package com.thaiopensource.relaxng.output.xsd.basic;

import com.thaiopensource.relaxng.output.common.Name;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class Wildcard {
    private final boolean positive;
    private final Set namespaces;
    private final Set excludedNames;

    public Wildcard(boolean bl, Set set, Set set2) {
        this.positive = bl;
        this.namespaces = Collections.unmodifiableSet(set);
        this.excludedNames = Collections.unmodifiableSet(set2);
    }

    public boolean isPositive() {
        return this.positive;
    }

    public Set getNamespaces() {
        return this.namespaces;
    }

    public Set getExcludedNames() {
        return this.excludedNames;
    }

    public boolean equals(Object object) {
        if (!(object instanceof Wildcard)) {
            return false;
        }
        Wildcard wildcard = (Wildcard)object;
        return this.positive == wildcard.positive && this.namespaces.equals(wildcard.namespaces) && this.excludedNames.equals(wildcard.excludedNames);
    }

    public int hashCode() {
        return this.namespaces.hashCode() ^ this.excludedNames.hashCode();
    }

    public boolean contains(Name name) {
        return this.namespaces.contains(name.getNamespaceUri()) == this.positive && !this.excludedNames.contains(name);
    }

    public static Wildcard union(Wildcard wildcard, Wildcard wildcard2) {
        boolean bl;
        HashSet hashSet = new HashSet();
        if (wildcard.isPositive() && wildcard2.isPositive()) {
            bl = true;
            hashSet.addAll(wildcard.getNamespaces());
            hashSet.addAll(wildcard2.getNamespaces());
        } else {
            bl = false;
            if (!wildcard.isPositive() && !wildcard2.isPositive()) {
                hashSet.addAll(wildcard.getNamespaces());
                hashSet.retainAll(wildcard2.getNamespaces());
            } else if (!wildcard.isPositive()) {
                hashSet.addAll(wildcard.getNamespaces());
                hashSet.removeAll(wildcard2.getNamespaces());
            } else {
                hashSet.addAll(wildcard2.getNamespaces());
                hashSet.removeAll(wildcard.getNamespaces());
            }
        }
        HashSet hashSet2 = new HashSet();
        Wildcard.addExcludedNames(hashSet2, wildcard, wildcard2);
        Wildcard.addExcludedNames(hashSet2, wildcard2, wildcard);
        return new Wildcard(bl, hashSet, hashSet2);
    }

    private static void addExcludedNames(Set set, Wildcard wildcard, Wildcard wildcard2) {
        Iterator iterator = wildcard.getExcludedNames().iterator();
        while (iterator.hasNext()) {
            Name name = (Name)iterator.next();
            if (wildcard2.contains(name)) continue;
            set.add(name);
        }
    }
}

