/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.data.commons.projection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.jam.JamService;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtilBase;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spring.data.commons.inspections.SpringDataRepositoryMethodReturnTypeInspection;
import com.intellij.spring.data.commons.util.SpringDataUtil;
import com.intellij.spring.data.rest.SpringProjectionJamComponent;
import com.intellij.spring.data.rest.SpringRepositoryRestResource;
import com.intellij.spring.data.utils.model.RepositoriesSearchUtil;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringDataProjectionUtil {
    public static boolean isExplicitProjectionType(@NotNull PsiClass projectionClass, @NotNull PsiClass domainClass, @NotNull PsiClass repositoryClass) {
        SpringRepositoryRestResource restResource;
        SpringProjectionJamComponent projectionJamComponent;
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(0);
        }
        if (domainClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(1);
        }
        if (repositoryClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(2);
        }
        if ((projectionJamComponent = (SpringProjectionJamComponent)SpringProjectionJamComponent.META.getJamElement((PsiModifierListOwner)projectionClass)) != null) {
            for (PsiClass aClass : projectionJamComponent.getDomainClasses()) {
                if (!aClass.equals(domainClass)) continue;
                return true;
            }
        }
        return (restResource = (SpringRepositoryRestResource)SpringRepositoryRestResource.META.getJamElement((PsiModifierListOwner)repositoryClass)) != null && projectionClass.equals(restResource.getProjectionClass());
    }

    public static boolean hasProjectionMethods(@NotNull PsiClass projectionClass, @NotNull PsiClass domainClass) {
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(3);
        }
        if (domainClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(4);
        }
        Set<String> domainClassProperties = SpringDataUtil.getProperties(domainClass);
        PsiMethod[] methods = projectionClass.getMethods();
        if (methods.length == 0) {
            return false;
        }
        for (PsiMethod method : methods) {
            String propertyName = PropertyUtilBase.getPropertyName((PsiMethod)method);
            if (propertyName == null) continue;
            boolean methodHasClosedProjection = domainClassProperties.contains(propertyName);
            boolean methodHasOpenProjection = AnnotationUtil.isAnnotated((PsiModifierListOwner)method, (String)"org.springframework.beans.factory.annotation.Value", (int)1);
            if (methodHasClosedProjection || methodHasOpenProjection) continue;
            return false;
        }
        return true;
    }

    @Nullable
    public static PsiMember findDomainAssociatedMember(@NotNull PsiMethod projectionMethod, @NotNull PsiClass domainClass) {
        String propertyName;
        if (projectionMethod == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(5);
        }
        if (domainClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(6);
        }
        if ((propertyName = PropertyUtilBase.getPropertyName((PsiMethod)projectionMethod)) != null) {
            PsiField[] fields;
            Map properties = PropertyUtilBase.getAllProperties((PsiClass)domainClass, (boolean)false, (boolean)true);
            PsiMethod method = (PsiMethod)properties.get(propertyName);
            if (method != null) {
                return method;
            }
            for (PsiField field : fields = domainClass.getFields()) {
                if (!propertyName.equals(PropertyUtilBase.suggestPropertyName((PsiField)field))) continue;
                return field;
            }
        }
        return null;
    }

    @NotNull
    public static Set<PsiClass> getDomainProjectionClasses(@NotNull PsiClass projectionClass) {
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(7);
        }
        Set set = (Set)CachedValuesManager.getCachedValue((PsiElement)projectionClass, () -> {
            if (projectionClass == null) {
                SpringDataProjectionUtil.$$$reportNull$$$0(23);
            }
            return CachedValueProvider.Result.create(SpringDataProjectionUtil.getDomainClasses(projectionClass), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        });
        if (set == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(8);
        }
        return set;
    }

    @NotNull
    private static Set<PsiClass> getDomainClasses(@NotNull PsiClass projectionClass) {
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(9);
        }
        HashSet domainClasses = ContainerUtil.newHashSet();
        SpringProjectionJamComponent projectionJamComponent = (SpringProjectionJamComponent)SpringProjectionJamComponent.META.getJamElement((PsiModifierListOwner)projectionClass);
        if (projectionJamComponent != null) {
            Set<PsiClass> set = projectionJamComponent.getDomainClasses();
            if (set == null) {
                SpringDataProjectionUtil.$$$reportNull$$$0(10);
            }
            return set;
        }
        GlobalSearchScope scope = projectionClass.getResolveScope();
        Project project = projectionClass.getProject();
        for (SpringRepositoryRestResource restResource : JamService.getJamService((Project)project).getJamClassElements(SpringRepositoryRestResource.JAM_KEY, "org.springframework.data.rest.core.annotation.RepositoryRestResource", scope)) {
            if (!projectionClass.equals(restResource.getProjectionClass())) continue;
            ContainerUtil.addIfNotNull((Collection)domainClasses, (Object)SpringDataProjectionUtil.getDomainClass(restResource.getPsiElement()));
        }
        if (domainClasses.size() > 0) {
            HashSet hashSet = domainClasses;
            if (hashSet == null) {
                SpringDataProjectionUtil.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        for (SpringBeanPointer repository : SpringDataProjectionUtil.geRepositories(ModuleUtilCore.findModuleForPsiElement((PsiElement)projectionClass), scope)) {
            PsiClass domainClass;
            PsiClass repositoryBeanClass = repository.getBeanClass();
            if (repositoryBeanClass == null || (domainClass = SpringDataProjectionUtil.getDomainClass(repositoryBeanClass)) == null || projectionClass.equals(domainClass) || !SpringDataProjectionUtil.isRepositoryUsesProjections(repositoryBeanClass, projectionClass) || !SpringDataProjectionUtil.hasProjectionMethods(projectionClass, domainClass)) continue;
            domainClasses.add(domainClass);
        }
        HashSet hashSet = domainClasses;
        if (hashSet == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    public static boolean isRepositoryUsesProjections(@NotNull PsiClass repositoryBeanClass, @NotNull PsiClass projectionClass) {
        if (repositoryBeanClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(13);
        }
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(14);
        }
        List<PsiMethod> methods = SpringDataUtil.getRepositoryMethods(repositoryBeanClass);
        for (PsiMethod method : methods) {
            if (!SpringDataProjectionUtil.isRepositoryUsesProjections(projectionClass, method)) continue;
            return true;
        }
        return false;
    }

    public static boolean isRepositoryUsesProjections(@NotNull PsiClass projectionClass, @NotNull PsiMethod method) {
        PsiType returnType;
        if (projectionClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(15);
        }
        if (method == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(16);
        }
        if ((returnType = method.getReturnType()) == null) {
            return false;
        }
        PsiClassType projectionType = PsiTypesUtil.getClassType((PsiClass)projectionClass);
        if (returnType.equals(projectionType)) {
            return true;
        }
        if (projectionType.equals((Object)PsiUtil.extractIterableTypeParameter((PsiType)returnType, (boolean)false))) {
            return true;
        }
        return projectionType.equals((Object)SpringDataRepositoryMethodReturnTypeInspection.getSubstitutedTypeParameters(returnType));
    }

    @NotNull
    public static Set<SpringBeanPointer> geRepositories(@Nullable Module module, @NotNull GlobalSearchScope scope) {
        if (scope == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(17);
        }
        if (module == null) {
            Set<SpringBeanPointer> set = Collections.emptySet();
            if (set == null) {
                SpringDataProjectionUtil.$$$reportNull$$$0(18);
            }
            return set;
        }
        List<CommonSpringBean> repositories = RepositoriesSearchUtil.getAllRepositories(scope, module, "org.springframework.data.repository.Repository");
        Set set = BeanService.getInstance().mapSpringBeans(repositories);
        if (set == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(19);
        }
        return set;
    }

    @Nullable
    public static PsiClass getDomainClass(@NotNull PsiClass repositoryClass) {
        Pair<PsiClass, ? extends PsiType> pair;
        if (repositoryClass == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(20);
        }
        if ((pair = SpringDataUtil.substituteRepositoryTypes(repositoryClass)) != null) {
            return (PsiClass)pair.first;
        }
        return null;
    }

    @NotNull
    public static Set<PsiMember> getDomainProjectionMembers(@NotNull PsiMethod projectionMethod) {
        if (projectionMethod == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(21);
        }
        HashSet members = ContainerUtil.newHashSet();
        PsiClass projectionClass = projectionMethod.getContainingClass();
        if (projectionClass != null && projectionClass.isInterface()) {
            for (PsiClass domainClass : SpringDataProjectionUtil.getDomainProjectionClasses(projectionClass)) {
                ContainerUtil.addIfNotNull((Collection)members, (Object)SpringDataProjectionUtil.findDomainAssociatedMember(projectionMethod, domainClass));
            }
        }
        HashSet hashSet = members;
        if (hashSet == null) {
            SpringDataProjectionUtil.$$$reportNull$$$0(22);
        }
        return hashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionClass";
                break;
            }
            case 1: 
            case 4: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "domainClass";
                break;
            }
            case 2: 
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryClass";
                break;
            }
            case 5: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectionMethod";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "repositoryBeanClass";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/data/commons/projection/SpringDataProjectionUtil";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainProjectionClasses";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainClasses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "geRepositories";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getDomainProjectionMembers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "isExplicitProjectionType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasProjectionMethods";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "findDomainAssociatedMember";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getDomainProjectionClasses";
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getDomainClasses";
                break;
            }
            case 13: 
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isRepositoryUsesProjections";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "geRepositories";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getDomainClass";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getDomainProjectionMembers";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getDomainProjectionClasses$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 8: 
            case 10: 
            case 11: 
            case 12: 
            case 18: 
            case 19: 
            case 22: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

