/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.properties.editor;

import com.intellij.icons.AllIcons;
import com.intellij.ide.structureView.StructureViewTreeElement;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.ResourceBundle;
import com.intellij.lang.properties.editor.ResourceBundleEditorViewElement;
import com.intellij.lang.properties.editor.ResourceBundlePropertyStructureViewElement;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.navigation.ItemPresentation;
import com.intellij.psi.PsiFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import com.intellij.util.containers.MultiMap;
import gnu.trove.TObjectIntHashMap;
import gnu.trove.TObjectIntProcedure;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResourceBundleFileStructureViewElement
implements StructureViewTreeElement,
ResourceBundleEditorViewElement {
    private final ResourceBundle myResourceBundle;
    private volatile boolean myShowOnlyIncomplete;
    private final Map<String, ResourceBundlePropertyStructureViewElement> myElements = ContainerUtil.newLinkedHashMap();

    public ResourceBundleFileStructureViewElement(ResourceBundle resourceBundle) {
        this.myResourceBundle = resourceBundle;
    }

    public void setShowOnlyIncomplete(boolean showOnlyIncomplete) {
        this.myShowOnlyIncomplete = showOnlyIncomplete;
    }

    public boolean isShowOnlyIncomplete() {
        return this.myShowOnlyIncomplete;
    }

    public ResourceBundle getValue() {
        return this.myResourceBundle.isValid() ? null : this.myResourceBundle;
    }

    @NotNull
    public synchronized StructureViewTreeElement[] getChildren() {
        MultiMap<String, IProperty> propertyNames = ResourceBundleFileStructureViewElement.getPropertiesMap(this.myResourceBundle, this.myShowOnlyIncomplete);
        HashSet remains = new HashSet(this.myElements.keySet());
        for (Map.Entry entry : propertyNames.entrySet()) {
            String propKey = (String)entry.getKey();
            Collection properties = (Collection)entry.getValue();
            ResourceBundlePropertyStructureViewElement oldPropertyNode = this.myElements.get(propKey);
            if (oldPropertyNode != null && properties.contains(oldPropertyNode.getProperty())) {
                remains.remove((Object)propKey);
                continue;
            }
            if (this.myElements.containsKey(propKey)) {
                remains.remove((Object)propKey);
            }
            IProperty representative = (IProperty)properties.iterator().next();
            this.myElements.put(propKey, new ResourceBundlePropertyStructureViewElement(representative));
        }
        for (String remain : remains) {
            this.myElements.remove(remain);
        }
        StructureViewTreeElement[] structureViewTreeElementArray = this.myElements.values().toArray(StructureViewTreeElement.EMPTY_ARRAY);
        if (structureViewTreeElementArray == null) {
            ResourceBundleFileStructureViewElement.$$$reportNull$$$0(0);
        }
        return structureViewTreeElementArray;
    }

    public static MultiMap<String, IProperty> getPropertiesMap(ResourceBundle resourceBundle, boolean onlyIncomplete) {
        MultiMap<String, IProperty> propertyNames;
        if (!resourceBundle.isValid()) {
            return MultiMap.EMPTY;
        }
        List<PropertiesFile> propertiesFiles = resourceBundle.getPropertiesFiles();
        if (onlyIncomplete) {
            propertyNames = ResourceBundleFileStructureViewElement.getChildrenIdShowOnlyIncomplete(resourceBundle);
        } else {
            propertyNames = MultiMap.createLinked();
            for (PropertiesFile propertiesFile : propertiesFiles) {
                List<IProperty> properties = propertiesFile.getProperties();
                for (IProperty property : properties) {
                    String name = property.getKey();
                    propertyNames.putValue((Object)name, (Object)property);
                }
            }
        }
        return propertyNames;
    }

    private static MultiMap<String, IProperty> getChildrenIdShowOnlyIncomplete(ResourceBundle resourceBundle) {
        final MultiMap propertyNames = MultiMap.createLinked();
        TObjectIntHashMap occurrences = new TObjectIntHashMap();
        for (PropertiesFile file : resourceBundle.getPropertiesFiles()) {
            MultiMap currentFilePropertyNames = MultiMap.createLinked();
            for (IProperty property : file.getProperties()) {
                String name = property.getKey();
                currentFilePropertyNames.putValue((Object)name, (Object)property);
            }
            propertyNames.putAllValues(currentFilePropertyNames);
            for (String propertyName : currentFilePropertyNames.keySet()) {
                if (occurrences.contains((Object)propertyName)) {
                    occurrences.adjustValue((Object)propertyName, 1);
                    continue;
                }
                occurrences.put((Object)propertyName, 1);
            }
        }
        final int targetOccurrences = resourceBundle.getPropertiesFiles().size();
        occurrences.forEachEntry((TObjectIntProcedure)new TObjectIntProcedure<String>(){

            public boolean execute(String propertyName, int occurrences) {
                if (occurrences == targetOccurrences) {
                    propertyNames.remove((Object)propertyName);
                }
                return true;
            }
        });
        return propertyNames;
    }

    @NotNull
    public ItemPresentation getPresentation() {
        ItemPresentation itemPresentation = new ItemPresentation(){

            public String getPresentableText() {
                return ResourceBundleFileStructureViewElement.this.myResourceBundle.isValid() ? ResourceBundleFileStructureViewElement.this.myResourceBundle.getBaseName() : null;
            }

            public String getLocationString() {
                return null;
            }

            public Icon getIcon(boolean open) {
                return AllIcons.FileTypes.Properties;
            }
        };
        if (itemPresentation == null) {
            ResourceBundleFileStructureViewElement.$$$reportNull$$$0(1);
        }
        return itemPresentation;
    }

    @Override
    @Nullable
    public IProperty[] getProperties() {
        return IProperty.EMPTY_ARRAY;
    }

    @Override
    @Nullable
    public PsiFile[] getFiles() {
        ResourceBundle rb = this.getValue();
        if (rb == null) {
            return null;
        }
        List<PropertiesFile> files = rb.getPropertiesFiles();
        return (PsiFile[])ContainerUtil.map2Array(files, (Object[])new PsiFile[files.size()], propertiesFile -> propertiesFile.getContainingFile());
    }

    public void navigate(boolean requestFocus) {
    }

    public boolean canNavigate() {
        return false;
    }

    public boolean canNavigateToSource() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/intellij/lang/properties/editor/ResourceBundleFileStructureViewElement";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getPresentation";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

