/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.jam.JamService;
import com.intellij.jam.reflect.JamMemberMeta;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.contexts.model.AnnotationSpringModel;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.ComponentScannedApplicationContext;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.SpringProfile;
import com.intellij.spring.model.jam.JamPsiClassSpringBean;
import com.intellij.spring.model.jam.stereotype.SpringComponent;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class AnnotationSpringModelImpl
extends AnnotationSpringModel {
    private final Set<PsiClass> myConfigClasses;

    public AnnotationSpringModelImpl(@NotNull Set<PsiClass> classes, @NotNull Module module, @Nullable SpringFileSet fileSet) {
        if (classes == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(1);
        }
        super(module, fileSet);
        this.myConfigClasses = classes;
    }

    @NotNull
    public Module getModule() {
        Module module = super.getModule();
        if (module == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(2);
        }
        return module;
    }

    @NotNull
    public Set<CommonSpringModel> getModelsToProcess(boolean checkActiveProfiles) {
        Set<PsiPackage> packages;
        Set<LocalAnnotationModel> localAnnotationModels = this.getLocalAnnotationSpringModels(checkActiveProfiles);
        LinkedHashSet<LocalAnnotationModel> models = new LinkedHashSet<LocalAnnotationModel>(localAnnotationModels);
        LinkedHashSet<PsiClass> simpleBeans = new LinkedHashSet<PsiClass>();
        for (PsiClass configClass : this.myConfigClasses) {
            if (AnnotationSpringModelImpl.isConfiguration(configClass)) continue;
            simpleBeans.add(configClass);
        }
        if (!simpleBeans.isEmpty()) {
            models.add((LocalAnnotationModel)new BeansSpringModel(this.getModule(), simpleBeans));
        }
        if (!(packages = this.getComponentScanPackages()).isEmpty()) {
            models.add((LocalAnnotationModel)new ComponentScanPackagesModel((NotNullLazyValue)new NotNullLazyValue<Set<PsiPackage>>(){

                @NotNull
                protected Set<PsiPackage> compute() {
                    Set set = packages;
                    if (set == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return set;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/AnnotationSpringModelImpl$1", "compute"));
                }
            }, this.getModule()));
        }
        models.addAll(this.getDependencies());
        LinkedHashSet<LocalAnnotationModel> linkedHashSet = models;
        if (linkedHashSet == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(3);
        }
        return linkedHashSet;
    }

    @NotNull
    private Set<PsiPackage> getComponentScanPackages() {
        SpringFileSet set = this.getFileSet();
        if (!(set instanceof ComponentScannedApplicationContext)) {
            Set<PsiPackage> set2 = Collections.emptySet();
            if (set2 == null) {
                AnnotationSpringModelImpl.$$$reportNull$$$0(4);
            }
            return set2;
        }
        LinkedHashSet<PsiPackage> packages = new LinkedHashSet<PsiPackage>();
        for (String pkg : ((ComponentScannedApplicationContext)set).getComponentScanPackages()) {
            PsiPackage psiPackage = JavaPsiFacade.getInstance((Project)this.getModule().getProject()).findPackage(pkg);
            ContainerUtil.addIfNotNull(packages, (Object)psiPackage);
        }
        LinkedHashSet<PsiPackage> linkedHashSet = packages;
        if (linkedHashSet == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(5);
        }
        return linkedHashSet;
    }

    private Set<LocalAnnotationModel> getLocalAnnotationSpringModels(boolean checkActiveProfiles) {
        Set activeProfiles = this.getActiveProfiles();
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        for (PsiClass configClass : this.myConfigClasses) {
            Set profiles;
            JamPsiClassSpringBean springConfiguration = (JamPsiClassSpringBean)ObjectUtils.chooseNotNull((Object)AnnotationSpringModelImpl.getConfiguration(configClass), (Object)AnnotationSpringModelImpl.getComponent(configClass));
            if (springConfiguration == null || checkActiveProfiles && !AnnotationSpringModelImpl.isInActiveProfile(springConfiguration, activeProfiles)) continue;
            Set set = profiles = activeProfiles == null || !checkActiveProfiles ? Collections.emptySet() : activeProfiles;
            LocalAnnotationModel model = SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configClass, this.getModule(), (Set<String>)profiles);
            if (model == null) continue;
            models.add(model);
        }
        return models;
    }

    private static boolean isConfiguration(@NotNull PsiClass configClass) {
        if (configClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(6);
        }
        return SpringCommonUtils.isConfigurationOrMeta((PsiClass)configClass);
    }

    @Nullable
    private static SpringConfiguration getConfiguration(@NotNull PsiClass configClass) {
        if (configClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(7);
        }
        return configClass.isValid() ? (SpringConfiguration)JamService.getJamService((Project)configClass.getProject()).getJamElement(SpringConfiguration.JAM_KEY, (PsiElement)configClass) : null;
    }

    @Nullable
    private static SpringComponent getComponent(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(8);
        }
        return (SpringComponent)JamService.getJamService((Project)psiClass.getProject()).getJamElement((PsiElement)psiClass, new JamMemberMeta[]{SpringComponent.META});
    }

    public static boolean isInActiveProfile(@NotNull JamPsiClassSpringBean configuration, @Nullable Set<String> activeProfiles) {
        if (configuration == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(9);
        }
        if (activeProfiles == null || activeProfiles.size() == 0) {
            return true;
        }
        SpringProfile profile = configuration.getProfile();
        if (profile == SpringProfile.DEFAULT) {
            return true;
        }
        return SpringProfileUtils.isActive((Set)profile.getNames(), activeProfiles);
    }

    @NotNull
    public Set<String> getAllProfiles() {
        LinkedHashSet profiles = ContainerUtil.newLinkedHashSet();
        for (CommonSpringModel commonSpringModel : this.getLocalAnnotationSpringModels(false)) {
            profiles.addAll(commonSpringModel.getAllProfiles());
        }
        LinkedHashSet linkedHashSet = profiles;
        if (linkedHashSet == null) {
            AnnotationSpringModelImpl.$$$reportNull$$$0(10);
        }
        return linkedHashSet;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "classes";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/AnnotationSpringModelImpl";
                break;
            }
            case 6: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configClass";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/AnnotationSpringModelImpl";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getModelsToProcess";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScanPackages";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "isConfiguration";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "getConfiguration";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "isInActiveProfile";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

