/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.contexts.model;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.AtomicNotNullLazyValue;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.VolatileNotNullLazyValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMember;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.AnnotatedElementsSearch;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.psi.util.ParameterizedCachedValue;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringModificationTrackersManager;
import com.intellij.spring.contexts.model.BeanNamesMapper;
import com.intellij.spring.contexts.model.BeansSpringModel;
import com.intellij.spring.contexts.model.ComponentScanPackagesModel;
import com.intellij.spring.contexts.model.LocalModel;
import com.intellij.spring.contexts.model.LocalXmlModel;
import com.intellij.spring.contexts.model.LocalXmlModelIndexProcessor;
import com.intellij.spring.contexts.model.graph.LocalModelDependency;
import com.intellij.spring.contexts.model.graph.LocalModelDependencyType;
import com.intellij.spring.dom.PlaceholderDomReferenceInjector;
import com.intellij.spring.dom.SpringDomUtils;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.beans.CustomSetting;
import com.intellij.spring.impl.SpringCachedModelFactory;
import com.intellij.spring.model.BeanService;
import com.intellij.spring.model.CommonSpringBean;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.SpringModelSearchParameters;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringJavaConfiguration;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringConfiguration;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringBeanUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringProfileUtils;
import com.intellij.spring.model.xml.AbstractDomSpringBean;
import com.intellij.spring.model.xml.DomSpringBean;
import com.intellij.spring.model.xml.beans.Beans;
import com.intellij.spring.model.xml.beans.SpringBean;
import com.intellij.spring.model.xml.beans.SpringImport;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScan;
import com.intellij.spring.model.xml.context.SpringBeansPackagesScanBean;
import com.intellij.util.ArrayUtil;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomJavaUtil;
import com.intellij.xml.util.PsiElementPointer;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LocalXmlModelImpl
extends LocalXmlModel {
    private final XmlFile myConfigFile;
    private final Module myModule;
    private final Set<String> myActiveProfiles;
    private final LocalXmlModelIndexProcessor myIndexProcessor;
    private final NotNullLazyValue<BeanNamesMapper> myLocalBeanNamesMapper;
    private CachedValue<Set<CommonSpringModel>> myLocalRelatedModels;
    private CachedValue<CommonSpringModel> javaConfigurationModel;
    private CachedValue<CommonSpringModel> explicitlyDefinedBeansModel;
    private final NotNullLazyValue<List<SpringBeanPointer>> myPlaceholders;
    private final Map<String, Collection<XmlTag>> myCustomBeanIdCandidates;
    private final AtomicNotNullLazyValue<Set<String>> myProfiles;
    private final NotNullLazyValue<List<SpringBeanPointer>> myAnnotationConfigApplicationContexts;
    private final NotNullLazyValue<List<SpringBeansPackagesScan>> myComponentScanBeans;
    private final NotNullLazyValue<MultiMap<SpringBeanPointer, SpringBeanPointer>> myDirectInheritorsMap;
    private static final Key<CachedValue<Map<XmlFile, LocalModelDependency>>> IMPORT_FILES_KEY = Key.create((String)"IMPORT_FILES_KEY");
    private static final Key<ParameterizedCachedValue<Set<PsiClass>, GlobalSearchScope>> EXPLICIT_BEAN_CLASSES = Key.create((String)"explicitBeanClasses");

    public LocalXmlModelImpl(@NotNull XmlFile configFile, @NotNull Module module, @NotNull Set<String> activeProfiles) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(0);
        }
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(1);
        }
        if (activeProfiles == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(2);
        }
        this.myLocalBeanNamesMapper = new VolatileNotNullLazyValue<BeanNamesMapper>(){

            @NotNull
            protected BeanNamesMapper compute() {
                BeanNamesMapper beanNamesMapper = new BeanNamesMapper(LocalXmlModelImpl.this);
                if (beanNamesMapper == null) {
                    1.$$$reportNull$$$0(0);
                }
                return beanNamesMapper;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$1", "compute"));
            }
        };
        this.myPlaceholders = new VolatileNotNullLazyValue<List<SpringBeanPointer>>(){

            @NotNull
            protected List<SpringBeanPointer> compute() {
                List list = LocalXmlModelImpl.this.computePlaceholders();
                if (list == null) {
                    2.$$$reportNull$$$0(0);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$2", "compute"));
            }
        };
        this.myProfiles = new AtomicNotNullLazyValue<Set<String>>(){

            @NotNull
            protected Set<String> compute() {
                DomFileElement<Beans> element = LocalXmlModelImpl.this.getRoot();
                if (element == null) {
                    Set<String> set = Collections.emptySet();
                    if (set == null) {
                        3.$$$reportNull$$$0(0);
                    }
                    return set;
                }
                LinkedHashSet allProfiles = ContainerUtil.newLinkedHashSet();
                allProfiles.addAll(SpringProfileUtils.getAllProfiles((Beans)((Beans)element.getRootElement())));
                for (Pair<LocalModel, LocalModelDependency> dependencyPair : LocalXmlModelImpl.this.getDependentLocalModels()) {
                    allProfiles.addAll(((LocalModel)dependencyPair.getFirst()).getAllProfiles());
                }
                LinkedHashSet linkedHashSet = allProfiles;
                if (linkedHashSet == null) {
                    3.$$$reportNull$$$0(1);
                }
                return linkedHashSet;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$3", "compute"));
            }
        };
        this.myAnnotationConfigApplicationContexts = new VolatileNotNullLazyValue<List<SpringBeanPointer>>(){

            @NotNull
            protected List<SpringBeanPointer> compute() {
                if (!LocalXmlModelImpl.this.canProcessBeans()) {
                    List<SpringBeanPointer> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                PsiClass annotationConfigAppContext = SpringCommonUtils.findLibraryClass((Module)LocalXmlModelImpl.this.myModule, (String)"org.springframework.context.annotation.AnnotationConfigApplicationContext");
                if (annotationConfigAppContext == null) {
                    List<SpringBeanPointer> list = Collections.emptyList();
                    if (list == null) {
                        4.$$$reportNull$$$0(1);
                    }
                    return list;
                }
                SmartList result = new SmartList();
                CommonProcessors.CollectProcessor<SpringBeanPointer> processor = new CommonProcessors.CollectProcessor<SpringBeanPointer>((Collection)result){

                    public boolean process(SpringBeanPointer pointer) {
                        ProgressManager.checkCanceled();
                        return super.process((Object)pointer);
                    }

                    protected boolean accept(SpringBeanPointer pointer) {
                        return pointer.getSpringBean() instanceof SpringBean;
                    }
                };
                SpringModelSearchParameters.BeanClass searchParameters = SpringModelSearchParameters.byClass((PsiClass)annotationConfigAppContext).withInheritors();
                LocalXmlModelImpl.this.myIndexProcessor.processByClass(searchParameters, (Processor<SpringBeanPointer>)processor, LocalXmlModelImpl.this.getActiveProfiles(), LocalXmlModelImpl.this.myModule, true);
                SmartList smartList = result;
                if (smartList == null) {
                    4.$$$reportNull$$$0(2);
                }
                return smartList;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$4", "compute"));
            }
        };
        this.myComponentScanBeans = new VolatileNotNullLazyValue<List<SpringBeansPackagesScan>>(){

            @NotNull
            protected List<SpringBeansPackagesScan> compute() {
                if (!LocalXmlModelImpl.this.canProcessBeans()) {
                    List<SpringBeansPackagesScan> list = Collections.emptyList();
                    if (list == null) {
                        5.$$$reportNull$$$0(0);
                    }
                    return list;
                }
                List<SpringBeansPackagesScan> list = LocalXmlModelImpl.this.myIndexProcessor.getComponentScans();
                if (list == null) {
                    5.$$$reportNull$$$0(1);
                }
                return list;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$5", "compute"));
            }
        };
        this.myDirectInheritorsMap = new VolatileNotNullLazyValue<MultiMap<SpringBeanPointer, SpringBeanPointer>>(){

            @NotNull
            protected MultiMap<SpringBeanPointer, SpringBeanPointer> compute() {
                MultiMap<SpringBeanPointer, SpringBeanPointer> map = new MultiMap<SpringBeanPointer, SpringBeanPointer>(){

                    @NotNull
                    protected Map<SpringBeanPointer, Collection<SpringBeanPointer>> createMap() {
                        ConcurrentMap concurrentMap = ContainerUtil.newConcurrentMap();
                        if (concurrentMap == null) {
                            1.$$$reportNull$$$0(0);
                        }
                        return concurrentMap;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$6$1", "createMap"));
                    }
                };
                for (SpringBeanPointer pointer : LocalXmlModelImpl.this.getAllDomBeans()) {
                    SpringBeanPointer parentPointer = pointer.getParentPointer();
                    if (parentPointer == null) continue;
                    map.putValue((Object)parentPointer.getBasePointer(), (Object)pointer);
                }
                MultiMap<SpringBeanPointer, SpringBeanPointer> multiMap = map;
                if (multiMap == null) {
                    6.$$$reportNull$$$0(0);
                }
                return multiMap;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$6", "compute"));
            }
        };
        this.myConfigFile = configFile;
        this.myModule = module;
        this.myActiveProfiles = activeProfiles;
        this.myIndexProcessor = (LocalXmlModelIndexProcessor)CachedValuesManager.getCachedValue((PsiElement)this.myConfigFile, () -> {
            if (configFile == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(35);
            }
            Project project = this.getProject();
            SpringModificationTrackersManager springModificationTrackersManager = SpringModificationTrackersManager.getInstance((Project)project);
            Object[] indexProcessorDependencies = new Object[]{this.myConfigFile, springModificationTrackersManager.getCustomBeanParserModificationTracker(), ProjectRootManager.getInstance((Project)project), springModificationTrackersManager.getOuterModelsModificationTracker()};
            return CachedValueProvider.Result.create((Object)new LocalXmlModelIndexProcessor(configFile), (Object[])indexProcessorDependencies);
        });
        this.myCustomBeanIdCandidates = ConcurrentFactoryMap.createMap(key -> {
            if (!this.canProcessBeans()) {
                return Collections.emptyList();
            }
            return this.myIndexProcessor.getCustomBeanCandidates((String)key);
        });
    }

    @Nullable
    public DomFileElement<Beans> getRoot() {
        return SpringDomUtils.getSpringDomFileElement((XmlFile)this.myConfigFile);
    }

    @NotNull
    public Set<PsiFile> getConfigFiles() {
        Set<XmlFile> set = Collections.singleton(this.myConfigFile);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(3);
        }
        return set;
    }

    public boolean hasConfigFile(@NotNull PsiFile configFile) {
        if (configFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(4);
        }
        return this.myConfigFile.equals(configFile);
    }

    private Project getProject() {
        return this.myConfigFile.getProject();
    }

    @NotNull
    public XmlFile getConfig() {
        XmlFile xmlFile = this.myConfigFile;
        if (xmlFile == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(5);
        }
        return xmlFile;
    }

    public Collection<XmlTag> getCustomBeanCandidates(String id) {
        return this.myCustomBeanIdCandidates.get(id);
    }

    private BeanNamesMapper getLocalBeanNamesMapper() {
        return (BeanNamesMapper)this.myLocalBeanNamesMapper.getValue();
    }

    @NotNull
    public Set<String> getAllBeanNames(@NotNull String beanName) {
        if (beanName == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(6);
        }
        THashSet set = new THashSet(this.getLocalBeanNamesMapper().getAllBeanNames(beanName));
        this.processRelatedModels(arg_0 -> LocalXmlModelImpl.lambda$getAllBeanNames$2((Set)set, beanName, arg_0));
        THashSet tHashSet = set;
        if (tHashSet == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(7);
        }
        return tHashSet;
    }

    public Collection<PsiElementPointer> getDuplicatedNames(@NotNull String beanName) {
        if (beanName == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(8);
        }
        return this.getLocalBeanNamesMapper().getDuplicatedNames(beanName);
    }

    protected Collection<SpringBeanPointer> calculateLocalBeans() {
        return Collections.unmodifiableCollection(this.getAllDomBeans());
    }

    public Iterable<CommonSpringModel> getRelatedModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        models.addAll(this.getOrCreateLocalRelatedModels());
        models.add(this.getCustomDiscoveredBeansModel());
        models.add(this.getOldJavaConfigurationBeansModel());
        models.add(this.getExplicitlyDefinedBeansModel());
        return models;
    }

    private Set<CommonSpringModel> getOrCreateLocalRelatedModels() {
        if (this.myLocalRelatedModels == null) {
            this.myLocalRelatedModels = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                LinkedHashSet models = ContainerUtil.newLinkedHashSet();
                Set localModels = this.getRelatedLocalModels();
                models.addAll(localModels);
                models.addAll(this.getPackageScanModels(localModels));
                return CachedValueProvider.Result.create((Object)models, (Object[])ArrayUtil.mergeArrays((Object[])this.getOutsideModelDependencies((LocalModel)this), (Object[])this.getConfigs(localModels)));
            }, false);
        }
        return (Set)this.myLocalRelatedModels.getValue();
    }

    @NotNull
    private Set<CommonSpringModel> getPackageScanModels(@NotNull Set<LocalModel> localRelatedModels) {
        if (localRelatedModels == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(9);
        }
        LinkedHashSet packageScanContextModels = ContainerUtil.newLinkedHashSet();
        packageScanContextModels.add(this);
        packageScanContextModels.addAll(localRelatedModels);
        Set set = this.getPackageScanModels(packageScanContextModels, this.myModule, this.myActiveProfiles);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(10);
        }
        return set;
    }

    private CommonSpringModel getOldJavaConfigurationBeansModel() {
        if (this.javaConfigurationModel == null) {
            this.javaConfigurationModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                BeansSpringModel model = new BeansSpringModel(this.getModule(), (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        LinkedHashSet pointers = ContainerUtil.newLinkedHashSet();
                        for (SpringJavaConfiguration javaConfiguration : SpringOldJavaConfigurationUtil.getJavaConfigurations((Module)LocalXmlModelImpl.this.myModule)) {
                            for (SpringJavaBean javaBean : javaConfiguration.getBeans()) {
                                if (!javaBean.isPublic()) continue;
                                pointers.add(BeanService.getInstance().createSpringBeanPointer((CommonSpringBean)javaBean));
                            }
                        }
                        LinkedHashSet linkedHashSet = pointers;
                        if (linkedHashSet == null) {
                            7.$$$reportNull$$$0(0);
                        }
                        return linkedHashSet;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$7", "compute"));
                    }
                });
                return CachedValueProvider.Result.create((Object)model, (Object[])this.getOutsideModelDependencies((LocalModel)this));
            }, false);
        }
        return (CommonSpringModel)this.javaConfigurationModel.getValue();
    }

    @NotNull
    public Collection<SpringBeanPointer> calculateDomBeans() {
        ArrayList<SpringBeanPointer> beans = new ArrayList<SpringBeanPointer>();
        Processor processor = bean -> {
            beans.add(BeanService.getInstance().createSpringBeanPointer(bean));
            return true;
        };
        DomFileElement<Beans> element = this.getRoot();
        if (element != null) {
            this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor);
        }
        ArrayList<SpringBeanPointer> arrayList = beans;
        if (arrayList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(11);
        }
        return arrayList;
    }

    private void processDomBeans(@NotNull Beans rootElement, Processor<CommonSpringBean> processor) {
        if (rootElement == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(12);
        }
        if (SpringProfileUtils.isActiveProfile((Beans)rootElement, this.getActiveProfiles())) {
            SpringBeanUtils.getInstance().processChildBeans((DomElement)rootElement, false, processor);
            for (Beans profile : rootElement.getBeansProfiles()) {
                this.processDomBeans(profile, processor);
            }
        }
    }

    @NotNull
    public List<SpringBeanPointer> getDescendants(@NotNull SpringBeanPointer pointer) {
        if (pointer == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(13);
        }
        THashSet visited = new THashSet();
        visited.add(pointer);
        MultiMap map = (MultiMap)this.myDirectInheritorsMap.getValue();
        LocalXmlModelImpl.addDescendants((MultiMap<SpringBeanPointer, SpringBeanPointer>)map, pointer, (Set<SpringBeanPointer>)visited);
        visited.remove(pointer);
        SmartList smartList = new SmartList((Collection)visited);
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(14);
        }
        return smartList;
    }

    private static void addDescendants(MultiMap<SpringBeanPointer, SpringBeanPointer> map, SpringBeanPointer current, Set<SpringBeanPointer> result) {
        Collection pointers = map.get((Object)current);
        for (SpringBeanPointer pointer : pointers) {
            if (!result.add(pointer)) continue;
            LocalXmlModelImpl.addDescendants(map, pointer, result);
        }
    }

    @NotNull
    public Module getModule() {
        Module module = this.myModule;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(15);
        }
        return module;
    }

    @NotNull
    public List<SpringBeanPointer> getPlaceholderConfigurers() {
        List list = (List)this.myPlaceholders.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    public List<SpringBeansPackagesScan> getComponentScans() {
        Set<String> activeProfiles = this.getActiveProfiles();
        List allComponentScans = (List)this.myComponentScanBeans.getValue();
        if (activeProfiles.isEmpty()) {
            List list = allComponentScans;
            if (list == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(17);
            }
            return list;
        }
        List list = ContainerUtil.mapNotNull((Collection)allComponentScans, scan -> {
            if (scan instanceof DomSpringBean && SpringProfileUtils.isInActiveProfile((DomElement)((DomSpringBean)scan), (Set)activeProfiles)) {
                return scan;
            }
            return null;
        });
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(18);
        }
        return list;
    }

    @NotNull
    public List<SpringBeanPointer> getAnnotationConfigApplicationContexts() {
        List list = (List)this.myAnnotationConfigApplicationContexts.getValue();
        if (list == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(19);
        }
        return list;
    }

    @NotNull
    public Set<String> getAllProfiles() {
        Set set = (Set)this.myProfiles.getValue();
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(20);
        }
        return set;
    }

    @NotNull
    public Set<String> getActiveProfiles() {
        Set<String> set = this.myActiveProfiles;
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(21);
        }
        return set;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof LocalXmlModel)) {
            return false;
        }
        LocalXmlModel model = (LocalXmlModel)o;
        if (!this.myConfigFile.equals(model.getConfig())) {
            return false;
        }
        if (!this.myModule.equals(model.getModule())) {
            return false;
        }
        return SpringProfileUtils.profilesAsString(this.myActiveProfiles).equals(SpringProfileUtils.profilesAsString((Set)model.getActiveProfiles()));
    }

    public int hashCode() {
        int result = this.myConfigFile.hashCode();
        result = 31 * result + this.myModule.hashCode();
        result = 31 * result + SpringProfileUtils.profilesAsString(this.myActiveProfiles).hashCode();
        return result;
    }

    public boolean processByClass(@NotNull SpringModelSearchParameters.BeanClass params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(22);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(23);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        if (!this.myIndexProcessor.processByClass(params, processor, this.getActiveProfiles(), this.myModule, false)) {
            return false;
        }
        return this.processRelatedModels(params, processor);
    }

    public boolean processByName(@NotNull SpringModelSearchParameters.BeanName params, @NotNull Processor<SpringBeanPointer> processor) {
        if (params == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(24);
        }
        if (processor == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(25);
        }
        if (!params.canSearch() || !this.canProcessBeans()) {
            return true;
        }
        if (!this.myIndexProcessor.processByName(params, processor, this.getActiveProfiles())) {
            return false;
        }
        return this.processRelatedModels(params, processor);
    }

    private boolean canProcessBeans() {
        DomFileElement<Beans> root = this.getRoot();
        return root != null && SpringProfileUtils.isActiveProfile((Beans)((Beans)root.getRootElement()), this.getActiveProfiles());
    }

    @NotNull
    public Set<Pair<LocalModel, LocalModelDependency>> getDependentLocalModels() {
        LinkedHashSet models = ContainerUtil.newLinkedHashSet();
        Set<String> profiles = this.getActiveProfiles();
        for (Map.Entry<XmlFile, LocalModelDependency> importedXml : LocalXmlModelImpl.getImports(this.getConfig(), profiles).entrySet()) {
            LocalXmlModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalXmlModel(importedXml.getKey(), this.getModule(), profiles), (LocalModelDependency)importedXml.getValue());
        }
        for (SpringBeansPackagesScan packagesScan : this.getComponentScans()) {
            if (!(packagesScan instanceof SpringBeansPackagesScanBean)) {
                throw new UnsupportedOperationException("not support " + packagesScan);
            }
            SpringBeansPackagesScanBean domScan = (SpringBeansPackagesScanBean)packagesScan;
            String label = "<" + domScan.getXmlElementName() + " [" + domScan.getProviderName() + "] \"" + domScan.getBasePackage().getStringValue() + "\">";
            LocalModelDependency dependency = LocalModelDependency.create((String)label, (LocalModelDependencyType)LocalModelDependencyType.COMPONENT_SCAN, (DomElement)domScan);
            for (SpringConfiguration configuration : ComponentScanPackagesModel.getScannedConfigurations((SpringBeansPackagesScan)packagesScan, (Module)this.getModule(), profiles)) {
                LocalXmlModelImpl.addNotNullModel((Set)models, (LocalModel)SpringCachedModelFactory.getOrCreateLocalAnnotationModel(configuration, this.getModule(), profiles), (LocalModelDependency)dependency);
            }
        }
        LinkedHashSet linkedHashSet = models;
        if (linkedHashSet == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(26);
        }
        return linkedHashSet;
    }

    private static Map<XmlFile, LocalModelDependency> getImports(@NotNull XmlFile file, @Nullable Set<String> activeProfiles) {
        if (file == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(27);
        }
        return (Map)CachedValuesManager.getManager((Project)file.getProject()).getCachedValue((UserDataHolder)file, IMPORT_FILES_KEY, () -> {
            if (file == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(33);
            }
            LinkedHashMap<XmlFile, LocalModelDependency> includes = new LinkedHashMap<XmlFile, LocalModelDependency>();
            DomFileElement beans = SpringDomUtils.getSpringDomFileElement((XmlFile)file);
            if (beans != null) {
                LocalXmlModelImpl.processLocalImports(includes, (Beans)beans.getRootElement(), activeProfiles);
            }
            includes.remove(file);
            return CachedValueProvider.Result.create(includes, (Object[])new Object[]{file, SpringModificationTrackersManager.getInstance((Project)file.getProject()).getOuterModelsModificationTracker()});
        }, false);
    }

    private static void processLocalImports(Map<XmlFile, LocalModelDependency> includes, Beans beans, @Nullable Set<String> activeProfiles) {
        for (SpringImport springImport : beans.getImports()) {
            Set psiFiles = (Set)springImport.getResource().getValue();
            if (psiFiles == null) continue;
            for (PsiFile psiFile : psiFiles) {
                XmlFile xmlFile;
                if (!(psiFile instanceof XmlFile) || includes.containsKey(xmlFile = (XmlFile)psiFile) || !SpringDomUtils.isSpringXml((XmlFile)xmlFile)) continue;
                DomFileElement fileElement = SpringDomUtils.getSpringDomFileElement((XmlFile)xmlFile);
                assert (fileElement != null) : psiFile;
                Beans child = (Beans)fileElement.getRootElement();
                if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)child, activeProfiles)) continue;
                String label = "<import resource=\"" + springImport.getResource().getStringValue() + "/>";
                includes.put(xmlFile, LocalModelDependency.create((String)label, (LocalModelDependencyType)LocalModelDependencyType.IMPORT, (DomElement)springImport));
            }
        }
        for (Beans beanProfiles : beans.getBeansProfiles()) {
            if (activeProfiles != null && !SpringProfileUtils.isActiveProfile((Beans)beanProfiles, activeProfiles)) continue;
            LocalXmlModelImpl.processLocalImports(includes, beanProfiles, activeProfiles);
        }
    }

    private CommonSpringModel getExplicitlyDefinedBeansModel() {
        if (this.explicitlyDefinedBeansModel == null) {
            this.explicitlyDefinedBeansModel = CachedValuesManager.getManager((Project)this.getProject()).createCachedValue(() -> {
                BeansSpringModel model = new BeansSpringModel(this.getModule(), (NotNullLazyValue)new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        LinkedHashSet explicitBeans = ContainerUtil.newLinkedHashSet();
                        Module module = LocalXmlModelImpl.this.getModule();
                        if (LocalXmlModelImpl.isProcessExplicitlyDefinedAnnotatedBeans(module)) {
                            Set explicitBeanPsiClasses = LocalXmlModelImpl.getExplicitBeanCandidatePsiClasses(module, LocalXmlModelImpl.this.myConfigFile.getResolveScope());
                            for (PsiClass explicitBeanClass : explicitBeanPsiClasses) {
                                SpringModelSearchParameters.BeanClass candidateClassParams = SpringModelSearchParameters.byClass((PsiClass)explicitBeanClass).effectiveBeanTypes();
                                if (!candidateClassParams.canSearch()) continue;
                                CommonProcessors.FindFirstProcessor findFirstProcessor = new CommonProcessors.FindFirstProcessor();
                                LocalXmlModelImpl.this.myIndexProcessor.processByClass(candidateClassParams, (Processor<SpringBeanPointer>)findFirstProcessor, LocalXmlModelImpl.this.getActiveProfiles(), LocalXmlModelImpl.this.myModule, true);
                                if (!findFirstProcessor.isFound()) continue;
                                explicitBeans.addAll(SpringJamUtils.getInstance().getContextBeans(explicitBeanClass, Collections.emptySet()));
                            }
                        }
                        Set set = BeanService.getInstance().mapSpringBeans((Collection)explicitBeans);
                        if (set == null) {
                            8.$$$reportNull$$$0(0);
                        }
                        return set;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/contexts/model/LocalXmlModelImpl$8", "compute"));
                    }
                });
                return CachedValueProvider.Result.create((Object)model, (Object[])this.getOutsideModelDependencies((LocalModel)this));
            }, false);
        }
        return (CommonSpringModel)this.explicitlyDefinedBeansModel.getValue();
    }

    private static boolean isProcessExplicitlyDefinedAnnotatedBeans(@NotNull Module module) {
        SpringFacet springFacet;
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(28);
        }
        if ((springFacet = SpringFacet.getInstance((Module)module)) == null) {
            return true;
        }
        CustomSetting.BOOLEAN setting = (CustomSetting.BOOLEAN)springFacet.findSetting(PROCESS_EXPLICITLY_ANNOTATED);
        return setting == null || setting.getBooleanValue();
    }

    @NotNull
    private static Set<PsiClass> getExplicitBeanCandidatePsiClasses(@NotNull Module module, GlobalSearchScope scope) {
        if (module == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(29);
        }
        Set set = (Set)CachedValuesManager.getManager((Project)module.getProject()).getParameterizedCachedValue((UserDataHolder)module, EXPLICIT_BEAN_CLASSES, param -> {
            PsiClass annotationClass;
            if (module == null) {
                LocalXmlModelImpl.$$$reportNull$$$0(32);
            }
            if ((annotationClass = SpringCommonUtils.findLibraryClass((Module)module, (String)"org.springframework.context.annotation.Bean")) == null) {
                return CachedValueProvider.Result.create(Collections.emptySet(), (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
            }
            LinkedHashSet psiClasses = ContainerUtil.newLinkedHashSet();
            for (PsiMember member : AnnotatedElementsSearch.searchPsiMethods((PsiClass)annotationClass, (SearchScope)param).findAll()) {
                PsiClass containingClass = member.getContainingClass();
                if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)containingClass)) continue;
                ContainerUtil.addIfNotNull((Collection)psiClasses, (Object)containingClass);
            }
            return CachedValueProvider.Result.create((Object)psiClasses, (Object[])new Object[]{PsiModificationTracker.JAVA_STRUCTURE_MODIFICATION_COUNT});
        }, false, (Object)scope);
        if (set == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(30);
        }
        return set;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    private List<SpringBeanPointer> computePlaceholders() {
        SmartList result = new SmartList();
        try {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(true);
            DomFileElement<Beans> element = this.getRoot();
            if (element != null) {
                CommonProcessors.CollectProcessor<CommonSpringBean> processor = new CommonProcessors.CollectProcessor<CommonSpringBean>((List)result){
                    final /* synthetic */ List val$result;
                    {
                        this.val$result = list;
                    }

                    public boolean process(CommonSpringBean bean) {
                        PsiClass psiClass;
                        String className;
                        if (bean instanceof AbstractDomSpringBean && (className = ((AbstractDomSpringBean)bean).getClassName()) != null && InheritanceUtil.isInheritor((PsiClass)(psiClass = DomJavaUtil.findClass((String)className.trim(), (PsiFile)LocalXmlModelImpl.this.getConfig(), (Module)LocalXmlModelImpl.this.getModule(), null)), (String)"org.springframework.core.io.support.PropertiesLoaderSupport")) {
                            this.val$result.add(BeanService.getInstance().createSpringBeanPointer(bean));
                        }
                        return true;
                    }
                };
                this.processDomBeans((Beans)element.getRootElement(), (Processor<CommonSpringBean>)processor);
            }
        }
        finally {
            PlaceholderDomReferenceInjector.IS_COMPUTING.set(false);
        }
        SmartList smartList = result;
        if (smartList == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(31);
        }
        return smartList;
    }

    private static /* synthetic */ boolean lambda$getAllBeanNames$2(Set set, @NotNull String beanName, CommonSpringModel model) {
        if (beanName == null) {
            LocalXmlModelImpl.$$$reportNull$$$0(34);
        }
        set.addAll(model.getAllBeanNames(beanName));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configFile";
                break;
            }
            case 1: 
            case 28: 
            case 29: 
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "activeProfiles";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 6: 
            case 8: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "beanName";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "localRelatedModels";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "rootElement";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pointer";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "params";
                break;
            }
            case 23: 
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 27: 
            case 33: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/contexts/model/LocalXmlModelImpl";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfigFiles";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getConfig";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllBeanNames";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getPackageScanModels";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateDomBeans";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDescendants";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getModule";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getPlaceholderConfigurers";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "getComponentScans";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getAnnotationConfigApplicationContexts";
                break;
            }
            case 20: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllProfiles";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getActiveProfiles";
                break;
            }
            case 26: {
                objectArray = objectArray2;
                objectArray2[1] = "getDependentLocalModels";
                break;
            }
            case 30: {
                objectArray = objectArray2;
                objectArray2[1] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
            case 31: {
                objectArray = objectArray2;
                objectArray2[1] = "computePlaceholders";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "hasConfigFile";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getAllBeanNames";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getDuplicatedNames";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "getPackageScanModels";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "processDomBeans";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getDescendants";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "processByClass";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "processByName";
                break;
            }
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "getImports";
                break;
            }
            case 28: {
                objectArray = objectArray;
                objectArray[2] = "isProcessExplicitlyDefinedAnnotatedBeans";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "getExplicitBeanCandidatePsiClasses";
                break;
            }
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getExplicitBeanCandidatePsiClasses$9";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getImports$7";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "lambda$getAllBeanNames$2";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "lambda$new$0";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
            case 26: 
            case 30: 
            case 31: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

