/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.codeInsight.daemon.RelatedItemLineMarkerProvider;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.SyntaxTraverser;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.SpringLibraryUtil;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.settings.SpringGeneralSettings;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UAnnotated;
import org.jetbrains.uast.UAnnotation;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;
import org.jetbrains.uast.UastContextKt;
import org.jetbrains.uast.visitor.AbstractUastVisitor;
import org.jetbrains.uast.visitor.UastVisitor;

public abstract class SpringAnnotatorBase
extends RelatedItemLineMarkerProvider {
    protected void collectNavigationMarkers(@NotNull PsiElement psiElement, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement element;
        if (psiElement == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(0);
        }
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(1);
        }
        if ((element = UastContextKt.toUElement((PsiElement)psiElement)) instanceof UMethod) {
            this.annotateMethod((UMethod)element, result);
        } else if (element instanceof UClass) {
            this.annotateClass(result, (UClass)element);
        }
    }

    protected void annotateClass(@NotNull Collection<? super RelatedItemLineMarkerInfo> result, UClass uClass) {
        UElement anchor;
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(2);
        }
        if ((anchor = uClass.getUastAnchor()) == null) {
            return;
        }
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)anchor);
        if (identifier == null) {
            return;
        }
        this.annotateClass(result, uClass, identifier);
    }

    protected void annotateMethod(UMethod method, @NotNull Collection<? super RelatedItemLineMarkerInfo> result) {
        UElement anchor;
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(3);
        }
        if ((anchor = method.getUastAnchor()) == null) {
            return;
        }
        PsiElement identifier = UElementKt.getSourcePsiElement((UElement)anchor);
        if (identifier == null) {
            return;
        }
        this.annotateMethod(method, identifier, result);
    }

    protected void annotateMethod(UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
    }

    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo> result, UClass uClass, PsiElement identifier) {
    }

    public final void collectNavigationMarkers(@NotNull List<PsiElement> elements, @NotNull Collection<? super RelatedItemLineMarkerInfo> result, boolean forNavigation) {
        PsiElement psiElement;
        if (elements == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(4);
        }
        if (result == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(5);
        }
        if ((psiElement = (PsiElement)ContainerUtil.getFirstItem(elements)) == null || !SpringAnnotatorBase.hasFacetsOrAutoConfigurationMode(psiElement) || !SpringLibraryUtil.hasSpringLibrary((Project)psiElement.getProject())) {
            return;
        }
        super.collectNavigationMarkers(elements, result, forNavigation);
    }

    private static boolean hasFacetsOrAutoConfigurationMode(PsiElement psiElement) {
        return SpringCommonUtils.hasSpringFacets((Project)psiElement.getProject()) || SpringGeneralSettings.getInstance((Project)psiElement.getProject()).isAllowAutoConfigurationMode();
    }

    protected PsiElement getIdentifierLocal(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(6);
        }
        return SpringAnnotatorBase.getIdentifier(annotation);
    }

    @Nullable
    protected static UAnnotation getUAnnotation(@NotNull UAnnotated annotated, final PsiAnnotation annotation) {
        if (annotated == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(7);
        }
        final UAnnotation[] result = new UAnnotation[1];
        annotated.accept((UastVisitor)new AbstractUastVisitor(){

            public boolean visitElement(@NotNull UElement node) {
                if (node == null) {
                    1.$$$reportNull$$$0(0);
                }
                return result[0] != null || super.visitElement(node);
            }

            public boolean visitAnnotation(@NotNull UAnnotation node) {
                if (node == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (annotation.equals(UElementKt.getAsJavaPsiElement((UElement)node, PsiAnnotation.class))) {
                    result[0] = node;
                    return true;
                }
                return false;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "node";
                objectArray2[1] = "com/intellij/spring/gutter/SpringAnnotatorBase$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitElement";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "visitAnnotation";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
        return result[0];
    }

    @Contract(value="null -> null")
    @Nullable
    protected static PsiElement getIdentifierLocal(@Nullable UAnnotation uAnnotation) {
        if (uAnnotation == null) {
            return null;
        }
        PsiElement sourcePsiElement = UElementKt.getSourcePsiElement((UElement)uAnnotation);
        if (sourcePsiElement == null) {
            return null;
        }
        PsiElement identifier = sourcePsiElement.getNavigationElement();
        if (identifier == null) {
            return null;
        }
        String qualifiedName = uAnnotation.getQualifiedName();
        if (qualifiedName != null) {
            String shortName = StringUtilRt.getShortName((String)qualifiedName);
            PsiElement shortNamePsi = (PsiElement)((SyntaxTraverser)SyntaxTraverser.psiTraverser((PsiElement)sourcePsiElement).filter(psi -> psi.getReferences().length > 0 && psi.getText().contains(shortName))).traverse().first();
            if (shortNamePsi != null) {
                return PsiTreeUtil.getDeepestFirst((PsiElement)shortNamePsi);
            }
        }
        return PsiTreeUtil.getDeepestFirst((PsiElement)identifier);
    }

    @Nullable
    protected PsiElement getElementToProcess(@NotNull PsiElement psiElement) {
        if (psiElement == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(8);
        }
        if (psiElement instanceof PsiIdentifier) {
            return psiElement.getParent();
        }
        return null;
    }

    public static PsiElement getIdentifier(@NotNull PsiAnnotation annotation) {
        PsiJavaCodeReferenceElement identifier;
        if (annotation == null) {
            SpringAnnotatorBase.$$$reportNull$$$0(9);
        }
        return (identifier = annotation.getNameReferenceElement()) == null ? null : identifier.getReferenceNameElement();
    }

    protected static void addSpringJavaBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends CommonModelElement>> targets, Icon icon) {
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)icon, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_CONVERTOR, NavigationGutterIconBuilderUtil.COMMON_MODEL_ELEMENT_GOTO_PROVIDER);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createSpringGroupLineMarkerInfo(psiIdentifier));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiElement";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elements";
                break;
            }
            case 6: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotation";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "annotated";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/gutter/SpringAnnotatorBase";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "collectNavigationMarkers";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateClass";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdentifierLocal";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "getUAnnotation";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "getElementToProcess";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "getIdentifier";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

