/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.gutter;

import com.intellij.codeInsight.daemon.RelatedItemLineMarkerInfo;
import com.intellij.jam.model.common.CommonModelElement;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.semantic.SemService;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.contexts.model.LocalAnnotationModel;
import com.intellij.spring.contexts.model.SpringModel;
import com.intellij.spring.gutter.NavigationGutterIconBuilderUtil;
import com.intellij.spring.gutter.SpringAnnotatorBase;
import com.intellij.spring.gutter.SpringBeansPsiElementCellRenderer;
import com.intellij.spring.gutter.groups.SpringGutterIconBuilder;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.jam.JamSpringBeanPointer;
import com.intellij.spring.model.jam.javaConfig.SpringJavaBean;
import com.intellij.spring.model.jam.javaConfig.SpringOldJavaConfigurationUtil;
import com.intellij.spring.model.jam.stereotype.SpringImport;
import com.intellij.spring.model.jam.utils.SpringJamUtils;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import icons.SpringApiIcons;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.uast.UClass;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UMethod;

public class SpringBeanAnnotator
extends SpringAnnotatorBase {
    public String getId() {
        return "SpringBeanAnnotator";
    }

    public String getName() {
        return "Bean";
    }

    @Nullable
    public Icon getIcon() {
        return SpringApiIcons.SpringBean;
    }

    @Override
    protected void annotateClass(Collection<? super RelatedItemLineMarkerInfo> result, @NotNull UClass uClass, PsiElement identifier) {
        PsiClass psiClass;
        if (uClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(0);
        }
        if ((psiClass = (PsiClass)UElementKt.getAsJavaPsiElement((UElement)uClass, PsiClass.class)) == null) {
            return;
        }
        if (!SpringCommonUtils.isSpringBeanCandidateClass((PsiClass)psiClass)) {
            return;
        }
        SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
        if (info.isMappedDomBean()) {
            SpringBeanAnnotator.addSpringBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                @NotNull
                protected Collection<? extends SpringBeanPointer> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    List domBeans = info.getMappedDomBeans();
                    Collections.sort(domBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                    List list = domBeans;
                    if (list == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return list;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringBeanAnnotator$1", "compute"));
                }
            });
        } else if (info.isStereotypeJavaBean()) {
            final Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass);
            if (module == null) {
                return;
            }
            SpringBeanAnnotator.addSpringJavaBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends CommonModelElement>>(){

                @NotNull
                protected Collection<? extends CommonModelElement> compute() {
                    SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
                    SmartList result = new SmartList();
                    List mappedBeans = info.getStereotypeMappedBeans();
                    for (JamSpringBeanPointer mappedBean : mappedBeans) {
                        if (!(mappedBean.getSpringBean() instanceof SpringJavaBean)) continue;
                        result.add(mappedBean.getSpringBean());
                    }
                    CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
                    ContainerUtil.addAllNotNull((Collection)result, (Iterable)SpringJamUtils.getInstance().findStereotypeConfigurationBeans(model, mappedBeans, module));
                    ContainerUtil.addAllNotNull((Collection)result, (Iterable)SpringBeanAnnotator.getImportConfigurations(model, psiClass));
                    SmartList smartList = result;
                    if (smartList == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return smartList;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringBeanAnnotator$2", "compute"));
                }
            }, SpringApiIcons.Gutter.SpringJavaBean);
        }
    }

    @Override
    protected void annotateMethod(@NotNull UMethod uMethod, PsiElement identifier, Collection<? super RelatedItemLineMarkerInfo> result) {
        PsiMethod method;
        if (uMethod == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(1);
        }
        if ((method = (PsiMethod)UElementKt.getAsJavaPsiElement((UElement)uMethod, PsiMethod.class)) == null) {
            return;
        }
        PsiClass psiClass = method.getContainingClass();
        if (psiClass == null) {
            return;
        }
        if (SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass)) {
            Collection methodTypes;
            SpringJavaClassInfo info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass);
            List externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method);
            if (!externalBeans.isEmpty()) {
                SpringBeanAnnotator.addSpringBeanGutterIcon(result, identifier, new NotNullLazyValue<Collection<? extends SpringBeanPointer>>(){

                    @NotNull
                    protected Collection<? extends SpringBeanPointer> compute() {
                        List externalBeans = SpringOldJavaConfigurationUtil.findExternalBeans((PsiMethod)method);
                        Collections.sort(externalBeans, SpringBeanPointer.DISPLAY_COMPARATOR);
                        List list = externalBeans;
                        if (list == null) {
                            3.$$$reportNull$$$0(0);
                        }
                        return list;
                    }

                    private static /* synthetic */ void $$$reportNull$$$0(int n) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/gutter/SpringBeanAnnotator$3", "compute"));
                    }
                });
            }
            if (!(methodTypes = info.getMethodTypes(method)).isEmpty()) {
                SpringBeanAnnotator.addMethodTypesGutterIcon(result, method, methodTypes);
            }
        }
    }

    private static void addMethodTypesGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiMethod psiMethod, Collection<Pair<PsiElement, SpringJavaClassInfo.SpringMethodType>> targets) {
        String tooltipText = SpringBundle.message("spring.bean.methods.tooltip.navigate.declaration", new Object[0]);
        Icon icon = SpringApiIcons.Gutter.SpringBeanMethod;
        if (targets.size() == 1) {
            SpringJavaClassInfo.SpringMethodType methodType = (SpringJavaClassInfo.SpringMethodType)targets.iterator().next().second;
            tooltipText = SpringBundle.message("spring.bean.method.tooltip.navigate.declaration", methodType.getName());
            if (methodType == SpringJavaClassInfo.SpringMethodType.FACTORY) {
                icon = SpringApiIcons.Gutter.FactoryMethodBean;
            }
        }
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)icon);
        builder.setTargets((Collection)ContainerUtil.mapNotNull(targets, pair -> (PsiElement)pair.getFirst())).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setTooltipText(tooltipText);
        PsiIdentifier identifier = psiMethod.getNameIdentifier();
        if (identifier != null) {
            result.add((RelatedItemLineMarkerInfo)builder.createLineMarkerInfo((PsiElement)identifier));
        }
    }

    private static void addSpringBeanGutterIcon(Collection<? super RelatedItemLineMarkerInfo> result, PsiElement psiIdentifier, NotNullLazyValue<Collection<? extends SpringBeanPointer>> targets) {
        SpringGutterIconBuilder builder = SpringGutterIconBuilder.createBuilder((Icon)SpringApiIcons.Gutter.SpringBean, NavigationGutterIconBuilderUtil.BEAN_POINTER_CONVERTOR, NavigationGutterIconBuilderUtil.BEAN_POINTER_GOTO_PROVIDER);
        builder.setTargets(targets).setEmptyPopupText(SpringBundle.message("gutter.navigate.no.matching.beans", new Object[0])).setPopupTitle(SpringBundle.message("spring.bean.class.navigate.choose.class.title", new Object[0])).setCellRenderer(SpringBeansPsiElementCellRenderer.INSTANCE).setTooltipText(SpringBundle.message("spring.bean.class.tooltip.navigate.declaration", new Object[0]));
        result.add((RelatedItemLineMarkerInfo)builder.createSpringGroupLineMarkerInfo(psiIdentifier));
    }

    private static List<CommonModelElement> getImportConfigurations(@NotNull CommonSpringModel model, @NotNull PsiClass psiClass) {
        Module module;
        if (model == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(2);
        }
        if (psiClass == null) {
            SpringBeanAnnotator.$$$reportNull$$$0(3);
        }
        if ((module = model.getModule()) == null) {
            return Collections.emptyList();
        }
        List result = ContainerUtil.newSmartList();
        if (model instanceof SpringModel) {
            ((SpringModel)model).processModels(visitedModel -> {
                PsiClass clazz;
                SpringImport springImport;
                if (psiClass == null) {
                    SpringBeanAnnotator.$$$reportNull$$$0(4);
                }
                if (visitedModel instanceof LocalAnnotationModel && (springImport = (SpringImport)SemService.getSemService((Project)(clazz = (PsiClass)((LocalAnnotationModel)visitedModel).getConfig()).getProject()).getSemElement(SpringImport.IMPORT_JAM_KEY, (PsiElement)clazz)) != null && springImport.getImportedClasses().contains(psiClass)) {
                    result.add(springImport);
                }
                return true;
            });
        }
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "uMethod";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiClass";
                break;
            }
        }
        objectArray2[1] = "com/intellij/spring/gutter/SpringBeanAnnotator";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "annotateMethod";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "getImportConfigurations";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "lambda$getImportConfigurations$1";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

