/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.actions;

import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.psi.PsiClass;
import com.intellij.spring.CommonSpringModel;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.java.SpringJavaClassInfo;
import com.intellij.spring.model.SpringBeanPointer;
import com.intellij.spring.model.actions.GenerateAutowiredDependenciesActionHandler;
import com.intellij.spring.model.actions.GenerateSpringBeanDependencyAction;
import com.intellij.spring.model.actions.generate.GenerateSpringBeanDependenciesUtil;
import com.intellij.spring.model.jam.testContexts.SpringTestContextUtil;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.model.utils.SpringModelUtils;
import org.jetbrains.annotations.NotNull;

public class GenerateAutowiredDependencyAction
extends GenerateSpringBeanDependencyAction {
    public GenerateAutowiredDependencyAction() {
        super(new GenerateAutowiredDependenciesActionHandler(), SpringBundle.message("action.generate.autowired.dependencies.action.text", new Object[0]));
    }

    @Override
    protected boolean acceptPsiClass(@NotNull PsiClass psiClass) {
        if (psiClass == null) {
            GenerateAutowiredDependencyAction.$$$reportNull$$$0(0);
        }
        if (!(GenerateAutowiredDependencyAction.isMappedClass(psiClass) || SpringTestContextUtil.getInstance().isTestContextConfigurationClass(psiClass) || SpringCommonUtils.isConfiguration((PsiClass)psiClass))) {
            return false;
        }
        CommonSpringModel model = SpringModelUtils.getInstance().getPsiClassSpringModel(psiClass);
        return GenerateSpringBeanDependenciesUtil.getAutowiredBeanCandidates(model, (Condition<SpringBeanPointer>)Conditions.alwaysTrue()).size() > 0;
    }

    private static boolean isMappedClass(@NotNull PsiClass psiClass) {
        SpringJavaClassInfo info;
        if (psiClass == null) {
            GenerateAutowiredDependencyAction.$$$reportNull$$$0(1);
        }
        return SpringCommonUtils.isSpringBeanCandidateClassInSpringProject((PsiClass)psiClass) && (info = SpringJavaClassInfo.getSpringJavaClassInfo((PsiClass)psiClass)).isMapped();
    }

    @Override
    protected boolean isXmlBasedAction() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        objectArray2[0] = "psiClass";
        objectArray2[1] = "com/intellij/spring/model/actions/GenerateAutowiredDependencyAction";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "acceptPsiClass";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[2] = "isMappedClass";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

