/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.model.highlighting.config;

import com.intellij.codeInsight.daemon.DaemonCodeAnalyzer;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.facet.Facet;
import com.intellij.facet.FacetManager;
import com.intellij.facet.FacetManagerListener;
import com.intellij.icons.AllIcons;
import com.intellij.ide.DataManager;
import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopup;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.ListSeparator;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.impl.LightFilePointer;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.spring.SpringBundle;
import com.intellij.spring.facet.SpringFacet;
import com.intellij.spring.facet.SpringFacetConfiguration;
import com.intellij.spring.facet.SpringFileSet;
import com.intellij.spring.facet.SpringFileSetImpl;
import com.intellij.spring.facet.SpringFileSetService;
import com.intellij.spring.facet.editor.FileSetEditor;
import com.intellij.spring.facet.searchers.CodeConfigSearcher;
import com.intellij.spring.facet.searchers.XmlConfigSearcher;
import com.intellij.ui.EditorNotifications;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.ui.SwingHelper;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import java.awt.Component;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class ConfigureFileSetFix
implements LocalQuickFix {
    protected final Module myModule;
    private final VirtualFile myVirtualFile;

    ConfigureFileSetFix(@NotNull Module module, VirtualFile virtualFile) {
        if (module == null) {
            ConfigureFileSetFix.$$$reportNull$$$0(0);
        }
        this.myModule = module;
        this.myVirtualFile = virtualFile;
    }

    @NotNull
    public String getFamilyName() {
        String string = SpringBundle.message("spring.facet.inspection.configure.context.for.file", new Object[0]);
        if (string == null) {
            ConfigureFileSetFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public boolean startInWriteAction() {
        return false;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        SpringFileSetImpl fakeNewSet;
        if (project == null) {
            ConfigureFileSetFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            ConfigureFileSetFix.$$$reportNull$$$0(3);
        }
        UsageTrigger.trigger((String)"spring.SpringFacetInspection.ConfigureFileSetFix");
        final Ref fileSetsInMultipleModules = Ref.create((Object)Boolean.FALSE);
        final LinkedHashSet<SpringFileSet> sets = new LinkedHashSet<SpringFileSet>();
        ModuleUtilCore.visitMeAndDependentModules((Module)this.myModule, module -> {
            SpringFacet facet = SpringFacet.getInstance((Module)module);
            if (facet != null) {
                for (SpringFileSet set : SpringFileSetService.getInstance().getAllSets(facet)) {
                    if (set.isAutodetected()) continue;
                    sets.add(set);
                    if (this.myModule.equals(module)) continue;
                    fileSetsInMultipleModules.set((Object)Boolean.TRUE);
                }
            }
            return true;
        });
        ArrayList<1> list = new ArrayList<1>(sets);
        final SpringFacet facet = SpringFacet.getInstance((Module)this.myModule);
        if (facet != null) {
            fakeNewSet = new SpringFileSetImpl(SpringFileSetService.getInstance().getUniqueId(sets), SpringBundle.message("spring.facet.inspection.context.create", new Object[0]), facet){

                public boolean isNew() {
                    return true;
                }

                protected VirtualFilePointer createVirtualFilePointer(@NotNull String url) {
                    if (url == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    return new LightFilePointer(url);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "url", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix$1", "createVirtualFilePointer"));
                }
            };
            list.add(fakeNewSet);
        } else {
            fakeNewSet = null;
        }
        BaseListPopupStep<SpringFileSet> step = new BaseListPopupStep<SpringFileSet>(SpringBundle.message("spring.facet.inspection.context.choose", new Object[0]), list){

            public PopupStep onChosen(SpringFileSet selectedValue, boolean finalChoice) {
                return this.doFinalStep(() -> ConfigureFileSetFix.this.onChosen(selectedValue, fakeNewSet, sets, facet));
            }

            @NotNull
            public String getTextFor(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet) || !((Boolean)fileSetsInMultipleModules.get()).booleanValue()) {
                    String string = fileSet.getName();
                    if (string == null) {
                        2.$$$reportNull$$$0(0);
                    }
                    return string;
                }
                Module filesetModule = fileSet.getFacet().getModule();
                String string = fileSet.getName() + " [" + filesetModule.getName() + "]";
                if (string == null) {
                    2.$$$reportNull$$$0(1);
                }
                return string;
            }

            public Icon getIconFor(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet)) {
                    return LayeredIcon.create((Icon)fileSet.getIcon(), (Icon)AllIcons.Actions.New);
                }
                return fileSet.getIcon();
            }

            @Nullable
            public ListSeparator getSeparatorAbove(SpringFileSet fileSet) {
                if (this.isFakeNewSet(fileSet)) {
                    return new ListSeparator();
                }
                return null;
            }

            public boolean isSpeedSearchEnabled() {
                return true;
            }

            private boolean isFakeNewSet(SpringFileSet fileSet) {
                return fileSet.equals((Object)fakeNewSet);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix$2", "getTextFor"));
            }
        };
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            assert (fakeNewSet != null);
            this.onChosen((SpringFileSet)list.get(0), fakeNewSet, sets, facet);
            return;
        }
        ListPopup popup = JBPopupFactory.getInstance().createListPopup((ListPopupStep)step);
        Component component = SwingHelper.getComponentFromRecentMouseEvent();
        if (component != null) {
            ApplicationManager.getApplication().invokeLater(() -> popup.showUnderneathOf(component));
            return;
        }
        DataManager.getInstance().getDataContextFromFocus().doWhenDone(context -> popup.showInBestPositionFor(context));
    }

    private void onChosen(@Nullable SpringFileSet selectedValue, @Nullable SpringFileSet fakeNewSet, Set<SpringFileSet> existingSets, SpringFacet facet) {
        if (selectedValue == null) {
            return;
        }
        if (selectedValue == fakeNewSet) {
            this.editNewSet(facet, existingSets, fakeNewSet);
        } else {
            selectedValue.addFile(this.myVirtualFile);
        }
        ((FacetManagerListener)facet.getModule().getMessageBus().syncPublisher(FacetManager.FACETS_TOPIC)).facetConfigurationChanged((Facet)facet);
        Project project = facet.getModule().getProject();
        DomElementAnnotationsManager.getInstance((Project)project).dropAnnotationsCache();
        DaemonCodeAnalyzer.getInstance((Project)project).restart();
        EditorNotifications.getInstance((Project)project).updateAllNotifications();
    }

    private void editNewSet(SpringFacet facet, Set<SpringFileSet> sets, SpringFileSet fakeNewSet) {
        String defaultName = StringUtil.capitalizeWords((String)this.myVirtualFile.getNameWithoutExtension().replace('-', ' '), (boolean)true);
        String uniqueName = SpringFileSetService.getInstance().getUniqueName(defaultName, sets);
        fakeNewSet.setName(uniqueName);
        fakeNewSet.addFile(this.myVirtualFile);
        if (DumbService.isDumb((Project)this.myModule.getProject()) || ApplicationManager.getApplication().isUnitTestMode()) {
            ConfigureFileSetFix.addNewSet(facet, fakeNewSet);
            return;
        }
        Set currentModuleFileSets = SpringFileSetService.getInstance().getAllSets(facet);
        FileSetEditor editor = new FileSetEditor(this.myModule, fakeNewSet, currentModuleFileSets, new XmlConfigSearcher(this.myModule, false), new CodeConfigSearcher(this.myModule, false));
        if (editor.showAndGet()) {
            ConfigureFileSetFix.addNewSet(facet, editor.getEditedFileSet());
        } else {
            Disposer.dispose((Disposable)fakeNewSet);
        }
    }

    private static void addNewSet(SpringFacet facet, SpringFileSet fileSet) {
        facet.addFileSet(fileSet);
        ((SpringFacetConfiguration)facet.getConfiguration()).setModified();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/spring/model/highlighting/config/ConfigureFileSetFix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

