/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spring.spi;

import com.intellij.lang.ASTNode;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.psi.impl.PropertiesFileImpl;
import com.intellij.lang.properties.psi.impl.PropertyImpl;
import com.intellij.lang.properties.psi.impl.PropertyValueImpl;
import com.intellij.openapi.module.Module;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.JavaClassReferenceSet;
import com.intellij.spring.model.utils.SpringCommonUtils;
import com.intellij.spring.spi.SpringSpiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PairProcessor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SpringSpiManagerImpl
extends SpringSpiManager {
    private final Module myModule;

    public SpringSpiManagerImpl(Module module) {
        this.myModule = module;
    }

    public List<PropertiesFileImpl> getSpringFactoriesFiles(boolean includeTests) {
        return SpringCommonUtils.findConfigFilesInMetaInf((Module)this.myModule, (boolean)includeTests, (String)"spring.factories", PropertiesFileImpl.class);
    }

    private List<PropertiesFileImpl> getSpringFactoriesFilesWithValue(boolean includeTests, @Nullable String valueHint) {
        List<PropertiesFileImpl> files = this.getSpringFactoriesFiles(includeTests);
        if (valueHint == null) {
            return files;
        }
        return ContainerUtil.filter(files, file -> file.getText().contains(valueHint));
    }

    public List<PsiClass> getClassesListValue(boolean includeTests, @NotNull String key) {
        if (key == null) {
            SpringSpiManagerImpl.$$$reportNull$$$0(0);
        }
        SmartList result = new SmartList();
        PairProcessor collectProcessor = (arg_0, arg_1) -> SpringSpiManagerImpl.lambda$getClassesListValue$1((List)result, arg_0, arg_1);
        List<PropertiesFileImpl> configFiles = this.getSpringFactoriesFiles(includeTests);
        for (PropertiesFileImpl configFile : configFiles) {
            IProperty property = configFile.findPropertyByKey(key);
            SpringSpiManagerImpl.processClassReference(property, (PairProcessor<IProperty, PsiClass>)collectProcessor);
        }
        return result;
    }

    public boolean processClassesListValues(boolean includeTests, @Nullable String valueHint, PairProcessor<IProperty, PsiClass> processor) {
        List<PropertiesFileImpl> configFiles = this.getSpringFactoriesFilesWithValue(includeTests, valueHint);
        for (PropertiesFileImpl propertiesFile : configFiles) {
            for (IProperty property : propertiesFile.getProperties()) {
                if (SpringSpiManagerImpl.processClassReference(property, processor)) continue;
                return false;
            }
        }
        return true;
    }

    private static boolean processClassReference(IProperty property, PairProcessor<IProperty, PsiClass> processor) {
        PropertyValueImpl valueElement = SpringSpiManagerImpl.getPropertyValuePsiElement(property);
        if (valueElement == null) {
            return true;
        }
        SmartHashSet processedClassReferenceSets = new SmartHashSet();
        for (PsiReference reference : valueElement.getReferences()) {
            PsiElement resolve;
            JavaClassReference lastReference;
            JavaClassReferenceSet set;
            if (!(reference instanceof JavaClassReference) || !processedClassReferenceSets.add(set = ((JavaClassReference)reference).getJavaClassReferenceSet()) || (lastReference = (JavaClassReference)ArrayUtil.getLastElement((Object[])set.getAllReferences())) == null || !((resolve = lastReference.resolve()) instanceof PsiClass) || processor.process((Object)property, (Object)((PsiClass)resolve))) continue;
            return false;
        }
        return true;
    }

    @Nullable
    private static PropertyValueImpl getPropertyValuePsiElement(@Nullable IProperty property) {
        if (!(property instanceof PropertyImpl)) {
            return null;
        }
        ASTNode valueNode = ((PropertyImpl)property).getValueNode();
        if (valueNode == null) {
            return null;
        }
        PsiElement valueElement = valueNode.getPsi();
        if (!(valueElement instanceof PropertyValueImpl)) {
            return null;
        }
        return (PropertyValueImpl)valueElement;
    }

    private static /* synthetic */ boolean lambda$getClassesListValue$1(List result, IProperty property, PsiClass psiClass) {
        result.add(psiClass);
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "key", "com/intellij/spring/spi/SpringSpiManagerImpl", "getClassesListValue"));
    }
}

