/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool;

import android.databinding.tool.DataBinder;
import android.databinding.tool.DataBindingCompilerArgs;
import android.databinding.tool.LayoutBinder;
import android.databinding.tool.reflection.InjectedClass;
import android.databinding.tool.reflection.InjectedMethod;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.store.ResourceBundle;
import android.databinding.tool.util.L;
import android.databinding.tool.util.Preconditions;
import android.databinding.tool.writer.BRWriter;
import android.databinding.tool.writer.BindingMapperWriter;
import android.databinding.tool.writer.DynamicUtilWriter;
import android.databinding.tool.writer.JavaFileWriter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompilerChef {
    private static final String[] VERSION_CODES = new String[]{"BASE", "BASE_1_1", "CUPCAKE", "DONUT", "ECLAIR", "ECLAIRE_0_1", "ECLAIR_MR1", "FROYO", "GINGERBREAD", "GINGERBREAD_MR1", "HONEYCOMB", "HONEYCOMB_MR1", "HONEYCOMB_MR2", "ICE_CREAM_SANDWICH", "ICE_CREAM_SANDWICH_MR1", "JELLY_BEAN", "JELLY_BEAN_MR1", "JELLY_BEAN_MR2", "KITKAT", "KITKAT_WATCH", "LOLLIPOP", "LOLLIPOP_MR1", "M"};
    private JavaFileWriter mFileWriter;
    private ResourceBundle mResourceBundle;
    private DataBinder mDataBinder;

    private CompilerChef() {
    }

    public static CompilerChef createChef(ResourceBundle bundle, JavaFileWriter fileWriter) {
        CompilerChef chef = new CompilerChef();
        chef.mResourceBundle = bundle;
        chef.mFileWriter = fileWriter;
        chef.mResourceBundle.validateMultiResLayouts();
        chef.pushClassesToAnalyzer();
        chef.pushDynamicUtilToAnalyzer();
        return chef;
    }

    public ResourceBundle getResourceBundle() {
        return this.mResourceBundle;
    }

    public void ensureDataBinder() {
        if (this.mDataBinder == null) {
            this.mDataBinder = new DataBinder(this.mResourceBundle);
            this.mDataBinder.setFileWriter(this.mFileWriter);
        }
    }

    public boolean hasAnythingToGenerate() {
        L.d("checking if we have anything to generate. bundle size: %s", this.mResourceBundle == null ? -1 : this.mResourceBundle.getLayoutBundles().size());
        return this.mResourceBundle != null && this.mResourceBundle.getLayoutBundles().size() > 0;
    }

    private void pushClassesToAnalyzer() {
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        for (String layoutName : this.mResourceBundle.getLayoutBundles().keySet()) {
            HashSet<String> variables2 = new HashSet<String>();
            HashSet<String> fields = new HashSet<String>();
            List<ResourceBundle.LayoutFileBundle> bundles = this.mResourceBundle.getLayoutBundles().get(layoutName);
            String className = bundles.get(0).getBindingClassPackage() + "." + bundles.get(0).getBindingClassName();
            InjectedClass bindingClass = new InjectedClass(className, "android.databinding.ViewDataBinding");
            analyzer.injectClass(bindingClass);
            for (ResourceBundle.LayoutFileBundle layoutFileBundle : bundles) {
                HashMap<String, String> imports = new HashMap<String, String>();
                for (ResourceBundle.NameTypeLocation imp : layoutFileBundle.getImports()) {
                    imports.put(imp.name, imp.type);
                }
                for (ResourceBundle.VariableDeclaration variable : layoutFileBundle.getVariables()) {
                    if (!variables2.add(variable.name)) continue;
                    bindingClass.addVariable(variable.name, variable.type, imports);
                }
                for (ResourceBundle.BindingTargetBundle bindingTargetBundle : layoutFileBundle.getBindingTargetBundles()) {
                    String fieldName2;
                    if (bindingTargetBundle.getId() == null || !fields.add(fieldName2 = bindingTargetBundle.getId())) continue;
                    String fieldType = bindingTargetBundle.getInterfaceType();
                    bindingClass.addField(fieldName2, fieldType);
                }
                if (bundles.size() <= 1) continue;
                String implName = className + layoutFileBundle.getConfigName() + "Impl";
                analyzer.injectClass(new InjectedClass(implName, className));
            }
        }
    }

    public static InjectedClass pushDynamicUtilToAnalyzer() {
        InjectedClass injectedClass = new InjectedClass("android.databinding.DynamicUtil", "java.lang.Object");
        for (Map.Entry<Class, Class> entry : ModelClass.BOX_MAPPING.entrySet()) {
            injectedClass.addMethod(new InjectedMethod(injectedClass, true, "safeUnbox", null, entry.getKey().getCanonicalName(), entry.getValue().getCanonicalName()));
        }
        ModelAnalyzer analyzer = ModelAnalyzer.getInstance();
        analyzer.injectClass(injectedClass);
        return injectedClass;
    }

    public void writeDataBinderMapper(DataBindingCompilerArgs compilerArgs, BRWriter brWriter) {
        this.ensureDataBinder();
        String pkg = "android.databinding";
        BindingMapperWriter dbr = new BindingMapperWriter("android.databinding", "DataBinderMapper", this.mDataBinder.getLayoutBinders(), compilerArgs);
        this.mFileWriter.writeToFile("android.databinding." + dbr.getClassName(), dbr.write(brWriter));
    }

    public void writeDynamicUtil() {
        DynamicUtilWriter dynamicUtil = new DynamicUtilWriter();
        ModelClass versionCodes = ModelAnalyzer.getInstance().findClass("android.os.Build.VERSION_CODES", null);
        Preconditions.checkNotNull(versionCodes, "Could not find compile SDK", new Object[0]);
        int compileVersion = 1;
        for (int i = VERSION_CODES.length - 1; i >= 0; --i) {
            if (versionCodes.findGetterOrField(VERSION_CODES[i], true) == null) continue;
            compileVersion = i + 1;
            break;
        }
        this.mFileWriter.writeToFile("android.databinding.DynamicUtil", dynamicUtil.write(compileVersion).generate());
    }

    public void addBRVariables(BindableHolder bindables) {
        this.ensureDataBinder();
        for (LayoutBinder layoutBinder : this.mDataBinder.mLayoutBinders) {
            for (String variableName : layoutBinder.getUserDefinedVariables().keySet()) {
                bindables.addVariable(variableName, layoutBinder.getClassName());
            }
        }
    }

    public void sealModels() {
        this.ensureDataBinder();
        this.mDataBinder.sealModels();
    }

    public void writeViewBinderInterfaces(boolean isLibrary) {
        this.ensureDataBinder();
        this.mDataBinder.writerBaseClasses(isLibrary);
    }

    public void writeViewBinders(int minSdk) {
        this.ensureDataBinder();
        this.mDataBinder.writeBinders(minSdk);
    }

    public void writeComponent() {
        this.ensureDataBinder();
        this.mDataBinder.writeComponent();
    }

    public Set<String> getWrittenClassNames() {
        this.ensureDataBinder();
        return this.mDataBinder.getWrittenClassNames();
    }

    public static interface BindableHolder {
        public void addVariable(String var1, String var2);
    }
}

