/*
 * Decompiled with CFR 0.152.
 */
package android.databinding.tool.expr;

import android.databinding.tool.expr.Dependency;
import android.databinding.tool.expr.Expr;
import android.databinding.tool.expr.ExprModel;
import android.databinding.tool.reflection.ModelAnalyzer;
import android.databinding.tool.reflection.ModelClass;
import android.databinding.tool.writer.KCode;
import java.util.List;

public class UnaryExpr
extends Expr {
    final String mOp;

    UnaryExpr(String op, Expr expr) {
        super(expr);
        this.mOp = op;
    }

    @Override
    public String getInvertibleError() {
        return this.getExpr().getInvertibleError();
    }

    @Override
    protected String computeUniqueKey() {
        return UnaryExpr.join(this.mOp, this.getExpr());
    }

    @Override
    public Expr generateInverse(ExprModel model, Expr value, String bindingClassName) {
        return this.getExpr().generateInverse(model, model.unary(this.mOp, value), bindingClassName);
    }

    @Override
    public Expr cloneToModel(ExprModel model) {
        return model.unary(this.mOp, this.getExpr().cloneToModel(model));
    }

    @Override
    protected KCode generateCode() {
        return new KCode().app(this.getOp(), this.getExpr().toCode());
    }

    @Override
    protected ModelClass resolveType(ModelAnalyzer modelAnalyzer) {
        return this.getExpr().getResolvedType();
    }

    @Override
    protected List<Dependency> constructDependencies() {
        return this.constructDynamicChildrenDependencies();
    }

    @Override
    public void injectSafeUnboxing(ModelAnalyzer modelAnalyzer, ExprModel model) {
        Expr expr = this.getExpr();
        if (expr.getResolvedType().isNullable()) {
            this.safeUnboxChild(model, expr);
        }
    }

    private String getOpStr() {
        switch (this.mOp.charAt(0)) {
            case '~': {
                return "bitNot";
            }
            case '!': {
                return "logicalNot";
            }
            case '-': {
                return "unaryMinus";
            }
            case '+': {
                return "unaryPlus";
            }
        }
        return this.mOp;
    }

    public String getOp() {
        return this.mOp;
    }

    public Expr getExpr() {
        return this.getChildren().get(0);
    }

    @Override
    public String toString() {
        return this.mOp + this.getExpr();
    }
}

