/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.events.Failure;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.ui.ConsoleView;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.notification.Notification;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.IJSwingUtilities;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class BuildConsoleUtils {
    private static final Pattern d = Pattern.compile("<[^>]*>");
    private static final Pattern a = Pattern.compile("<a ([^>]* )?href=[\"']([^>]*)[\"'][^>]*>");
    private static final String b = "</a>";
    private static final Set<String> c = ContainerUtil.set((Object[])new String[]{"<br>", "</br>", "<br/>", "<p>", "</p>", "<p/>", "<pre>", "</pre>"});

    public static boolean printFailure(final ConsoleView consoleView, final Failure failure) {
        String string = (String)ObjectUtils.chooseNotNull((Object)failure.getDescription(), (Object)failure.getMessage());
        if (string == null && failure.getError() != null) {
            string = failure.getError().getMessage();
        }
        if (string == null) {
            return false;
        }
        String string2 = StringUtil.convertLineSeparators((String)string);
        while (true) {
            Matcher matcher;
            if (!(matcher = d.matcher(string2)).find()) break;
            String string3 = matcher.group();
            consoleView.print(string2.substring(0, matcher.start()), ConsoleViewContentType.ERROR_OUTPUT);
            Matcher matcher2 = a.matcher(string3);
            if (matcher2.matches()) {
                final String string4 = matcher2.group(2);
                int n2 = string2.indexOf(b, matcher.end());
                if (n2 > 0) {
                    String string5 = string2.substring(matcher.end(), n2).replaceAll(d.pattern(), "");
                    consoleView.printHyperlink(string5, new HyperlinkInfo(){

                        public void navigate(Project project2) {
                            Notification notification = failure.getNotification();
                            if (notification != null && notification.getListener() != null) {
                                notification.getListener().hyperlinkUpdate(notification, IJSwingUtilities.createHyperlinkEvent((String)string4, (Object)consoleView.getComponent()));
                            }
                        }
                    });
                    string2 = string2.substring(n2 + b.length());
                    continue;
                }
            }
            if (c.contains(string3)) {
                consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
            } else {
                consoleView.print(string2.substring(matcher.start(), matcher.end()), ConsoleViewContentType.ERROR_OUTPUT);
            }
            string2 = string2.substring(matcher.end());
        }
        consoleView.print(string2, ConsoleViewContentType.ERROR_OUTPUT);
        consoleView.print("\n", ConsoleViewContentType.SYSTEM_OUTPUT);
        return true;
    }
}

