/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.ExecutionNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.Nullable;

public class ExecutionNodeProgressAnimator
implements Runnable,
Disposable {
    private static final int g = 8;
    private static final int f = 1200;
    private static final int c = 150;
    public static final Icon[] FRAMES = new Icon[8];
    private long e = -1L;
    private Alarm a;
    private List<ExecutionNode> b = new SmartList();
    private BuildTreeConsoleView d;

    public ExecutionNodeProgressAnimator(BuildTreeConsoleView buildTreeConsoleView) {
        Disposer.register((Disposable)buildTreeConsoleView, (Disposable)this);
        this.a = new Alarm();
        this.d = buildTreeConsoleView;
    }

    public static int getCurrentFrameIndex() {
        return (int)(System.currentTimeMillis() % 1200L / 150L);
    }

    public static Icon getCurrentFrame() {
        return FRAMES[ExecutionNodeProgressAnimator.getCurrentFrameIndex()];
    }

    @Override
    public void run() {
        long l2;
        if (!this.b.isEmpty() && (l2 = System.currentTimeMillis()) - this.e >= 150L) {
            this.a();
            this.e = l2;
        }
        this.d();
    }

    public void addNode(@Nullable ExecutionNode executionNode) {
        this.b.add(executionNode);
    }

    public void startMovie() {
        this.d();
    }

    public void stopMovie() {
        this.a();
        for (ExecutionNode executionNode : this.b) {
            executionNode.setIconProvider(() -> AllIcons.Process.State.YellowStr);
            executionNode.setEndTime(System.currentTimeMillis());
        }
        this.b.clear();
        this.c();
    }

    public void dispose() {
        this.d = null;
        this.b.clear();
        this.c();
    }

    private void c() {
        if (this.a != null) {
            this.a.cancelAllRequests();
            this.a = null;
        }
    }

    private void a() {
        if (this.d == null || this.d.isDisposed()) {
            return;
        }
        Iterator<ExecutionNode> iterator = this.b.iterator();
        while (iterator.hasNext()) {
            ExecutionNode executionNode = iterator.next();
            this.d.scheduleUpdate(executionNode);
            if (executionNode.isRunning()) continue;
            iterator.remove();
        }
    }

    private void d() {
        if (this.a == null) {
            return;
        }
        this.a.cancelAllRequests();
        this.a.addRequest((Runnable)this, 150);
    }

    static {
        ExecutionNodeProgressAnimator.FRAMES[0] = AllIcons.Process.State.GreyProgr_1;
        ExecutionNodeProgressAnimator.FRAMES[1] = AllIcons.Process.State.GreyProgr_2;
        ExecutionNodeProgressAnimator.FRAMES[2] = AllIcons.Process.State.GreyProgr_3;
        ExecutionNodeProgressAnimator.FRAMES[3] = AllIcons.Process.State.GreyProgr_4;
        ExecutionNodeProgressAnimator.FRAMES[4] = AllIcons.Process.State.GreyProgr_5;
        ExecutionNodeProgressAnimator.FRAMES[5] = AllIcons.Process.State.GreyProgr_6;
        ExecutionNodeProgressAnimator.FRAMES[6] = AllIcons.Process.State.GreyProgr_7;
        ExecutionNodeProgressAnimator.FRAMES[7] = AllIcons.Process.State.GreyProgr_8;
    }
}

