/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.build;

import com.intellij.build.AbstractViewManager;
import com.intellij.build.BuildContentDescriptor;
import com.intellij.build.BuildContentManager;
import com.intellij.build.BuildContentManagerImpl;
import com.intellij.build.BuildProgressListener;
import com.intellij.build.BuildTreeConsoleView;
import com.intellij.build.BuildView;
import com.intellij.build.DefaultBuildDescriptor;
import com.intellij.build.events.BuildEvent;
import com.intellij.build.events.FinishBuildEvent;
import com.intellij.build.events.StartBuildEvent;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ThreeComponentsSplitter;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBList;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.impl.ContentImpl;
import com.intellij.util.Alarm;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.TransferToEDTQueue;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.EmptyIcon;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import org.jetbrains.annotations.ApiStatus;

@ApiStatus.Experimental
public class MultipleBuildsView
implements BuildProgressListener,
Disposable {
    protected final Project myProject;
    protected final BuildContentManager myBuildContentManager;
    private final AtomicBoolean f;
    private final List<Runnable> a;
    private final ProgressWatcher k;
    private final ThreeComponentsSplitter d;
    private final JBList<AbstractViewManager.BuildInfo> g;
    private final Map<Object, AbstractViewManager.BuildInfo> j;
    private final Map<AbstractViewManager.BuildInfo, BuildView> e;
    private final AbstractViewManager l;
    private volatile Content c;
    private volatile DefaultActionGroup i;
    private volatile boolean b;
    private final TransferToEDTQueue<Runnable> h;

    public MultipleBuildsView(Project project2, BuildContentManager buildContentManager, AbstractViewManager abstractViewManager) {
        this.myProject = project2;
        this.myBuildContentManager = buildContentManager;
        this.l = abstractViewManager;
        this.f = new AtomicBoolean();
        this.a = ContainerUtil.createConcurrentList();
        this.d = new ThreeComponentsSplitter();
        Disposer.register((Disposable)this, (Disposable)this.d);
        this.g = new JBList();
        this.g.setModel(new DefaultListModel());
        this.g.setFixedCellHeight(40);
        this.g.installCellRenderer(object -> {
            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)object;
            JPanel jPanel = new JPanel(new BorderLayout());
            SimpleColoredComponent simpleColoredComponent = new SimpleColoredComponent();
            simpleColoredComponent.setIcon(buildInfo.getIcon());
            simpleColoredComponent.append(buildInfo.getTitle() + ": ", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
            simpleColoredComponent.append(buildInfo.message, SimpleTextAttributes.REGULAR_ATTRIBUTES);
            jPanel.add((Component)simpleColoredComponent, "North");
            if (buildInfo.statusMessage != null) {
                SimpleColoredComponent simpleColoredComponent2 = new SimpleColoredComponent();
                simpleColoredComponent2.setIcon(EmptyIcon.ICON_16);
                simpleColoredComponent2.append(buildInfo.statusMessage, SimpleTextAttributes.GRAY_ATTRIBUTES);
                jPanel.add((Component)simpleColoredComponent2, "South");
            }
            return jPanel;
        });
        this.e = ContainerUtil.newConcurrentMap();
        this.j = ContainerUtil.newConcurrentMap();
        this.k = new ProgressWatcher();
        this.h = new TransferToEDTQueue("Multiple builds view queue", runnable -> {
            runnable.run();
            return true;
        }, object -> this.b);
    }

    public void dispose() {
        this.b = true;
    }

    public Content getContent() {
        return this.c;
    }

    public Map<AbstractViewManager.BuildInfo, BuildView> getBuildsMap() {
        return Collections.unmodifiableMap(this.e);
    }

    public boolean shouldConsume(BuildEvent buildEvent) {
        return buildEvent.getParentId() != null && this.j.containsKey(buildEvent.getParentId()) || this.j.containsKey(buildEvent.getId());
    }

    @Override
    public void onEvent(BuildEvent buildEvent) {
        SmartList smartList = new SmartList();
        if (buildEvent instanceof StartBuildEvent) {
            if (this.f.get()) {
                long l2 = System.currentTimeMillis();
                DefaultListModel defaultListModel = (DefaultListModel)this.g.getModel();
                boolean bl2 = !defaultListModel.isEmpty();
                for (int i2 = 0; i2 < defaultListModel.getSize(); ++i2) {
                    AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)defaultListModel.getElementAt(i2);
                    if (buildInfo.endTime != -1L && l2 - buildInfo.endTime >= TimeUnit.SECONDS.toMillis(1L)) continue;
                    bl2 = false;
                    break;
                }
                if (bl2) {
                    this.j.clear();
                    SmartList smartList2 = new SmartList(this.e.values());
                    smartList.add(() -> smartList2.forEach(Disposer::dispose));
                    this.e.clear();
                    defaultListModel.clear();
                    this.g.setVisible(false);
                    smartList.add(() -> {
                        this.d.setFirstComponent(null);
                        this.d.setLastComponent(null);
                    });
                    this.i.removeAll();
                }
            }
            StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
            AbstractViewManager.BuildInfo buildInfo = new AbstractViewManager.BuildInfo(buildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), buildEvent.getEventTime());
            this.j.put(buildEvent.getId(), buildInfo);
        } else if (buildEvent.getParentId() != null) {
            AbstractViewManager.BuildInfo buildInfo = this.j.get(buildEvent.getParentId());
            assert (buildInfo != null);
            this.j.put(buildEvent.getId(), buildInfo);
        }
        smartList.add(() -> {
            AbstractViewManager.BuildInfo buildInfo2 = this.j.get(buildEvent.getId());
            assert (buildInfo2 != null);
            if (buildEvent instanceof StartBuildEvent) {
                RunContentDescriptor runContentDescriptor;
                StartBuildEvent startBuildEvent = (StartBuildEvent)buildEvent;
                buildInfo2.message = startBuildEvent.getMessage();
                DefaultListModel defaultListModel = (DefaultListModel)this.g.getModel();
                defaultListModel.addElement(buildInfo2);
                BuildView buildView = this.e.computeIfAbsent(buildInfo2, buildInfo -> {
                    DefaultBuildDescriptor defaultBuildDescriptor = new DefaultBuildDescriptor(startBuildEvent.getId(), startBuildEvent.getBuildTitle(), startBuildEvent.getWorkingDir(), startBuildEvent.getEventTime());
                    String string = "build.toolwindow." + this.l.getViewName() + ".selection.state";
                    BuildView buildView = new BuildView(this.myProject, defaultBuildDescriptor, string, this.l);
                    Disposer.register((Disposable)this.d, (Disposable)buildView);
                    return buildView;
                });
                buildView.onEvent(startBuildEvent);
                this.c.setPreferredFocusedComponent(buildView::getPreferredFocusableComponent);
                Supplier<RunContentDescriptor> supplier = startBuildEvent.getContentDescriptorSupplier();
                RunContentDescriptor runContentDescriptor2 = runContentDescriptor = supplier != null ? supplier.get() : null;
                if (runContentDescriptor != null) {
                    boolean bl2;
                    buildInfo2.activateToolWindowWhenAdded = bl2 = runContentDescriptor.isActivateToolWindowWhenAdded();
                    if (runContentDescriptor instanceof BuildContentDescriptor) {
                        buildInfo2.activateToolWindowWhenFailed = ((BuildContentDescriptor)runContentDescriptor).isActivateToolWindowWhenFailed();
                    }
                    boolean bl3 = runContentDescriptor.isAutoFocusContent();
                    this.myBuildContentManager.setSelectedContent(this.c, bl3, bl3, bl2, runContentDescriptor.getActivationCallback());
                    Disposer.register((Disposable)buildView, (Disposable)runContentDescriptor);
                } else {
                    this.myBuildContentManager.setSelectedContent(this.c, true, true, false, null);
                }
                buildInfo2.content = this.c;
                if (this.d.getLastComponent() == null) {
                    this.d.setLastComponent((JComponent)buildView);
                    this.l.configureToolbar(this.i, this, buildView);
                }
                if (this.g.getModel().getSize() > 1) {
                    JBScrollPane jBScrollPane = new JBScrollPane();
                    jBScrollPane.setBorder((Border)JBUI.Borders.empty());
                    jBScrollPane.setViewportView(this.g);
                    this.d.setFirstComponent((JComponent)jBScrollPane);
                    this.g.setVisible(true);
                    this.g.setSelectedIndex(0);
                    this.d.repaint();
                    for (BuildView buildView2 : this.e.values()) {
                        BuildTreeConsoleView buildTreeConsoleView = buildView2.getView(BuildTreeConsoleView.class.getName(), BuildTreeConsoleView.class);
                        if (buildTreeConsoleView == null) continue;
                        buildTreeConsoleView.hideRootNode();
                    }
                } else {
                    this.d.setFirstComponent(null);
                }
                this.l.onBuildStart(buildInfo2);
                this.k.addBuild(buildInfo2);
                ((BuildContentManagerImpl)this.myBuildContentManager).startBuildNotified(buildInfo2, buildInfo2.content, startBuildEvent.getProcessHandler());
            } else {
                if (buildEvent instanceof FinishBuildEvent) {
                    buildInfo2.endTime = buildEvent.getEventTime();
                    buildInfo2.message = buildEvent.getMessage();
                    buildInfo2.result = ((FinishBuildEvent)buildEvent).getResult();
                    this.k.stopBuild(buildInfo2);
                    ((BuildContentManagerImpl)this.myBuildContentManager).finishBuildNotified(buildInfo2, buildInfo2.content);
                    this.l.onBuildFinish(buildInfo2);
                } else {
                    buildInfo2.statusMessage = buildEvent.getMessage();
                }
                this.e.get(buildInfo2).onEvent(buildEvent);
            }
        });
        if (this.c == null) {
            this.a.addAll((Collection<Runnable>)smartList);
            if (this.f.compareAndSet(false, true)) {
                this.h.offer(() -> {
                    this.g.setSelectionMode(0);
                    this.g.addListSelectionListener(new ListSelectionListener(){

                        @Override
                        public void valueChanged(ListSelectionEvent listSelectionEvent) {
                            AbstractViewManager.BuildInfo buildInfo = (AbstractViewManager.BuildInfo)MultipleBuildsView.this.g.getSelectedValue();
                            if (buildInfo == null) {
                                return;
                            }
                            BuildView buildView = (BuildView)MultipleBuildsView.this.e.get(buildInfo);
                            JComponent jComponent = MultipleBuildsView.this.d.getLastComponent();
                            if (buildView != null && jComponent != buildView.getComponent()) {
                                MultipleBuildsView.this.d.setLastComponent(buildView.getComponent());
                                buildView.getComponent().setVisible(true);
                                if (jComponent != null) {
                                    jComponent.setVisible(false);
                                }
                                MultipleBuildsView.this.l.configureToolbar(MultipleBuildsView.this.i, MultipleBuildsView.this, buildView);
                                buildView.getComponent().repaint();
                            }
                            int n2 = MultipleBuildsView.this.d.getFirstSize();
                            int n3 = MultipleBuildsView.this.d.getLastSize();
                            if (n2 == 0 && n3 == 0) {
                                EdtInvocationManager.getInstance().invokeLater(() -> {
                                    int n2 = Math.round((float)MultipleBuildsView.this.d.getWidth() / 4.0f);
                                    MultipleBuildsView.this.d.setFirstSize(n2);
                                });
                            }
                        }
                    });
                    JPanel jPanel = new JPanel(new BorderLayout());
                    jPanel.add((Component)this.d, "Center");
                    this.i = new DefaultActionGroup();
                    jPanel.add((Component)ActionManager.getInstance().createActionToolbar("BuildView", (ActionGroup)this.i, false).getComponent(), "West");
                    this.c = new ContentImpl((JComponent)jPanel, this.l.getViewName(), true);
                    Disposer.register((Disposable)this.c, (Disposable)this);
                    this.c.setCloseable(false);
                    Icon icon = this.l.getContentIcon();
                    if (icon != null) {
                        this.c.setIcon(icon);
                        this.c.putUserData(ToolWindow.SHOW_CONTENT_ICON, (Object)Boolean.TRUE);
                    }
                    this.myBuildContentManager.addContent(this.c);
                    ArrayList<Runnable> arrayList = new ArrayList<Runnable>(this.a);
                    this.a.clear();
                    for (Runnable runnable : arrayList) {
                        runnable.run();
                    }
                });
            }
        } else {
            this.h.offer(() -> MultipleBuildsView.a((List)smartList));
        }
    }

    public boolean hasRunningBuilds() {
        return !this.k.a.isEmpty();
    }

    private static /* synthetic */ void a(List list) {
        for (Runnable runnable : list) {
            runnable.run();
        }
    }

    private class ProgressWatcher
    implements Runnable {
        private final Alarm b = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        private final Set<AbstractViewManager.BuildInfo> a = ContainerUtil.newConcurrentSet();

        private ProgressWatcher() {
        }

        @Override
        public void run() {
            this.b.cancelAllRequests();
            JComponent jComponent = MultipleBuildsView.this.d.getFirstComponent();
            if (jComponent != null) {
                jComponent.revalidate();
                jComponent.repaint();
            }
            if (!this.a.isEmpty()) {
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void addBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.add(buildInfo);
            if (this.a.size() > 1) {
                this.b.cancelAllRequests();
                this.b.addRequest((Runnable)this, 300);
            }
        }

        void stopBuild(AbstractViewManager.BuildInfo buildInfo) {
            this.a.remove(buildInfo);
        }
    }
}

