/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;

public class CompilerIOUtil {
    private static final ThreadLocal<byte[]> a = new ThreadLocal<byte[]>(){

        @Override
        protected byte[] initialValue() {
            return new byte[1024];
        }
    };

    private CompilerIOUtil() {
    }

    public static String readString(DataInput dataInput) throws IOException {
        int n2 = dataInput.readInt();
        try {
            if (n2 == -1) {
                return null;
            }
        }
        catch (IOException iOException) {
            throw CompilerIOUtil.b(iOException);
        }
        try {
            if (n2 == 0) {
                return "";
            }
        }
        catch (IOException iOException) {
            throw CompilerIOUtil.b(iOException);
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        byte[] byArray = a.get();
        while (n3 < n2) {
            int n4 = Math.min((n2 - n3) * 2, byArray.length);
            dataInput.readFully(byArray, 0, n4);
            try {
                for (int i2 = 0; i2 < n4; i2 += 2) {
                    cArray[n3++] = (char)((byArray[i2] << 8) + (byArray[i2 + 1] & 0xFF));
                }
            }
            catch (IOException iOException) {
                throw CompilerIOUtil.b(iOException);
            }
        }
        return new String(cArray);
    }

    public static void writeString(String string, DataOutput dataOutput) throws IOException {
        try {
            if (string == null) {
                dataOutput.writeInt(-1);
                return;
            }
        }
        catch (IOException iOException) {
            throw CompilerIOUtil.b(iOException);
        }
        int n2 = string.length();
        try {
            dataOutput.writeInt(n2);
            if (n2 == 0) {
                return;
            }
        }
        catch (IOException iOException) {
            throw CompilerIOUtil.b(iOException);
        }
        int n3 = 0;
        byte[] byArray = a.get();
        while (n3 < n2) {
            int n4 = Math.min((n2 - n3) * 2, byArray.length);
            for (int i2 = 0; i2 < n4; i2 += 2) {
                char c2 = string.charAt(n3++);
                byArray[i2] = (byte)(c2 >>> 8 & 0xFF);
                byArray[i2 + 1] = (byte)(c2 & 0xFF);
            }
            dataOutput.write(byArray, 0, n4);
        }
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }
}

