/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.ant;

import com.intellij.compiler.ant.BuildProperties;
import com.intellij.compiler.ant.ChunkBuildExtension;
import com.intellij.compiler.ant.GenerationOptions;
import com.intellij.compiler.ant.PropertyFileGenerator;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ArrayUtil;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Set;

public class PropertyFileGeneratorImpl
extends PropertyFileGenerator {
    private final List<Couple<String>> a = new ArrayList<Couple<String>>();

    public PropertyFileGeneratorImpl(Project project2, GenerationOptions generationOptions) {
        Object[] objectArray;
        PathMacros pathMacros = PathMacros.getInstance();
        Set set = pathMacros.getUserMacroNames();
        if (set.size() > 0) {
            objectArray = ArrayUtil.toStringArray((Collection)set);
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                this.addProperty(BuildProperties.getPathMacroProperty((String)object), pathMacros.getValue((String)object));
            }
        }
        if (generationOptions.forceTargetJdk) {
            for (Object object : objectArray = BuildProperties.getUsedJdks((Project)project2)) {
                if (object.getHomeDirectory() == null) continue;
                File file = BuildProperties.toCanonicalFile((File)VfsUtil.virtualToIoFile((VirtualFile)object.getHomeDirectory()));
                this.addProperty(BuildProperties.getJdkHomeProperty((String)object.getName()), file.getPath().replace(File.separatorChar, '/'));
            }
        }
        if (generationOptions.isIdeaHomeGenerated()) {
            this.addProperty("idea.home", PathManager.getHomePath());
        }
        if (generationOptions.enableFormCompiler) {
            this.addProperty("javac2.instrumentation.includeJavaRuntime", generationOptions.forceTargetJdk ? "false" : "true");
        }
        ChunkBuildExtension.generateAllProperties((PropertyFileGenerator)this, (Project)project2, (GenerationOptions)generationOptions);
    }

    public void addProperty(String string, String string2) {
        this.a.add((Couple<String>)Couple.of((Object)string, (Object)string2));
    }

    public void generate(PrintWriter printWriter) throws IOException {
        boolean bl2 = true;
        for (Couple<String> couple : this.a) {
            block4: {
                block3: {
                    try {
                        if (bl2) break block3;
                        PropertyFileGeneratorImpl.crlf((PrintWriter)printWriter);
                        break block4;
                    }
                    catch (IOException iOException) {
                        throw PropertyFileGeneratorImpl.b(iOException);
                    }
                }
                bl2 = false;
            }
            printWriter.print(StringUtil.escapeProperty((String)((String)couple.getFirst()), (boolean)true));
            printWriter.print("=");
            printWriter.print(StringUtil.escapeProperty((String)((String)couple.getSecond()), (boolean)false));
        }
    }

    private static IOException b(IOException iOException) {
        return iOException;
    }
}

