/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.options;

import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.util.ui.EditableModel;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import org.jetbrains.jps.model.java.compiler.ProcessorConfigProfile;

public class ProcessorProfilePanel
extends JPanel {
    private final Project c;
    private JRadioButton a;
    private JRadioButton g;
    private TextFieldWithBrowseButton b;
    private JTextField r;
    private JTextField j;
    private JRadioButton t;
    private JRadioButton q;
    private ProcessorTableModel s;
    private JCheckBox n;
    private JBTable m;
    private JBTable h;
    private JPanel f;
    private JPanel e;
    private OptionsTableModel o;
    private JLabel d;
    private JLabel i;
    private JLabel l;
    private JPanel p;
    private JPanel k;

    public ProcessorProfilePanel(Project project2) {
        super(new GridBagLayout());
        this.c = project2;
        this.n = new JCheckBox("Enable annotation processing");
        this.a = new JRadioButton("Obtain processors from project classpath");
        this.g = new JRadioButton("Processor path:");
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.a);
        buttonGroup.add(this.g);
        this.q = new JRadioButton("Module content root");
        this.t = new JRadioButton("Module output directory");
        buttonGroup = new ButtonGroup();
        buttonGroup.add(this.q);
        buttonGroup.add(this.t);
        this.b = new TextFieldWithBrowseButton(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createAllButJarContentsDescriptor();
                VirtualFile[] virtualFileArray = FileChooser.chooseFiles((FileChooserDescriptor)fileChooserDescriptor, (Component)ProcessorProfilePanel.this.b, (Project)ProcessorProfilePanel.this.c, null);
                if (virtualFileArray.length > 0) {
                    StringBuilder stringBuilder = new StringBuilder();
                    for (VirtualFile virtualFile : virtualFileArray) {
                        if (stringBuilder.length() > 0) {
                            stringBuilder.append(File.pathSeparator);
                        }
                        stringBuilder.append(FileUtil.toSystemDependentName((String)virtualFile.getPath()));
                    }
                    ProcessorProfilePanel.this.b.setText(stringBuilder.toString());
                }
            }
        });
        this.p = new JPanel(new BorderLayout());
        this.s = new ProcessorTableModel();
        this.p.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Annotation Processors", (boolean)false));
        this.m = new JBTable((TableModel)this.s);
        this.m.getEmptyText().setText("Compiler will run all automatically discovered processors");
        this.f = ProcessorProfilePanel.a(this.m);
        this.p.add((Component)this.f, "Center");
        this.k = new JPanel(new BorderLayout());
        this.o = new OptionsTableModel();
        this.k.setBorder((Border)IdeBorderFactory.createTitledBorder((String)"Annotation Processor options", (boolean)false));
        this.h = new JBTable((TableModel)this.o);
        this.h.getEmptyText().setText("No processor-specific options configured");
        this.e = ProcessorProfilePanel.a(this.h);
        this.k.add((Component)this.e, "Center");
        this.r = new JTextField();
        this.j = new JTextField();
        this.add((Component)this.n, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 18, 0, (Insets)JBUI.emptyInsets(), 0, 0));
        this.add((Component)this.a, new GridBagConstraints(0, -1, 3, 1, 1.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.add((Component)this.g, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 0, (Insets)JBUI.insetsTop((int)5), 0, 0));
        this.add((Component)this.b, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)5, (int)5, (int)0, (int)0), 0, 0));
        this.d = new JLabel("Store generated sources relative to: ");
        this.add((Component)this.d, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.t, new GridBagConstraints(1, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.q, new GridBagConstraints(2, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)15, (int)5, (int)0, (int)0), 0, 0));
        this.i = new JLabel("Production sources directory:");
        this.add((Component)this.i, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.r, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.l = new JLabel("Test sources directory:");
        this.add((Component)this.l, new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.j, new GridBagConstraints(1, -1, 2, 1, 1.0, 0.0, 17, 2, (Insets)JBUI.insets((int)10, (int)5, (int)0, (int)0), 0, 0));
        this.add((Component)this.p, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.add((Component)this.k, new GridBagConstraints(0, -1, 3, 1, 1.0, 1.0, 18, 1, (Insets)JBUI.insetsTop((int)10), 0, 0));
        this.a.addItemListener(itemEvent -> this.a());
        this.m.getSelectionModel().addListSelectionListener(listSelectionEvent -> {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.a();
            }
        });
        this.n.addItemListener(itemEvent -> this.a());
        this.a();
    }

    public void setProfile(ProcessorConfigProfile processorConfigProfile) {
        this.n.setSelected(processorConfigProfile.isEnabled());
        (processorConfigProfile.isObtainProcessorsFromClasspath() ? this.a : this.g).setSelected(true);
        this.b.setText(FileUtil.toSystemDependentName((String)processorConfigProfile.getProcessorPath()));
        String string = processorConfigProfile.getGeneratedSourcesDirectoryName(false);
        this.r.setText(string != null ? string.trim() : "");
        String string2 = processorConfigProfile.getGeneratedSourcesDirectoryName(true);
        this.j.setText(string2 != null ? string2.trim() : "");
        if (processorConfigProfile.isOutputRelativeToContentRoot()) {
            this.q.setSelected(true);
        } else {
            this.t.setSelected(true);
        }
        this.s.setProcessors(processorConfigProfile.getProcessors());
        this.o.setOptions(processorConfigProfile.getProcessorOptions());
        this.a();
    }

    public void saveTo(ProcessorConfigProfile processorConfigProfile) {
        processorConfigProfile.setEnabled(this.n.isSelected());
        processorConfigProfile.setObtainProcessorsFromClasspath(this.a.isSelected());
        processorConfigProfile.setProcessorPath(this.b.getText().trim());
        String string = this.r.getText().trim();
        processorConfigProfile.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)string) ? null : string, false);
        String string2 = this.j.getText().trim();
        processorConfigProfile.setGeneratedSourcesDirectoryName(StringUtil.isEmpty((String)string2) ? null : string2, true);
        processorConfigProfile.setOutputRelativeToContentRoot(this.q.isSelected());
        processorConfigProfile.clearProcessors();
        for (String object : this.s.getProcessors()) {
            processorConfigProfile.addProcessor(object);
        }
        processorConfigProfile.clearProcessorOptions();
        for (Map.Entry entry : this.o.getOptions().entrySet()) {
            processorConfigProfile.setOption((String)entry.getKey(), (String)entry.getValue());
        }
    }

    private static JPanel a(final JBTable jBTable) {
        return ToolbarDecorator.createDecorator((JTable)jBTable).disableUpAction().disableDownAction().setAddAction(new AnActionButtonRunnable(){

            public void run(AnActionButton anActionButton) {
                TableCellEditor tableCellEditor = jBTable.getCellEditor();
                if (tableCellEditor != null) {
                    tableCellEditor.stopCellEditing();
                }
                TableModel tableModel = jBTable.getModel();
                ((EditableModel)tableModel).addRow();
                TableUtil.editCellAt((JTable)jBTable, (int)(tableModel.getRowCount() - 1), (int)0);
            }
        }).createPanel();
    }

    private void a() {
        boolean bl2 = this.n.isSelected();
        boolean bl3 = !this.a.isSelected();
        this.a.setEnabled(bl2);
        this.g.setEnabled(bl2);
        this.b.setEnabled(bl2 && bl3);
        ProcessorProfilePanel.a(this.f, this.m, bl2);
        ProcessorProfilePanel.a(this.e, this.h, bl2);
        this.r.setEnabled(bl2);
        this.j.setEnabled(bl2);
        this.t.setEnabled(bl2);
        this.q.setEnabled(bl2);
        this.d.setEnabled(bl2);
        this.i.setEnabled(bl2);
        this.l.setEnabled(bl2);
        this.p.setEnabled(bl2);
        this.k.setEnabled(bl2);
    }

    private static void a(JPanel jPanel, JBTable jBTable, boolean bl2) {
        AnActionButton anActionButton;
        AnActionButton anActionButton2 = ToolbarDecorator.findAddButton((JComponent)jPanel);
        if (anActionButton2 != null) {
            anActionButton2.setEnabled(bl2);
        }
        if ((anActionButton = ToolbarDecorator.findRemoveButton((JComponent)jPanel)) != null) {
            anActionButton.setEnabled(bl2 && jBTable.getSelectedRow() >= 0);
        }
        jBTable.setEnabled(bl2);
        JTableHeader jTableHeader = jBTable.getTableHeader();
        if (jTableHeader != null) {
            jTableHeader.repaint();
        }
    }

    private static class ProcessorTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<String> a = new ArrayList<String>();

        private ProcessorTableModel() {
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return "Processor FQ Name";
                }
            }
            return super.getColumnName(n2);
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            switch (n3) {
                case 0: {
                    return this.a.get(n2);
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            if (object != null) {
                switch (n3) {
                    case 0: {
                        this.a.set(n2, (String)object);
                    }
                }
            }
        }

        public void removeRow(int n2) {
            this.a.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }

        public void exchangeRows(int n2, int n3) {
        }

        public boolean canExchangeRows(int n2, int n3) {
            return false;
        }

        public void addRow() {
            this.a.add("");
            int n2 = this.a.size() - 1;
            this.fireTableRowsInserted(n2, n2);
        }

        public void setProcessors(Collection<String> collection) {
            this.clear();
            if (!collection.isEmpty()) {
                for (String string3 : collection) {
                    this.a.add(string3);
                }
                Collections.sort(this.a, (string, string2) -> string.compareToIgnoreCase((String)string2));
                this.fireTableRowsInserted(0, collection.size() - 1);
            }
        }

        public void clear() {
            int n2 = this.a.size();
            if (n2 > 0) {
                this.a.clear();
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }

        public Collection<String> getProcessors() {
            HashSet<String> hashSet = new HashSet<String>();
            for (String string : this.a) {
                if (string == null) continue;
                hashSet.add(string.trim());
            }
            hashSet.remove("");
            return hashSet;
        }
    }

    private static class OptionsTableModel
    extends AbstractTableModel
    implements EditableModel {
        private final List<KeyValuePair> a = new ArrayList<KeyValuePair>();

        private OptionsTableModel() {
        }

        @Override
        public String getColumnName(int n2) {
            switch (n2) {
                case 0: {
                    return "Option Name";
                }
                case 1: {
                    return "Value";
                }
            }
            return super.getColumnName(n2);
        }

        @Override
        public Class<?> getColumnClass(int n2) {
            return String.class;
        }

        @Override
        public int getRowCount() {
            return this.a.size();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public boolean isCellEditable(int n2, int n3) {
            return n3 == 0 || n3 == 1;
        }

        @Override
        public Object getValueAt(int n2, int n3) {
            switch (n3) {
                case 0: {
                    return this.a.get((int)n2).key;
                }
                case 1: {
                    return this.a.get((int)n2).value;
                }
            }
            return null;
        }

        @Override
        public void setValueAt(Object object, int n2, int n3) {
            if (object != null) {
                switch (n3) {
                    case 0: {
                        this.a.get((int)n2).key = (String)object;
                        break;
                    }
                    case 1: {
                        this.a.get((int)n2).value = (String)object;
                    }
                }
            }
        }

        public void removeRow(int n2) {
            this.a.remove(n2);
            this.fireTableRowsDeleted(n2, n2);
        }

        public void exchangeRows(int n2, int n3) {
        }

        public boolean canExchangeRows(int n2, int n3) {
            return false;
        }

        public void addRow() {
            this.a.add(new KeyValuePair());
            int n2 = this.a.size() - 1;
            this.fireTableRowsInserted(n2, n2);
        }

        public void setOptions(Map<String, String> map) {
            this.clear();
            if (!map.isEmpty()) {
                for (Map.Entry<String, String> entry : map.entrySet()) {
                    this.a.add(new KeyValuePair(entry.getKey(), entry.getValue()));
                }
                Collections.sort(this.a, (keyValuePair, keyValuePair2) -> keyValuePair.key.compareToIgnoreCase(keyValuePair2.key));
                this.fireTableRowsInserted(0, map.size() - 1);
            }
        }

        public void clear() {
            int n2 = this.a.size();
            if (n2 > 0) {
                this.a.clear();
                this.fireTableRowsDeleted(0, n2 - 1);
            }
        }

        public Map<String, String> getOptions() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (KeyValuePair keyValuePair : this.a) {
                hashMap.put(keyValuePair.key.trim(), keyValuePair.value.trim());
            }
            hashMap.remove("");
            return hashMap;
        }

        private static final class KeyValuePair {
            String key;
            String value;

            KeyValuePair() {
                this("", "");
            }

            KeyValuePair(String string, String string2) {
                this.key = string;
                this.value = string2;
            }
        }
    }
}

