/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaExecutionStack;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.StackFrameDescriptorImpl;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.impl.ui.DebuggerUIUtil;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public abstract class GotoFrameSourceAction
extends DebuggerAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        DataContext dataContext = anActionEvent.getDataContext();
        GotoFrameSourceAction.doAction(dataContext);
    }

    public static void doAction(DataContext dataContext) {
        Project project2 = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        if (project2 == null) {
            return;
        }
        StackFrameDescriptorImpl stackFrameDescriptorImpl = GotoFrameSourceAction.a(dataContext);
        final XDebugSession xDebugSession = (XDebugSession)XDebugSession.DATA_KEY.getData(dataContext);
        if (stackFrameDescriptorImpl != null && xDebugSession != null) {
            final StackFrameProxyImpl stackFrameProxyImpl = stackFrameDescriptorImpl.getFrameProxy();
            final DebugProcessImpl debugProcessImpl = (DebugProcessImpl)stackFrameDescriptorImpl.getDebugProcess();
            debugProcessImpl.getManagerThread().schedule(new SuspendContextCommandImpl((SuspendContextImpl)xDebugSession.getSuspendContext()){

                @Override
                public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                    try {
                        if (suspendContextImpl == null) {
                            1.b(0);
                        }
                    }
                    catch (Exception exception) {
                        throw 1.c(exception);
                    }
                    ThreadReferenceProxyImpl threadReferenceProxyImpl = stackFrameProxyImpl.threadProxy();
                    SuspendContextImpl suspendContextImpl2 = SuspendManagerUtil.findContextByThread(debugProcessImpl.getSuspendManager(), threadReferenceProxyImpl);
                    JavaExecutionStack javaExecutionStack = new JavaExecutionStack(threadReferenceProxyImpl, debugProcessImpl, Objects.equals(suspendContextImpl2.getThread(), threadReferenceProxyImpl));
                    javaExecutionStack.initTopFrame();
                    XStackFrame xStackFrame = javaExecutionStack.createStackFrame(stackFrameProxyImpl);
                    DebuggerUIUtil.invokeLater(() -> xDebugSession.setCurrentStackFrame((XExecutionStack)javaExecutionStack, xStackFrame));
                }

                private static /* synthetic */ void b(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/GotoFrameSourceAction$1", "contextAction"));
                }

                private static Exception c(Exception exception) {
                    return exception;
                }
            });
        }
    }

    public void update(AnActionEvent anActionEvent) {
        anActionEvent.getPresentation().setVisible(GotoFrameSourceAction.a(anActionEvent.getDataContext()) != null);
    }

    private static StackFrameDescriptorImpl a(DataContext dataContext) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = GotoFrameSourceAction.getSelectedNode(dataContext);
        if (debuggerTreeNodeImpl == null) {
            return null;
        }
        if (debuggerTreeNodeImpl.getDescriptor() == null || !(debuggerTreeNodeImpl.getDescriptor() instanceof StackFrameDescriptorImpl)) {
            return null;
        }
        return (StackFrameDescriptorImpl)debuggerTreeNodeImpl.getDescriptor();
    }
}

