/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.ui.HotSwapUI;
import com.intellij.debugger.ui.HotSwapUIImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;

public class HotSwapAction
extends AnAction {
    public void actionPerformed(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(project2);
        DebuggerSession debuggerSession = debuggerManagerEx.getContext().getDebuggerSession();
        if (debuggerSession != null && debuggerSession.isAttached()) {
            HotSwapUI.getInstance(project2).reloadChangedClasses(debuggerSession, DebuggerSettings.getInstance().COMPILE_BEFORE_HOTSWAP);
        }
    }

    public void update(AnActionEvent anActionEvent) {
        Project project2 = anActionEvent.getProject();
        if (project2 == null) {
            anActionEvent.getPresentation().setEnabled(false);
            return;
        }
        DebuggerManagerEx debuggerManagerEx = DebuggerManagerEx.getInstanceEx(project2);
        DebuggerSession debuggerSession = debuggerManagerEx.getContext().getDebuggerSession();
        anActionEvent.getPresentation().setEnabled(debuggerSession != null && HotSwapUIImpl.canHotSwap(debuggerSession));
    }
}

