/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.MethodBytecodeUtil;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.ArrayType;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassType;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.Type;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JumpToObjectAction
extends DebuggerAction {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.actions.JumpToObjectAction");

    public void actionPerformed(AnActionEvent anActionEvent) {
        DebuggerTreeNodeImpl debuggerTreeNodeImpl = JumpToObjectAction.getSelectedNode(anActionEvent.getDataContext());
        try {
            if (debuggerTreeNodeImpl == null) {
                return;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw JumpToObjectAction.b(classNotPreparedException);
        }
        NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
        try {
            if (!(nodeDescriptorImpl instanceof ValueDescriptor)) {
                return;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw JumpToObjectAction.b(classNotPreparedException);
        }
        DebuggerContextImpl debuggerContextImpl = JumpToObjectAction.getDebuggerContext(anActionEvent.getDataContext());
        DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
        try {
            if (debugProcessImpl == null) {
                return;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw JumpToObjectAction.b(classNotPreparedException);
        }
        debugProcessImpl.getManagerThread().schedule(new NavigateCommand(debuggerContextImpl, (ValueDescriptor)((Object)nodeDescriptorImpl), debugProcessImpl, anActionEvent));
    }

    public void update(AnActionEvent anActionEvent) {
        block12: {
            block11: {
                try {
                    if (!JumpToObjectAction.isFirstStart(anActionEvent)) {
                        return;
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw JumpToObjectAction.b(classNotPreparedException);
                }
                DebuggerContextImpl debuggerContextImpl = JumpToObjectAction.getDebuggerContext(anActionEvent.getDataContext());
                DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
                try {
                    if (debugProcessImpl == null) {
                        anActionEvent.getPresentation().setVisible(false);
                        return;
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw JumpToObjectAction.b(classNotPreparedException);
                }
                DebuggerTreeNodeImpl debuggerTreeNodeImpl = JumpToObjectAction.getSelectedNode(anActionEvent.getDataContext());
                try {
                    if (debuggerTreeNodeImpl == null) {
                        anActionEvent.getPresentation().setVisible(false);
                        return;
                    }
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw JumpToObjectAction.b(classNotPreparedException);
                }
                NodeDescriptorImpl nodeDescriptorImpl = debuggerTreeNodeImpl.getDescriptor();
                try {
                    if (!(nodeDescriptorImpl instanceof ValueDescriptor)) break block11;
                    debugProcessImpl.getManagerThread().schedule(new EnableCommand(debuggerContextImpl, (ValueDescriptor)((Object)nodeDescriptorImpl), debugProcessImpl, anActionEvent));
                    break block12;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw JumpToObjectAction.b(classNotPreparedException);
                }
            }
            anActionEvent.getPresentation().setVisible(false);
        }
    }

    private static SourcePosition a(ValueDescriptor valueDescriptor, DebugProcessImpl debugProcessImpl) throws ClassNotLoadedException {
        Type type = valueDescriptor.getType();
        try {
            if (type == null) {
                return null;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw JumpToObjectAction.b(classNotPreparedException);
        }
        try {
            if (type instanceof ArrayType) {
                type = ((ArrayType)type).componentType();
            }
            if (type instanceof ClassType) {
                Location location;
                ClassType classType = (ClassType)type;
                Method method = MethodBytecodeUtil.getLambdaMethod(classType, debugProcessImpl.getVirtualMachineProxy().getClassesByNameProvider());
                try {
                    Location location2 = location = method != null ? (Location)ContainerUtil.getFirstItem(DebuggerUtilsEx.allLineLocations(method)) : null;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw JumpToObjectAction.b(classNotPreparedException);
                }
                if (location == null) {
                    location = (Location)ContainerUtil.getFirstItem(classType.allLineLocations());
                }
                if (location != null) {
                    SourcePosition sourcePosition = debugProcessImpl.getPositionManager().getSourcePosition(location);
                    return (SourcePosition)ReadAction.compute(() -> {
                        PsiClass psiClass;
                        if (classType.name().indexOf(36) < 0 && (psiClass = JVMNameUtil.getClassAt(sourcePosition)) != null) {
                            SourcePosition sourcePosition2 = SourcePosition.createFromElement((PsiElement)psiClass);
                            try {
                                if (sourcePosition2 != null) {
                                    return sourcePosition2;
                                }
                            }
                            catch (RuntimeException runtimeException) {
                                throw JumpToObjectAction.b(runtimeException);
                            }
                        }
                        return sourcePosition;
                    });
                }
            }
        }
        catch (AbsentInformationException | ClassNotPreparedException exception) {
            b.debug((Throwable)exception);
        }
        return null;
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    public static abstract class SourcePositionCommand
    extends SuspendContextCommandImpl {
        protected final DebuggerContextImpl myDebuggerContext;
        protected final ValueDescriptor myDescriptor;
        protected final DebugProcessImpl myDebugProcess;
        protected final AnActionEvent myActionEvent;

        public SourcePositionCommand(DebuggerContextImpl debuggerContextImpl, ValueDescriptor valueDescriptor, DebugProcessImpl debugProcessImpl, AnActionEvent anActionEvent) {
            super(debuggerContextImpl.getSuspendContext());
            this.myDebuggerContext = debuggerContextImpl;
            this.myDescriptor = valueDescriptor;
            this.myDebugProcess = debugProcessImpl;
            this.myActionEvent = anActionEvent;
        }

        @Override
        public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
            try {
                if (suspendContextImpl == null) {
                    SourcePositionCommand.b(0);
                }
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                throw SourcePositionCommand.b(classNotLoadedException);
            }
            try {
                this.doAction(JumpToObjectAction.a(this.myDescriptor, this.myDebugProcess));
            }
            catch (ClassNotLoadedException classNotLoadedException) {
                String string = classNotLoadedException.className();
                try {
                    if (this.a(string) != null) {
                        this.myDebugProcess.getManagerThread().schedule(this.createRetryCommand());
                    }
                }
                catch (ClassNotLoadedException classNotLoadedException2) {
                    throw SourcePositionCommand.b(classNotLoadedException2);
                }
            }
        }

        protected abstract SourcePositionCommand createRetryCommand();

        protected abstract void doAction(@Nullable SourcePosition var1);

        private ReferenceType a(String string) {
            EvaluationContextImpl evaluationContextImpl = this.myDebuggerContext.createEvaluationContext();
            try {
                return this.myDebugProcess.loadClass(evaluationContextImpl, string, evaluationContextImpl.getClassLoader());
            }
            catch (Throwable throwable) {
                return null;
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/actions/JumpToObjectAction$SourcePositionCommand", "contextAction"));
        }

        private static ClassNotLoadedException b(ClassNotLoadedException classNotLoadedException) {
            return classNotLoadedException;
        }
    }

    private static class EnableCommand
    extends SourcePositionCommand {
        public EnableCommand(DebuggerContextImpl debuggerContextImpl, ValueDescriptor valueDescriptor, DebugProcessImpl debugProcessImpl, AnActionEvent anActionEvent) {
            super(debuggerContextImpl, valueDescriptor, debugProcessImpl, anActionEvent);
        }

        @Override
        protected EnableCommand createRetryCommand() {
            return new EnableCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            DebuggerAction.enableAction(this.myActionEvent, sourcePosition != null);
        }
    }

    public static class NavigateCommand
    extends SourcePositionCommand {
        public NavigateCommand(DebuggerContextImpl debuggerContextImpl, ValueDescriptor valueDescriptor, DebugProcessImpl debugProcessImpl, AnActionEvent anActionEvent) {
            super(debuggerContextImpl, valueDescriptor, debugProcessImpl, anActionEvent);
        }

        @Override
        protected NavigateCommand createRetryCommand() {
            return new NavigateCommand(this.myDebuggerContext, this.myDescriptor, this.myDebugProcess, this.myActionEvent);
        }

        @Override
        protected void doAction(SourcePosition sourcePosition) {
            if (sourcePosition != null) {
                sourcePosition.navigate(true);
            }
        }
    }
}

