/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.actions;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.project.Project;
import com.intellij.unscramble.ThreadDumpParser;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.BooleanValue;
import com.sun.jdi.Field;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.Location;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadReference;
import gnu.trove.TIntObjectHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

public class ThreadDumpAction
extends AnAction
implements AnAction.TransparentUpdate {
    public void actionPerformed(AnActionEvent anActionEvent) {
        block5: {
            final Project project2 = anActionEvent.getProject();
            try {
                if (project2 == null) {
                    return;
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw ThreadDumpAction.b(invalidStackFrameException);
            }
            DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
            final DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            try {
                if (debuggerSession == null || !debuggerSession.isAttached()) break block5;
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw ThreadDumpAction.b(invalidStackFrameException);
            }
            final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
            debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                    virtualMachineProxyImpl.suspend();
                    try {
                        List<ThreadState> list = ThreadDumpAction.buildThreadStates(virtualMachineProxyImpl);
                        ApplicationManager.getApplication().invokeLater(() -> {
                            XDebugSession xDebugSession = debuggerSession.getXDebugSession();
                            if (xDebugSession != null) {
                                DebuggerUtilsEx.addThreadDump(project2, list, xDebugSession.getUI(), debuggerSession);
                            }
                        }, ModalityState.NON_MODAL);
                    }
                    finally {
                        virtualMachineProxyImpl.resume();
                    }
                }
            });
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    public static List<ThreadState> buildThreadStates(VirtualMachineProxyImpl virtualMachineProxyImpl) {
        Object object;
        List<ThreadReference> list = virtualMachineProxyImpl.getVirtualMachine().allThreads();
        ArrayList<ThreadState> arrayList = new ArrayList<ThreadState>();
        HashMap<String, ThreadState> hashMap = new HashMap<String, ThreadState>();
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        for (Object object2 : list) {
            Object object3;
            Object object4;
            Object object5;
            Object object6;
            ThreadState threadState;
            String string;
            boolean bl2;
            block52: {
                ReferenceType referenceType;
                block50: {
                    object = new StringBuilder();
                    bl2 = true;
                    int n2 = object2.status();
                    try {
                        if (n2 == 0) {
                            continue;
                        }
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                    string = ThreadDumpAction.a((ThreadReference)object2);
                    threadState = new ThreadState(string, ThreadDumpAction.b(n2));
                    hashMap.put(string, threadState);
                    arrayList.add(threadState);
                    threadState.setJavaThreadState(ThreadDumpAction.a(n2));
                    ((StringBuilder)object).append("\"").append(string).append("\"");
                    referenceType = object2.referenceType();
                    if (referenceType == null) break block52;
                    object6 = referenceType.fieldByName("daemon");
                    if (object6 == null) break block50;
                    object5 = object2.getValue((Field)object6);
                    if (!(object5 instanceof BooleanValue)) break block50;
                    try {
                        block53: {
                            if (!((BooleanValue)object5).booleanValue()) break block50;
                            break block53;
                            catch (InvalidStackFrameException invalidStackFrameException) {
                                throw ThreadDumpAction.b(invalidStackFrameException);
                            }
                        }
                        ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.daemon", (Object[])new Object[0]));
                        threadState.setDaemon(true);
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                }
                if ((object5 = referenceType.fieldByName("priority")) != null) {
                    object4 = object2.getValue((Field)object5);
                    try {
                        if (object4 instanceof IntegerValue) {
                            ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.priority", (Object[])new Object[]{((IntegerValue)object4).intValue()}));
                        }
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                }
                if ((object4 = referenceType.fieldByName("tid")) != null) {
                    object3 = object2.getValue((Field)object4);
                    try {
                        if (object3 instanceof LongValue) {
                            ((StringBuilder)object).append(" ").append(DebuggerBundle.message((String)"threads.export.attribute.label.tid", (Object[])new Object[]{Long.toHexString(((LongValue)object3).longValue())}));
                            ((StringBuilder)object).append(" nid=NA");
                        }
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                }
            }
            object6 = threadState.getState();
            try {
                if (object6 != null) {
                    ((StringBuilder)object).append(" ").append((String)object6);
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw ThreadDumpAction.b(invalidStackFrameException);
            }
            ((StringBuilder)object).append("\n  java.lang.Thread.State: ").append(threadState.getJavaThreadState());
            try {
                boolean bl3;
                Object object7;
                block51: {
                    ObjectReference objectReference;
                    if (virtualMachineProxyImpl.canGetOwnedMonitorInfo() && virtualMachineProxyImpl.canGetMonitorInfo()) {
                        object5 = object2.ownedMonitors();
                        object4 = object5.iterator();
                        while (object4.hasNext()) {
                            object3 = (ObjectReference)object4.next();
                            try {
                                if (!virtualMachineProxyImpl.canGetMonitorFrameInfo()) {
                                    ((StringBuilder)object).append("\n\t ").append(ThreadDumpAction.a((ObjectReference)object3));
                                }
                            }
                            catch (InvalidStackFrameException invalidStackFrameException) {
                                throw ThreadDumpAction.b(invalidStackFrameException);
                            }
                            List<ThreadReference> list2 = object3.waitingThreads();
                            Object object8 = list2.iterator();
                            while (object8.hasNext()) {
                                ThreadReference threadReference = object8.next();
                                object7 = ThreadDumpAction.a(threadReference);
                                hashMap2.put((String)object7, string);
                                ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.blocks.thread", (Object[])new Object[]{object7}));
                            }
                        }
                    }
                    try {
                        objectReference = virtualMachineProxyImpl.canGetCurrentContendedMonitor() ? object2.currentContendedMonitor() : null;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                    object5 = objectReference;
                    try {
                        if (object5 == null || !virtualMachineProxyImpl.canGetMonitorInfo()) break block51;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                    object4 = object5.owningThread();
                    if (object4 != null) {
                        object3 = ThreadDumpAction.a((ThreadReference)object4);
                        hashMap2.put(string, object3);
                        ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.label.waiting.for.thread", (Object[])new Object[]{object3, ThreadDumpAction.renderObject((ObjectReference)object5)}));
                    }
                }
                object4 = object2.frames();
                try {
                    bl3 = object4.size() == 0;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw ThreadDumpAction.b(invalidStackFrameException);
                }
                bl2 = bl3;
                object3 = new TIntObjectHashMap();
                if (virtualMachineProxyImpl.canGetMonitorFrameInfo()) {
                    for (Object object8 : object2.ownedMonitorsAndFrames()) {
                        int n3 = object8.stackDepth();
                        object7 = (List)object3.get(n3);
                        if (object7 == null) {
                            object7 = new SmartList();
                            object3.put(n3, object7);
                        }
                        object7.add(object8.monitor());
                    }
                }
                int n4 = object4.size();
                for (int i2 = 0; i2 < n4; ++i2) {
                    StackFrame stackFrame = (StackFrame)object4.get(i2);
                    try {
                        object7 = stackFrame.location();
                        ((StringBuilder)object).append("\n\t  ").append(ThreadDumpAction.renderLocation((Location)object7));
                        List list3 = (List)object3.get(i2);
                        if (list3 == null) continue;
                        for (ObjectReference objectReference : list3) {
                            ((StringBuilder)object).append("\n\t  - ").append(ThreadDumpAction.a(objectReference));
                        }
                        continue;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        ((StringBuilder)object).append("\n\t  Invalid stack frame: ").append(invalidStackFrameException.getMessage());
                    }
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                ((StringBuilder)object).append("\n\t ").append(DebuggerBundle.message((String)"threads.export.attribute.error.incompatible.state", (Object[])new Object[0]));
            }
            threadState.setStackTrace(((StringBuilder)object).toString(), bl2);
            ThreadDumpParser.inferThreadStateDetail((ThreadState)threadState);
        }
        for (Object object2 : hashMap2.keySet()) {
            object = (ThreadState)hashMap.get(object2);
            ThreadState threadState = (ThreadState)hashMap.get(hashMap2.get(object2));
            try {
                try {
                    if (object == null || threadState == null) continue;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw ThreadDumpAction.b(invalidStackFrameException);
                }
                threadState.addWaitingThread((ThreadState)object);
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw ThreadDumpAction.b(invalidStackFrameException);
            }
        }
        for (Object object2 : arrayList) {
            for (ThreadState threadState : object2.getAwaitingThreads()) {
                try {
                    if (!threadState.isAwaitedBy((ThreadState)object2)) continue;
                    object2.addDeadlockedThread(threadState);
                    threadState.addDeadlockedThread((ThreadState)object2);
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw ThreadDumpAction.b(invalidStackFrameException);
                }
            }
        }
        ThreadDumpParser.sortThreads(arrayList);
        return arrayList;
    }

    private static String a(ObjectReference objectReference) {
        return DebuggerBundle.message((String)"threads.export.attribute.label.locked", (Object[])new Object[]{ThreadDumpAction.renderObject(objectReference)});
    }

    public static String renderObject(ObjectReference objectReference) {
        String string;
        try {
            string = objectReference.referenceType().name();
        }
        catch (Throwable throwable) {
            string = "Error getting object type: '" + throwable.getMessage() + "'";
        }
        return DebuggerBundle.message((String)"threads.export.attribute.label.object-id", (Object[])new Object[]{Long.toHexString(objectReference.uniqueID()), string});
    }

    /*
     * Exception decompiling
     */
    private static String a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Exception decompiling
     */
    private static String b(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static String renderLocation(Location location) {
        return DebuggerBundle.message((String)"export.threads.stackframe.format", (Object[])new Object[]{DebuggerUtilsEx.getLocationMethodQName(location), DebuggerUtilsEx.getSourceName(location, throwable -> "Unknown Source"), DebuggerUtilsEx.getLineNumber(location, false)});
    }

    private static String a(ThreadReference threadReference) {
        return threadReference.name() + "@" + threadReference.uniqueID();
    }

    public void update(AnActionEvent anActionEvent) {
        boolean bl2;
        Presentation presentation;
        block8: {
            block7: {
                Presentation presentation2 = anActionEvent.getPresentation();
                Project project2 = anActionEvent.getProject();
                try {
                    if (project2 == null) {
                        presentation2.setEnabled(false);
                        return;
                    }
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw ThreadDumpAction.b(invalidStackFrameException);
                }
                DebuggerSession debuggerSession = DebuggerManagerEx.getInstanceEx(project2).getContext().getDebuggerSession();
                try {
                    try {
                        presentation = presentation2;
                        if (debuggerSession == null || !debuggerSession.isAttached()) break block7;
                    }
                    catch (InvalidStackFrameException invalidStackFrameException) {
                        throw ThreadDumpAction.b(invalidStackFrameException);
                    }
                    bl2 = true;
                    break block8;
                }
                catch (InvalidStackFrameException invalidStackFrameException) {
                    throw ThreadDumpAction.b(invalidStackFrameException);
                }
            }
            bl2 = false;
        }
        presentation.setEnabled(bl2);
    }

    private static InvalidStackFrameException b(InvalidStackFrameException invalidStackFrameException) {
        return invalidStackFrameException;
    }
}

