/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.codeinsight;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.EvaluatingComputable;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.ui.EditorEvaluationCommand;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiType;
import com.sun.jdi.ClassType;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.Type;
import com.sun.jdi.Value;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class RuntimeTypeEvaluator
extends EditorEvaluationCommand<PsiType> {
    public RuntimeTypeEvaluator(@Nullable Editor editor, PsiElement psiElement, DebuggerContextImpl debuggerContextImpl, ProgressIndicator progressIndicator) {
        super(editor, psiElement, debuggerContextImpl, progressIndicator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
        try {
            if (suspendContextImpl == null) {
                RuntimeTypeEvaluator.c(0);
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
        }
        PsiType psiType = null;
        try {
            psiType = (PsiType)this.evaluate();
        }
        catch (EvaluateException | ProcessCanceledException throwable) {
        }
        finally {
            this.typeCalculationFinished(psiType);
        }
    }

    protected abstract void typeCalculationFinished(@Nullable PsiType var1);

    @Override
    @Nullable
    protected PsiType evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
        Project project2 = evaluationContextImpl.getProject();
        final SourcePosition sourcePosition = ContextUtil.getSourcePosition((StackFrameContext)evaluationContextImpl);
        ExpressionEvaluator expressionEvaluator = DebuggerInvocationUtil.commitAndRunReadAction(project2, new EvaluatingComputable<ExpressionEvaluator>(){

            @Override
            public ExpressionEvaluator compute() throws EvaluateException {
                return EvaluatorBuilderImpl.getInstance().build(RuntimeTypeEvaluator.this.myElement, sourcePosition);
            }
        });
        Value value = expressionEvaluator.evaluate((EvaluationContext)evaluationContextImpl);
        try {
            if (value != null) {
                return RuntimeTypeEvaluator.getCastableRuntimeType(project2, value);
            }
        }
        catch (EvaluateException evaluateException) {
            throw RuntimeTypeEvaluator.d((Exception)((Object)evaluateException));
        }
        throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.surrounded.expression.null", (Object[])new Object[0]));
    }

    @Nullable
    public static PsiType getCastableRuntimeType(Project project2, Value value) {
        Type type = value.type();
        PsiType psiType = RuntimeTypeEvaluator.a(project2, type);
        try {
            if (psiType != null) {
                return psiType;
            }
        }
        catch (ProcessCanceledException processCanceledException) {
            throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
        }
        if (type instanceof ClassType) {
            block12: {
                ClassType classType = ((ClassType)type).superclass();
                try {
                    if (classType == null || "java.lang.Object".equals(classType.name())) break block12;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
                }
                psiType = RuntimeTypeEvaluator.a(project2, classType);
                try {
                    if (psiType != null) {
                        return psiType;
                    }
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
                }
            }
            for (InterfaceType interfaceType : ((ClassType)type).interfaces()) {
                psiType = RuntimeTypeEvaluator.a(project2, interfaceType);
                try {
                    if (psiType == null) continue;
                    return psiType;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
                }
            }
        }
        return null;
    }

    private static PsiType a(Project project2, Type type) {
        return (PsiType)ReadAction.compute(() -> DebuggerUtils.getType((String)type.name().replace('$', '.'), (Project)project2));
    }

    public static boolean isSubtypeable(PsiExpression psiExpression) {
        block8: {
            PsiType psiType = psiExpression.getType();
            try {
                if (psiType instanceof PsiPrimitiveType) {
                    return false;
                }
            }
            catch (ProcessCanceledException processCanceledException) {
                throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
            }
            if (psiType instanceof PsiClassType) {
                PsiClass psiClass = ((PsiClassType)psiType).resolve();
                try {
                    try {
                        if (psiClass == null || !psiClass.hasModifierProperty("final")) break block8;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
                    }
                    return false;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw RuntimeTypeEvaluator.d((Exception)((Object)processCanceledException));
                }
            }
        }
        return true;
    }

    private static /* synthetic */ void c(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/codeinsight/RuntimeTypeEvaluator", "threadAction"));
    }

    private static Exception d(Exception exception) {
        return exception;
    }
}

