/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.Patches;
import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.PositionManager;
import com.intellij.debugger.actions.DebuggerAction;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.CompoundPositionManager;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessListener;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.PositionManagerImpl;
import com.intellij.debugger.engine.RequestHint;
import com.intellij.debugger.engine.SuspendContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManager;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.SuspendManagerUtil;
import com.intellij.debugger.engine.ThreadBlockedMonitor;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.engine.requests.MethodReturnValueWatcher;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.DebuggerUtilsImpl;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.jdi.EmptyConnectorArgument;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.settings.DebuggerSettings;
import com.intellij.debugger.settings.NodeRendererSettings;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.execution.CantRunException;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.NotificationGroup;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkType;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.impl.status.StatusBarUtil;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.ui.classFilter.DebuggerClassFilterProvider;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EventDispatcher;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashMap;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.ArrayType;
import com.sun.jdi.Bootstrap;
import com.sun.jdi.ClassLoaderReference;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassNotPreparedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.VirtualMachineManager;
import com.sun.jdi.connect.AttachingConnector;
import com.sun.jdi.connect.Connector;
import com.sun.jdi.connect.IllegalConnectorArgumentsException;
import com.sun.jdi.connect.ListeningConnector;
import com.sun.jdi.connect.VMStartException;
import com.sun.jdi.request.StepRequest;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventListener;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class DebugProcessImpl
extends UserDataHolderBase
implements DebugProcess {
    private static final Logger u = Logger.getInstance((String)"#com.intellij.debugger.engine.DebugProcessImpl");
    @NonNls
    private static final String e = "com.sun.jdi.SocketAttach";
    @NonNls
    private static final String c = "com.sun.jdi.SharedMemoryAttach";
    @NonNls
    private static final String k = "com.sun.jdi.SocketListen";
    @NonNls
    private static final String d = "com.sun.jdi.SharedMemoryListen";
    private final Project m;
    private final RequestManagerImpl h;
    private volatile VirtualMachineProxyImpl p = null;
    protected final EventDispatcher<DebugProcessListener> myDebugProcessDispatcher = EventDispatcher.create(DebugProcessListener.class);
    protected final EventDispatcher<EvaluationListener> myEvaluationDispatcher = EventDispatcher.create(EvaluationListener.class);
    private final List<ProcessListener> q = ContainerUtil.createLockFreeCopyOnWriteList();
    protected final AtomicReference<State> myState = new AtomicReference<State>(State.INITIAL);
    private volatile ExecutionResult f;
    private RemoteConnection j;
    private JavaDebugProcess i;
    private volatile Map<String, Connector.Argument> n;
    private final List<NodeRenderer> a = new ArrayList<NodeRenderer>();
    private final Map<Type, NodeRenderer> w = new HashMap();
    private final SuspendManagerImpl v = new SuspendManagerImpl(this);
    protected CompoundPositionManager myPositionManager = CompoundPositionManager.EMPTY;
    private final DebuggerManagerThreadImpl o;
    private final Semaphore l = new Semaphore();
    private final AtomicBoolean x = new AtomicBoolean(false);
    private final AtomicBoolean s = new AtomicBoolean(false);
    protected DebuggerSession mySession;
    @Nullable
    protected MethodReturnValueWatcher myReturnValueWatcher;
    protected final Disposable myDisposable = Disposer.newDisposable();
    private final Alarm t = new Alarm();
    private final ThreadBlockedMonitor r = new ThreadBlockedMonitor(this, this.myDisposable);
    private static final int g;
    private volatile RunToCursorBreakpoint b;

    protected DebugProcessImpl(Project project2) {
        this.m = project2;
        this.o = new DebuggerManagerThreadImpl(this.myDisposable, this.m);
        this.h = new RequestManagerImpl(this);
        NodeRendererSettings.getInstance().addListener(this::b, this.myDisposable);
        this.b();
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void paused(SuspendContext suspendContext) {
                DebugProcessImpl.this.r.stopWatching(suspendContext.getSuspendPolicy() != 2 ? suspendContext.getThread() : null);
            }
        });
    }

    private void b() {
        this.getManagerThread().invoke(new DebuggerCommandImpl(){

            @Override
            public PrioritizedTask.Priority getPriority() {
                return PrioritizedTask.Priority.HIGH;
            }

            @Override
            protected void action() throws Exception {
                DebugProcessImpl.this.w.clear();
                DebugProcessImpl.this.a.clear();
                try {
                    NodeRendererSettings.getInstance().getAllRenderers().stream().filter(NodeRenderer::isEnabled).forEachOrdered(DebugProcessImpl.this.a::add);
                }
                finally {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.m, () -> {
                        DebuggerSession debuggerSession = DebugProcessImpl.this.mySession;
                        if (debuggerSession != null && debuggerSession.isAttached()) {
                            DebuggerAction.refreshViews(DebugProcessImpl.this.mySession.getXDebugSession());
                        }
                    });
                }
            }
        });
    }

    @Nullable
    public Pair<Method, Value> getLastExecutedMethod() {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        try {
            if (methodReturnValueWatcher == null) {
                return null;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        Method method = methodReturnValueWatcher.getLastExecutedMethod();
        try {
            if (method == null) {
                return null;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return Pair.create((Object)method, (Object)methodReturnValueWatcher.getLastMethodReturnValue());
    }

    public void setWatchMethodReturnValuesEnabled(boolean bl2) {
        MethodReturnValueWatcher methodReturnValueWatcher = this.myReturnValueWatcher;
        try {
            if (methodReturnValueWatcher != null) {
                methodReturnValueWatcher.setEnabled(bl2);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
    }

    public boolean canGetMethodReturnValue() {
        boolean bl2;
        try {
            bl2 = this.myReturnValueWatcher != null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return bl2;
    }

    public NodeRenderer getAutoRenderer(ValueDescriptor valueDescriptor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Type type = valueDescriptor.getType();
        try {
            if (!DebuggerManagerEx.getInstanceEx(this.getProject()).getContext().isEvaluationPossible()) {
                return DebugProcessImpl.getDefaultRenderer(type);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            return this.w.computeIfAbsent(type, type2 -> this.a.stream().filter(nodeRenderer -> DebuggerUtilsImpl.suppressExceptions(() -> nodeRenderer.isApplicable(type), false, true, ClassNotPreparedException.class)).findFirst().orElseGet(() -> DebugProcessImpl.getDefaultRenderer(type)));
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            u.info((Throwable)classNotPreparedException);
            return DebugProcessImpl.getDefaultRenderer(type);
        }
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Value value) {
        NodeRenderer nodeRenderer;
        Type type;
        try {
            type = value != null ? value.type() : null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            nodeRenderer = DebugProcessImpl.getDefaultRenderer(type);
            if (nodeRenderer == null) {
                DebugProcessImpl.a(0);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return nodeRenderer;
    }

    @NotNull
    public static NodeRenderer getDefaultRenderer(Type type) {
        ClassRenderer classRenderer;
        NodeRendererSettings nodeRendererSettings;
        block13: {
            ArrayRenderer arrayRenderer;
            block14: {
                block11: {
                    PrimitiveRenderer primitiveRenderer;
                    block12: {
                        nodeRendererSettings = NodeRendererSettings.getInstance();
                        PrimitiveRenderer primitiveRenderer2 = nodeRendererSettings.getPrimitiveRenderer();
                        try {
                            try {
                                if (!primitiveRenderer2.isApplicable(type)) break block11;
                                primitiveRenderer = primitiveRenderer2;
                                if (primitiveRenderer != null) break block12;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw DebugProcessImpl.b(classNotPreparedException);
                            }
                            DebugProcessImpl.a(1);
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw DebugProcessImpl.b(classNotPreparedException);
                        }
                    }
                    return primitiveRenderer;
                }
                ArrayRenderer arrayRenderer2 = nodeRendererSettings.getArrayRenderer();
                try {
                    try {
                        if (!arrayRenderer2.isApplicable(type)) break block13;
                        arrayRenderer = arrayRenderer2;
                        if (arrayRenderer != null) break block14;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    DebugProcessImpl.a(2);
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            return arrayRenderer;
        }
        ClassRenderer classRenderer2 = nodeRendererSettings.getClassRenderer();
        try {
            u.assertTrue(classRenderer2.isApplicable(type), (Object)type.name());
            classRenderer = classRenderer2;
            if (classRenderer == null) {
                DebugProcessImpl.a(3);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return classRenderer;
    }

    protected void commitVM(VirtualMachine virtualMachine) {
        try {
            if (!this.isInInitialState()) {
                u.error("State is invalid " + (Object)((Object)this.myState.get()));
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager = new CompoundPositionManager(new PositionManagerImpl(this));
        u.debug("*******************VM attached******************");
        this.a(virtualMachine);
        this.p = new VirtualMachineProxyImpl(this, virtualMachine);
        virtualMachine.setDebugTraceMode(g);
    }

    private void c() {
        Map<String, Connector.Argument> map = this.n;
        try {
            if (map == null) {
                return;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            try {
                if (this.j.isServerMode()) {
                    ((ListeningConnector)DebugProcessImpl.b("com.sun.jdi.SocketListen")).stopListening(map);
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
        }
        catch (IllegalConnectorArgumentsException | IOException exception) {
            u.debug((Throwable)exception);
        }
        catch (ExecutionException executionException) {
            u.error((Throwable)executionException);
        }
    }

    public void printToConsole(String string) {
        this.f.getProcessHandler().notifyTextAvailable(string, ProcessOutputTypes.SYSTEM);
    }

    public ProcessHandler getProcessHandler() {
        ProcessHandler processHandler;
        try {
            processHandler = this.f != null ? this.f.getProcessHandler() : null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return processHandler;
    }

    /*
     * Unable to fully structure code
     */
    protected void doStep(SuspendContextImpl var1_1, ThreadReferenceProxyImpl var2_2, int var3_3, int var4_4, RequestHint var5_5) {
        try {
            if (var2_2 == null) {
                return;
            }
        }
        catch (ObjectCollectedException v0) {
            throw DebugProcessImpl.b(v0);
        }
        try {
            block17: {
                var6_6 = var2_2.getThreadReference();
                try {
                    if (DebugProcessImpl.u.isDebugEnabled()) {
                        DebugProcessImpl.u.debug("DO_STEP: creating step request for " + var6_6);
                    }
                }
                catch (ObjectCollectedException v1) {
                    throw DebugProcessImpl.b(v1);
                }
                this.deleteStepRequests(var6_6);
                var7_8 = this.getVirtualMachineProxy().eventRequestManager();
                var8_9 = var7_8.createStepRequest(var6_6, var3_3, var4_4);
                if (var5_5 == null) ** GOTO lbl25
                try {
                    block18: {
                        if (var5_5.isIgnoreFilters()) break block17;
                        break block18;
                        catch (ObjectCollectedException v2) {
                            throw DebugProcessImpl.b(v2);
                        }
                    }
                    this.checkPositionNotFiltered(var2_2, (Consumer<List<ClassFilter>>)(Consumer)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, a(com.sun.jdi.request.StepRequest java.util.List ), (Ljava/util/List;)V)((StepRequest)var8_9));
                }
                catch (ObjectCollectedException v3) {
                    throw DebugProcessImpl.b(v3);
                }
            }
            try {
                v4 = var8_9;
                v5 = var1_1.getSuspendPolicy() == 1 ? 1 : 2;
            }
            catch (ObjectCollectedException v6) {
                throw DebugProcessImpl.b(v6);
            }
            try {
                v4.setSuspendPolicy(v5);
                var8_9.addCountFilter(1);
                if (var5_5 != null) {
                    var8_9.putProperty("hint", var5_5);
                }
            }
            catch (ObjectCollectedException v7) {
                throw DebugProcessImpl.b(v7);
            }
            var8_9.enable();
        }
        catch (ObjectCollectedException var6_7) {
            // empty catch block
        }
    }

    public void checkPositionNotFiltered(ThreadReferenceProxyImpl threadReferenceProxyImpl, Consumer<List<ClassFilter>> consumer) {
        block5: {
            List<ClassFilter> list = DebugProcessImpl.f();
            if (!list.isEmpty()) {
                String string = DebugProcessImpl.getCurrentClassName(threadReferenceProxyImpl);
                try {
                    try {
                        if (string != null && DebuggerUtilsEx.isFiltered(string, list)) break block5;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    consumer.consume(list);
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
        }
    }

    @NotNull
    private static List<ClassFilter> f() {
        List list;
        DebuggerSettings debuggerSettings = DebuggerSettings.getInstance();
        StreamEx streamEx = StreamEx.of((Object[])Extensions.getExtensions((ExtensionPointName)DebuggerClassFilterProvider.EP_NAME)).flatCollection(DebuggerClassFilterProvider::getFilters);
        if (debuggerSettings.TRACING_FILTERS_ENABLED) {
            streamEx = streamEx.prepend((Object[])debuggerSettings.getSteppingFilters());
        }
        try {
            list = ((StreamEx)streamEx.filter(ClassFilter::isEnabled)).toList();
            if (list == null) {
                DebugProcessImpl.a(4);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    void deleteStepRequests(@Nullable ThreadReference var1_1) {
        block10: {
            var2_2 = this.getVirtualMachineProxy().eventRequestManager();
            var3_3 = var2_2.stepRequests();
            if (var3_3.isEmpty()) break block10;
            var4_4 = new ArrayList<StepRequest>(var3_3.size());
            for (StepRequest var6_6 : var3_3) {
                var7_7 = var6_6.thread();
                try {
                    block11: {
                        if (var7_7.status() == -1) continue;
                        if (var1_1 == null) ** GOTO lbl21
                        break block11;
                        catch (IllegalThreadStateException v0) {
                            throw DebugProcessImpl.b(v0);
                        }
                    }
                    try {
                        block12: {
                            if (!var1_1.equals(var7_7)) continue;
                            break block12;
                            catch (IllegalThreadStateException v1) {
                                throw DebugProcessImpl.b(v1);
                            }
                        }
                        var4_4.add(var6_6);
                    }
                    catch (IllegalThreadStateException v2) {
                        throw DebugProcessImpl.b(v2);
                    }
                }
                catch (IllegalThreadStateException var8_9) {
                    DebugProcessImpl.u.info((Throwable)var8_9);
                }
                catch (ObjectCollectedException var8_10) {
                }
            }
            var2_2.deleteEventRequests(var4_4);
        }
    }

    @Nullable
    static String getCurrentClassName(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        block8: {
            try {
                try {
                    if (threadReferenceProxyImpl == null || threadReferenceProxyImpl.frameCount() <= 0) break block8;
                }
                catch (EvaluateException evaluateException) {
                    throw DebugProcessImpl.b(evaluateException);
                }
                StackFrameProxyImpl stackFrameProxyImpl = threadReferenceProxyImpl.frame(0);
                if (stackFrameProxyImpl != null) {
                    ReferenceType referenceType;
                    Location location = stackFrameProxyImpl.location();
                    try {
                        ReferenceType referenceType2 = referenceType = location == null ? null : location.declaringType();
                    }
                    catch (EvaluateException evaluateException) {
                        throw DebugProcessImpl.b(evaluateException);
                    }
                    if (referenceType != null) {
                        return referenceType.name();
                    }
                }
            }
            catch (EvaluateException evaluateException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    private VirtualMachine d() throws ExecutionException {
        block66: {
            block63: {
                block64: {
                    block61: {
                        block59: {
                            block60: {
                                try {
                                    if (this.n != null) {
                                        throw new IOException(DebuggerBundle.message((String)"error.debugger.already.listening", (Object[])new Object[0]));
                                    }
                                }
                                catch (IllegalArgumentException v0) {
                                    throw DebugProcessImpl.b(v0);
                                }
                                var1_1 = this.j.getAddress();
                                if (!this.j.isServerMode()) break block64;
                                var2_4 = (ListeningConnector)DebugProcessImpl.findConnector(this.j.isUseSockets(), true);
                                try {
                                    this.n = var2_4.defaultArguments();
                                    if (this.n == null) {
                                        throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
                                    }
                                }
                                catch (IllegalArgumentException v1) {
                                    throw DebugProcessImpl.b(v1);
                                }
                                try {
                                    if (var1_1 == null) {
                                        throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.listen.port", (Object[])new Object[0]));
                                    }
                                }
                                catch (IllegalArgumentException v2) {
                                    throw DebugProcessImpl.b(v2);
                                }
                                try {
                                    v3 = this.j.isUseSockets() != false ? this.n.get("port") : this.n.get("name");
                                }
                                catch (IllegalArgumentException v4) {
                                    throw DebugProcessImpl.b(v4);
                                }
                                var3_6 = v3;
                                if (var3_6 == null) break block59;
                                try {
                                    block65: {
                                        var3_6.setValue(var1_1);
                                        if (var1_1.length() == 0) break block60;
                                        break block65;
                                        catch (IllegalArgumentException v5) {
                                            throw DebugProcessImpl.b(v5);
                                        }
                                    }
                                    if (!var1_1.equals("0")) break block59;
                                }
                                catch (IllegalArgumentException v6) {
                                    throw DebugProcessImpl.b(v6);
                                }
                            }
                            var4_8 = new EmptyConnectorArgument("argForUniqueness");
                            this.n.put(var4_8.name(), var4_8);
                        }
                        var4_8 = this.n.get("timeout");
                        try {
                            if (var4_8 != null) {
                                var4_8.setValue("0");
                            }
                        }
                        catch (IllegalArgumentException v7) {
                            throw DebugProcessImpl.b(v7);
                        }
                        var5_11 = var2_4.startListening(this.n);
                        var6_13 = StringUtil.substringAfterLast((String)var5_11, (String)":");
                        if (var6_13 != null) {
                            var5_11 = var6_13;
                        }
                        this.j.setAddress(var5_11);
                        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
                        var7_14 = var2_4.accept(this.n);
                        try {
                            if (this.n == null) break block61;
                            var2_4.stopListening(this.n);
                        }
                        catch (IOException v8) {
                            throw DebugProcessImpl.b(v8);
                        }
                        {
                            catch (IllegalConnectorArgumentsException | IllegalArgumentException var8_15) {
                                // empty catch block
                            }
                        }
                    }
                    return var7_14;
                    catch (IllegalArgumentException var5_12) {
                        try {
                            throw new CantRunException(var5_12.getLocalizedMessage());
                        }
                        catch (Throwable var9_16) {
                            block62: {
                                try {
                                    if (this.n == null) break block62;
                                    var2_4.stopListening(this.n);
                                    break block62;
                                }
                                catch (IOException v9) {
                                    throw DebugProcessImpl.b(v9);
                                }
                                {
                                    catch (IllegalConnectorArgumentsException | IllegalArgumentException var10_17) {
                                        // empty catch block
                                    }
                                }
                            }
                            throw var9_16;
                        }
                    }
                }
                var2_5 = (AttachingConnector)DebugProcessImpl.findConnector(this.j.isUseSockets(), false);
                this.n = var2_5.defaultArguments();
                if (!this.j.isUseSockets()) break block66;
                var3_7 = this.n.get("hostname");
                if (var3_7 == null) break block63;
                try {
                    block67: {
                        if (this.j.getHostName() == null) break block63;
                        break block67;
                        catch (IllegalArgumentException v10) {
                            throw DebugProcessImpl.b(v10);
                        }
                    }
                    var3_7.setValue(this.j.getHostName());
                }
                catch (IllegalArgumentException v11) {
                    throw DebugProcessImpl.b(v11);
                }
            }
            try {
                if (var1_1 == null) {
                    throw new CantRunException(DebuggerBundle.message((String)"error.no.debug.attach.port", (Object[])new Object[0]));
                }
            }
            catch (IllegalArgumentException v12) {
                throw DebugProcessImpl.b(v12);
            }
            var4_9 = this.n.get("port");
            try {
                if (var4_9 == null) ** GOTO lbl133
                var4_9.setValue(var1_1);
            }
            catch (IllegalArgumentException v13) {
                throw DebugProcessImpl.b(v13);
            }
        }
        try {
            if (var1_1 == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.no.shmem.address", (Object[])new Object[0]));
            }
        }
        catch (IllegalArgumentException v14) {
            throw DebugProcessImpl.b(v14);
        }
        var3_7 = this.n.get("name");
        try {
            if (var3_7 != null) {
                var3_7.setValue(var1_1);
            }
        }
        catch (IllegalArgumentException v15) {
            throw DebugProcessImpl.b(v15);
        }
lbl133:
        // 3 sources

        var3_7 = this.n.get("timeout");
        try {
            if (var3_7 != null) {
                var3_7.setValue("0");
            }
        }
        catch (IllegalArgumentException v16) {
            throw DebugProcessImpl.b(v16);
        }
        ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).connectorIsReady();
        try {
            var4_9 = var2_5.attach(this.n);
            return var4_9;
        }
        catch (IllegalArgumentException var4_10) {
            try {
                throw new CantRunException(var4_10.getLocalizedMessage());
            }
            catch (IOException var1_2) {
                throw new ExecutionException(DebugProcessImpl.processIOException(var1_2, DebuggerBundle.getAddressDisplayName((RemoteConnection)this.j)), (Throwable)var1_2);
            }
            catch (IllegalConnectorArgumentsException var1_3) {
                throw new ExecutionException(DebugProcessImpl.processError(var1_3), (Throwable)var1_3);
            }
        }
        finally {
            this.n = null;
        }
    }

    public void showStatusText(String string) {
        this.t.cancelAllRequests();
        this.t.addRequest(() -> {
            try {
                if (!this.m.isDisposed()) {
                    StatusBarUtil.setStatusBarInfo((Project)this.m, (String)string);
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
        }, 50);
    }

    @NotNull
    public static Connector findConnector(boolean bl2, boolean bl3) throws ExecutionException {
        Connector connector;
        String string;
        block12: {
            Connector connector2;
            String string2;
            block14: {
                block13: {
                    try {
                        try {
                            if (!bl3) break block12;
                            if (!bl2) break block13;
                        }
                        catch (ExecutionException executionException) {
                            throw DebugProcessImpl.b(executionException);
                        }
                        string2 = "com.sun.jdi.SocketListen";
                        break block14;
                    }
                    catch (ExecutionException executionException) {
                        throw DebugProcessImpl.b(executionException);
                    }
                }
                string2 = "com.sun.jdi.SharedMemoryListen";
            }
            try {
                connector2 = DebugProcessImpl.b(string2);
                if (connector2 == null) {
                    DebugProcessImpl.a(5);
                }
            }
            catch (ExecutionException executionException) {
                throw DebugProcessImpl.b(executionException);
            }
            return connector2;
        }
        try {
            string = bl2 ? "com.sun.jdi.SocketAttach" : "com.sun.jdi.SharedMemoryAttach";
        }
        catch (ExecutionException executionException) {
            throw DebugProcessImpl.b(executionException);
        }
        try {
            connector = DebugProcessImpl.b(string);
            if (connector == null) {
                DebugProcessImpl.a(6);
            }
        }
        catch (ExecutionException executionException) {
            throw DebugProcessImpl.b(executionException);
        }
        return connector;
    }

    @NotNull
    private static Connector b(String string) throws ExecutionException {
        Connector connector2;
        VirtualMachineManager virtualMachineManager;
        try {
            virtualMachineManager = Bootstrap.virtualMachineManager();
        }
        catch (Error error) {
            throw new ExecutionException(DebuggerBundle.message((String)"debugger.jdi.bootstrap.error", (Object[])new Object[]{error.getClass().getName() + " : " + error.getLocalizedMessage()}));
        }
        Connector connector3 = StreamEx.of(virtualMachineManager.allConnectors()).findFirst(connector -> string.equals(connector.name())).orElse(null);
        try {
            if (connector3 == null) {
                throw new CantRunException(DebuggerBundle.message((String)"error.debug.connector.not.found", (Object[])new Object[]{string}));
            }
        }
        catch (Error error) {
            throw DebugProcessImpl.b(error);
        }
        try {
            connector2 = connector3;
            if (connector2 == null) {
                DebugProcessImpl.a(7);
            }
        }
        catch (Error error) {
            throw DebugProcessImpl.b(error);
        }
        return connector2;
    }

    private void a(VirtualMachine virtualMachine) {
        block10: {
            String string = virtualMachine.version();
            try {
                if ("1.4.0".equals(string)) {
                    DebuggerInvocationUtil.swingInvokeLater(this.m, () -> Messages.showMessageDialog((Project)this.m, (String)DebuggerBundle.message((String)"warning.jdk140.unstable", (Object[])new Object[0]), (String)DebuggerBundle.message((String)"title.jdk140.unstable", (Object[])new Object[0]), (Icon)Messages.getWarningIcon()));
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
            if (this.getSession().getAlternativeJre() == null) {
                Sdk sdk3 = this.getSession().getRunJre();
                try {
                    try {
                        try {
                            if (sdk3 != null && !(sdk3.getSdkType() instanceof JavaSdkType)) break block10;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw DebugProcessImpl.b(classNotPreparedException);
                        }
                        if (DebugProcessImpl.a(sdk3, string)) break block10;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    Arrays.stream(ProjectJdkTable.getInstance().getAllJdks()).filter(sdk -> DebugProcessImpl.a(sdk, string)).findFirst().ifPresent(sdk2 -> {
                        String string2;
                        Object[] objectArray;
                        String string3;
                        NotificationGroup notificationGroup;
                        try {
                            notificationGroup = XDebuggerManagerImpl.NOTIFICATION_GROUP;
                            string3 = "message.remote.jre.version.mismatch";
                            Object[] objectArray2 = new Object[3];
                            objectArray2[0] = string;
                            Object[] objectArray3 = objectArray2;
                            objectArray = objectArray2;
                            int n2 = 1;
                            string2 = sdk3 != null ? sdk3.getVersionString() : "unknown";
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw DebugProcessImpl.b(classNotPreparedException);
                        }
                        objectArray3[n2] = string2;
                        objectArray[2] = sdk2.getName();
                        notificationGroup.createNotification(DebuggerBundle.message((String)string3, (Object[])objectArray), MessageType.INFO).notify(this.m);
                        this.getSession().setAlternativeJre((Sdk)sdk2);
                    });
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
        }
    }

    private static boolean a(@Nullable Sdk sdk, String string) {
        block6: {
            boolean bl2;
            block8: {
                block7: {
                    try {
                        if (sdk == null || !(sdk.getSdkType() instanceof JavaSdkType)) break block6;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    String string2 = sdk.getVersionString();
                    try {
                        try {
                            if (string2 == null || !string2.contains(string)) break block7;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw DebugProcessImpl.b(classNotPreparedException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }
        return false;
    }

    public void addEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.addListener((EventListener)evaluationListener);
    }

    public void removeEvaluationListener(EvaluationListener evaluationListener) {
        this.myEvaluationDispatcher.removeListener((EventListener)evaluationListener);
    }

    public void addDebugProcessListener(DebugProcessListener debugProcessListener) {
        this.myDebugProcessDispatcher.addListener((EventListener)debugProcessListener);
    }

    public void removeDebugProcessListener(DebugProcessListener debugProcessListener) {
        this.myDebugProcessDispatcher.removeListener((EventListener)debugProcessListener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.q;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().addProcessListener(processListener);
            } else {
                this.q.add(processListener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProcessListener(ProcessListener processListener) {
        List<ProcessListener> list = this.q;
        synchronized (list) {
            if (this.getProcessHandler() != null) {
                this.getProcessHandler().removeProcessListener(processListener);
            } else {
                this.q.remove(processListener);
            }
        }
    }

    public RemoteConnection getConnection() {
        return this.j;
    }

    public ExecutionResult getExecutionResult() {
        return this.f;
    }

    @NotNull
    public Project getProject() {
        Project project2;
        try {
            project2 = this.m;
            if (project2 == null) {
                DebugProcessImpl.a(8);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return project2;
    }

    public boolean canRedefineClasses() {
        boolean bl2;
        block5: {
            block4: {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.p;
                try {
                    try {
                        if (virtualMachineProxyImpl == null || !virtualMachineProxyImpl.canRedefineClasses()) break block4;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public boolean canWatchFieldModification() {
        boolean bl2;
        block5: {
            block4: {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.p;
                try {
                    try {
                        if (virtualMachineProxyImpl == null || !virtualMachineProxyImpl.canWatchFieldModification()) break block4;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public boolean isInInitialState() {
        boolean bl2;
        try {
            bl2 = this.myState.get() == State.INITIAL;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return bl2;
    }

    public boolean isAttached() {
        boolean bl2;
        try {
            bl2 = this.myState.get() == State.ATTACHED;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return bl2;
    }

    public boolean isDetached() {
        boolean bl2;
        try {
            bl2 = this.myState.get() == State.DETACHED;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return bl2;
    }

    public boolean isDetaching() {
        boolean bl2;
        try {
            bl2 = this.myState.get() == State.DETACHING;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return bl2;
    }

    public RequestManagerImpl getRequestsManager() {
        return this.h;
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachineProxy() {
        VirtualMachineProxyImpl virtualMachineProxyImpl;
        VirtualMachineProxyImpl virtualMachineProxyImpl2;
        block7: {
            block8: {
                DebuggerManagerThreadImpl.assertIsManagerThread();
                virtualMachineProxyImpl2 = this.p;
                try {
                    try {
                        if (virtualMachineProxyImpl2 != null) break block7;
                        if (!this.isInInitialState()) break block8;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    throw new IllegalStateException("Virtual machine is not initialized yet");
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            throw new VMDisconnectedException();
        }
        try {
            virtualMachineProxyImpl = virtualMachineProxyImpl2;
            if (virtualMachineProxyImpl == null) {
                DebugProcessImpl.a(9);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return virtualMachineProxyImpl;
    }

    public void appendPositionManager(PositionManager positionManager) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.myPositionManager.appendPositionManager(positionManager);
    }

    public void setRunToCursorBreakpoint(@Nullable RunToCursorBreakpoint runToCursorBreakpoint) {
        this.b = runToCursorBreakpoint;
    }

    public void cancelRunToCursorBreakpoint() {
        block4: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            RunToCursorBreakpoint runToCursorBreakpoint = this.b;
            try {
                try {
                    if (runToCursorBreakpoint == null) break block4;
                    this.setRunToCursorBreakpoint(null);
                    this.getRequestsManager().deleteRequest(runToCursorBreakpoint);
                    if (!runToCursorBreakpoint.isRestoreBreakpoints()) break block4;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
                DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager().enableBreakpoints(this);
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void closeProcess(boolean bl2) {
        block19: {
            try {
                DebuggerManagerThreadImpl.assertIsManagerThread();
                if (!this.myState.compareAndSet(State.INITIAL, State.DETACHING) && !this.myState.compareAndSet(State.ATTACHED, State.DETACHING)) break block19;
            }
            catch (Throwable throwable) {
                throw DebugProcessImpl.b(throwable);
            }
            try {
                this.getManagerThread().close();
            }
            finally {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.p;
                this.p = null;
                this.myPositionManager = CompoundPositionManager.EMPTY;
                this.myReturnValueWatcher = null;
                this.w.clear();
                this.a.clear();
                DebuggerUtils.cleanupAfterProcessFinish((DebugProcess)this);
                this.myState.compareAndSet(State.DETACHING, State.DETACHED);
                try {
                    ((DebugProcessListener)this.myDebugProcessDispatcher.getMulticaster()).processDetached((DebugProcess)this, bl2);
                }
                finally {
                    if (virtualMachineProxyImpl != null) {
                        try {
                            virtualMachineProxyImpl.dispose();
                        }
                        catch (Throwable throwable) {}
                    }
                    this.l.up();
                }
            }
        }
    }

    private static String a(String string) {
        int n2 = 90;
        StringBuilder stringBuilder = new StringBuilder(string.length());
        try {
            for (int i2 = 0; i2 < string.length(); i2 += 90) {
                stringBuilder.append(string.substring(i2, Math.min(i2 + 90, string.length()))).append('\n');
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return stringBuilder.toString();
    }

    public static String processError(Exception exception) {
        String string;
        if (exception instanceof VMStartException) {
            VMStartException vMStartException = (VMStartException)exception;
            string = vMStartException.getLocalizedMessage();
        } else if (exception instanceof IllegalConnectorArgumentsException) {
            IllegalConnectorArgumentsException illegalConnectorArgumentsException = (IllegalConnectorArgumentsException)exception;
            List<String> list = illegalConnectorArgumentsException.argumentNames();
            string = DebugProcessImpl.a(DebuggerBundle.message((String)"error.invalid.argument", (Object[])new Object[]{list.size()}) + ": " + illegalConnectorArgumentsException.getLocalizedMessage()) + list;
            u.debug((Throwable)illegalConnectorArgumentsException);
        } else if (exception instanceof CantRunException) {
            string = exception.getLocalizedMessage();
        } else if (exception instanceof VMDisconnectedException) {
            string = DebuggerBundle.message((String)"error.vm.disconnected", (Object[])new Object[0]);
        } else if (exception instanceof IOException) {
            string = DebugProcessImpl.processIOException((IOException)exception, null);
        } else if (exception instanceof ExecutionException) {
            string = exception.getLocalizedMessage();
        } else {
            string = DebuggerBundle.message((String)"error.exception.while.connecting", (Object[])new Object[]{exception.getClass().getName(), exception.getLocalizedMessage()});
            u.debug((Throwable)exception);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @NotNull
    public static String processIOException(@NotNull IOException iOException, @Nullable String string) {
        String string2;
        String string3;
        block22: {
            String string4;
            String string5;
            StringBuilder stringBuilder;
            block24: {
                block23: {
                    try {
                        if (iOException == null) {
                            DebugProcessImpl.a(10);
                        }
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    if (!(iOException instanceof UnknownHostException)) break block22;
                    try {
                        block26: {
                            stringBuilder = new StringBuilder().append(DebuggerBundle.message((String)"error.unknown.host", (Object[])new Object[0]));
                            if (string == null) break block23;
                            break block26;
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw DebugProcessImpl.b(classNotPreparedException);
                            }
                        }
                        string5 = " (" + string + ")";
                        break block24;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                }
                string5 = "";
            }
            try {
                string4 = stringBuilder.append(string5).append(":\n").append(iOException.getLocalizedMessage()).toString();
                if (string4 == null) {
                    DebugProcessImpl.a(11);
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
            return string4;
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            try {
                stringBuilder.append(DebuggerBundle.message((String)"error.cannot.open.debugger.port", (Object[])new Object[0]));
                if (string != null) {
                    stringBuilder.append(" (").append(string).append(")");
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
            stringBuilder.append(": ");
            stringBuilder.append(iOException.getClass().getName()).append(" ");
            String string6 = iOException.getLocalizedMessage();
            try {
                if (!StringUtil.isEmpty((String)string6)) {
                    stringBuilder.append('\"');
                    stringBuilder.append(string6);
                    stringBuilder.append('\"');
                }
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
            u.debug((Throwable)iOException);
            string3 = stringBuilder.toString();
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
        try {
            string2 = string3;
            if (string2 == null) {
                DebugProcessImpl.a(12);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return string2;
    }

    public void dispose() {
        Disposer.dispose((Disposable)this.myDisposable);
        this.h.setFilterThread(null);
    }

    public DebuggerManagerThreadImpl getManagerThread() {
        return this.o;
    }

    private static int a(SuspendContext suspendContext) {
        block4: {
            try {
                try {
                    if (suspendContext.getSuspendPolicy() != 1 && !DebugProcessImpl.isResumeOnlyCurrentThread()) break block4;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
                return 1;
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
        }
        return 0;
    }

    public void waitFor() {
        boolean bl2;
        Logger logger;
        try {
            logger = u;
            bl2 = !DebuggerManagerThreadImpl.isManagerThread();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        logger.assertTrue(bl2);
        this.l.waitFor();
    }

    public void waitFor(long l2) {
        boolean bl2;
        Logger logger;
        try {
            logger = u;
            bl2 = !DebuggerManagerThreadImpl.isManagerThread();
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        logger.assertTrue(bl2);
        this.l.waitFor(l2);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ObjectReference objectReference, @NotNull Method method, @NotNull List<? extends Value> list) throws EvaluateException {
        try {
            if (evaluationContext == null) {
                DebugProcessImpl.a(13);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (objectReference == null) {
                DebugProcessImpl.a(14);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (method == null) {
                DebugProcessImpl.a(15);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (list == null) {
                DebugProcessImpl.a(16);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        return this.invokeInstanceMethod(evaluationContext, objectReference, method, list, 0);
    }

    public Value invokeInstanceMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ObjectReference objectReference, @NotNull Method method, @NotNull List<? extends Value> list, final int n2) throws EvaluateException {
        try {
            if (evaluationContext == null) {
                DebugProcessImpl.a(17);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (objectReference == null) {
                DebugProcessImpl.a(18);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (method == null) {
                DebugProcessImpl.a(19);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (list == null) {
                DebugProcessImpl.a(20);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list){

            @Override
            protected Value invokeMethod(int n22, Method method, List<? extends Value> list) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                try {
                    if (u.isDebugEnabled()) {
                        u.debug("Invoking " + objectReference.type().name() + "." + method.name());
                    }
                }
                catch (InvocationException invocationException) {
                    throw 3.b(invocationException);
                }
                return objectReference.invokeMethod(threadReference, method, list, n22 | n2);
            }

            private static InvocationException b(InvocationException invocationException) {
                return invocationException;
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    private static ThreadReference a(EvaluationContext evaluationContext) throws EvaluateException {
        ThreadReferenceProxy threadReferenceProxy = evaluationContext.getSuspendContext().getThread();
        try {
            if (threadReferenceProxy == null) {
                throw EvaluateExceptionUtil.NULL_STACK_FRAME;
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        return threadReferenceProxy.getThreadReference();
    }

    public Value invokeMethod(EvaluationContext evaluationContext, ClassType classType, Method method, List<? extends Value> list) throws EvaluateException {
        return this.invokeMethod(evaluationContext, classType, method, list, 0, false);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list, boolean bl2) throws EvaluateException {
        try {
            if (evaluationContext == null) {
                DebugProcessImpl.a(21);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (classType == null) {
                DebugProcessImpl.a(22);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (method == null) {
                DebugProcessImpl.a(23);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (list == null) {
                DebugProcessImpl.a(24);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        return this.invokeMethod(evaluationContext, classType, method, list, 0, bl2);
    }

    public Value invokeMethod(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list, final int n2, boolean bl2) throws EvaluateException {
        try {
            if (evaluationContext == null) {
                DebugProcessImpl.a(25);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (classType == null) {
                DebugProcessImpl.a(26);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (method == null) {
                DebugProcessImpl.a(27);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (list == null) {
                DebugProcessImpl.a(28);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list){

            @Override
            protected Value invokeMethod(int n22, Method method, List<? extends Value> list) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                try {
                    if (u.isDebugEnabled()) {
                        u.debug("Invoking " + classType.name() + "." + method.name());
                    }
                }
                catch (InvocationException invocationException) {
                    throw 4.b(invocationException);
                }
                return classType.invokeMethod(threadReference, method, list, n22 | n2);
            }

            private static InvocationException b(InvocationException invocationException) {
                return invocationException;
            }
        }.start((EvaluationContextImpl)evaluationContext, bl2);
    }

    public Value invokeMethod(EvaluationContext evaluationContext, final InterfaceType interfaceType, Method method, List<? extends Value> list) throws EvaluateException {
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        return new InvokeCommand<Value>(method, list){

            @Override
            protected Value invokeMethod(int n2, Method method, List<? extends Value> list) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                try {
                    if (u.isDebugEnabled()) {
                        u.debug("Invoking " + interfaceType.name() + "." + method.name());
                    }
                }
                catch (LinkageError linkageError) {
                    throw 5.b(linkageError);
                }
                try {
                    return interfaceType.invokeMethod(threadReference, method, list, n2);
                }
                catch (LinkageError linkageError) {
                    throw new IllegalStateException("Interface method invocation is not supported in JVM " + SystemInfo.JAVA_VERSION + ". Use JVM 1.8.0_45 or higher to run " + ApplicationNamesInfo.getInstance().getFullProductName());
                }
            }

            private static LinkageError b(LinkageError linkageError) {
                return linkageError;
            }
        }.start((EvaluationContextImpl)evaluationContext, false);
    }

    public ArrayReference newInstance(ArrayType arrayType, int n2) throws EvaluateException {
        try {
            return arrayType.newInstance(n2);
        }
        catch (Exception exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    public ObjectReference newInstance(@NotNull EvaluationContext evaluationContext, final @NotNull ClassType classType, @NotNull Method method, @NotNull List<? extends Value> list) throws EvaluateException {
        try {
            if (evaluationContext == null) {
                DebugProcessImpl.a(29);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (classType == null) {
                DebugProcessImpl.a(30);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (method == null) {
                DebugProcessImpl.a(31);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        try {
            if (list == null) {
                DebugProcessImpl.a(32);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        final ThreadReference threadReference = DebugProcessImpl.a(evaluationContext);
        InvokeCommand<ObjectReference> invokeCommand = new InvokeCommand<ObjectReference>(method, list){

            @Override
            protected ObjectReference invokeMethod(int n2, Method method, List<? extends Value> list) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
                try {
                    if (u.isDebugEnabled()) {
                        u.debug("New instance " + classType.name() + "." + method.name());
                    }
                }
                catch (InvocationException invocationException) {
                    throw 6.b(invocationException);
                }
                return classType.newInstance(threadReference, method, list, n2);
            }

            private static InvocationException b(InvocationException invocationException) {
                return invocationException;
            }
        };
        return (ObjectReference)invokeCommand.start((EvaluationContextImpl)evaluationContext, false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearCashes(int n2) {
        try {
            if (!this.isAttached()) {
                return;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            switch (n2) {
                case 2: {
                    this.getVirtualMachineProxy().clearCaches();
                    return;
                }
                case 1: {
                    this.getVirtualMachineProxy().clearCaches();
                    return;
                }
                default: {
                    return;
                }
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
    }

    protected void beforeSuspend(SuspendContextImpl suspendContextImpl) {
        this.clearCashes(suspendContextImpl.getSuspendPolicy());
    }

    private void a(SuspendContextImpl suspendContextImpl, Method method, boolean bl2) {
        block11: {
            block12: {
                block8: {
                    String string;
                    StringBuilder stringBuilder;
                    Logger logger;
                    block10: {
                        block9: {
                            try {
                                try {
                                    if (!u.isDebugEnabled()) break block8;
                                    logger = u;
                                    stringBuilder = new StringBuilder().append("before invocation in  thread ").append(suspendContextImpl.getThread().name()).append(" method ");
                                    if (method != null) break block9;
                                }
                                catch (ClassNotPreparedException classNotPreparedException) {
                                    throw DebugProcessImpl.b(classNotPreparedException);
                                }
                                string = "null";
                                break block10;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw DebugProcessImpl.b(classNotPreparedException);
                            }
                        }
                        string = method.name();
                    }
                    logger.debug(stringBuilder.append(string).toString());
                }
                try {
                    try {
                        if (bl2) break block11;
                        if (method == null) break block12;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    this.showStatusText(DebuggerBundle.message((String)"progress.evaluating", (Object[])new Object[]{DebuggerUtilsEx.methodName(method)}));
                    break block11;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            this.showStatusText(DebuggerBundle.message((String)"title.evaluating", (Object[])new Object[0]));
        }
    }

    private void a(SuspendContextImpl suspendContextImpl, boolean bl2) {
        try {
            if (u.isDebugEnabled()) {
                u.debug("after invocation in  thread " + suspendContextImpl.getThread().name());
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            if (!bl2) {
                this.showStatusText("");
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
    }

    public ReferenceType findClass(EvaluationContext evaluationContext, String string, ClassLoaderReference classLoaderReference) throws EvaluateException {
        try {
            ReferenceType referenceType;
            block7: {
                DebuggerManagerThreadImpl.assertIsManagerThread();
                referenceType = null;
                for (ReferenceType referenceType2 : this.getVirtualMachineProxy().classesByName(string)) {
                    try {
                        if (!referenceType2.isPrepared() || !DebugProcessImpl.a(classLoaderReference, referenceType2)) continue;
                    }
                    catch (InvocationException invocationException) {
                        throw DebugProcessImpl.b(invocationException);
                    }
                    referenceType = referenceType2;
                    break;
                }
                EvaluationContextImpl evaluationContextImpl = (EvaluationContextImpl)evaluationContext;
                try {
                    if (referenceType != null || !evaluationContextImpl.isAutoLoadClasses()) break block7;
                }
                catch (InvocationException invocationException) {
                    throw DebugProcessImpl.b(invocationException);
                }
                return this.loadClass(evaluationContextImpl, string, classLoaderReference);
            }
            return referenceType;
        }
        catch (ClassNotLoadedException | IncompatibleThreadStateException | InvalidTypeException | InvocationException exception) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
        }
    }

    private static boolean a(ClassLoaderReference classLoaderReference, ReferenceType referenceType) {
        boolean bl2;
        block8: {
            block7: {
                try {
                    block6: {
                        try {
                            try {
                                if (classLoaderReference == null || classLoaderReference.equals(referenceType.classLoader())) break block6;
                            }
                            catch (ClassNotPreparedException classNotPreparedException) {
                                throw DebugProcessImpl.b(classNotPreparedException);
                            }
                            if (!classLoaderReference.visibleClasses().contains(referenceType)) break block7;
                        }
                        catch (ClassNotPreparedException classNotPreparedException) {
                            throw DebugProcessImpl.b(classNotPreparedException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String c(String string) {
        try {
            if (string.indexOf(91) == -1) {
                return string;
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        int n2 = 0;
        while (string.endsWith("[]")) {
            string = string.substring(0, string.length() - 2);
            ++n2;
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            block10: {
                block9: {
                    StringUtil.repeatSymbol((Appendable)stringBuilder, (char)'[', (int)n2);
                    String string2 = JVMNameUtil.getPrimitiveSignature(string);
                    try {
                        if (string2 == null) break block9;
                        stringBuilder.append(string2);
                        break block10;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                }
                stringBuilder.append('L');
                stringBuilder.append(string);
                stringBuilder.append(';');
            }
            String string3 = stringBuilder.toString();
            return string3;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    public ReferenceType loadClass(EvaluationContextImpl evaluationContextImpl, String string, ClassLoaderReference classLoaderReference) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException, EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        string = DebugProcessImpl.c(string);
        ReferenceType referenceType = null;
        VirtualMachineProxyImpl virtualMachineProxyImpl = this.getVirtualMachineProxy();
        ClassType classType = (ClassType)ContainerUtil.getFirstItem(virtualMachineProxyImpl.classesByName("java.lang.Class"));
        if (classType != null) {
            Method method;
            ArrayList<Value> arrayList = new ArrayList<Value>();
            arrayList.add(virtualMachineProxyImpl.mirrorOf(string));
            if (classLoaderReference != null) {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;ZLjava/lang/ClassLoader;)Ljava/lang/Class;");
                arrayList.add(virtualMachineProxyImpl.mirrorOf(true));
                arrayList.add(classLoaderReference);
            } else {
                method = DebuggerUtils.findMethod((ReferenceType)classType, (String)"forName", (String)"(Ljava/lang/String;)Ljava/lang/Class;");
            }
            Value value = this.invokeMethod((EvaluationContext)evaluationContextImpl, classType, method, arrayList);
            if (value instanceof ClassObjectReference) {
                referenceType = ((ClassObjectReference)value).reflectedType();
            }
        }
        return referenceType;
    }

    public void logThreads() {
        if (u.isDebugEnabled()) {
            try {
                Collection<ThreadReferenceProxyImpl> collection = this.getVirtualMachineProxy().allThreads();
                for (ThreadReferenceProxyImpl threadReferenceProxyImpl : collection) {
                    u.debug("Thread name=" + threadReferenceProxyImpl.name() + " suspendCount()=" + threadReferenceProxyImpl.getSuspendCount());
                }
            }
            catch (Exception exception) {
                u.debug((Throwable)exception);
            }
        }
    }

    public void onHotSwapFinished() {
        this.getPositionManager().clearCache();
        StackCapturingLineBreakpoint.clearCaches(this);
    }

    @NotNull
    public SuspendManager getSuspendManager() {
        SuspendManagerImpl suspendManagerImpl;
        try {
            suspendManagerImpl = this.v;
            if (suspendManagerImpl == null) {
                DebugProcessImpl.a(33);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return suspendManagerImpl;
    }

    @NotNull
    public CompoundPositionManager getPositionManager() {
        CompoundPositionManager compoundPositionManager;
        try {
            compoundPositionManager = this.myPositionManager;
            if (compoundPositionManager == null) {
                DebugProcessImpl.a(34);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return compoundPositionManager;
    }

    public void stop(boolean bl2) {
        int n2;
        StopCommand stopCommand;
        DebuggerManagerThreadImpl debuggerManagerThreadImpl;
        try {
            this.s.set(true);
            this.c();
            debuggerManagerThreadImpl = this.getManagerThread();
            stopCommand = this.createStopCommand(bl2);
            n2 = ApplicationManager.getApplication().isUnitTestMode() ? 0 : 3000;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        debuggerManagerThreadImpl.terminateAndInvoke(stopCommand, n2);
    }

    @NotNull
    public StopCommand createStopCommand(boolean bl2) {
        StopCommand stopCommand;
        try {
            stopCommand = new StopCommand(bl2);
            if (stopCommand == null) {
                DebugProcessImpl.a(35);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return stopCommand;
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope;
        boolean bl2;
        Logger logger;
        try {
            logger = u;
            bl2 = this.mySession != null;
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            logger.assertTrue(bl2, (Object)"Accessing debug session before its initialization");
            globalSearchScope = this.mySession.getSearchScope();
            if (globalSearchScope == null) {
                DebugProcessImpl.a(36);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return globalSearchScope;
    }

    public void reattach(final DebugEnvironment debugEnvironment) throws ExecutionException {
        try {
            if (!this.s.get()) {
                this.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        DebugProcessImpl.this.closeProcess(false);
                        this.a();
                    }

                    @Override
                    protected void commandCancelled() {
                        this.a();
                    }

                    private void a() {
                        DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.m, () -> {
                            ((XDebugSessionImpl)DebugProcessImpl.this.getXdebugProcess().getSession()).reset();
                            DebugProcessImpl.this.myState.set(State.INITIAL);
                            DebugProcessImpl.this.j = debugEnvironment.getRemoteConnection();
                            DebugProcessImpl.this.getManagerThread().restartIfNeeded();
                            DebugProcessImpl.this.a(debugEnvironment);
                        });
                    }
                });
            }
        }
        catch (ExecutionException executionException) {
            throw DebugProcessImpl.b(executionException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public ExecutionResult attachVirtualMachine(DebugEnvironment debugEnvironment, DebuggerSession debuggerSession) throws ExecutionException {
        ExecutionResult executionResult;
        this.mySession = debuggerSession;
        this.l.down();
        ApplicationManager.getApplication().assertIsDispatchThread();
        u.assertTrue(this.isInInitialState());
        this.j = debugEnvironment.getRemoteConnection();
        this.a(debugEnvironment);
        try {
            List<ProcessListener> list = this.q;
            synchronized (list) {
                this.f = executionResult = debugEnvironment.createExecutionResult();
                if (executionResult == null) {
                    this.a();
                    return null;
                }
                for (ProcessListener processListener : this.q) {
                    executionResult.getProcessHandler().addProcessListener(processListener);
                }
                this.q.clear();
            }
        }
        catch (ExecutionException executionException) {
            this.a();
            throw executionException;
        }
        try {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return executionResult;
            }
        }
        catch (ExecutionException executionException) {
            throw DebugProcessImpl.b(executionException);
        }
        return executionResult;
    }

    private void a() {
        try {
            if (this.x.compareAndSet(false, true)) {
                this.stop(false);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
    }

    private void a(DebugEnvironment debugEnvironment) {
        final String string = debugEnvironment.getSessionName();
        final long l2 = debugEnvironment.getPollTimeout();
        final Semaphore semaphore = new Semaphore();
        semaphore.down();
        final AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        this.myDebugProcessDispatcher.addListener((EventListener)new DebugProcessListener(){

            public void connectorIsReady() {
                atomicBoolean.set(true);
                semaphore.up();
                DebugProcessImpl.this.myDebugProcessDispatcher.removeListener((EventListener)((Object)this));
            }
        });
        DebuggerManagerEx.getInstanceEx(this.m).getBreakpointManager().reloadBreakpoints();
        this.getManagerThread().schedule(new DebuggerCommandImpl(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             * Could not resolve type clashes
             */
            @Override
            protected void action() {
                var1_1 = null;
                try {
                    var2_2 = System.currentTimeMillis();
                    while (true) {
                        try {
                            var1_1 = DebugProcessImpl.access$1300(DebugProcessImpl.this);
                        }
                        catch (ExecutionException var4_4) {
                            block26: {
                                block25: {
                                    block28: {
                                        block23: {
                                            if (l2 <= 0L) break block23;
                                            try {
                                                block27: {
                                                    if (DebugProcessImpl.access$1100(DebugProcessImpl.this).isServerMode()) break block23;
                                                    break block27;
                                                    catch (ExecutionException v0) {
                                                        throw 9.b(v0);
                                                    }
                                                }
                                                if (!(var4_4.getCause() instanceof IOException)) break block23;
                                            }
                                            catch (ExecutionException v1) {
                                                throw 9.b(v1);
                                            }
                                            var5_5 /* !! */  = this;
                                            synchronized (var5_5 /* !! */ ) {
                                                try {
                                                    this.wait(500L);
                                                }
                                                catch (InterruptedException var6_6) {
                                                    break;
                                                }
                                            }
                                        }
                                        var5_5 /* !! */  = DebugProcessImpl.this.getProcessHandler();
                                        if (var5_5 /* !! */  == null) break block25;
                                        if (var5_5 /* !! */ .isProcessTerminating()) ** GOTO lbl47
                                        break block28;
                                        catch (ExecutionException v2) {
                                            throw 9.b(v2);
                                        }
                                    }
                                    try {
                                        block29: {
                                            if (!var5_5 /* !! */ .isProcessTerminated()) break block25;
                                            break block29;
                                            catch (ExecutionException v3) {
                                                throw 9.b(v3);
                                            }
                                        }
                                        v4 = true;
                                        break block26;
                                    }
                                    catch (ExecutionException v5) {
                                        throw 9.b(v5);
                                    }
                                }
                                v4 = false;
                            }
                            var6_7 = v4;
                            DebugProcessImpl.access$1400(DebugProcessImpl.this);
                            DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.access$300(DebugProcessImpl.this), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(boolean java.util.concurrent.atomic.AtomicBoolean java.lang.String com.intellij.execution.ExecutionException ), ()V)(this, (boolean)var6_7, (AtomicBoolean)atomicBoolean, (String)string, (ExecutionException)var4_4));
                            break;
                            if (System.currentTimeMillis() - var2_2 < l2) continue;
                        }
                        break;
                    }
                }
                finally {
                    semaphore.up();
                }
                if (var1_1 != null) {
                    var2_3 = var1_1;
                    DebugProcessImpl.access$1500(DebugProcessImpl.this, (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.sun.jdi.VirtualMachine ), ()V)(this, (VirtualMachine)var2_3));
                } else {
                    DebugProcessImpl.access$1400(DebugProcessImpl.this);
                }
            }

            @Override
            protected void commandCancelled() {
                try {
                    super.commandCancelled();
                }
                finally {
                    semaphore.up();
                }
            }

            private /* synthetic */ void a(final VirtualMachine virtualMachine) {
                DebugProcessImpl.this.getManagerThread().schedule(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        try {
                            DebugProcessImpl.this.commitVM(virtualMachine);
                        }
                        catch (VMDisconnectedException vMDisconnectedException) {
                            DebugProcessImpl.this.a();
                        }
                    }
                });
            }

            private /* synthetic */ void a(boolean bl2, AtomicBoolean atomicBoolean2, String string2, ExecutionException executionException) {
                if (DebugProcessImpl.this.f != null && !bl2 || !atomicBoolean2.get()) {
                    ExecutionUtil.handleExecutionError((Project)DebugProcessImpl.this.m, (String)ToolWindowId.DEBUG, (String)string2, (Throwable)executionException);
                }
            }

            private static ExecutionException b(ExecutionException executionException) {
                return executionException;
            }
        });
        semaphore.waitFor();
    }

    private void a(final Runnable runnable) {
        block4: {
            class MyProcessAdapter
            extends ProcessAdapter {
                private boolean a = false;

                MyProcessAdapter() {
                }

                public synchronized void run() {
                    try {
                        if (!this.a) {
                            this.a = true;
                            runnable.run();
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MyProcessAdapter.a(illegalArgumentException);
                    }
                    DebugProcessImpl.this.removeProcessListener((ProcessListener)this);
                }

                public void startNotified(@NotNull ProcessEvent processEvent) {
                    try {
                        if (processEvent == null) {
                            MyProcessAdapter.a(0);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw MyProcessAdapter.a(illegalArgumentException);
                    }
                    this.run();
                }

                private static /* synthetic */ void a(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/debugger/engine/DebugProcessImpl$1MyProcessAdapter", "startNotified"));
                }

                private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                    return illegalArgumentException;
                }
            }
            MyProcessAdapter myProcessAdapter = new MyProcessAdapter();
            try {
                try {
                    this.addProcessListener((ProcessListener)myProcessAdapter);
                    if (this.f == null || !this.f.getProcessHandler().isStartNotified()) break block4;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
                myProcessAdapter.run();
            }
            catch (ClassNotPreparedException classNotPreparedException) {
                throw DebugProcessImpl.b(classNotPreparedException);
            }
        }
    }

    public boolean isPausePressed() {
        boolean bl2;
        block5: {
            block4: {
                VirtualMachineProxyImpl virtualMachineProxyImpl = this.p;
                try {
                    try {
                        if (virtualMachineProxyImpl == null || !virtualMachineProxyImpl.isPausePressed()) break block4;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @NotNull
    public DebuggerCommandImpl createPauseCommand() {
        PauseCommand pauseCommand;
        try {
            pauseCommand = new PauseCommand();
            if (pauseCommand == null) {
                DebugProcessImpl.a(37);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return pauseCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContextImpl) {
        ResumeCommand resumeCommand;
        try {
            resumeCommand = this.createResumeCommand(suspendContextImpl, PrioritizedTask.Priority.HIGH);
            if (resumeCommand == null) {
                DebugProcessImpl.a(38);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createResumeCommand(SuspendContextImpl suspendContextImpl, final PrioritizedTask.Priority priority) {
        ResumeCommand resumeCommand;
        final BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(this.getProject()).getBreakpointManager();
        try {
            resumeCommand = new ResumeCommand(suspendContextImpl){

                @Override
                public void contextAction() {
                    breakpointManager.applyThreadFilter(DebugProcessImpl.this, null);
                    if (DebugProcessImpl.this.myReturnValueWatcher != null) {
                        DebugProcessImpl.this.myReturnValueWatcher.clear();
                    }
                    super.contextAction();
                }

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return priority;
                }
            };
            if (resumeCommand == null) {
                DebugProcessImpl.a(39);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2) {
        ResumeCommand resumeCommand;
        try {
            resumeCommand = this.createStepOverCommand(suspendContextImpl, bl2, -2);
            if (resumeCommand == null) {
                DebugProcessImpl.a(40);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2, int n2) {
        StepOverCommand stepOverCommand;
        try {
            stepOverCommand = new StepOverCommand(suspendContextImpl, bl2, n2);
            if (stepOverCommand == null) {
                DebugProcessImpl.a(41);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return stepOverCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContextImpl) {
        ResumeCommand resumeCommand;
        try {
            resumeCommand = this.createStepOutCommand(suspendContextImpl, -2);
            if (resumeCommand == null) {
                DebugProcessImpl.a(42);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepOutCommand(SuspendContextImpl suspendContextImpl, int n2) {
        StepOutCommand stepOutCommand;
        try {
            stepOutCommand = new StepOutCommand(suspendContextImpl, n2);
            if (stepOutCommand == null) {
                DebugProcessImpl.a(43);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return stepOutCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContextImpl, boolean bl2, MethodFilter methodFilter) {
        ResumeCommand resumeCommand;
        try {
            resumeCommand = this.createStepIntoCommand(suspendContextImpl, bl2, methodFilter, -2);
            if (resumeCommand == null) {
                DebugProcessImpl.a(44);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeCommand;
    }

    @NotNull
    public ResumeCommand createStepIntoCommand(SuspendContextImpl suspendContextImpl, boolean bl2, MethodFilter methodFilter, int n2) {
        StepIntoCommand stepIntoCommand;
        try {
            stepIntoCommand = new StepIntoCommand(suspendContextImpl, bl2, methodFilter, n2);
            if (stepIntoCommand == null) {
                DebugProcessImpl.a(45);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return stepIntoCommand;
    }

    @NotNull
    public ResumeCommand createRunToCursorCommand(SuspendContextImpl suspendContextImpl, @NotNull XSourcePosition xSourcePosition, boolean bl2) throws EvaluateException {
        RunToCursorCommand runToCursorCommand;
        try {
            if (xSourcePosition == null) {
                DebugProcessImpl.a(46);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        RunToCursorCommand runToCursorCommand2 = new RunToCursorCommand(suspendContextImpl, xSourcePosition, bl2);
        if (RunToCursorCommand.access$1800(runToCursorCommand2) == null) {
            String string;
            Object[] objectArray;
            String string2;
            EvaluateException evaluateException;
            EvaluateException evaluateException2;
            PsiFile psiFile = PsiManager.getInstance((Project)this.m).findFile(xSourcePosition.getFile());
            try {
                EvaluateException evaluateException3;
                evaluateException2 = evaluateException3;
                evaluateException = evaluateException3;
                string2 = "error.running.to.cursor.no.executable.code";
                Object[] objectArray2 = new Object[2];
                Object[] objectArray3 = objectArray2;
                objectArray = objectArray2;
                int n2 = 0;
                string = psiFile != null ? psiFile.getName() : "<No File>";
            }
            catch (EvaluateException evaluateException4) {
                throw DebugProcessImpl.b(evaluateException4);
            }
            objectArray3[n2] = string;
            objectArray[1] = xSourcePosition.getLine();
            evaluateException2(DebuggerBundle.message((String)string2, (Object[])objectArray), null);
            throw evaluateException;
        }
        try {
            runToCursorCommand = runToCursorCommand2;
            if (runToCursorCommand == null) {
                DebugProcessImpl.a(47);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebugProcessImpl.b(evaluateException);
        }
        return runToCursorCommand;
    }

    @NotNull
    public DebuggerCommandImpl createFreezeThreadCommand(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        FreezeThreadCommand freezeThreadCommand;
        try {
            freezeThreadCommand = new FreezeThreadCommand(threadReferenceProxyImpl);
            if (freezeThreadCommand == null) {
                DebugProcessImpl.a(48);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return freezeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createResumeThreadCommand(SuspendContextImpl suspendContextImpl, @NotNull ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        ResumeThreadCommand resumeThreadCommand;
        try {
            if (threadReferenceProxyImpl == null) {
                DebugProcessImpl.a(49);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        try {
            resumeThreadCommand = new ResumeThreadCommand(suspendContextImpl, threadReferenceProxyImpl);
            if (resumeThreadCommand == null) {
                DebugProcessImpl.a(50);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return resumeThreadCommand;
    }

    @NotNull
    public SuspendContextCommandImpl createPopFrameCommand(DebuggerContextImpl debuggerContextImpl, StackFrameProxyImpl stackFrameProxyImpl) {
        PopFrameCommand popFrameCommand;
        try {
            popFrameCommand = new PopFrameCommand(debuggerContextImpl, stackFrameProxyImpl);
            if (popFrameCommand == null) {
                DebugProcessImpl.a(51);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return popFrameCommand;
    }

    @NotNull
    public DebuggerContextImpl getDebuggerContext() {
        DebuggerContextImpl debuggerContextImpl;
        try {
            debuggerContextImpl = this.mySession.getContextManager().getContext();
            if (debuggerContextImpl == null) {
                DebugProcessImpl.a(52);
            }
        }
        catch (ClassNotPreparedException classNotPreparedException) {
            throw DebugProcessImpl.b(classNotPreparedException);
        }
        return debuggerContextImpl;
    }

    public void setXDebugProcess(JavaDebugProcess javaDebugProcess) {
        this.i = javaDebugProcess;
    }

    @Nullable
    public JavaDebugProcess getXdebugProcess() {
        return this.i;
    }

    public boolean areBreakpointsMuted() {
        boolean bl2;
        block5: {
            block4: {
                XDebugSession xDebugSession = this.mySession.getXDebugSession();
                try {
                    try {
                        if (xDebugSession == null || !xDebugSession.areBreakpointsMuted()) break block4;
                    }
                    catch (ClassNotPreparedException classNotPreparedException) {
                        throw DebugProcessImpl.b(classNotPreparedException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (ClassNotPreparedException classNotPreparedException) {
                    throw DebugProcessImpl.b(classNotPreparedException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public DebuggerSession getSession() {
        return this.mySession;
    }

    static boolean isResumeOnlyCurrentThread() {
        return DebuggerSettings.getInstance().RESUME_ONLY_CURRENT_THREAD;
    }

    private static /* synthetic */ void a(StepRequest stepRequest, List list) {
        list.forEach(classFilter -> stepRequest.addClassExclusionFilter(classFilter.getPattern()));
    }

    static /* synthetic */ void access$400(DebugProcessImpl debugProcessImpl, SuspendContextImpl suspendContextImpl, Method method, boolean bl2) {
        debugProcessImpl.a(suspendContextImpl, method, bl2);
    }

    static /* synthetic */ void access$700(DebugProcessImpl debugProcessImpl, SuspendContextImpl suspendContextImpl, boolean bl2) {
        debugProcessImpl.a(suspendContextImpl, bl2);
    }

    static /* synthetic */ int access$800(SuspendContext suspendContext) {
        return DebugProcessImpl.a(suspendContext);
    }

    static /* synthetic */ int access$900() {
        return g;
    }

    static /* synthetic */ VirtualMachine access$1300(DebugProcessImpl debugProcessImpl) throws ExecutionException {
        return debugProcessImpl.d();
    }

    static /* synthetic */ RemoteConnection access$1100(DebugProcessImpl debugProcessImpl) {
        return debugProcessImpl.j;
    }

    static /* synthetic */ void access$1500(DebugProcessImpl debugProcessImpl, Runnable runnable) {
        debugProcessImpl.a(runnable);
    }

    static {
        String string = System.getProperty("idea.debugger.trace");
        int n2 = 0;
        if (!StringUtil.isEmpty((String)string)) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string2 = stringTokenizer.nextToken();
                if ("SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 1;
                    continue;
                }
                if ("RAW_SENDS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x1000000;
                    continue;
                }
                if ("RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 2;
                    continue;
                }
                if ("RAW_RECEIVES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x2000000;
                    continue;
                }
                if ("EVENTS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 4;
                    continue;
                }
                if ("REFTYPES".compareToIgnoreCase(string2) == 0) {
                    n2 |= 8;
                    continue;
                }
                if ("OBJREFS".compareToIgnoreCase(string2) == 0) {
                    n2 |= 0x10;
                    continue;
                }
                if ("ALL".compareToIgnoreCase(string2) != 0) continue;
                n2 |= 0xFFFFFF;
            }
        }
        g = n2;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }

    private class PopFrameCommand
    extends DebuggerContextCommandImpl {
        private final StackFrameProxyImpl h;

        public PopFrameCommand(DebuggerContextImpl debuggerContextImpl, StackFrameProxyImpl stackFrameProxyImpl) {
            super(debuggerContextImpl, stackFrameProxyImpl.threadProxy());
            this.h = stackFrameProxyImpl;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
            try {
                if (suspendContextImpl == null) {
                    PopFrameCommand.c(0);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw PopFrameCommand.c(objectCollectedException);
            }
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.h.threadProxy();
            try {
                if (!DebugProcessImpl.this.getSuspendManager().isSuspended(threadReferenceProxyImpl)) {
                    this.notifyCancelled();
                    return;
                }
            }
            catch (EvaluateException evaluateException) {
                throw PopFrameCommand.c((Exception)((Object)evaluateException));
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.notifyCancelled();
                return;
            }
            try {
                if (!suspendContextImpl.suspends(threadReferenceProxyImpl)) {
                    suspendContextImpl.postponeCommand(this);
                    return;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw PopFrameCommand.c(objectCollectedException);
            }
            try {
                if (this.h.isBottom()) {
                    DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.m, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.m, (String)DebuggerBundle.message((String)"error.pop.bottom.stackframe", (Object[])new Object[0]), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                    return;
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw PopFrameCommand.c(objectCollectedException);
            }
            try {
                threadReferenceProxyImpl.popFrames(this.h);
            }
            catch (EvaluateException evaluateException) {
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.m, () -> Messages.showMessageDialog((Project)DebugProcessImpl.this.m, (String)DebuggerBundle.message((String)"error.pop.stackframe", (Object[])new Object[]{evaluateException.getLocalizedMessage()}), (String)ActionsBundle.actionText((String)"Debugger.PopFrame"), (Icon)Messages.getErrorIcon()));
                u.info((Throwable)evaluateException);
            }
            finally {
                DebugProcessImpl.this.getSuspendManager().popFrame(suspendContextImpl);
            }
        }

        private static /* synthetic */ void c(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/engine/DebugProcessImpl$PopFrameCommand", "threadAction"));
        }

        private static Exception c(Exception exception) {
            return exception;
        }
    }

    private class FreezeThreadCommand
    extends DebuggerCommandImpl {
        private final ThreadReferenceProxyImpl b;

        public FreezeThreadCommand(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            this.b = threadReferenceProxyImpl;
        }

        @Override
        protected void action() throws Exception {
            SuspendManager suspendManager = DebugProcessImpl.this.getSuspendManager();
            if (!suspendManager.isFrozen(this.b)) {
                suspendManager.freezeThread(this.b);
                SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.v.pushSuspendContext(1, 0);
                suspendContextImpl.setThread(this.b.getThreadReference());
                ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
            }
        }
    }

    private class ResumeThreadCommand
    extends SuspendContextCommandImpl {
        private final ThreadReferenceProxyImpl d;

        public ResumeThreadCommand(@NotNull SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            if (threadReferenceProxyImpl == null) {
                ResumeThreadCommand.b(0);
            }
            super(suspendContextImpl);
            this.d = threadReferenceProxyImpl;
        }

        @Override
        public void contextAction() {
            Set<SuspendContextImpl> set = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), this.d);
            for (SuspendContextImpl suspendContextImpl : set) {
                block5: {
                    try {
                        try {
                            if (suspendContextImpl.getSuspendPolicy() != 1 || suspendContextImpl.getThread() != this.d) break block5;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw ResumeThreadCommand.a(illegalArgumentException);
                        }
                        DebugProcessImpl.this.getSession().getXDebugSession().sessionResumed();
                        DebugProcessImpl.this.getManagerThread().invoke(DebugProcessImpl.this.createResumeCommand(suspendContextImpl));
                        continue;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw ResumeThreadCommand.a(illegalArgumentException);
                    }
                }
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.d);
            }
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "thread", "com/intellij/debugger/engine/DebugProcessImpl$ResumeThreadCommand", "<init>"));
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }

    private class PauseCommand
    extends DebuggerCommandImpl {
        @Override
        public void action() {
            if (!DebugProcessImpl.this.isAttached() || DebugProcessImpl.this.getVirtualMachineProxy().isPausePressed()) {
                return;
            }
            DebugProcessImpl.this.logThreads();
            DebugProcessImpl.this.getVirtualMachineProxy().suspend();
            DebugProcessImpl.this.logThreads();
            SuspendContextImpl suspendContextImpl = DebugProcessImpl.this.v.pushSuspendContext(2, 0);
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).paused((SuspendContext)suspendContextImpl);
        }
    }

    public abstract class ResumeCommand
    extends SuspendContextCommandImpl {
        @Nullable
        protected final ThreadReferenceProxyImpl myContextThread;

        public ResumeCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
            ThreadReferenceProxyImpl threadReferenceProxyImpl = DebugProcessImpl.this.getDebuggerContext().getThreadProxy();
            this.myContextThread = threadReferenceProxyImpl != null ? threadReferenceProxyImpl : (suspendContextImpl != null ? suspendContextImpl.getThread() : null);
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.process.resumed", (Object[])new Object[0]));
            this.resumeAction();
            ((DebugProcessListener)DebugProcessImpl.this.myDebugProcessDispatcher.getMulticaster()).resumed((SuspendContext)this.getSuspendContext());
        }

        protected void resumeAction() {
            DebugProcessImpl.this.getSuspendManager().resume(this.getSuspendContext());
        }

        @Nullable
        public ThreadReferenceProxyImpl getContextThread() {
            return this.myContextThread;
        }

        protected void applyThreadFilter(ThreadReferenceProxy threadReferenceProxy) {
            if (this.getSuspendContext().getSuspendPolicy() == 2) {
                BreakpointManager breakpointManager = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.getProject()).getBreakpointManager();
                breakpointManager.applyThreadFilter(DebugProcessImpl.this, threadReferenceProxy.getThreadReference());
            }
        }
    }

    private abstract class StepCommand
    extends ResumeCommand {
        public StepCommand(SuspendContextImpl suspendContextImpl) {
            super(suspendContextImpl);
        }

        @Override
        protected void resumeAction() {
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            if (suspendContextImpl != null && (suspendContextImpl.getSuspendPolicy() == 1 || DebugProcessImpl.isResumeOnlyCurrentThread())) {
                DebugProcessImpl.this.r.startWatching(this.myContextThread);
            }
            if (suspendContextImpl != null && DebugProcessImpl.isResumeOnlyCurrentThread() && suspendContextImpl.getSuspendPolicy() == 2 && this.myContextThread != null) {
                DebugProcessImpl.this.getSuspendManager().resumeThread(suspendContextImpl, this.myContextThread);
            } else {
                super.resumeAction();
            }
        }
    }

    private class RunToCursorCommand
    extends StepCommand {
        private final RunToCursorBreakpoint d;
        private final boolean e;

        private RunToCursorCommand(@NotNull SuspendContextImpl suspendContextImpl, XSourcePosition xSourcePosition, boolean bl2) {
            if (xSourcePosition == null) {
                RunToCursorCommand.b(0);
            }
            super(suspendContextImpl);
            this.e = bl2;
            this.d = DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.m).getBreakpointManager().addRunToCursorBreakpoint(xSourcePosition, bl2);
        }

        @Override
        public void contextAction() {
            block11: {
                DebugProcessImpl debugProcessImpl;
                SuspendContextImpl suspendContextImpl;
                block10: {
                    String string;
                    RunToCursorBreakpoint runToCursorBreakpoint;
                    try {
                        DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.run.to.cursor", (Object[])new Object[0]));
                        DebugProcessImpl.this.cancelRunToCursorBreakpoint();
                        if (this.d == null) {
                            return;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RunToCursorCommand.a(illegalArgumentException);
                    }
                    try {
                        if (this.e) {
                            DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.m).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RunToCursorCommand.a(illegalArgumentException);
                    }
                    this.applyThreadFilter(this.getContextThread());
                    suspendContextImpl = this.getSuspendContext();
                    try {
                        runToCursorBreakpoint = this.d;
                        string = suspendContextImpl.getSuspendPolicy() == 1 ? "SuspendThread" : "SuspendAll";
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RunToCursorCommand.a(illegalArgumentException);
                    }
                    runToCursorBreakpoint.setSuspendPolicy(string);
                    debugProcessImpl = suspendContextImpl.getDebugProcess();
                    try {
                        this.d.createRequest(debugProcessImpl);
                        DebugProcessImpl.this.setRunToCursorBreakpoint(this.d);
                        if (debugProcessImpl.getRequestsManager().getWarning(this.d) != null) break block10;
                        super.contextAction();
                        break block11;
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw RunToCursorCommand.a(illegalArgumentException);
                    }
                }
                DebuggerInvocationUtil.swingInvokeLater(DebugProcessImpl.this.m, () -> {
                    Messages.showErrorDialog((String)DebuggerBundle.message((String)"error.running.to.cursor.no.executable.code", (Object[])new Object[]{this.d.getSourcePosition().getFile().getName(), this.d.getLineIndex() + 1}), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
                    DebuggerSession debuggerSession = debugProcessImpl.getSession();
                    debuggerSession.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(debuggerSession, suspendContextImpl), DebuggerSession.State.PAUSED, DebuggerSession.Event.CONTEXT, null);
                });
            }
        }

        static /* synthetic */ RunToCursorBreakpoint access$1800(RunToCursorCommand runToCursorCommand) {
            return runToCursorCommand.d;
        }

        private static /* synthetic */ void b(int n2) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "position", "com/intellij/debugger/engine/DebugProcessImpl$RunToCursorCommand", "<init>"));
        }

        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
            return illegalArgumentException;
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    public class StepOverCommand
    extends StepCommand {
        private final boolean e;
        private final int d;

        public StepOverCommand(SuspendContextImpl suspendContextImpl, boolean bl2, int n2) {
            super(suspendContextImpl);
            this.e = bl2;
            this.d = n2;
        }

        protected int getStepSize() {
            return 2;
        }

        @NotNull
        protected String getStatusText() {
            String string;
            try {
                string = DebuggerBundle.message((String)"status.step.over", (Object[])new Object[0]);
                if (string == null) {
                    StepOverCommand.b(0);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw StepOverCommand.b(illegalStateException);
            }
            return string;
        }

        @NotNull
        protected RequestHint getHint(SuspendContextImpl suspendContextImpl, ThreadReferenceProxyImpl threadReferenceProxyImpl) {
            RequestHint requestHint;
            boolean bl2;
            RequestHint requestHint2;
            RequestHint requestHint3;
            block8: {
                block7: {
                    requestHint3 = new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 2);
                    try {
                        try {
                            requestHint3.setRestoreBreakpoints(this.e);
                            requestHint2 = requestHint3;
                            if (!this.e && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters()) break block7;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw StepOverCommand.b(illegalStateException);
                        }
                        bl2 = true;
                        break block8;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw StepOverCommand.b(illegalStateException);
                    }
                }
                bl2 = false;
            }
            try {
                requestHint2.setIgnoreFilters(bl2);
                requestHint = requestHint3;
                if (requestHint == null) {
                    StepOverCommand.b(1);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw StepOverCommand.b(illegalStateException);
            }
            return requestHint;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(this.getStatusText());
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = this.getHint(suspendContextImpl, threadReferenceProxyImpl);
            this.applyThreadFilter(threadReferenceProxyImpl);
            MethodReturnValueWatcher methodReturnValueWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            try {
                if (methodReturnValueWatcher != null) {
                    methodReturnValueWatcher.enable(threadReferenceProxyImpl.getThreadReference());
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw StepOverCommand.b(illegalStateException);
            }
            try {
                DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.d, this.getStepSize(), requestHint);
                if (this.e) {
                    DebuggerManagerEx.getInstanceEx(DebugProcessImpl.access$300(DebugProcessImpl.this)).getBreakpointManager().disableBreakpoints(DebugProcessImpl.this);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw StepOverCommand.b(illegalStateException);
            }
            super.contextAction();
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void b(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalStateException b(IllegalStateException illegalStateException) {
            return illegalStateException;
        }
    }

    private class StepIntoCommand
    extends StepCommand {
        private final boolean e;
        private final MethodFilter g;
        @Nullable
        private final StepIntoBreakpoint d;
        private final int f;

        public StepIntoCommand(SuspendContextImpl suspendContextImpl, @Nullable boolean bl2, MethodFilter methodFilter, int n2) {
            super(suspendContextImpl);
            this.e = bl2 || methodFilter != null;
            this.g = methodFilter;
            this.d = methodFilter instanceof BreakpointStepMethodFilter ? DebuggerManagerEx.getInstanceEx(DebugProcessImpl.this.m).getBreakpointManager().addStepIntoBreakpoint((BreakpointStepMethodFilter)methodFilter) : null;
            this.f = n2;
        }

        /*
         * Loose catch block
         */
        @Override
        public void contextAction() {
            RequestHint requestHint;
            ThreadReferenceProxyImpl threadReferenceProxyImpl;
            SuspendContextImpl suspendContextImpl;
            block21: {
                String string;
                StepIntoBreakpoint stepIntoBreakpoint;
                block23: {
                    block22: {
                        boolean bl2;
                        RequestHint requestHint2;
                        block20: {
                            block19: {
                                block18: {
                                    boolean bl3;
                                    block17: {
                                        block16: {
                                            RequestHint requestHint3;
                                            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.into", (Object[])new Object[0]));
                                            suspendContextImpl = this.getSuspendContext();
                                            threadReferenceProxyImpl = this.getContextThread();
                                            try {
                                                requestHint3 = this.g != null ? new RequestHint(threadReferenceProxyImpl, suspendContextImpl, this.g) : new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 1);
                                            }
                                            catch (EvaluateException evaluateException) {
                                                throw StepIntoCommand.b(evaluateException);
                                            }
                                            requestHint = requestHint3;
                                            if (this.g == null) break block16;
                                            try {
                                                block24: {
                                                    if (DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters()) break block16;
                                                    break block24;
                                                    catch (EvaluateException evaluateException) {
                                                        throw StepIntoCommand.b(evaluateException);
                                                    }
                                                }
                                                bl3 = true;
                                                break block17;
                                            }
                                            catch (EvaluateException evaluateException) {
                                                throw StepIntoCommand.b(evaluateException);
                                            }
                                        }
                                        bl3 = false;
                                    }
                                    requestHint.setResetIgnoreFilters(bl3);
                                    if (!this.e) break block18;
                                    try {
                                        DebugProcessImpl.this.mySession.setIgnoreStepFiltersFlag(threadReferenceProxyImpl.frameCount());
                                    }
                                    catch (EvaluateException evaluateException) {
                                        u.info((Throwable)evaluateException);
                                    }
                                }
                                try {
                                    try {
                                        requestHint2 = requestHint;
                                        if (!this.e && !DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters()) break block19;
                                    }
                                    catch (EvaluateException evaluateException) {
                                        throw StepIntoCommand.b(evaluateException);
                                    }
                                    bl2 = true;
                                    break block20;
                                }
                                catch (EvaluateException evaluateException) {
                                    throw StepIntoCommand.b(evaluateException);
                                }
                            }
                            bl2 = false;
                        }
                        try {
                            try {
                                requestHint2.setIgnoreFilters(bl2);
                                this.applyThreadFilter(threadReferenceProxyImpl);
                                if (this.d == null) break block21;
                                stepIntoBreakpoint = this.d;
                                if (suspendContextImpl.getSuspendPolicy() != 1) break block22;
                            }
                            catch (EvaluateException evaluateException) {
                                throw StepIntoCommand.b(evaluateException);
                            }
                            string = "SuspendThread";
                            break block23;
                        }
                        catch (EvaluateException evaluateException) {
                            throw StepIntoCommand.b(evaluateException);
                        }
                    }
                    string = "SuspendAll";
                }
                stepIntoBreakpoint.setSuspendPolicy(string);
                this.d.createRequest(suspendContextImpl.getDebugProcess());
                this.d.setRequestHint(requestHint);
                DebugProcessImpl.this.setRunToCursorBreakpoint(this.d);
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.f, 1, requestHint);
            super.contextAction();
        }

        private static EvaluateException b(EvaluateException evaluateException) {
            return evaluateException;
        }
    }

    private class StepOutCommand
    extends StepCommand {
        private final int d;

        public StepOutCommand(SuspendContextImpl suspendContextImpl, int n2) {
            super(suspendContextImpl);
            this.d = n2;
        }

        @Override
        public void contextAction() {
            DebugProcessImpl.this.showStatusText(DebuggerBundle.message((String)"status.step.out", (Object[])new Object[0]));
            SuspendContextImpl suspendContextImpl = this.getSuspendContext();
            ThreadReferenceProxyImpl threadReferenceProxyImpl = this.getContextThread();
            RequestHint requestHint = new RequestHint(threadReferenceProxyImpl, suspendContextImpl, 3);
            requestHint.setIgnoreFilters(DebugProcessImpl.this.mySession.shouldIgnoreSteppingFilters());
            this.applyThreadFilter(threadReferenceProxyImpl);
            MethodReturnValueWatcher methodReturnValueWatcher = DebugProcessImpl.this.myReturnValueWatcher;
            if (methodReturnValueWatcher != null) {
                methodReturnValueWatcher.enable(threadReferenceProxyImpl.getThreadReference());
            }
            DebugProcessImpl.this.doStep(suspendContextImpl, threadReferenceProxyImpl, this.d, 3, requestHint);
            super.contextAction();
        }
    }

    protected class StopCommand
    extends DebuggerCommandImpl {
        private final boolean b;

        public StopCommand(boolean bl2) {
            this.b = bl2;
        }

        @Override
        public PrioritizedTask.Priority getPriority() {
            return PrioritizedTask.Priority.HIGH;
        }

        @Override
        protected void action() throws Exception {
            block10: {
                if (DebugProcessImpl.this.isAttached()) {
                    VirtualMachineProxyImpl virtualMachineProxyImpl;
                    block9: {
                        virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                        try {
                            if (!this.b) break block9;
                            virtualMachineProxyImpl.exit(-1);
                            break block10;
                        }
                        catch (Exception exception) {
                            throw StopCommand.b(exception);
                        }
                    }
                    try {
                        virtualMachineProxyImpl.resume();
                    }
                    finally {
                        virtualMachineProxyImpl.dispose();
                    }
                }
                try {
                    DebugProcessImpl.this.c();
                }
                finally {
                    DebugProcessImpl.this.closeProcess(true);
                }
            }
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private abstract class InvokeCommand<E extends Value> {
        private final Method b;
        private final List<Value> a;

        protected InvokeCommand(@NotNull Method method, List<? extends Value> list) {
            if (method == null) {
                InvokeCommand.a(0);
            }
            if (list == null) {
                InvokeCommand.a(1);
            }
            this.b = method;
            this.a = new ArrayList<Value>(list);
        }

        public String toString() {
            return "INVOKE: " + super.toString();
        }

        protected abstract E invokeMethod(int var1, Method var2, List<? extends Value> var3) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException;

        E start(EvaluationContextImpl evaluationContextImpl, boolean bl2) throws EvaluateException {
            while (true) {
                try {
                    return this.startInternal(evaluationContextImpl, bl2);
                }
                catch (ClassNotLoadedException classNotLoadedException) {
                    ReferenceType referenceType = null;
                    try {
                        if (evaluationContextImpl.isAutoLoadClasses()) {
                            referenceType = DebugProcessImpl.this.loadClass(evaluationContextImpl, classNotLoadedException.className(), evaluationContextImpl.getClassLoader());
                        }
                    }
                    catch (Exception exception) {
                        referenceType = null;
                    }
                    try {
                        if (referenceType != null) continue;
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)classNotLoadedException);
                    }
                    catch (ClassNotLoadedException classNotLoadedException2) {
                        throw InvokeCommand.b(classNotLoadedException2);
                    }
                }
                break;
            }
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        E startInternal(EvaluationContextImpl var1_1, boolean var2_2) throws EvaluateException, ClassNotLoadedException {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            var3_3 = var1_1.getSuspendContext();
            SuspendManagerUtil.assertSuspendContext(var3_3);
            var4_4 = var3_3.getThread();
            try {
                if (SuspendManagerUtil.isEvaluating(DebugProcessImpl.this.getSuspendManager(), var4_4)) {
                    throw EvaluateExceptionUtil.NESTED_EVALUATION_ERROR;
                }
            }
            catch (InvocationException v0) {
                throw InvokeCommand.b(v0);
            }
            try {
                if (!var3_3.suspends(var4_4)) {
                    throw EvaluateExceptionUtil.THREAD_WAS_RESUMED;
                }
            }
            catch (InvocationException v1) {
                throw InvokeCommand.b(v1);
            }
            var5_5 = SuspendManagerUtil.getSuspendingContexts(DebugProcessImpl.this.getSuspendManager(), var4_4);
            var6_6 = var4_4.getThreadReference();
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationStarted(var3_3);
            DebugProcessImpl.access$400(DebugProcessImpl.this, var3_3, this.b, var2_2);
            var7_7 = null;
            for (Object var9_10 : var5_5) {
                block41: {
                    block40: {
                        block39: {
                            var10_11 = var9_10.getThread();
                            if (var10_11 == var4_4) continue;
                            try {
                                block42: {
                                    if (!DebugProcessImpl.access$500().isDebugEnabled()) break block39;
                                    break block42;
                                    catch (InvocationException v2) {
                                        throw InvokeCommand.b(v2);
                                    }
                                }
                                DebugProcessImpl.access$500().debug("Resuming " + var4_4 + " that is paused by " + var10_11);
                            }
                            catch (InvocationException v3) {
                                throw InvokeCommand.b(v3);
                            }
                        }
                        v4 = DebugProcessImpl.access$500();
                        if (var10_11 == null) ** GOTO lbl46
                        try {
                            block43: {
                                if (var6_6.equals(var10_11.getThreadReference())) break block40;
                                break block43;
                                catch (InvocationException v5) {
                                    throw InvokeCommand.b(v5);
                                }
                            }
                            v6 = true;
                            break block41;
                        }
                        catch (InvocationException v7) {
                            throw InvokeCommand.b(v7);
                        }
                    }
                    v6 = false;
                }
                v4.assertTrue(v6);
                DebugProcessImpl.this.getSuspendManager().resumeThread((SuspendContextImpl)var9_10, var4_4);
            }
            var7_7 = SuspendManagerUtil.prepareForResume(var3_3);
            var3_3.setIsEvaluating(var1_1);
            DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
            var8_8 /* !! */  = this.a(var3_3);
            try {
                var3_3.setIsEvaluating(null);
                if (var7_7 != null) {
                    SuspendManagerUtil.restoreAfterResume(var3_3, var7_7);
                }
            }
            catch (InvocationException v8) {
                throw InvokeCommand.b(v8);
            }
            for (Object var10_11 : DebugProcessImpl.access$600(DebugProcessImpl.this).getEventContexts()) {
                block44: {
                    if (!var5_5.contains(var10_11)) continue;
                    if (var10_11.isEvaluating()) continue;
                    break block44;
                    catch (InvocationException v9) {
                        throw InvokeCommand.b(v9);
                    }
                }
                try {
                    block45: {
                        if (var10_11.suspends(var4_4)) continue;
                        break block45;
                        catch (InvocationException v10) {
                            throw InvokeCommand.b(v10);
                        }
                    }
                    DebugProcessImpl.access$600(DebugProcessImpl.this).suspendThread((SuspendContextImpl)var10_11, var4_4);
                }
                catch (InvocationException v11) {
                    throw InvokeCommand.b(v11);
                }
            }
            DebugProcessImpl.access$500().debug("getVirtualMachine().clearCaches()");
            DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
            DebugProcessImpl.access$700(DebugProcessImpl.this, var3_3, var2_2);
            ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(var3_3);
            return (E)var8_8 /* !! */ ;
            catch (IncompatibleThreadStateException | InternalException | InvalidTypeException | InvocationException | ObjectCollectedException | UnsupportedOperationException var8_9) {
                try {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)var8_9);
                }
                catch (Throwable var11_12) {
                    try {
                        var3_3.setIsEvaluating(null);
                        if (var7_7 != null) {
                            SuspendManagerUtil.restoreAfterResume(var3_3, var7_7);
                        }
                    }
                    catch (InvocationException v12) {
                        throw InvokeCommand.b(v12);
                    }
                    for (SuspendContextImpl var13_14 : DebugProcessImpl.access$600(DebugProcessImpl.this).getEventContexts()) {
                        try {
                            try {
                                try {
                                    if (!var5_5.contains((Object)var13_14) || var13_14.isEvaluating()) continue;
                                }
                                catch (InvocationException v13) {
                                    throw InvokeCommand.b(v13);
                                }
                                if (var13_14.suspends(var4_4)) continue;
                            }
                            catch (InvocationException v14) {
                                throw InvokeCommand.b(v14);
                            }
                            DebugProcessImpl.access$600(DebugProcessImpl.this).suspendThread(var13_14, var4_4);
                        }
                        catch (InvocationException v15) {
                            throw InvokeCommand.b(v15);
                        }
                    }
                    DebugProcessImpl.access$500().debug("getVirtualMachine().clearCaches()");
                    DebugProcessImpl.this.getVirtualMachineProxy().clearCaches();
                    DebugProcessImpl.access$700(DebugProcessImpl.this, var3_3, var2_2);
                    ((EvaluationListener)DebugProcessImpl.this.myEvaluationDispatcher.getMulticaster()).evaluationFinished(var3_3);
                    throw var11_12;
                }
            }
        }

        private E a(SuspendContextImpl suspendContextImpl) throws InvocationException, ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
            Value[] valueArray;
            block16: {
                Exception[] exceptionArray;
                block17: {
                    int n2 = DebugProcessImpl.access$800(suspendContextImpl);
                    exceptionArray = new Exception[1];
                    valueArray = new Value[1];
                    try {
                        try {
                            DebugProcessImpl.this.getManagerThread().startLongProcessAndFork(() -> {
                                ThreadReferenceProxyImpl threadReferenceProxyImpl = suspendContextImpl.getThread();
                                try {
                                    try {
                                        Mirror mirror;
                                        block35: {
                                            List<Object> list;
                                            Value value2;
                                            block36: {
                                                if (DebugProcessImpl.access$500().isDebugEnabled()) {
                                                    VirtualMachineProxyImpl virtualMachineProxyImpl = DebugProcessImpl.this.getVirtualMachineProxy();
                                                    virtualMachineProxyImpl.logThreads();
                                                    DebugProcessImpl.access$500().debug("Invoke in " + threadReferenceProxyImpl.name());
                                                    this.a(threadReferenceProxyImpl, suspendContextImpl);
                                                }
                                                if (!this.b.isVarArgs()) break block35;
                                                int n3 = this.b.argumentTypeNames().size() - 1;
                                                try {
                                                    if (n3 < 0 || this.a.size() <= n3) break block35;
                                                }
                                                catch (Exception exception) {
                                                    throw InvokeCommand.b(exception);
                                                }
                                                value2 = this.a.get(n3);
                                                try {
                                                    if (this.a.size() != n3 + 1) break block36;
                                                    if (!(value2 instanceof ArrayReference)) break block35;
                                                }
                                                catch (Exception exception) {
                                                    throw InvokeCommand.b(exception);
                                                }
                                                mirror = (ArrayReference)value2;
                                                if (!(((ArrayType)mirror.referenceType()).componentType() instanceof InterfaceType)) break block35;
                                                list = this.b.argumentTypeNames();
                                                if (list.size() <= n3) break block35;
                                                try {
                                                    block38: {
                                                        if (!((String)list.get(n3)).startsWith("java.lang.Object")) break block35;
                                                        break block38;
                                                        catch (Exception exception) {
                                                            throw InvokeCommand.b(exception);
                                                        }
                                                    }
                                                    this.a.remove(n3);
                                                    this.a.addAll(mirror.getValues());
                                                    break block35;
                                                }
                                                catch (Exception exception) {
                                                    throw InvokeCommand.b(exception);
                                                }
                                            }
                                            if (value2 == null) {
                                                int n4 = this.a.size();
                                                list = this.b.argumentTypes();
                                                int n5 = list.size();
                                                ArrayType arrayType = (ArrayType)list.get(list.size() - 1);
                                                int n6 = n4 - n5 + 1;
                                                ArrayReference arrayReference = arrayType.newInstance(n6);
                                                arrayReference.setValues(0, this.a, n5 - 1, n6);
                                                this.a.set(n5 - 1, arrayReference);
                                                this.a.subList(n5, n4).clear();
                                            }
                                        }
                                        for (Value value2 : this.a) {
                                            if (!(value2 instanceof ArrayReference)) continue;
                                            mirror = value2.type();
                                            while (mirror instanceof ArrayType) {
                                                mirror = ((ArrayType)mirror).componentType();
                                            }
                                        }
                                        try {
                                            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                                                StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::disableCollection);
                                            }
                                        }
                                        catch (Exception exception) {
                                            throw InvokeCommand.b(exception);
                                        }
                                        try {
                                            if ((DebugProcessImpl.access$900() & 1) != 0) {
                                                this.a.forEach(Object::toString);
                                            }
                                        }
                                        catch (Exception exception) {
                                            throw InvokeCommand.b(exception);
                                        }
                                        try {
                                            if ((DebugProcessImpl.access$900() & 1) != 0) {
                                                StreamEx.of(this.a).findAny(ThreadReference.class::isInstance).ifPresent(value -> {
                                                    System.err.println("[JDI: workaround for invocation of " + this.b + "]");
                                                    this.b.virtualMachine().setDebugTraceMode(DebugProcessImpl.access$900() & 0xFFFFFFFE);
                                                });
                                            }
                                        }
                                        catch (Exception exception) {
                                            throw InvokeCommand.b(exception);
                                        }
                                        valueArray[0] = this.invokeMethod(n2, this.b, this.a);
                                    }
                                    catch (Throwable throwable) {
                                        try {
                                            if ((DebugProcessImpl.access$900() & 1) != 0) {
                                                this.b.virtualMachine().setDebugTraceMode(DebugProcessImpl.access$900());
                                            }
                                        }
                                        catch (Exception exception) {
                                            throw InvokeCommand.b(exception);
                                        }
                                        try {
                                            if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                                                StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::enableCollection);
                                            }
                                        }
                                        catch (Exception exception) {
                                            throw InvokeCommand.b(exception);
                                        }
                                        throw throwable;
                                    }
                                    if ((DebugProcessImpl.access$900() & 1) != 0) {
                                        this.b.virtualMachine().setDebugTraceMode(DebugProcessImpl.access$900());
                                    }
                                    try {
                                        if (!Patches.IBM_JDK_DISABLE_COLLECTION_BUG) {
                                            StreamEx.of(this.a).select(ObjectReference.class).forEach(DebuggerUtilsEx::enableCollection);
                                        }
                                    }
                                    catch (Exception exception) {
                                        throw InvokeCommand.b(exception);
                                    }
                                }
                                catch (Exception exception) {
                                    exceptionArray[0] = exception;
                                }
                            });
                            if (exceptionArray[0] == null) break block16;
                            if (!(exceptionArray[0] instanceof InvocationException)) break block17;
                        }
                        catch (InvocationException invocationException) {
                            throw InvokeCommand.b(invocationException);
                        }
                        throw (InvocationException)exceptionArray[0];
                    }
                    catch (InvocationException invocationException) {
                        throw InvokeCommand.b(invocationException);
                    }
                }
                try {
                    if (exceptionArray[0] instanceof ClassNotLoadedException) {
                        throw (ClassNotLoadedException)exceptionArray[0];
                    }
                }
                catch (InvocationException invocationException) {
                    throw InvokeCommand.b(invocationException);
                }
                try {
                    if (exceptionArray[0] instanceof IncompatibleThreadStateException) {
                        throw (IncompatibleThreadStateException)exceptionArray[0];
                    }
                }
                catch (InvocationException invocationException) {
                    throw InvokeCommand.b(invocationException);
                }
                try {
                    if (exceptionArray[0] instanceof InvalidTypeException) {
                        throw (InvalidTypeException)exceptionArray[0];
                    }
                }
                catch (InvocationException invocationException) {
                    throw InvokeCommand.b(invocationException);
                }
                try {
                    if (exceptionArray[0] instanceof RuntimeException) {
                        throw (RuntimeException)exceptionArray[0];
                    }
                }
                catch (InvocationException invocationException) {
                    throw InvokeCommand.b(invocationException);
                }
                DebugProcessImpl.access$500().error("Unexpected exception", new Throwable().initCause(exceptionArray[0]));
            }
            return (E)valueArray[0];
        }

        private void a(ThreadReferenceProxyImpl threadReferenceProxyImpl, SuspendContextImpl suspendContextImpl) {
            DebugProcessImpl.access$500().assertTrue(suspendContextImpl.isEvaluating());
            try {
                boolean bl2 = threadReferenceProxyImpl.isSuspended();
                DebugProcessImpl.access$500().assertTrue(bl2, (Object)threadReferenceProxyImpl);
            }
            catch (ObjectCollectedException objectCollectedException) {
                // empty catch block
            }
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void a(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }

    static enum State {
        INITIAL,
        ATTACHED,
        DETACHING,
        DETACHED;

    }
}

