/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine;

import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiStatement;
import com.intellij.util.Range;
import com.sun.jdi.Location;
import com.sun.jdi.Method;
import org.jetbrains.annotations.Nullable;

public class LambdaMethodFilter
implements BreakpointStepMethodFilter {
    private final int d;
    @Nullable
    private final SourcePosition b;
    private final int a;
    private final Range<Integer> c;

    public LambdaMethodFilter(PsiLambdaExpression psiLambdaExpression, int n2, Range<Integer> range) {
        this.d = n2;
        this.c = range;
        SourcePosition sourcePosition = null;
        SourcePosition sourcePosition2 = null;
        PsiElement psiElement = psiLambdaExpression.getBody();
        if (psiElement instanceof PsiCodeBlock) {
            PsiStatement[] psiStatementArray = ((PsiCodeBlock)psiElement).getStatements();
            if (psiStatementArray.length > 0 && (sourcePosition = SourcePosition.createFromElement((PsiElement)psiStatementArray[0])) != null) {
                PsiStatement psiStatement = psiStatementArray[psiStatementArray.length - 1];
                sourcePosition2 = SourcePosition.createFromOffset((PsiFile)sourcePosition.getFile(), (int)psiStatement.getTextRange().getEndOffset());
            }
        } else if (psiElement != null) {
            sourcePosition = SourcePosition.createFromElement((PsiElement)psiElement);
        }
        this.b = sourcePosition;
        this.a = sourcePosition2 != null ? sourcePosition2.getLine() : -1;
    }

    public int getLambdaOrdinal() {
        return this.d;
    }

    @Override
    @Nullable
    public SourcePosition getBreakpointPosition() {
        return this.b;
    }

    @Override
    public int getLastStatementLine() {
        return this.a;
    }

    @Override
    public boolean locationMatches(DebugProcessImpl debugProcessImpl, Location location) throws EvaluateException {
        boolean bl2;
        block8: {
            block6: {
                VirtualMachineProxyImpl virtualMachineProxyImpl = debugProcessImpl.getVirtualMachineProxy();
                Method method = location.method();
                try {
                    block7: {
                        try {
                            try {
                                if (!DebuggerUtilsEx.isLambda(method)) break block6;
                                if (!virtualMachineProxyImpl.canGetSyntheticAttribute()) break block7;
                            }
                            catch (EvaluateException evaluateException) {
                                throw LambdaMethodFilter.c(evaluateException);
                            }
                            if (!method.isSynthetic()) break block6;
                        }
                        catch (EvaluateException evaluateException) {
                            throw LambdaMethodFilter.c(evaluateException);
                        }
                    }
                    bl2 = true;
                    break block8;
                }
                catch (EvaluateException evaluateException) {
                    throw LambdaMethodFilter.c(evaluateException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    @Override
    @Nullable
    public Range<Integer> getCallingExpressionLines() {
        return this.c;
    }

    private static EvaluateException c(EvaluateException evaluateException) {
        return evaluateException;
    }
}

