/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation;

import com.intellij.codeInsight.completion.CompletionService;
import com.intellij.codeInsight.completion.JavaCompletionUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.codeinsight.RuntimeTypeEvaluator;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.DebuggerExpressionComboBox;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.concurrency.Semaphore;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultCodeFragmentFactory
extends CodeFragmentFactory {
    public static final Key<String> KEY = Key.create((String)"DefaultCodeFragmentFactory.KEY");

    public static DefaultCodeFragmentFactory getInstance() {
        return SingletonHolder.ourInstance;
    }

    public JavaCodeFragment createPresentationCodeFragment(TextWithImports textWithImports, PsiElement psiElement, Project project2) {
        return this.createCodeFragment(textWithImports, psiElement, project2);
    }

    public JavaCodeFragment createCodeFragment(TextWithImports textWithImports, PsiElement psiElement, Project project2) {
        JavaCodeFragmentFactory javaCodeFragmentFactory = JavaCodeFragmentFactory.getInstance((Project)project2);
        String string = textWithImports.getText();
        JavaCodeFragment javaCodeFragment = null;
        if (CodeFragmentKind.EXPRESSION == textWithImports.getKind()) {
            try {
                String string2 = StringUtil.trimTrailing((String)string, (char)';');
                try {
                    if (!string2.isEmpty()) {
                        JavaPsiFacade.getElementFactory((Project)project2).createExpressionFromText(string2, psiElement);
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                }
                javaCodeFragment = javaCodeFragmentFactory.createExpressionCodeFragment(string2, psiElement, null, true);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                // empty catch block
            }
        }
        if (javaCodeFragment == null) {
            javaCodeFragment = javaCodeFragmentFactory.createCodeBlockCodeFragment(string, psiElement, true);
        }
        try {
            if (textWithImports.getImports().length() > 0) {
                javaCodeFragment.addImportsFromString(textWithImports.getImports());
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw DefaultCodeFragmentFactory.b(incorrectOperationException);
        }
        javaCodeFragment.setVisibilityChecker(JavaCodeFragment.VisibilityChecker.EVERYTHING_VISIBLE);
        javaCodeFragment.putUserData(KEY, (Object)"DebuggerComboBoxEditor.IS_DEBUGGER_EDITOR");
        javaCodeFragment.putCopyableUserData(JavaCompletionUtil.DYNAMIC_TYPE_EVALUATOR, (psiExpression, completionParameters) -> {
            block17: {
                block16: {
                    try {
                        if (!RuntimeTypeEvaluator.isSubtypeable(psiExpression)) {
                            return null;
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                    }
                    try {
                        if (completionParameters.getInvocationCount() > 1 || !JavaCompletionUtil.mayHaveSideEffects((PsiElement)psiExpression)) break block16;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                    }
                    CompletionService completionService = CompletionService.getCompletionService();
                    try {
                        if (completionParameters.getInvocationCount() < 2) {
                            completionService.setAdvertisementText("Invoke completion once more to see runtime type variants");
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                    }
                    return null;
                }
                DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
                DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
                try {
                    if (debuggerSession == null || debuggerContextImpl.getSuspendContext() == null) break block17;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                }
                final Semaphore semaphore = new Semaphore();
                semaphore.down();
                final AtomicReference atomicReference = new AtomicReference();
                RuntimeTypeEvaluator runtimeTypeEvaluator = new RuntimeTypeEvaluator(null, (PsiElement)psiExpression, debuggerContextImpl, ProgressManager.getInstance().getProgressIndicator()){

                    @Override
                    protected void typeCalculationFinished(@Nullable PsiType psiType) {
                        atomicReference.set(psiType);
                        semaphore.up();
                    }
                };
                debuggerSession.getProcess().getManagerThread().invoke(runtimeTypeEvaluator);
                int n2 = 0;
                while (true) {
                    try {
                        try {
                            if (n2 >= 50) break;
                            ProgressManager.checkCanceled();
                            if (semaphore.waitFor(20L)) {
                                break;
                            }
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                        }
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                    }
                    ++n2;
                }
                return (PsiType)atomicReference.get();
            }
            return null;
        });
        return javaCodeFragment;
    }

    public boolean isContextAccepted(PsiElement psiElement) {
        return true;
    }

    @NotNull
    public LanguageFileType getFileType() {
        LanguageFileType languageFileType;
        try {
            languageFileType = StdFileTypes.JAVA;
            if (languageFileType == null) {
                DefaultCodeFragmentFactory.a(0);
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw DefaultCodeFragmentFactory.b(incorrectOperationException);
        }
        return languageFileType;
    }

    public EvaluatorBuilder getEvaluatorBuilder() {
        return EvaluatorBuilderImpl.getInstance();
    }

    public static boolean isDebuggerFile(PsiFile psiFile) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (psiFile.getUserData(KEY) == null && psiFile.getUserData(DebuggerExpressionComboBox.KEY) == null) break block4;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw DefaultCodeFragmentFactory.b(incorrectOperationException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/engine/evaluation/DefaultCodeFragmentFactory", "getFileType"));
    }

    private static IncorrectOperationException b(IncorrectOperationException incorrectOperationException) {
        return incorrectOperationException;
    }

    private static final class SingletonHolder {
        public static final DefaultCodeFragmentFactory ourInstance = new DefaultCodeFragmentFactory();

        private SingletonHolder() {
        }
    }
}

