/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.evaluation.expression;

import com.intellij.codeInsight.daemon.JavaErrorMessages;
import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.analysis.HighlightUtil;
import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactoryContextWrapper;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluateRuntimeException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.expression.ArrayAccessEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ArrayInitializerEvaluator;
import com.intellij.debugger.engine.evaluation.expression.AssignmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BinaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BlockStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.BreakContinueStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CatchEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ClassObjectEvaluator;
import com.intellij.debugger.engine.evaluation.expression.CodeFragmentEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ConditionalExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.DisableGC;
import com.intellij.debugger.engine.evaluation.expression.DoWhileStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Evaluator;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilder;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluatorImpl;
import com.intellij.debugger.engine.evaluation.expression.FieldEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ForeachStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IdentityEvaluator;
import com.intellij.debugger.engine.evaluation.expression.IfStatementEvaluator;
import com.intellij.debugger.engine.evaluation.expression.InstanceofEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LiteralEvaluator;
import com.intellij.debugger.engine.evaluation.expression.LocalVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.MethodEvaluator;
import com.intellij.debugger.engine.evaluation.expression.Modifier;
import com.intellij.debugger.engine.evaluation.expression.NewArrayInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.NewClassInstanceEvaluator;
import com.intellij.debugger.engine.evaluation.expression.PostfixOperationEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ReturnEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SuperEvaluator;
import com.intellij.debugger.engine.evaluation.expression.SyntheticVariableEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThisEvaluator;
import com.intellij.debugger.engine.evaluation.expression.ThrowEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TryEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeCastEvaluator;
import com.intellij.debugger.engine.evaluation.expression.TypeEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnBoxingEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnaryExpressionEvaluator;
import com.intellij.debugger.engine.evaluation.expression.UnsupportedExpressionException;
import com.intellij.debugger.engine.evaluation.expression.WhileStatementEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiCodeFragment;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.impl.JavaConstantExpressionEvaluator;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiTypesUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class EvaluatorBuilderImpl
implements EvaluatorBuilder {
    private static final EvaluatorBuilderImpl a = new EvaluatorBuilderImpl();

    private EvaluatorBuilderImpl() {
    }

    public static EvaluatorBuilder getInstance() {
        return a;
    }

    public static ExpressionEvaluator build(TextWithImports textWithImports, @Nullable PsiElement psiElement, @Nullable SourcePosition sourcePosition, @NotNull Project project2) throws EvaluateException {
        try {
            if (project2 == null) {
                EvaluatorBuilderImpl.a(0);
            }
        }
        catch (EvaluateException evaluateException) {
            throw EvaluatorBuilderImpl.b((Exception)((Object)evaluateException));
        }
        CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImports, psiElement);
        JavaCodeFragment javaCodeFragment = codeFragmentFactory.createCodeFragment(textWithImports, psiElement, project2);
        try {
            if (javaCodeFragment == null) {
                throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{textWithImports.getText()}));
            }
        }
        catch (EvaluateException evaluateException) {
            throw EvaluatorBuilderImpl.b((Exception)((Object)evaluateException));
        }
        DebuggerUtils.checkSyntax((PsiCodeFragment)javaCodeFragment);
        return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, sourcePosition);
    }

    public ExpressionEvaluator build(PsiElement psiElement, SourcePosition sourcePosition) throws EvaluateException {
        return new Builder(sourcePosition).buildElement(psiElement);
    }

    private static void a(PsiParameter[] psiParameterArray, PsiExpression[] psiExpressionArray, PsiSubstitutor psiSubstitutor, Evaluator[] evaluatorArray) {
        if (psiParameterArray.length > 0) {
            int n2 = Math.max(psiParameterArray.length, psiExpressionArray.length);
            PsiType psiType = null;
            int n3 = 0;
            while (true) {
                PsiType psiType2;
                PsiType psiType3;
                try {
                    try {
                        if (n3 >= n2 || n3 >= psiExpressionArray.length) {
                            break;
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw EvaluatorBuilderImpl.b(illegalArgumentException);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw EvaluatorBuilderImpl.b(illegalArgumentException);
                }
                if (n3 < psiParameterArray.length) {
                    psiType3 = psiSubstitutor.substitute(psiParameterArray[n3].getType());
                    if (psiType3 instanceof PsiEllipsisType) {
                        psiType3 = psiType = ((PsiEllipsisType)psiType3).getComponentType();
                    }
                } else {
                    if (psiType == null) break;
                    psiType3 = psiType;
                }
                if (TypeConversionUtil.boxingConversionApplicable((PsiType)psiType3, (PsiType)(psiType2 = psiExpressionArray[n3].getType()))) {
                    Evaluator evaluator;
                    Evaluator evaluator2 = evaluatorArray[n3];
                    try {
                        Evaluator[] evaluatorArray2 = evaluatorArray;
                        int n4 = n3;
                        evaluator = psiType3 instanceof PsiPrimitiveType ? new UnBoxingEvaluator(evaluator2) : new BoxingEvaluator(evaluator2);
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw EvaluatorBuilderImpl.b(illegalArgumentException);
                    }
                    evaluatorArray2[n4] = evaluator;
                }
                ++n3;
            }
        }
    }

    static /* synthetic */ void access$100(PsiParameter[] psiParameterArray, PsiExpression[] psiExpressionArray, PsiSubstitutor psiSubstitutor, Evaluator[] evaluatorArray) {
        EvaluatorBuilderImpl.a(psiParameterArray, psiExpressionArray, psiSubstitutor, evaluatorArray);
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/engine/evaluation/expression/EvaluatorBuilderImpl", "build"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private static class Builder
    extends JavaElementVisitor {
        private static final Logger a = Logger.getInstance((String)"#com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl");
        private Evaluator e = null;
        private PsiClass b;
        private CodeFragmentEvaluator f;
        private final Set<JavaCodeFragment> c = new HashSet<JavaCodeFragment>();
        @Nullable
        private final SourcePosition d;

        private Builder(@Nullable SourcePosition sourcePosition) {
            this.d = sourcePosition;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void visitCodeFragment(JavaCodeFragment javaCodeFragment) {
            this.c.add(javaCodeFragment);
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            CodeFragmentEvaluator codeFragmentEvaluator = this.a();
            try {
                PsiElement psiElement = javaCodeFragment.getFirstChild();
                while (true) {
                    block8: {
                        if (psiElement == null) break;
                        try {
                            block10: {
                                psiElement.accept((PsiElementVisitor)this);
                                if (this.e == null) break block8;
                                break block10;
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                            }
                            arrayList.add(this.e);
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                    }
                    this.e = null;
                    psiElement = psiElement.getNextSibling();
                }
                this.f.setStatements(arrayList.toArray(new Evaluator[arrayList.size()]));
                this.e = this.f;
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        public void visitErrorElement(PsiErrorElement psiErrorElement) {
            Builder.a((PsiElement)psiErrorElement);
        }

        public void visitAssignmentExpression(PsiAssignmentExpression psiAssignmentExpression) {
            PsiType psiType;
            IElementType iElementType;
            PsiType psiType2;
            PsiExpression psiExpression;
            Evaluator evaluator;
            block15: {
                PsiExpression psiExpression2 = psiAssignmentExpression.getRExpression();
                try {
                    if (psiExpression2 == null) {
                        Builder.a((PsiElement)psiAssignmentExpression);
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                psiExpression2.accept((PsiElementVisitor)this);
                evaluator = this.e;
                psiExpression = psiAssignmentExpression.getLExpression();
                psiType2 = psiExpression.getType();
                try {
                    if (psiType2 == null) {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression.getText()}));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                iElementType = psiAssignmentExpression.getOperationTokenType();
                psiType = psiExpression2.getType();
                try {
                    try {
                        if (TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType2, (PsiExpression)psiExpression2) || psiType == null) break block15;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.types", (Object[])new Object[]{psiAssignmentExpression.getOperationSign().getText()}));
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.e;
            evaluator = Builder.a(psiType2, psiType, evaluator);
            if (iElementType != JavaTokenType.EQ) {
                PsiType psiType3;
                IElementType iElementType2;
                block16: {
                    iElementType2 = TypeConversionUtil.convertEQtoOperation((IElementType)iElementType);
                    psiType3 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType2, (PsiType)psiType, (IElementType)iElementType2, (boolean)true);
                    try {
                        try {
                            if (psiType3 != null && psiType != null) break block16;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiAssignmentExpression.getText()}));
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                evaluator = Builder.a(evaluator2, psiType2, evaluator, psiType, iElementType2, psiType3);
            }
            this.e = new AssignmentEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, PsiType psiType2, Evaluator evaluator) {
            block15: {
                Object object;
                block17: {
                    block14: {
                        block16: {
                            PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
                            try {
                                try {
                                    try {
                                        if (psiPrimitiveType == null) break block14;
                                        if (!(psiType2 instanceof PsiPrimitiveType)) break block15;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    if (PsiType.NULL.equals((Object)psiType2)) break block15;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                if (psiType2.equals(psiPrimitiveType)) break block16;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                            evaluator = new TypeCastEvaluator(evaluator, psiPrimitiveType.getCanonicalText(), true);
                        }
                        evaluator = new BoxingEvaluator(evaluator);
                        break block15;
                    }
                    try {
                        if (!(psiType instanceof PsiPrimitiveType)) break block15;
                        if (!(psiType2 instanceof PsiClassType)) break block17;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    evaluator = new UnBoxingEvaluator(evaluator);
                }
                PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
                try {
                    object = psiPrimitiveType != null ? psiPrimitiveType : psiType2;
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                PsiPrimitiveType psiPrimitiveType2 = object;
                try {
                    try {
                        if (!(psiPrimitiveType2 instanceof PsiPrimitiveType) || PsiType.NULL.equals((Object)psiPrimitiveType2)) break block15;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    if (psiType.equals(psiPrimitiveType2)) break block15;
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                evaluator = new TypeCastEvaluator(evaluator, psiType.getCanonicalText(), true);
            }
            return evaluator;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitTryStatement(PsiTryStatement psiTryStatement) {
            try {
                if (psiTryStatement.getResourceList() != null) {
                    throw new EvaluateRuntimeException(new UnsupportedExpressionException("Try with resources is not yet supported"));
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            Evaluator evaluator = this.c((PsiElement)psiTryStatement.getTryBlock());
            if (evaluator != null) {
                PsiCatchSection[] psiCatchSectionArray = psiTryStatement.getCatchSections();
                ArrayList<CatchEvaluator> arrayList = new ArrayList<CatchEvaluator>();
                for (PsiCatchSection psiCatchSection : psiCatchSectionArray) {
                    PsiParameter psiParameter = psiCatchSection.getParameter();
                    PsiCodeBlock psiCodeBlock = psiCatchSection.getCatchBlock();
                    try {
                        if (psiParameter == null || psiCodeBlock == null) continue;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    CodeFragmentEvaluator codeFragmentEvaluator = this.a();
                    try {
                        List list;
                        this.f.setInitialValue(psiParameter.getName(), null);
                        this.f.setStatements(this.a(psiCodeBlock.getStatements()));
                        PsiType psiType = psiParameter.getType();
                        try {
                            list = psiType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)psiType).getDisjunctions() : Collections.singletonList(psiType);
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        List list2 = list;
                        for (PsiType psiType2 : list2) {
                            arrayList.add(new CatchEvaluator(psiType2.getCanonicalText(), psiParameter.getName(), this.f));
                        }
                    }
                    finally {
                        this.f = codeFragmentEvaluator;
                    }
                }
                this.e = new TryEvaluator(evaluator, arrayList, this.c((PsiElement)psiTryStatement.getFinallyBlock()));
            }
        }

        public void visitThrowStatement(PsiThrowStatement psiThrowStatement) {
            Evaluator evaluator = this.c((PsiElement)psiThrowStatement.getException());
            try {
                if (evaluator != null) {
                    this.e = new ThrowEvaluator(evaluator);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        public void visitReturnStatement(PsiReturnStatement psiReturnStatement) {
            this.e = new ReturnEvaluator(this.c((PsiElement)psiReturnStatement.getReturnValue()));
        }

        public void visitStatement(PsiStatement psiStatement) {
            Builder.a(DebuggerBundle.message((String)"evaluation.error.statement.not.supported", (Object[])new Object[]{psiStatement.getText()}));
        }

        private CodeFragmentEvaluator a() {
            CodeFragmentEvaluator codeFragmentEvaluator = this.f;
            this.f = new CodeFragmentEvaluator(this.f);
            return codeFragmentEvaluator;
        }

        private Evaluator[] a(PsiStatement[] psiStatementArray) {
            ArrayList<Evaluator> arrayList = new ArrayList<Evaluator>();
            for (PsiStatement psiStatement : psiStatementArray) {
                try {
                    psiStatement.accept((PsiElementVisitor)this);
                    if (this.e != null) {
                        arrayList.add(DisableGC.create(this.e));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                this.e = null;
            }
            return arrayList.toArray(new Evaluator[0]);
        }

        public void visitCodeBlock(PsiCodeBlock psiCodeBlock) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.a();
            try {
                this.e = new BlockStatementEvaluator(this.a(psiCodeBlock.getStatements()));
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        public void visitBlockStatement(PsiBlockStatement psiBlockStatement) {
            this.visitCodeBlock(psiBlockStatement.getCodeBlock());
        }

        public void visitLabeledStatement(PsiLabeledStatement psiLabeledStatement) {
            PsiStatement psiStatement = psiLabeledStatement.getStatement();
            try {
                if (psiStatement != null) {
                    psiStatement.accept((PsiElementVisitor)this);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        private static String b(PsiElement psiElement) {
            String string = null;
            if (psiElement.getParent() instanceof PsiLabeledStatement) {
                string = ((PsiLabeledStatement)psiElement.getParent()).getName();
            }
            return string;
        }

        public void visitDoWhileStatement(PsiDoWhileStatement psiDoWhileStatement) {
            Evaluator evaluator = this.c((PsiElement)psiDoWhileStatement.getBody());
            Evaluator evaluator2 = this.c((PsiElement)psiDoWhileStatement.getCondition());
            try {
                if (evaluator2 != null) {
                    this.e = new DoWhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.b((PsiElement)psiDoWhileStatement));
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        public void visitWhileStatement(PsiWhileStatement psiWhileStatement) {
            Evaluator evaluator = this.c((PsiElement)psiWhileStatement.getBody());
            Evaluator evaluator2 = this.c((PsiElement)psiWhileStatement.getCondition());
            try {
                if (evaluator2 != null) {
                    this.e = new WhileStatementEvaluator(new UnBoxingEvaluator(evaluator2), evaluator, Builder.b((PsiElement)psiWhileStatement));
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForStatement(PsiForStatement psiForStatement) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.a();
            try {
                Evaluator evaluator = this.c((PsiElement)psiForStatement.getInitialization());
                Evaluator evaluator2 = this.c((PsiElement)psiForStatement.getCondition());
                if (evaluator2 != null) {
                    evaluator2 = new UnBoxingEvaluator(evaluator2);
                }
                Evaluator evaluator3 = this.c((PsiElement)psiForStatement.getUpdate());
                Evaluator evaluator4 = this.c((PsiElement)psiForStatement.getBody());
                try {
                    if (evaluator4 != null) {
                        this.e = new ForStatementEvaluator(evaluator, evaluator2, evaluator3, evaluator4, Builder.b((PsiElement)psiForStatement));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void visitForeachStatement(PsiForeachStatement psiForeachStatement) {
            CodeFragmentEvaluator codeFragmentEvaluator = this.a();
            try {
                String string = psiForeachStatement.getIterationParameter().getName();
                this.f.setInitialValue(string, null);
                SyntheticVariableEvaluator syntheticVariableEvaluator = new SyntheticVariableEvaluator(this.f, string);
                Evaluator evaluator = this.c((PsiElement)psiForeachStatement.getIteratedValue());
                Evaluator evaluator2 = this.c((PsiElement)psiForeachStatement.getBody());
                try {
                    if (evaluator2 != null) {
                        this.e = new ForeachStatementEvaluator(syntheticVariableEvaluator, evaluator, evaluator2, Builder.b((PsiElement)psiForeachStatement));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            finally {
                this.f = codeFragmentEvaluator;
            }
        }

        @Nullable
        private Evaluator c(@Nullable PsiElement psiElement) {
            block4: {
                try {
                    try {
                        if (psiElement != null && !(psiElement instanceof PsiEmptyStatement)) break block4;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    return null;
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            psiElement.accept((PsiElementVisitor)this);
            return this.e;
        }

        public void visitIfStatement(PsiIfStatement psiIfStatement) {
            PsiStatement psiStatement = psiIfStatement.getThenBranch();
            try {
                if (psiStatement == null) {
                    return;
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            psiStatement.accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiStatement psiStatement2 = psiIfStatement.getElseBranch();
            Evaluator evaluator2 = null;
            if (psiStatement2 != null) {
                psiStatement2.accept((PsiElementVisitor)this);
                evaluator2 = this.e;
            }
            PsiExpression psiExpression = psiIfStatement.getCondition();
            try {
                if (psiExpression == null) {
                    return;
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            psiExpression.accept((PsiElementVisitor)this);
            this.e = new IfStatementEvaluator(new UnBoxingEvaluator(this.e), evaluator, evaluator2);
        }

        public void visitBreakStatement(PsiBreakStatement psiBreakStatement) {
            String string;
            PsiIdentifier psiIdentifier = psiBreakStatement.getLabelIdentifier();
            try {
                Builder builder2 = this;
                string = psiIdentifier != null ? psiIdentifier.getText() : null;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            builder2.e = BreakContinueStatementEvaluator.createBreakEvaluator(string);
        }

        public void visitContinueStatement(PsiContinueStatement psiContinueStatement) {
            String string;
            PsiIdentifier psiIdentifier = psiContinueStatement.getLabelIdentifier();
            try {
                Builder builder2 = this;
                string = psiIdentifier != null ? psiIdentifier.getText() : null;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            builder2.e = BreakContinueStatementEvaluator.createContinueEvaluator(string);
        }

        public void visitExpressionStatement(PsiExpressionStatement psiExpressionStatement) {
            psiExpressionStatement.getExpression().accept((PsiElementVisitor)this);
        }

        public void visitExpression(PsiExpression psiExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitExpression " + psiExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        public void visitPolyadicExpression(PsiPolyadicExpression psiPolyadicExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitPolyadicExpression " + psiPolyadicExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiExpression[] psiExpressionArray = psiPolyadicExpression.getOperands();
            psiExpressionArray[0].accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            PsiType psiType = psiExpressionArray[0].getType();
            for (int i2 = 1; i2 < psiExpressionArray.length; ++i2) {
                PsiExpression psiExpression = psiExpressionArray[i2];
                try {
                    if (psiExpression == null) {
                        Builder.a((PsiElement)psiPolyadicExpression);
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                psiExpression.accept((PsiElementVisitor)this);
                Evaluator evaluator2 = this.e;
                IElementType iElementType = psiPolyadicExpression.getOperationTokenType();
                PsiType psiType2 = psiExpression.getType();
                try {
                    if (psiType2 == null) {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiExpression.getText()}));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                PsiType psiType3 = TypeConversionUtil.calcTypeForBinaryExpression((PsiType)psiType, (PsiType)psiType2, (IElementType)iElementType, (boolean)true);
                try {
                    if (psiType3 == null) {
                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPolyadicExpression.getText()}));
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                this.e = Builder.a(evaluator, psiType, evaluator2, psiType2, iElementType, psiType3);
                psiType = psiType3;
                evaluator = this.e;
            }
        }

        private static Evaluator a(Evaluator evaluator, PsiType psiType, Evaluator evaluator2, @NotNull PsiType psiType2, @NotNull IElementType iElementType, @NotNull PsiType psiType3) {
            block40: {
                block47: {
                    block48: {
                        PsiType psiType4;
                        block46: {
                            PsiType psiType5;
                            block45: {
                                block44: {
                                    block43: {
                                        block42: {
                                            block41: {
                                                block39: {
                                                    block37: {
                                                        block38: {
                                                            try {
                                                                if (psiType2 == null) {
                                                                    Builder.a(0);
                                                                }
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            try {
                                                                if (iElementType == null) {
                                                                    Builder.a(1);
                                                                }
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            try {
                                                                if (psiType3 == null) {
                                                                    Builder.a(2);
                                                                }
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            try {
                                                                try {
                                                                    if (!Builder.a(psiType, psiType2, iElementType)) break block37;
                                                                    if (!(psiType2 instanceof PsiClassType)) break block38;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                                if (!UnBoxingEvaluator.isTypeUnboxable(psiType2.getCanonicalText())) break block38;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            evaluator2 = new UnBoxingEvaluator(evaluator2);
                                                        }
                                                        try {
                                                            if (!(psiType instanceof PsiClassType) || !UnBoxingEvaluator.isTypeUnboxable(psiType.getCanonicalText())) break block37;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                        evaluator = new UnBoxingEvaluator(evaluator);
                                                    }
                                                    if (!Builder.b(psiType, psiType2, iElementType)) break block48;
                                                    psiType5 = psiType;
                                                    PsiPrimitiveType psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
                                                    if (psiPrimitiveType != null) {
                                                        psiType5 = psiPrimitiveType;
                                                    }
                                                    psiType4 = psiType2;
                                                    PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
                                                    if (psiPrimitiveType2 != null) {
                                                        psiType4 = psiPrimitiveType2;
                                                    }
                                                    try {
                                                        if (!PsiType.DOUBLE.equals((Object)psiType5)) break block39;
                                                        if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.DOUBLE)) break block40;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                    evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.DOUBLE.getCanonicalText(), true);
                                                    break block40;
                                                }
                                                try {
                                                    if (!PsiType.DOUBLE.equals((Object)psiType4)) break block41;
                                                    if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.DOUBLE)) break block40;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                evaluator = new TypeCastEvaluator(evaluator, PsiType.DOUBLE.getCanonicalText(), true);
                                                break block40;
                                            }
                                            try {
                                                if (!PsiType.FLOAT.equals((Object)psiType5)) break block42;
                                                if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.FLOAT)) break block40;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.FLOAT.getCanonicalText(), true);
                                            break block40;
                                        }
                                        try {
                                            if (!PsiType.FLOAT.equals((Object)psiType4)) break block43;
                                            if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.FLOAT)) break block40;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        evaluator = new TypeCastEvaluator(evaluator, PsiType.FLOAT.getCanonicalText(), true);
                                        break block40;
                                    }
                                    try {
                                        if (!PsiType.LONG.equals((Object)psiType5)) break block44;
                                        if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.LONG)) break block40;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.LONG.getCanonicalText(), true);
                                    break block40;
                                }
                                try {
                                    if (!PsiType.LONG.equals((Object)psiType4)) break block45;
                                    if (!TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.LONG)) break block40;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                evaluator = new TypeCastEvaluator(evaluator, PsiType.LONG.getCanonicalText(), true);
                                break block40;
                            }
                            try {
                                if (PsiType.INT.equals((Object)psiType5) || !TypeConversionUtil.areTypesConvertible((PsiType)psiType5, (PsiType)PsiType.INT)) break block46;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                            evaluator = new TypeCastEvaluator(evaluator, PsiType.INT.getCanonicalText(), true);
                        }
                        try {
                            if (PsiType.INT.equals((Object)psiType4) || !TypeConversionUtil.areTypesConvertible((PsiType)psiType4, (PsiType)PsiType.INT)) break block40;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        evaluator2 = new TypeCastEvaluator(evaluator2, PsiType.INT.getCanonicalText(), true);
                        break block40;
                    }
                    try {
                        try {
                            if (iElementType == JavaTokenType.GTGT || iElementType == JavaTokenType.LTLT) break block47;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        if (iElementType != JavaTokenType.GTGTGT) break block40;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                evaluator = Builder.a(psiType, evaluator);
                evaluator2 = Builder.a(psiType2, evaluator2);
            }
            return DisableGC.create(new BinaryExpressionEvaluator(evaluator, evaluator2, iElementType, psiType3.getCanonicalText()));
        }

        private static boolean b(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            boolean bl2;
            block66: {
                block65: {
                    block54: {
                        block61: {
                            boolean bl3;
                            block63: {
                                block62: {
                                    block58: {
                                        boolean bl4;
                                        block60: {
                                            block59: {
                                                block57: {
                                                    block56: {
                                                        block53: {
                                                            block52: {
                                                                try {
                                                                    try {
                                                                        if (psiType != null && psiType2 != null) break block52;
                                                                    }
                                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                        throw Builder.b(evaluateRuntimeException);
                                                                    }
                                                                    return false;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                            }
                                                            try {
                                                                try {
                                                                    if (TypeConversionUtil.isNumericType((PsiType)psiType) && TypeConversionUtil.isNumericType((PsiType)psiType2)) break block53;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                                return false;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                        }
                                                        try {
                                                            block55: {
                                                                try {
                                                                    try {
                                                                        try {
                                                                            if (iElementType != JavaTokenType.EQEQ && iElementType != JavaTokenType.NE) break block54;
                                                                        }
                                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                            throw Builder.b(evaluateRuntimeException);
                                                                        }
                                                                        if (PsiType.NULL.equals((Object)psiType)) break block55;
                                                                    }
                                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                        throw Builder.b(evaluateRuntimeException);
                                                                    }
                                                                    if (!PsiType.NULL.equals((Object)psiType2)) break block56;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                            }
                                                            return false;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                    }
                                                    try {
                                                        try {
                                                            if (!(psiType instanceof PsiClassType) || !(psiType2 instanceof PsiClassType)) break block57;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                        return false;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                }
                                                try {
                                                    try {
                                                        if (!(psiType instanceof PsiClassType)) break block58;
                                                        if (PsiPrimitiveType.getUnboxedType((PsiType)psiType) == null) break block59;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                    bl4 = true;
                                                    break block60;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                            }
                                            bl4 = false;
                                        }
                                        return bl4;
                                    }
                                    try {
                                        try {
                                            if (!(psiType2 instanceof PsiClassType)) break block61;
                                            if (PsiPrimitiveType.getUnboxedType((PsiType)psiType2) == null) break block62;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        bl3 = true;
                                        break block63;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                }
                                bl3 = false;
                            }
                            return bl3;
                        }
                        return true;
                    }
                    try {
                        block64: {
                            try {
                                try {
                                    try {
                                        try {
                                            try {
                                                try {
                                                    try {
                                                        try {
                                                            try {
                                                                try {
                                                                    try {
                                                                        if (iElementType == JavaTokenType.ASTERISK || iElementType == JavaTokenType.DIV) break block64;
                                                                    }
                                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                        throw Builder.b(evaluateRuntimeException);
                                                                    }
                                                                    if (iElementType == JavaTokenType.PERC) break block64;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                                if (iElementType == JavaTokenType.PLUS) break block64;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            if (iElementType == JavaTokenType.MINUS) break block64;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                        if (iElementType == JavaTokenType.LT) break block64;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                    if (iElementType == JavaTokenType.LE) break block64;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                if (iElementType == JavaTokenType.GT) break block64;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            if (iElementType == JavaTokenType.GE) break block64;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        if (iElementType == JavaTokenType.AND) break block64;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    if (iElementType == JavaTokenType.XOR) break block64;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                if (iElementType != JavaTokenType.OR) break block65;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                        }
                        bl2 = true;
                        break block66;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }

        private static boolean a(PsiType psiType, PsiType psiType2, IElementType iElementType) {
            boolean bl2;
            block40: {
                block39: {
                    block36: {
                        block31: {
                            boolean bl3;
                            block35: {
                                block34: {
                                    block30: {
                                        try {
                                            try {
                                                if (!PsiType.NULL.equals((Object)psiType) && !PsiType.NULL.equals((Object)psiType2)) break block30;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            return false;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                    }
                                    try {
                                        block33: {
                                            try {
                                                try {
                                                    block32: {
                                                        try {
                                                            try {
                                                                try {
                                                                    if (iElementType != JavaTokenType.EQEQ && iElementType != JavaTokenType.NE) break block31;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                                if (!(psiType instanceof PsiPrimitiveType)) break block32;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            if (psiType2 instanceof PsiClassType) break block33;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                    }
                                                    if (!(psiType instanceof PsiClassType)) break block34;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                if (!(psiType2 instanceof PsiPrimitiveType)) break block34;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                        }
                                        bl3 = true;
                                        break block35;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                }
                                bl3 = false;
                            }
                            return bl3;
                        }
                        try {
                            block38: {
                                try {
                                    try {
                                        block37: {
                                            try {
                                                try {
                                                    if (iElementType != JavaTokenType.PLUS) break block36;
                                                    if (!(psiType instanceof PsiClassType)) break block37;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                if (psiType.equalsToText("java.lang.String")) break block38;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                        }
                                        if (!(psiType2 instanceof PsiClassType)) break block36;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    if (!psiType2.equalsToText("java.lang.String")) break block36;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                            }
                            return false;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                    }
                    try {
                        try {
                            if (!(psiType instanceof PsiClassType) && !(psiType2 instanceof PsiClassType)) break block39;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        bl2 = true;
                        break block40;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        }

        @Nullable
        private static PsiType a(PsiPrimitiveType psiPrimitiveType) {
            block9: {
                try {
                    block8: {
                        try {
                            try {
                                try {
                                    if (PsiType.BYTE.equals((Object)psiPrimitiveType) || PsiType.SHORT.equals((Object)psiPrimitiveType)) break block8;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                if (PsiType.CHAR.equals((Object)psiPrimitiveType)) break block8;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                            if (!PsiType.INT.equals((Object)psiPrimitiveType)) break block9;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                    }
                    return PsiType.INT;
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            return null;
        }

        public void visitDeclarationStatement(PsiDeclarationStatement psiDeclarationStatement) {
            ArrayList<AssignmentEvaluator> arrayList = new ArrayList<AssignmentEvaluator>();
            PsiElement[] psiElementArray = psiDeclarationStatement.getDeclaredElements();
            for (PsiElement psiElement : psiElementArray) {
                block12: {
                    block13: {
                        Object object;
                        PsiExpression psiExpression;
                        try {
                            if (!(psiElement instanceof PsiLocalVariable)) break block12;
                            if (this.f == null) break block13;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw Builder.b((Exception)((Object)incorrectOperationException));
                        }
                        PsiLocalVariable psiLocalVariable = (PsiLocalVariable)psiElement;
                        PsiType psiType = psiLocalVariable.getType();
                        PsiElementFactory psiElementFactory = JavaPsiFacade.getInstance((Project)psiLocalVariable.getProject()).getElementFactory();
                        try {
                            psiExpression = psiElementFactory.createExpressionFromText(PsiTypesUtil.getDefaultValueOfType((PsiType)psiType), null);
                            object = JavaConstantExpressionEvaluator.computeConstantExpression((PsiExpression)psiExpression, (boolean)true);
                            this.f.setInitialValue(psiLocalVariable.getName(), object);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            a.error((Throwable)incorrectOperationException);
                        }
                        psiExpression = psiLocalVariable.getInitializer();
                        if (psiExpression == null) continue;
                        try {
                            try {
                                if (!TypeConversionUtil.areTypesAssignmentCompatible((PsiType)psiType, (PsiExpression)psiExpression)) {
                                    Builder.a(DebuggerBundle.message((String)"evaluation.error.incompatible.variable.initializer.type", (Object[])new Object[]{psiLocalVariable.getName()}));
                                }
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                throw Builder.b((Exception)((Object)incorrectOperationException));
                            }
                            object = psiExpression.getType();
                            psiExpression.accept((PsiElementVisitor)this);
                            Evaluator evaluator = this.e;
                            PsiExpression psiExpression2 = psiElementFactory.createExpressionFromText(psiLocalVariable.getName(), (PsiElement)psiExpression);
                            psiExpression2.accept((PsiElementVisitor)this);
                            Evaluator evaluator2 = this.e;
                            evaluator = Builder.a(psiExpression2.getType(), (PsiType)object, evaluator);
                            AssignmentEvaluator assignmentEvaluator = new AssignmentEvaluator(evaluator2, evaluator);
                            arrayList.add(assignmentEvaluator);
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            a.error((Throwable)incorrectOperationException);
                        }
                        continue;
                    }
                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.local.variable.declarations.not.supported", (Object[])new Object[0]), null));
                }
                throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.unsupported.declaration", (Object[])new Object[]{psiElement.getText()}), null));
            }
            if (!arrayList.isEmpty()) {
                CodeFragmentEvaluator codeFragmentEvaluator = new CodeFragmentEvaluator(this.f);
                codeFragmentEvaluator.setStatements(arrayList.toArray(new Evaluator[arrayList.size()]));
                this.e = codeFragmentEvaluator;
            } else {
                this.e = null;
            }
        }

        public void visitConditionalExpression(PsiConditionalExpression psiConditionalExpression) {
            PsiExpression psiExpression;
            PsiExpression psiExpression2;
            block16: {
                try {
                    if (a.isDebugEnabled()) {
                        a.debug("visitConditionalExpression " + psiConditionalExpression);
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                psiExpression2 = psiConditionalExpression.getThenExpression();
                psiExpression = psiConditionalExpression.getElseExpression();
                try {
                    try {
                        if (psiExpression2 != null && psiExpression != null) break block16;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    Builder.a((PsiElement)psiConditionalExpression);
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            PsiExpression psiExpression3 = psiConditionalExpression.getCondition();
            try {
                psiExpression3.accept((PsiElementVisitor)this);
                if (this.e == null) {
                    Builder.a((PsiElement)psiExpression3);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            UnBoxingEvaluator unBoxingEvaluator = new UnBoxingEvaluator(this.e);
            try {
                psiExpression2.accept((PsiElementVisitor)this);
                if (this.e == null) {
                    Builder.a((PsiElement)psiExpression2);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            Evaluator evaluator = this.e;
            try {
                psiExpression.accept((PsiElementVisitor)this);
                if (this.e == null) {
                    Builder.a((PsiElement)psiExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            Evaluator evaluator2 = this.e;
            this.e = new ConditionalExpressionEvaluator(unBoxingEvaluator, evaluator, evaluator2);
        }

        public void visitReferenceExpression(PsiReferenceExpression psiReferenceExpression) {
            block71: {
                String string;
                block68: {
                    PsiElement psiElement;
                    PsiExpression psiExpression;
                    block70: {
                        PsiElement psiElement2;
                        block69: {
                            block72: {
                                Evaluator evaluator;
                                PsiClass psiClass;
                                PsiField psiField;
                                block73: {
                                    block67: {
                                        PsiElement psiElement3;
                                        block61: {
                                            PsiClass psiClass2;
                                            String string2;
                                            PsiVariable psiVariable;
                                            JavaResolveResult javaResolveResult;
                                            block63: {
                                                boolean bl2;
                                                block65: {
                                                    block64: {
                                                        block62: {
                                                            try {
                                                                if (a.isDebugEnabled()) {
                                                                    a.debug("visitReferenceExpression " + psiReferenceExpression);
                                                                }
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            psiExpression = psiReferenceExpression.getQualifierExpression();
                                                            javaResolveResult = psiReferenceExpression.advancedResolve(true);
                                                            psiElement3 = javaResolveResult.getElement();
                                                            try {
                                                                if (!(psiElement3 instanceof PsiLocalVariable) && !(psiElement3 instanceof PsiParameter)) break block61;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            Value value = (Value)psiElement3.getUserData(CodeFragmentFactoryContextWrapper.LABEL_VARIABLE_VALUE_KEY);
                                                            try {
                                                                if (value != null) {
                                                                    this.e = new IdentityEvaluator(value);
                                                                    return;
                                                                }
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            PsiFile psiFile = psiElement3.getContainingFile();
                                                            try {
                                                                try {
                                                                    try {
                                                                        if (!(psiFile instanceof PsiCodeFragment) || this.f == null) break block62;
                                                                    }
                                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                        throw Builder.b(evaluateRuntimeException);
                                                                    }
                                                                    if (!this.c.contains(psiFile)) break block62;
                                                                }
                                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                    throw Builder.b(evaluateRuntimeException);
                                                                }
                                                                this.e = new SyntheticVariableEvaluator(this.f, ((PsiVariable)psiElement3).getName());
                                                                return;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                        }
                                                        psiVariable = (PsiVariable)psiElement3;
                                                        string2 = psiVariable.getName();
                                                        psiClass2 = this.a(psiVariable);
                                                        try {
                                                            if (this.getContextPsiClass() != null && !this.getContextPsiClass().equals(psiClass2)) break block63;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                        PsiElement psiElement4 = DebuggerUtilsEx.getContainingMethod((PsiElement)psiReferenceExpression);
                                                        try {
                                                            try {
                                                                if (!(psiElement4 instanceof PsiLambdaExpression) && !ContextUtil.isJspImplicit(psiElement3)) break block64;
                                                            }
                                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                                throw Builder.b(evaluateRuntimeException);
                                                            }
                                                            bl2 = true;
                                                            break block65;
                                                        }
                                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                            throw Builder.b(evaluateRuntimeException);
                                                        }
                                                    }
                                                    bl2 = false;
                                                }
                                                boolean bl3 = bl2;
                                                this.e = new LocalVariableEvaluator(string2, bl3);
                                                return;
                                            }
                                            int n2 = 0;
                                            PsiClass psiClass3 = Builder.a(this.getContextPsiClass());
                                            while (true) {
                                                try {
                                                    if (psiClass3 == null || psiClass3.equals(psiClass2)) break;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                ++n2;
                                                psiClass3 = Builder.a(psiClass3);
                                            }
                                            if (psiClass3 != null) {
                                                PsiClass psiClass4;
                                                PsiClass psiClass5;
                                                Object object;
                                                PsiExpression psiExpression2 = psiVariable.getInitializer();
                                                if (psiExpression2 != null && (object = JavaPsiFacade.getInstance((Project)psiVariable.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)psiExpression2)) != null) {
                                                    PsiType psiType = javaResolveResult.getSubstitutor().substitute(psiVariable.getType());
                                                    this.e = new LiteralEvaluator(object, psiType.getCanonicalText());
                                                    return;
                                                }
                                                object = new ThisEvaluator(n2);
                                                try {
                                                    psiClass5 = this.d != null ? JVMNameUtil.getClassAt(this.d) : null;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                PsiClass psiClass6 = psiClass5;
                                                try {
                                                    psiClass4 = psiClass6 != null ? psiClass6 : this.getContextPsiClass();
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                FieldEvaluator.TargetClassFilter targetClassFilter = FieldEvaluator.createClassFilter(psiClass4);
                                                this.e = Builder.a(new FieldEvaluator((Evaluator)object, targetClassFilter, "val$" + string2), (Evaluator)new LocalVariableEvaluator(string2, true));
                                                return;
                                            }
                                            Builder.a(DebuggerBundle.message((String)"evaluation.error.local.variable.missing.from.class.closure", (Object[])new Object[]{string2}));
                                            break block71;
                                        }
                                        if (!(psiElement3 instanceof PsiField)) break block72;
                                        psiField = (PsiField)psiElement3;
                                        psiClass = psiField.getContainingClass();
                                        try {
                                            if (psiClass == null) {
                                                Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.field.class", (Object[])new Object[]{psiField.getName()}));
                                                return;
                                            }
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        if (psiField.hasModifierProperty("static")) {
                                            JVMName jVMName = JVMNameUtil.getContextClassJVMQualifiedName(SourcePosition.createFromElement((PsiElement)psiField));
                                            if (jVMName == null) {
                                                jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                                            }
                                            evaluator = new TypeEvaluator(jVMName);
                                        } else if (psiExpression != null) {
                                            psiExpression.accept((PsiElementVisitor)this);
                                            evaluator = this.e;
                                        } else {
                                            block66: {
                                                try {
                                                    try {
                                                        if (psiClass.equals(this.getContextPsiClass())) break block66;
                                                        if (this.getContextPsiClass() == null) break block67;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                    if (!this.getContextPsiClass().isInheritor(psiClass, true)) break block67;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                            }
                                            evaluator = new ThisEvaluator();
                                        }
                                        break block73;
                                    }
                                    int n3 = 0;
                                    PsiClass psiClass7 = this.getContextPsiClass();
                                    while (true) {
                                        try {
                                            try {
                                                if (psiClass7 == null || psiClass7.equals(psiClass)) break;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            if (psiClass7.isInheritor(psiClass, true)) break;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        ++n3;
                                        psiClass7 = Builder.a(psiClass7);
                                    }
                                    try {
                                        if (psiClass7 == null) {
                                            Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.sources.for.field.class", (Object[])new Object[]{psiField.getName()}));
                                        }
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    evaluator = new ThisEvaluator(n3);
                                }
                                this.e = new FieldEvaluator(evaluator, FieldEvaluator.createClassFilter(psiClass), psiField.getName());
                                break block71;
                            }
                            PsiElement psiElement5 = psiReferenceExpression.getReferenceNameElement();
                            if (!(psiElement5 instanceof PsiIdentifier)) {
                                String string3;
                                try {
                                    string3 = psiElement5 != null ? psiElement5.getText() : "(null)";
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                String string4 = string3;
                                Builder.a(DebuggerBundle.message((String)"evaluation.error.identifier.expected", (Object[])new Object[]{string4}));
                                return;
                            }
                            string = psiElement5.getText();
                            try {
                                try {
                                    if (psiExpression == null) break block68;
                                    if (!(psiExpression instanceof PsiReferenceExpression)) break block69;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                psiElement2 = ((PsiReferenceExpression)psiExpression).resolve();
                                break block70;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                        }
                        psiElement2 = psiElement = null;
                    }
                    if (psiElement instanceof PsiClass) {
                        PsiClass psiClass = (PsiClass)psiElement;
                        JVMName jVMName = JVMNameUtil.getJVMQualifiedName(psiClass);
                        this.e = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.createClassFilter(psiClass), string);
                    } else {
                        try {
                            psiExpression.accept((PsiElementVisitor)this);
                            if (this.e == null) {
                                Builder.a(DebuggerBundle.message((String)"evaluation.error.cannot.evaluate.qualifier", (Object[])new Object[]{psiExpression.getText()}));
                            }
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        this.e = new FieldEvaluator(this.e, FieldEvaluator.createClassFilter(psiExpression.getType()), string);
                    }
                    break block71;
                }
                this.e = Builder.a(new LocalVariableEvaluator(string, false), (Evaluator)new FieldEvaluator(new ThisEvaluator(), FieldEvaluator.TargetClassFilter.ALL, string));
            }
        }

        private static Evaluator a(final Evaluator evaluator, final Evaluator evaluator2) {
            return new Evaluator(){
                private boolean a;

                @Override
                public Object evaluate(EvaluationContextImpl evaluationContextImpl) throws EvaluateException {
                    try {
                        return evaluator.evaluate(evaluationContextImpl);
                    }
                    catch (EvaluateException evaluateException) {
                        try {
                            Object object = evaluator2.evaluate(evaluationContextImpl);
                            this.a = true;
                            return object;
                        }
                        catch (EvaluateException evaluateException2) {
                            throw evaluateException;
                        }
                    }
                }

                @Override
                public Modifier getModifier() {
                    return this.a ? evaluator2.getModifier() : evaluator.getModifier();
                }
            };
        }

        private static void a(PsiElement psiElement) {
            Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{psiElement.getText()}));
        }

        private static void a(String string) throws EvaluateRuntimeException {
            throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((String)string));
        }

        public void visitSuperExpression(PsiSuperExpression psiSuperExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitSuperExpression " + psiSuperExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            int n2 = this.a(psiSuperExpression.getQualifier());
            this.e = new SuperEvaluator(n2);
        }

        public void visitThisExpression(PsiThisExpression psiThisExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitThisExpression " + psiThisExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            int n2 = this.a(psiThisExpression.getQualifier());
            this.e = new ThisEvaluator(n2);
        }

        private int a(PsiJavaCodeReferenceElement psiJavaCodeReferenceElement) {
            try {
                if (psiJavaCodeReferenceElement != null) {
                    return this.a(psiJavaCodeReferenceElement.resolve(), psiJavaCodeReferenceElement.getText());
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            return 0;
        }

        /*
         * Unable to fully structure code
         */
        private int a(PsiElement var1_1, String var2_2) {
            block9: {
                var3_3 = 0;
                if (var1_1 == null) ** GOTO lbl9
                try {
                    block11: {
                        if (this.getContextPsiClass() != null) break block9;
                        break block11;
                        catch (Exception v0) {
                            throw Builder.b(v0);
                        }
                    }
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{var2_2}));
                }
                catch (Exception v1) {
                    throw Builder.b(v1);
                }
            }
            try {
                var4_4 = this.getContextPsiClass();
                while (true) {
                    try {
                        if (var4_4 == null || var4_4.equals(var1_1)) break;
                    }
                    catch (Exception v2) {
                        throw Builder.b(v2);
                    }
                    ++var3_3;
                    var4_4 = Builder.a(var4_4);
                }
            }
            catch (Exception var4_5) {
                throw new EvaluateRuntimeException(EvaluateExceptionUtil.createEvaluateException((Throwable)var4_5));
            }
            return var3_3;
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression psiInstanceOfExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitInstanceOfExpression " + psiInstanceOfExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiTypeElement psiTypeElement = psiInstanceOfExpression.getCheckType();
            try {
                if (psiTypeElement == null) {
                    Builder.a((PsiElement)psiInstanceOfExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiType psiType = psiTypeElement.getType();
            psiInstanceOfExpression.getOperand().accept((PsiElementVisitor)this);
            Evaluator evaluator = this.e;
            this.e = new InstanceofEvaluator(evaluator, new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
        }

        public void visitParenthesizedExpression(PsiParenthesizedExpression psiParenthesizedExpression) {
            try {
                if (a.isDebugEnabled()) {
                    a.debug("visitParenthesizedExpression " + psiParenthesizedExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiExpression psiExpression = psiParenthesizedExpression.getExpression();
            try {
                if (psiExpression != null) {
                    psiExpression.accept((PsiElementVisitor)this);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        public void visitPostfixExpression(PsiPostfixExpression psiPostfixExpression) {
            Object object;
            IElementType iElementType;
            PsiPrimitiveType psiPrimitiveType;
            LiteralEvaluator literalEvaluator;
            PsiType psiType;
            Evaluator evaluator;
            try {
                if (psiPostfixExpression.getType() == null) {
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPostfixExpression.getText()}));
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiExpression psiExpression = psiPostfixExpression.getOperand();
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.e;
            IElementType iElementType2 = psiPostfixExpression.getOperationTokenType();
            PsiType psiType2 = psiExpression.getType();
            PsiPrimitiveType psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
            try {
                evaluator = evaluator2;
                psiType = psiType2;
                literalEvaluator = new LiteralEvaluator(1, "int");
                psiPrimitiveType = PsiType.INT;
                iElementType = iElementType2 == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            try {
                object = psiPrimitiveType2 != null ? psiPrimitiveType2 : psiType2;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            Evaluator evaluator3 = Builder.a(evaluator, psiType, literalEvaluator, (PsiType)psiPrimitiveType, iElementType, (PsiType)object);
            if (psiPrimitiveType2 != null) {
                evaluator3 = new BoxingEvaluator(evaluator3);
            }
            this.e = new PostfixOperationEvaluator(evaluator2, evaluator3);
        }

        public void visitPrefixExpression(PsiPrefixExpression psiPrefixExpression) {
            block24: {
                IElementType iElementType;
                Evaluator evaluator;
                PsiType psiType;
                block25: {
                    PsiPrimitiveType psiPrimitiveType;
                    block23: {
                        PsiType psiType2;
                        block22: {
                            block21: {
                                psiType = psiPrefixExpression.getType();
                                try {
                                    if (psiType == null) {
                                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.type", (Object[])new Object[]{psiPrefixExpression.getText()}));
                                    }
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    throw Builder.b((Exception)((Object)incorrectOperationException));
                                }
                                PsiExpression psiExpression = psiPrefixExpression.getOperand();
                                try {
                                    if (psiExpression == null) {
                                        Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.expression.operand", (Object[])new Object[]{psiPrefixExpression.getText()}));
                                    }
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    throw Builder.b((Exception)((Object)incorrectOperationException));
                                }
                                psiExpression.accept((PsiElementVisitor)this);
                                evaluator = this.e;
                                psiType2 = psiExpression.getType();
                                psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType2);
                                iElementType = psiPrefixExpression.getOperationTokenType();
                                try {
                                    if (iElementType != JavaTokenType.PLUSPLUS && iElementType != JavaTokenType.MINUSMINUS) break block21;
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    throw Builder.b((Exception)((Object)incorrectOperationException));
                                }
                                try {
                                    Evaluator evaluator2;
                                    Evaluator evaluator3;
                                    AssignmentEvaluator assignmentEvaluator;
                                    AssignmentEvaluator assignmentEvaluator2;
                                    Object object;
                                    IElementType iElementType2;
                                    PsiPrimitiveType psiPrimitiveType2;
                                    LiteralEvaluator literalEvaluator;
                                    PsiType psiType3;
                                    Evaluator evaluator4;
                                    try {
                                        evaluator4 = evaluator;
                                        psiType3 = psiType2;
                                        literalEvaluator = new LiteralEvaluator(1, "int");
                                        psiPrimitiveType2 = PsiType.INT;
                                        iElementType2 = iElementType == JavaTokenType.PLUSPLUS ? JavaTokenType.PLUS : JavaTokenType.MINUS;
                                    }
                                    catch (IncorrectOperationException incorrectOperationException) {
                                        throw Builder.b((Exception)((Object)incorrectOperationException));
                                    }
                                    try {
                                        object = psiPrimitiveType != null ? psiPrimitiveType : psiType2;
                                    }
                                    catch (IncorrectOperationException incorrectOperationException) {
                                        throw Builder.b((Exception)((Object)incorrectOperationException));
                                    }
                                    Evaluator evaluator5 = Builder.a(evaluator4, psiType3, literalEvaluator, (PsiType)psiPrimitiveType2, iElementType2, (PsiType)object);
                                    try {
                                        AssignmentEvaluator assignmentEvaluator3;
                                        Builder builder2 = this;
                                        assignmentEvaluator2 = assignmentEvaluator3;
                                        assignmentEvaluator = assignmentEvaluator3;
                                        evaluator3 = evaluator;
                                        evaluator2 = psiPrimitiveType != null ? new BoxingEvaluator(evaluator5) : evaluator5;
                                    }
                                    catch (IncorrectOperationException incorrectOperationException) {
                                        throw Builder.b((Exception)((Object)incorrectOperationException));
                                    }
                                    assignmentEvaluator2(evaluator3, evaluator2);
                                    builder2.e = assignmentEvaluator;
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    a.error((Throwable)incorrectOperationException);
                                }
                                break block24;
                            }
                            try {
                                try {
                                    if (JavaTokenType.PLUS.equals(iElementType) || JavaTokenType.MINUS.equals(iElementType)) break block22;
                                }
                                catch (IncorrectOperationException incorrectOperationException) {
                                    throw Builder.b((Exception)((Object)incorrectOperationException));
                                }
                                if (!JavaTokenType.TILDE.equals(iElementType)) break block23;
                            }
                            catch (IncorrectOperationException incorrectOperationException) {
                                throw Builder.b((Exception)((Object)incorrectOperationException));
                            }
                        }
                        evaluator = Builder.a(psiType2, evaluator);
                        break block25;
                    }
                    if (psiPrimitiveType != null) {
                        evaluator = new UnBoxingEvaluator(evaluator);
                    }
                }
                this.e = new UnaryExpressionEvaluator(iElementType, psiType.getCanonicalText(), evaluator, psiPrefixExpression.getOperationSign().getText());
            }
        }

        public void visitMethodCallExpression(PsiMethodCallExpression psiMethodCallExpression) {
            JVMName jVMName;
            String string;
            JVMName jVMName2;
            Evaluator evaluator;
            MethodEvaluator methodEvaluator;
            MethodEvaluator methodEvaluator2;
            boolean bl2;
            Evaluator evaluator2;
            JVMName jVMName3;
            PsiMethod psiMethod;
            PsiReferenceExpression psiReferenceExpression;
            PsiExpression psiExpression;
            Evaluator[] evaluatorArray;
            PsiExpression[] psiExpressionArray;
            block37: {
                block36: {
                    block39: {
                        PsiExpression psiExpression2;
                        block34: {
                            block35: {
                                PsiClass psiClass;
                                block38: {
                                    try {
                                        if (a.isDebugEnabled()) {
                                            a.debug("visitMethodCallExpression " + psiMethodCallExpression);
                                        }
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    PsiExpressionList psiExpressionList = psiMethodCallExpression.getArgumentList();
                                    psiExpressionArray = psiExpressionList.getExpressions();
                                    evaluatorArray = new Evaluator[psiExpressionArray.length];
                                    for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                                        psiExpression = psiExpressionArray[i2];
                                        try {
                                            psiExpression.accept((PsiElementVisitor)this);
                                            if (this.e == null) {
                                                Builder.a((PsiElement)psiExpression);
                                            }
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        evaluatorArray[i2] = DisableGC.create(this.e);
                                    }
                                    psiReferenceExpression = psiMethodCallExpression.getMethodExpression();
                                    psiExpression = psiReferenceExpression.advancedResolve(false);
                                    psiMethod = (PsiMethod)psiExpression.getElement();
                                    psiExpression2 = psiReferenceExpression.getQualifierExpression();
                                    jVMName3 = null;
                                    if (psiMethod == null) break block38;
                                    psiClass = psiMethod.getContainingClass();
                                    jVMName3 = JVMNameUtil.getJVMQualifiedName(psiClass);
                                    if (psiMethod.hasModifierProperty("static")) {
                                        evaluator2 = new TypeEvaluator(jVMName3);
                                    } else if (psiExpression2 != null) {
                                        psiExpression2.accept((PsiElementVisitor)this);
                                        evaluator2 = this.e;
                                    } else {
                                        bl2 = false;
                                        PsiElement psiElement = psiExpression.getCurrentFileResolveScope();
                                        if (psiElement instanceof PsiClass) {
                                            PsiClass psiClass2 = this.getContextPsiClass();
                                            while (true) {
                                                try {
                                                    if (psiClass2 == null || psiClass2.equals(psiElement)) break;
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                                psiClass2 = Builder.a(psiClass2);
                                                bl2 += 1;
                                            }
                                        }
                                        evaluator2 = new ThisEvaluator(bl2 ? 1 : 0);
                                    }
                                    break block36;
                                }
                                if (psiExpression2 == null) break block39;
                                psiClass = psiExpression2.getType();
                                if (psiClass != null) {
                                    jVMName3 = JVMNameUtil.getJVMQualifiedName((PsiType)psiClass);
                                }
                                try {
                                    try {
                                        if (!(psiExpression2 instanceof PsiReferenceExpression) || !(((PsiReferenceExpression)psiExpression2).resolve() instanceof PsiClass)) break block34;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    if (jVMName3 != null) break block35;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                jVMName3 = JVMNameUtil.getJVMRawText(((PsiReferenceExpression)psiExpression2).getQualifiedName());
                            }
                            evaluator2 = new TypeEvaluator(jVMName3);
                            break block36;
                        }
                        psiExpression2.accept((PsiElementVisitor)this);
                        evaluator2 = this.e;
                        break block36;
                    }
                    evaluator2 = new ThisEvaluator();
                    jVMName3 = JVMNameUtil.getContextClassJVMQualifiedName(this.d);
                    try {
                        if (jVMName3 != null || this.b == null) break block36;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    jVMName3 = JVMNameUtil.getJVMQualifiedName(this.b);
                }
                try {
                    if (evaluator2 == null) {
                        Builder.a((PsiElement)psiMethodCallExpression);
                    }
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                try {
                    try {
                        try {
                            if (psiMethod == null || psiMethod.isConstructor()) break block37;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        if (psiMethod.getReturnType() != null) break block37;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    Builder.a(DebuggerBundle.message((String)"evaluation.error.unknown.method.return.type", (Object[])new Object[]{psiMethod.getText()}));
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
            boolean bl3 = false;
            bl2 = false;
            if (psiMethod != null) {
                EvaluatorBuilderImpl.access$100(psiMethod.getParameterList().getParameters(), psiExpressionArray, psiExpression.getSubstitutor(), evaluatorArray);
                bl3 = psiMethod.hasModifierProperty("default");
                bl2 = psiMethod.isVarArgs();
            }
            try {
                MethodEvaluator methodEvaluator3;
                Builder builder2 = this;
                methodEvaluator2 = methodEvaluator3;
                methodEvaluator = methodEvaluator3;
                evaluator = evaluator2;
                jVMName2 = jVMName3;
                string = psiReferenceExpression.getReferenceName();
                jVMName = psiMethod != null ? JVMNameUtil.getJVMSignature(psiMethod) : null;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            methodEvaluator2(evaluator, jVMName2, string, jVMName, evaluatorArray, bl3, bl2);
            builder2.e = methodEvaluator;
        }

        public void visitLiteralExpression(PsiLiteralExpression psiLiteralExpression) {
            HighlightInfo highlightInfo = HighlightUtil.checkLiteralExpressionParsingError((PsiLiteralExpression)psiLiteralExpression, null, null);
            try {
                if (highlightInfo != null) {
                    Builder.a(highlightInfo.getDescription());
                    return;
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            PsiType psiType = psiLiteralExpression.getType();
            try {
                if (psiType == null) {
                    Builder.a(psiLiteralExpression + ": null type");
                    return;
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            this.e = new LiteralEvaluator(psiLiteralExpression.getValue(), psiType.getCanonicalText());
        }

        public void visitArrayAccessExpression(PsiArrayAccessExpression psiArrayAccessExpression) {
            PsiExpression psiExpression = psiArrayAccessExpression.getIndexExpression();
            try {
                if (psiExpression == null) {
                    Builder.a((PsiElement)psiArrayAccessExpression);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            psiExpression.accept((PsiElementVisitor)this);
            Evaluator evaluator = Builder.a(psiExpression.getType(), this.e);
            psiArrayAccessExpression.getArrayExpression().accept((PsiElementVisitor)this);
            Evaluator evaluator2 = this.e;
            this.e = new ArrayAccessEvaluator(evaluator2, evaluator);
        }

        private static Evaluator a(PsiType psiType, Evaluator evaluator) {
            PsiType psiType2;
            PsiPrimitiveType psiPrimitiveType;
            PsiPrimitiveType psiPrimitiveType2;
            block5: {
                psiPrimitiveType2 = PsiPrimitiveType.getUnboxedType((PsiType)psiType);
                try {
                    if (psiPrimitiveType2 == null || PsiType.BOOLEAN.equals((Object)psiPrimitiveType2)) break block5;
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
                evaluator = new UnBoxingEvaluator(evaluator);
            }
            try {
                Object object = psiPrimitiveType = psiPrimitiveType2 != null ? psiPrimitiveType2 : psiType;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            if (psiPrimitiveType instanceof PsiPrimitiveType && (psiType2 = Builder.a(psiPrimitiveType)) != null) {
                evaluator = new TypeCastEvaluator(evaluator, psiType2.getCanonicalText(), true);
            }
            return evaluator;
        }

        public void visitTypeCastExpression(PsiTypeCastExpression psiTypeCastExpression) {
            boolean bl2;
            boolean bl3;
            PsiType psiType;
            Evaluator evaluator;
            block32: {
                boolean bl4;
                block31: {
                    boolean bl5;
                    block30: {
                        boolean bl6;
                        block29: {
                            block28: {
                                PsiType psiType2;
                                block27: {
                                    PsiExpression psiExpression = psiTypeCastExpression.getOperand();
                                    try {
                                        if (psiExpression == null) {
                                            Builder.a((PsiElement)psiTypeCastExpression);
                                        }
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    psiExpression.accept((PsiElementVisitor)this);
                                    evaluator = this.e;
                                    PsiTypeElement psiTypeElement = psiTypeCastExpression.getCastType();
                                    try {
                                        if (psiTypeElement == null) {
                                            Builder.a((PsiElement)psiTypeCastExpression);
                                        }
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    psiType = psiTypeElement.getType();
                                    psiType2 = psiExpression.getType();
                                    try {
                                        try {
                                            try {
                                                if (psiType2 == null || TypeConversionUtil.areTypesConvertible((PsiType)psiType2, (PsiType)psiType)) break block27;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            if (PsiUtil.resolveClassInType((PsiType)psiType2) == null) break block27;
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                        throw new EvaluateRuntimeException(new EvaluateException(JavaErrorMessages.message((String)"inconvertible.type.cast", (Object[])new Object[]{JavaHighlightUtil.formatType((PsiType)psiType2), JavaHighlightUtil.formatType((PsiType)psiType)})));
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                }
                                try {
                                    try {
                                        if (psiType2 == null || !TypeConversionUtil.boxingConversionApplicable((PsiType)psiType, (PsiType)psiType2)) break block28;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    bl6 = true;
                                    break block29;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                            }
                            bl6 = false;
                        }
                        bl5 = bl6;
                        bl3 = psiType instanceof PsiPrimitiveType;
                        try {
                            if (!bl5 || !bl3) break block30;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        evaluator = new UnBoxingEvaluator(evaluator);
                    }
                    try {
                        try {
                            if (!bl5 || bl3) break block31;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                        bl4 = true;
                        break block32;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                bl4 = bl2 = false;
            }
            if (!(PsiUtil.resolveClassInClassTypeOnly((PsiType)psiType) instanceof PsiTypeParameter)) {
                PsiPrimitiveType psiPrimitiveType;
                String string = psiType.getCanonicalText();
                if (bl2 && (psiPrimitiveType = PsiPrimitiveType.getUnboxedType((PsiType)psiType)) != null) {
                    string = psiPrimitiveType.getCanonicalText();
                }
                this.e = new TypeCastEvaluator(evaluator, string, bl3);
            }
            try {
                if (bl2) {
                    this.e = new BoxingEvaluator(this.e);
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
        }

        public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression psiClassObjectAccessExpression) {
            PsiType psiType = psiClassObjectAccessExpression.getOperand().getType();
            if (psiType instanceof PsiPrimitiveType) {
                JVMName jVMName = JVMNameUtil.getJVMRawText(((PsiPrimitiveType)psiType).getBoxedTypeName());
                this.e = new FieldEvaluator(new TypeEvaluator(jVMName), FieldEvaluator.TargetClassFilter.ALL, "TYPE");
            } else {
                this.e = new ClassObjectEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)));
            }
        }

        public void visitLambdaExpression(PsiLambdaExpression psiLambdaExpression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.lambda.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitMethodReferenceExpression(PsiMethodReferenceExpression psiMethodReferenceExpression) {
            throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.method.reference.evaluation.not.supported", (Object[])new Object[0])));
        }

        public void visitNewExpression(PsiNewExpression psiNewExpression) {
            block48: {
                block47: {
                    PsiType psiType;
                    block50: {
                        Object[] objectArray;
                        PsiMethod psiMethod;
                        PsiClass psiClass;
                        block45: {
                            PsiExpression psiExpression;
                            JavaResolveResult javaResolveResult;
                            PsiExpression[] psiExpressionArray;
                            block44: {
                                block49: {
                                    Object object;
                                    Evaluator evaluator;
                                    block43: {
                                        block41: {
                                            PsiArrayInitializerExpression psiArrayInitializerExpression;
                                            block42: {
                                                psiType = psiNewExpression.getType();
                                                if (!(psiType instanceof PsiArrayType)) break block49;
                                                evaluator = null;
                                                PsiExpression[] psiExpressionArray2 = psiNewExpression.getArrayDimensions();
                                                if (psiExpressionArray2.length == 1) {
                                                    object = psiExpressionArray2[0];
                                                    object.accept((PsiElementVisitor)this);
                                                    if (this.e != null) {
                                                        evaluator = Builder.a(object.getType(), this.e);
                                                    } else {
                                                        Builder.a(DebuggerBundle.message((String)"evaluation.error.invalid.array.dimension.expression", (Object[])new Object[]{object.getText()}));
                                                    }
                                                } else {
                                                    try {
                                                        if (psiExpressionArray2.length > 1) {
                                                            Builder.a(DebuggerBundle.message((String)"evaluation.error.multi.dimensional.arrays.creation.not.supported", (Object[])new Object[0]));
                                                        }
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                }
                                                object = null;
                                                psiArrayInitializerExpression = psiNewExpression.getArrayInitializer();
                                                try {
                                                    try {
                                                        if (psiArrayInitializerExpression == null) break block41;
                                                        if (evaluator == null) break block42;
                                                    }
                                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                        throw Builder.b(evaluateRuntimeException);
                                                    }
                                                    Builder.a((PsiElement)psiNewExpression);
                                                }
                                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                    throw Builder.b(evaluateRuntimeException);
                                                }
                                            }
                                            psiArrayInitializerExpression.accept((PsiElementVisitor)this);
                                            if (this.e != null) {
                                                object = Builder.a(psiArrayInitializerExpression.getType(), this.e);
                                            } else {
                                                Builder.a((PsiElement)psiArrayInitializerExpression);
                                            }
                                        }
                                        try {
                                            try {
                                                if (evaluator != null || object != null) break block43;
                                            }
                                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                                throw Builder.b(evaluateRuntimeException);
                                            }
                                            Builder.a((PsiElement)psiNewExpression);
                                        }
                                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                                            throw Builder.b(evaluateRuntimeException);
                                        }
                                    }
                                    this.e = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), evaluator, (Evaluator)object);
                                    break block48;
                                }
                                if (!(psiType instanceof PsiClassType)) break block50;
                                psiClass = ((PsiClassType)psiType).resolve();
                                try {
                                    if (psiClass instanceof PsiAnonymousClass) {
                                        throw new EvaluateRuntimeException(new UnsupportedExpressionException(DebuggerBundle.message((String)"evaluation.error.anonymous.class.evaluation.not.supported", (Object[])new Object[0])));
                                    }
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                PsiExpressionList psiExpressionList = psiNewExpression.getArgumentList();
                                try {
                                    if (psiExpressionList == null) {
                                        Builder.a((PsiElement)psiNewExpression);
                                    }
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                psiExpressionArray = psiExpressionList.getExpressions();
                                javaResolveResult = psiNewExpression.resolveMethodGenerics();
                                psiMethod = (PsiMethod)javaResolveResult.getElement();
                                try {
                                    try {
                                        if (psiMethod != null || psiExpressionArray.length <= 0) break block44;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    throw new EvaluateRuntimeException(new EvaluateException(DebuggerBundle.message((String)"evaluation.error.cannot.resolve.constructor", (Object[])new Object[]{psiNewExpression.getText()}), null));
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                            }
                            objectArray = new Evaluator[psiExpressionArray.length];
                            for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                                psiExpression = psiExpressionArray[i2];
                                try {
                                    psiExpression.accept((PsiElementVisitor)this);
                                    if (this.e != null) {
                                        objectArray[i2] = DisableGC.create(this.e);
                                        continue;
                                    }
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                                Builder.a((PsiElement)psiExpression);
                            }
                            try {
                                if (psiMethod != null) {
                                    EvaluatorBuilderImpl.access$100(psiMethod.getParameterList().getParameters(), psiExpressionArray, javaResolveResult.getSubstitutor(), (Evaluator[])objectArray);
                                }
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                            if (psiClass != null) {
                                PsiClass psiClass2;
                                block46: {
                                    psiClass2 = psiClass.getContainingClass();
                                    try {
                                        if (psiClass2 == null || psiClass.hasModifierProperty("static")) break block45;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    psiExpression = psiNewExpression.getQualifier();
                                    try {
                                        if (psiExpression == null) break block46;
                                        psiExpression.accept((PsiElementVisitor)this);
                                        if (this.e == null) break block45;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    objectArray = (Evaluator[])ArrayUtil.prepend((Object)this.e, (Object[])objectArray);
                                    break block45;
                                }
                                objectArray = (Evaluator[])ArrayUtil.prepend((Object)new ThisEvaluator(this.a((PsiElement)psiClass2, "this")), (Object[])objectArray);
                            }
                        }
                        JVMName jVMName = JVMNameUtil.getJVMConstructorSignature(psiMethod, psiClass);
                        this.e = new NewClassInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), jVMName, (Evaluator[])objectArray);
                        break block48;
                    }
                    try {
                        if (psiType == null) break block47;
                        Builder.a("Unsupported expression type: " + psiType.getPresentableText());
                        break block48;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                }
                Builder.a("Unknown type for expression: " + psiNewExpression.getText());
            }
        }

        public void visitArrayInitializerExpression(PsiArrayInitializerExpression psiArrayInitializerExpression) {
            block18: {
                boolean bl2;
                PsiType psiType;
                Evaluator[] evaluatorArray;
                PsiExpression[] psiExpressionArray;
                block14: {
                    block13: {
                        psiExpressionArray = psiArrayInitializerExpression.getInitializers();
                        evaluatorArray = new Evaluator[psiExpressionArray.length];
                        psiType = psiArrayInitializerExpression.getType();
                        try {
                            try {
                                if (!(psiType instanceof PsiArrayType) || !(((PsiArrayType)psiType).getComponentType() instanceof PsiPrimitiveType)) break block13;
                            }
                            catch (EvaluateRuntimeException evaluateRuntimeException) {
                                throw Builder.b(evaluateRuntimeException);
                            }
                            bl2 = true;
                            break block14;
                        }
                        catch (EvaluateRuntimeException evaluateRuntimeException) {
                            throw Builder.b(evaluateRuntimeException);
                        }
                    }
                    bl2 = false;
                }
                boolean bl3 = bl2;
                for (int i2 = 0; i2 < psiExpressionArray.length; ++i2) {
                    PsiExpression psiExpression;
                    block15: {
                        Evaluator evaluator;
                        block17: {
                            block16: {
                                psiExpression = psiExpressionArray[i2];
                                try {
                                    try {
                                        psiExpression.accept((PsiElementVisitor)this);
                                        if (this.e == null) break block15;
                                        if (!bl3) break block16;
                                    }
                                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                                        throw Builder.b(evaluateRuntimeException);
                                    }
                                    evaluator = Builder.a(psiExpression.getType(), this.e);
                                    break block17;
                                }
                                catch (EvaluateRuntimeException evaluateRuntimeException) {
                                    throw Builder.b(evaluateRuntimeException);
                                }
                            }
                            evaluator = new BoxingEvaluator(this.e);
                        }
                        Evaluator evaluator2 = evaluator;
                        evaluatorArray[i2] = DisableGC.create(evaluator2);
                        continue;
                    }
                    Builder.a((PsiElement)psiExpression);
                }
                try {
                    try {
                        this.e = new ArrayInitializerEvaluator(evaluatorArray);
                        if (psiType == null || psiArrayInitializerExpression.getParent() instanceof PsiNewExpression) break block18;
                    }
                    catch (EvaluateRuntimeException evaluateRuntimeException) {
                        throw Builder.b(evaluateRuntimeException);
                    }
                    this.e = new NewArrayInstanceEvaluator(new TypeEvaluator(JVMNameUtil.getJVMQualifiedName(psiType)), null, this.e);
                }
                catch (EvaluateRuntimeException evaluateRuntimeException) {
                    throw Builder.b(evaluateRuntimeException);
                }
            }
        }

        @Nullable
        private static PsiClass a(PsiClass psiClass) {
            PsiClass psiClass2;
            try {
                psiClass2 = psiClass == null ? null : (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiClass, PsiClass.class, (boolean)true);
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            return psiClass2;
        }

        private PsiClass a(PsiVariable psiVariable) {
            PsiClass psiClass;
            PsiElement psiElement = PsiTreeUtil.getParentOfType((PsiElement)psiVariable.getParent(), PsiClass.class, (boolean)false);
            try {
                psiClass = psiElement == null ? this.getContextPsiClass() : (PsiClass)psiElement;
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            return psiClass;
        }

        @Nullable
        public PsiClass getContextPsiClass() {
            return this.b;
        }

        protected ExpressionEvaluator buildElement(PsiElement psiElement) throws EvaluateException {
            a.assertTrue(psiElement.isValid());
            this.b = (PsiClass)PsiTreeUtil.getContextOfType((PsiElement)psiElement, PsiClass.class, (boolean)false);
            try {
                psiElement.accept((PsiElementVisitor)this);
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw evaluateRuntimeException.getCause();
            }
            try {
                if (this.e == null) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"evaluation.error.invalid.expression", (Object[])new Object[]{psiElement.toString()}));
                }
            }
            catch (EvaluateRuntimeException evaluateRuntimeException) {
                throw Builder.b(evaluateRuntimeException);
            }
            return new ExpressionEvaluatorImpl(this.e);
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void a(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static Exception b(Exception exception) {
            return exception;
        }
    }
}

