/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.engine.requests;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.JVMName;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.requests.ClassPrepareRequestor;
import com.intellij.debugger.requests.RequestManager;
import com.intellij.debugger.requests.Requestor;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.diagnostic.ThreadDumper;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiClass;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.containers.HashMap;
import com.sun.jdi.ClassType;
import com.sun.jdi.Field;
import com.sun.jdi.InterfaceType;
import com.sun.jdi.InternalException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.event.ClassPrepareEvent;
import com.sun.jdi.request.AccessWatchpointRequest;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.ClassPrepareRequest;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.ExceptionRequest;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.MethodEntryRequest;
import com.sun.jdi.request.MethodExitRequest;
import com.sun.jdi.request.ModificationWatchpointRequest;
import com.sun.jdi.request.WatchpointRequest;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.Nullable;

public class RequestManagerImpl
extends DebugProcessAdapterImpl
implements RequestManager {
    private static final Logger e = Logger.getInstance((String)"#com.intellij.debugger.RequestManagerImpl");
    private static final Key h = Key.create((String)"ClassName");
    private static final Key<Requestor> c = Key.create((String)"Requestor");
    private final DebugProcessImpl a;
    private final Map<Requestor, String> b = new HashMap();
    private final Map<Requestor, Set<EventRequest>> f = new HashMap();
    private EventRequestManager d;
    @Nullable
    private ThreadReference g;

    public RequestManagerImpl(DebugProcessImpl debugProcessImpl) {
        this.a = debugProcessImpl;
        this.a.addDebugProcessListener(this);
    }

    public EventRequestManager getVMRequestManager() {
        return this.d;
    }

    @Nullable
    public ThreadReference getFilterThread() {
        return this.g;
    }

    public void setFilterThread(@Nullable ThreadReference threadReference) {
        this.g = threadReference;
    }

    public Set<EventRequest> findRequests(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        Set<EventRequest> set = this.f.get(requestor);
        try {
            if (set == null) {
                return Collections.emptySet();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        return Collections.unmodifiableSet(set);
    }

    @Nullable
    public Requestor findRequestor(EventRequest eventRequest) {
        Requestor requestor;
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            requestor = eventRequest != null ? (Requestor)eventRequest.getProperty(c) : null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        return requestor;
    }

    private static void a(EventRequest eventRequest, String string) {
        block14: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                try {
                                    if (!(eventRequest instanceof AccessWatchpointRequest)) break block13;
                                    ((AccessWatchpointRequest)eventRequest).addClassFilter(string);
                                    break block14;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                                }
                            }
                            try {
                                if (!(eventRequest instanceof ExceptionRequest)) break block15;
                                ((ExceptionRequest)eventRequest).addClassFilter(string);
                                break block14;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                            }
                        }
                        try {
                            if (!(eventRequest instanceof MethodEntryRequest)) break block16;
                            ((MethodEntryRequest)eventRequest).addClassFilter(string);
                            break block14;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                        }
                    }
                    try {
                        if (!(eventRequest instanceof MethodExitRequest)) break block17;
                        ((MethodExitRequest)eventRequest).addClassFilter(string);
                        break block14;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                }
                try {
                    if (!(eventRequest instanceof ModificationWatchpointRequest)) break block18;
                    ((ModificationWatchpointRequest)eventRequest).addClassFilter(string);
                    break block14;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                }
            }
            try {
                if (eventRequest instanceof WatchpointRequest) {
                    ((WatchpointRequest)eventRequest).addClassFilter(string);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
            }
        }
    }

    private static void b(EventRequest eventRequest, String string) {
        block14: {
            block18: {
                block17: {
                    block16: {
                        block15: {
                            block13: {
                                try {
                                    if (!(eventRequest instanceof AccessWatchpointRequest)) break block13;
                                    ((AccessWatchpointRequest)eventRequest).addClassExclusionFilter(string);
                                    break block14;
                                }
                                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                                }
                            }
                            try {
                                if (!(eventRequest instanceof ExceptionRequest)) break block15;
                                ((ExceptionRequest)eventRequest).addClassExclusionFilter(string);
                                break block14;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                            }
                        }
                        try {
                            if (!(eventRequest instanceof MethodEntryRequest)) break block16;
                            ((MethodEntryRequest)eventRequest).addClassExclusionFilter(string);
                            break block14;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                        }
                    }
                    try {
                        if (!(eventRequest instanceof MethodExitRequest)) break block17;
                        ((MethodExitRequest)eventRequest).addClassExclusionFilter(string);
                        break block14;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                }
                try {
                    if (!(eventRequest instanceof ModificationWatchpointRequest)) break block18;
                    ((ModificationWatchpointRequest)eventRequest).addClassExclusionFilter(string);
                    break block14;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                }
            }
            try {
                if (eventRequest instanceof WatchpointRequest) {
                    ((WatchpointRequest)eventRequest).addClassExclusionFilter(string);
                }
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
            }
        }
    }

    /*
     * Loose catch block
     */
    private void a(FilteredRequestor filteredRequestor, EventRequest eventRequest) {
        block22: {
            block21: {
                block20: {
                    block19: {
                        try {
                            if (!"SuspendAll".equals(filteredRequestor.getSuspendPolicy())) break block19;
                            eventRequest.setSuspendPolicy(2);
                            break block20;
                        }
                        catch (EvaluateException evaluateException) {
                            throw RequestManagerImpl.b((Exception)((Object)evaluateException));
                        }
                    }
                    eventRequest.setSuspendPolicy(1);
                }
                if (!filteredRequestor.isCountFilterEnabled()) break block21;
                try {
                    block23: {
                        if (filteredRequestor.isConditionEnabled()) break block21;
                        break block23;
                        catch (EvaluateException evaluateException) {
                            throw RequestManagerImpl.b((Exception)((Object)evaluateException));
                        }
                    }
                    eventRequest.addCountFilter(filteredRequestor.getCountFilter());
                }
                catch (EvaluateException evaluateException) {
                    throw RequestManagerImpl.b((Exception)((Object)evaluateException));
                }
            }
            try {
                if (!filteredRequestor.isClassFiltersEnabled() || eventRequest instanceof BreakpointRequest) break block22;
            }
            catch (EvaluateException evaluateException) {
                throw RequestManagerImpl.b((Exception)((Object)evaluateException));
            }
            ClassFilter[] classFilterArray = filteredRequestor.getClassFilters();
            if (DebuggerUtilsEx.getEnabledNumber(classFilterArray) == 1) {
                for (ClassFilter classFilter : classFilterArray) {
                    try {
                        if (!classFilter.isEnabled()) {
                            continue;
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        throw RequestManagerImpl.b((Exception)((Object)evaluateException));
                    }
                    JVMName jVMName = (JVMName)ReadAction.compute(() -> {
                        PsiClass psiClass = DebuggerUtils.findClass((String)classFilter.getPattern(), (Project)this.a.getProject(), (GlobalSearchScope)this.a.getSearchScope());
                        try {
                            if (psiClass == null) {
                                return null;
                            }
                        }
                        catch (RuntimeException runtimeException) {
                            throw RequestManagerImpl.b(runtimeException);
                        }
                        return JVMNameUtil.getJVMQualifiedName(psiClass);
                    });
                    String string = classFilter.getPattern();
                    try {
                        if (jVMName != null) {
                            string = jVMName.getName(this.a);
                        }
                    }
                    catch (EvaluateException evaluateException) {
                        // empty catch block
                    }
                    RequestManagerImpl.a(eventRequest, string);
                    break;
                }
            }
            for (ClassFilter classFilter : filteredRequestor.getClassExclusionFilters()) {
                try {
                    if (!classFilter.isEnabled()) continue;
                    RequestManagerImpl.b(eventRequest, classFilter.getPattern());
                }
                catch (EvaluateException evaluateException) {
                    throw RequestManagerImpl.b((Exception)((Object)evaluateException));
                }
            }
        }
        this.registerRequestInternal(filteredRequestor, eventRequest);
    }

    public void registerRequestInternal(Requestor requestor, EventRequest eventRequest) {
        this.registerRequest(requestor, eventRequest);
        eventRequest.putProperty(c, requestor);
    }

    public void registerRequest(Requestor requestor2, EventRequest eventRequest) {
        this.f.computeIfAbsent(requestor2, requestor -> new HashSet()).add(eventRequest);
    }

    @Nullable
    public ClassPrepareRequest createClassPrepareRequest(ClassPrepareRequestor classPrepareRequestor, String string) {
        try {
            if (this.d == null) {
                return null;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        ClassPrepareRequest classPrepareRequest = this.d.createClassPrepareRequest();
        try {
            classPrepareRequest.setSuspendPolicy(1);
            if (!StringUtil.isEmpty((String)string)) {
                classPrepareRequest.addClassFilter(string);
                classPrepareRequest.putProperty(h, string);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        this.registerRequestInternal((Requestor)classPrepareRequestor, classPrepareRequest);
        return classPrepareRequest;
    }

    public ExceptionRequest createExceptionRequest(FilteredRequestor filteredRequestor, ReferenceType referenceType, boolean bl2, boolean bl3) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ExceptionRequest exceptionRequest = this.d.createExceptionRequest(referenceType, bl2, bl3);
        this.a(filteredRequestor, exceptionRequest);
        return exceptionRequest;
    }

    public MethodEntryRequest createMethodEntryRequest(FilteredRequestor filteredRequestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodEntryRequest methodEntryRequest = this.d.createMethodEntryRequest();
        this.a(filteredRequestor, methodEntryRequest);
        return methodEntryRequest;
    }

    public MethodExitRequest createMethodExitRequest(FilteredRequestor filteredRequestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        MethodExitRequest methodExitRequest = this.d.createMethodExitRequest();
        this.a(filteredRequestor, methodExitRequest);
        return methodExitRequest;
    }

    public BreakpointRequest createBreakpointRequest(FilteredRequestor filteredRequestor, Location location) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        BreakpointRequest breakpointRequest = this.d.createBreakpointRequest(location);
        this.a(filteredRequestor, breakpointRequest);
        this.b.remove(filteredRequestor);
        return breakpointRequest;
    }

    public AccessWatchpointRequest createAccessWatchpointRequest(FilteredRequestor filteredRequestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        AccessWatchpointRequest accessWatchpointRequest = this.d.createAccessWatchpointRequest(field);
        this.a(filteredRequestor, accessWatchpointRequest);
        return accessWatchpointRequest;
    }

    public ModificationWatchpointRequest createModificationWatchpointRequest(FilteredRequestor filteredRequestor, Field field) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ModificationWatchpointRequest modificationWatchpointRequest = this.d.createModificationWatchpointRequest(field);
        this.a(filteredRequestor, modificationWatchpointRequest);
        return modificationWatchpointRequest;
    }

    /*
     * Loose catch block
     */
    public void deleteRequest(Requestor requestor) {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            this.b.remove(requestor);
            if (!this.a.isAttached()) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        Set<EventRequest> set = this.f.remove(requestor);
        try {
            if (set == null) {
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        for (EventRequest eventRequest : set) {
            try {
                block19: {
                    Requestor requestor2 = (Requestor)eventRequest.getProperty(c);
                    if (requestor2 == requestor) break block19;
                    Set<EventRequest> set2 = this.f.get(requestor2);
                    if (set2 == null) break block19;
                    try {
                        block20: {
                            set2.remove(eventRequest);
                            if (!set2.isEmpty()) break block19;
                            break block20;
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                            }
                        }
                        this.f.remove(requestor2);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                }
                try {
                    this.d.deleteEventRequest(eventRequest);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    e.error("Exception in EventRequestManager.deleteEventRequest", (Throwable)arrayIndexOutOfBoundsException, new String[]{ThreadDumper.dumpThreadsToString()});
                }
            }
            catch (InvalidRequestStateException invalidRequestStateException) {
            }
            catch (InternalException internalException) {
                try {
                    if (internalException.errorCode() == 41) {
                        continue;
                    }
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                }
                e.info((Throwable)internalException);
            }
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor classPrepareRequestor, SourcePosition sourcePosition) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        List<ClassPrepareRequest> list = this.a.getPositionManager().createPrepareRequests(classPrepareRequestor, sourcePosition);
        try {
            if (list.isEmpty()) {
                this.setInvalid((Requestor)classPrepareRequestor, DebuggerBundle.message((String)"status.invalid.breakpoint.out.of.class", (Object[])new Object[0]));
                return;
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
        for (ClassPrepareRequest classPrepareRequest : list) {
            try {
                if (classPrepareRequest == null) continue;
                this.registerRequest((Requestor)classPrepareRequestor, classPrepareRequest);
                classPrepareRequest.enable();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
            }
        }
    }

    public void callbackOnPrepareClasses(ClassPrepareRequestor classPrepareRequestor, String string) {
        block4: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ClassPrepareRequest classPrepareRequest = this.createClassPrepareRequest(classPrepareRequestor, string);
            try {
                try {
                    if (classPrepareRequest == null) break block4;
                    this.registerRequest((Requestor)classPrepareRequestor, classPrepareRequest);
                    classPrepareRequest.enable();
                    if (!e.isDebugEnabled()) break block4;
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                }
                e.debug("classOrPatternToBeLoaded = " + string);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
            }
        }
    }

    /*
     * Exception decompiling
     */
    public void enableRequest(EventRequest var1_1) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [6[TRYBLOCK]], but top level block is 7[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void setInvalid(Requestor requestor, String string) {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (!this.isVerified(requestor)) {
                this.b.put(requestor, string);
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
        }
    }

    @Nullable
    public String getWarning(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.b.get(requestor);
    }

    public boolean isVerified(Requestor requestor) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return this.findRequests(requestor).stream().anyMatch(eventRequest -> {
            boolean bl2;
            try {
                bl2 = !(eventRequest instanceof ClassPrepareRequest);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
            }
            return bl2;
        });
    }

    @Override
    public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.d = null;
        this.b.clear();
        this.f.clear();
    }

    @Override
    public void processAttached(DebugProcessImpl debugProcessImpl) {
        this.d = this.a.getVirtualMachineProxy().eventRequestManager();
    }

    public void processClassPrepared(ClassPrepareEvent classPrepareEvent) {
        block13: {
            ClassPrepareRequestor classPrepareRequestor;
            ReferenceType referenceType;
            block15: {
                block14: {
                    try {
                        if (!this.a.isAttached()) {
                            return;
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                    referenceType = classPrepareEvent.referenceType();
                    try {
                        try {
                            try {
                                if (!(referenceType instanceof ClassType) && !(referenceType instanceof InterfaceType)) break block13;
                            }
                            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                                throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                            }
                            if (!e.isDebugEnabled()) break block14;
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                        }
                        e.debug("signature = " + referenceType.signature());
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                }
                classPrepareRequestor = (ClassPrepareRequestor)classPrepareEvent.request().getProperty(c);
                try {
                    try {
                        if (classPrepareRequestor == null) break block13;
                        if (!e.isDebugEnabled()) break block15;
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                    }
                    e.debug("requestor found " + referenceType.signature());
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    throw RequestManagerImpl.b(arrayIndexOutOfBoundsException);
                }
            }
            classPrepareRequestor.processClassPrepare((DebugProcess)this.a, referenceType);
        }
    }

    public void clearWarnings() {
        this.b.clear();
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

