/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebugEnvironment;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.ContextUtil;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessAdapterImpl;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JavaDebugProcess;
import com.intellij.debugger.engine.MethodFilter;
import com.intellij.debugger.engine.StackFrameContext;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.SuspendManagerImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationListener;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.jdi.StackFrameProxy;
import com.intellij.debugger.impl.AlternativeJreClassFinder;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextUtil;
import com.intellij.debugger.impl.DebuggerStateManager;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.JvmSteppingCommandProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.impl.SimpleStackFrameContext;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.configurations.RemoteConnection;
import com.intellij.execution.configurations.RemoteState;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.idea.ActionsBundle;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.AreaInstance;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiElementFinder;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.Alarm;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.AbstractDebuggerSession;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueLookupManager;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ThreadReference;
import java.lang.invoke.LambdaMetafactory;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Exception performing whole class analysis ignored.
 */
public class DebuggerSession
implements AbstractDebuggerSession {
    private static final Logger k = Logger.getInstance((String)"#com.intellij.debugger.impl.DebuggerSession");
    private final MyDebuggerStateManager l;
    private volatile boolean e;
    private volatile int a;
    private DebuggerSessionState j;
    private final String m;
    private final DebugProcessImpl d;
    private final GlobalSearchScope f;
    private Sdk h;
    private Sdk g;
    private final DebuggerContextImpl b;
    private final AtomicReference<ThreadReferenceProxyImpl> c;
    protected final Alarm myUpdateAlarm;
    private boolean i;

    public boolean isSteppingThrough(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        return Comparing.equal((Object)this.c.get(), (Object)threadReferenceProxyImpl);
    }

    public void setSteppingThrough(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        this.c.set(threadReferenceProxyImpl);
    }

    public void clearSteppingThrough() {
        this.c.set(null);
        this.resetIgnoreStepFiltersFlag();
    }

    @NotNull
    public GlobalSearchScope getSearchScope() {
        GlobalSearchScope globalSearchScope;
        try {
            globalSearchScope = this.f;
            if (globalSearchScope == null) {
                DebuggerSession.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return globalSearchScope;
    }

    public Sdk getAlternativeJre() {
        return this.h;
    }

    public void setAlternativeJre(Sdk sdk) {
        this.h = sdk;
        ((AlternativeJreClassFinder)((Object)Extensions.findExtension((ExtensionPointName)PsiElementFinder.EP_NAME, (AreaInstance)this.getProject(), AlternativeJreClassFinder.class))).clearCache();
    }

    public Sdk getRunJre() {
        return this.g;
    }

    public boolean isModifiedClassesScanRequired() {
        return this.i;
    }

    public void setModifiedClassesScanRequired(boolean bl2) {
        this.i = bl2;
    }

    static DebuggerSession create(String string, @NotNull DebugProcessImpl debugProcessImpl, DebugEnvironment debugEnvironment) throws ExecutionException {
        try {
            if (debugProcessImpl == null) {
                DebuggerSession.a(1);
            }
        }
        catch (ExecutionException executionException) {
            throw DebuggerSession.b((Exception)((Object)executionException));
        }
        DebuggerSession debuggerSession = new DebuggerSession(string, debugProcessImpl, debugEnvironment);
        try {
            debuggerSession.a(debugEnvironment);
        }
        catch (ExecutionException executionException) {
            debuggerSession.dispose();
            throw executionException;
        }
        return debuggerSession;
    }

    private DebuggerSession(String string, @NotNull DebugProcessImpl debugProcessImpl, DebugEnvironment debugEnvironment) {
        if (debugProcessImpl == null) {
            DebuggerSession.a(2);
        }
        this.a = 0;
        this.j = null;
        this.c = new AtomicReference();
        this.myUpdateAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD);
        this.i = false;
        this.m = string;
        this.d = debugProcessImpl;
        this.b = DebuggerContextImpl.createDebuggerContext(this, null, null, null);
        this.l = new MyDebuggerStateManager();
        this.j = new DebuggerSessionState(State.STOPPED, null);
        this.d.addDebugProcessListener(new MyDebugProcessListener(debugProcessImpl));
        this.d.addEvaluationListener(new MyEvaluationListener());
        ValueLookupManager.getInstance((Project)this.getProject()).startListening();
        this.f = debugEnvironment.getSearchScope();
        this.h = debugEnvironment.getAlternativeJre();
        this.g = debugEnvironment.getRunJre();
    }

    @NotNull
    public DebuggerStateManager getContextManager() {
        MyDebuggerStateManager myDebuggerStateManager;
        try {
            myDebuggerStateManager = this.l;
            if (myDebuggerStateManager == null) {
                DebuggerSession.a(3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return myDebuggerStateManager;
    }

    public Project getProject() {
        return this.getProcess().getProject();
    }

    public String getSessionName() {
        return this.m;
    }

    @NotNull
    public DebugProcessImpl getProcess() {
        DebugProcessImpl debugProcessImpl;
        try {
            debugProcessImpl = this.d;
            if (debugProcessImpl == null) {
                DebuggerSession.a(4);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return debugProcessImpl;
    }

    public State getState() {
        return this.j.myState;
    }

    /*
     * Exception decompiling
     */
    public String getStateDescription() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK]], but top level block is 3[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void a(DebugProcessImpl.ResumeCommand resumeCommand, Event event) {
        this.getContextManager().setState(this.b, State.WAIT_EVALUATION, event, null);
        this.d.getManagerThread().schedule(resumeCommand);
    }

    public void stepOut(int n2) {
        SuspendContextImpl suspendContextImpl = this.b();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        for (JvmSteppingCommandProvider jvmSteppingCommandProvider : (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions()) {
            resumeCommand = jvmSteppingCommandProvider.getStepOutCommand(suspendContextImpl, n2);
            try {
                if (resumeCommand == null) continue;
                break;
            }
            catch (IllegalStateException illegalStateException) {
                throw DebuggerSession.b(illegalStateException);
            }
        }
        if (resumeCommand == null) {
            resumeCommand = this.d.createStepOutCommand(suspendContextImpl, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOut() {
        this.stepOut(-2);
    }

    public void stepOver(boolean bl2, int n2) {
        SuspendContextImpl suspendContextImpl = this.b();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        for (JvmSteppingCommandProvider jvmSteppingCommandProvider : (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions()) {
            resumeCommand = jvmSteppingCommandProvider.getStepOverCommand(suspendContextImpl, bl2, n2);
            try {
                if (resumeCommand == null) continue;
                break;
            }
            catch (IllegalStateException illegalStateException) {
                throw DebuggerSession.b(illegalStateException);
            }
        }
        if (resumeCommand == null) {
            resumeCommand = this.d.createStepOverCommand(suspendContextImpl, bl2, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepOver(boolean bl2) {
        this.stepOver(bl2, -2);
    }

    public void stepInto(boolean bl2, @Nullable MethodFilter methodFilter, int n2) {
        SuspendContextImpl suspendContextImpl = this.b();
        DebugProcessImpl.ResumeCommand resumeCommand = null;
        for (JvmSteppingCommandProvider jvmSteppingCommandProvider : (JvmSteppingCommandProvider[])JvmSteppingCommandProvider.EP_NAME.getExtensions()) {
            resumeCommand = jvmSteppingCommandProvider.getStepIntoCommand(suspendContextImpl, bl2, methodFilter, n2);
            try {
                if (resumeCommand == null) continue;
                break;
            }
            catch (IllegalStateException illegalStateException) {
                throw DebuggerSession.b(illegalStateException);
            }
        }
        if (resumeCommand == null) {
            resumeCommand = this.d.createStepIntoCommand(suspendContextImpl, bl2, methodFilter, n2);
        }
        this.setSteppingThrough(resumeCommand.getContextThread());
        this.a(resumeCommand, Event.STEP);
    }

    public void stepInto(boolean bl2, @Nullable MethodFilter methodFilter) {
        this.stepInto(bl2, methodFilter, -2);
    }

    public void runToCursor(@NotNull XSourcePosition xSourcePosition, boolean bl2) {
        try {
            if (xSourcePosition == null) {
                DebuggerSession.a(5);
            }
        }
        catch (EvaluateException evaluateException) {
            throw DebuggerSession.b((Exception)((Object)evaluateException));
        }
        try {
            DebugProcessImpl.ResumeCommand resumeCommand = this.d.createRunToCursorCommand(this.b(), xSourcePosition, bl2);
            this.setSteppingThrough(resumeCommand.getContextThread());
            this.a(resumeCommand, Event.STEP);
        }
        catch (EvaluateException evaluateException) {
            Messages.showErrorDialog((String)evaluateException.getMessage(), (String)UIUtil.removeMnemonic((String)ActionsBundle.actionText((String)"RunToCursor")));
        }
    }

    public void resume() {
        SuspendContextImpl suspendContextImpl = this.b();
        try {
            if (suspendContextImpl != null) {
                this.clearSteppingThrough();
                this.a(this.d.createResumeCommand(suspendContextImpl), Event.RESUME);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
    }

    public void resetIgnoreStepFiltersFlag() {
        this.a = 0;
    }

    public void setIgnoreStepFiltersFlag(int n2) {
        try {
            this.a = this.a <= 0 ? n2 : Math.min(this.a, n2);
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
    }

    public boolean shouldIgnoreSteppingFilters() {
        boolean bl2;
        try {
            bl2 = this.a > 0;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return bl2;
    }

    public void pause() {
        this.d.getManagerThread().schedule(this.d.createPauseCommand());
    }

    public void showExecutionPoint() {
        this.getContextManager().setState(DebuggerContextUtil.createDebuggerContext(this, this.b()), State.PAUSED, Event.REFRESH, null);
    }

    public void refresh(boolean bl2) {
        Event event;
        State state;
        DebuggerContextImpl debuggerContextImpl;
        MyDebuggerStateManager myDebuggerStateManager;
        State state2 = this.getState();
        DebuggerContextImpl debuggerContextImpl2 = this.l.getContext();
        DebuggerContextImpl debuggerContextImpl3 = DebuggerContextImpl.createDebuggerContext(this, debuggerContextImpl2.getSuspendContext(), debuggerContextImpl2.getThreadProxy(), debuggerContextImpl2.getFrameProxy());
        try {
            myDebuggerStateManager = this.l;
            debuggerContextImpl = debuggerContextImpl3;
            state = state2;
            event = bl2 ? Event.REFRESH_WITH_STACK : Event.REFRESH;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        myDebuggerStateManager.setState(debuggerContextImpl, state, event, null);
    }

    public void dispose() {
        this.getProcess().dispose();
        Disposer.dispose((Disposable)this.myUpdateAlarm);
        DebuggerInvocationUtil.swingInvokeLater(this.getProject(), () -> {
            this.l.setState(this.b, State.DISPOSED, Event.DISPOSE, null);
            this.l.dispose();
        });
    }

    public boolean isStopped() {
        boolean bl2;
        try {
            bl2 = this.getState() == State.STOPPED;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return bl2;
    }

    public boolean isAttached() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (this.isStopped() || this.getState() == State.WAITING_ATTACH) break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw DebuggerSession.b(illegalStateException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DebuggerSession.b(illegalStateException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    public boolean isPaused() {
        boolean bl2;
        try {
            bl2 = this.getState() == State.PAUSED;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return bl2;
    }

    public boolean isConnecting() {
        boolean bl2;
        try {
            bl2 = this.getState() == State.WAITING_ATTACH;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return bl2;
    }

    public boolean isEvaluating() {
        return this.e;
    }

    public boolean isRunning() {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (this.getState() != State.RUNNING || this.getProcess().getProcessHandler().isProcessTerminated()) break block4;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw DebuggerSession.b(illegalStateException);
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DebuggerSession.b(illegalStateException);
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private SuspendContextImpl b() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        return this.getContextManager().getContext().getSuspendContext();
    }

    @Nullable
    private ExecutionResult a(DebugEnvironment debugEnvironment) throws ExecutionException {
        RemoteConnection remoteConnection = debugEnvironment.getRemoteConnection();
        String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
        String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
        ExecutionResult executionResult = this.d.attachVirtualMachine(debugEnvironment, this);
        this.getContextManager().setState(this.b, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, DebuggerBundle.message((String)"status.waiting.attach", (Object[])new Object[]{string, string2}));
        return executionResult;
    }

    public void switchContext(SuspendContextImpl suspendContextImpl) {
        this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(suspendContextImpl){

            @Override
            public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) {
                try {
                    if (suspendContextImpl == null) {
                        1.b(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 1.a(illegalArgumentException);
                }
                DebuggerContextImpl debuggerContextImpl = DebuggerContextUtil.createDebuggerContext(DebuggerSession.this, suspendContextImpl);
                DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.PAUSE, null));
            }

            private static /* synthetic */ void b(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$1", "contextAction"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
    }

    private static String a(DebuggerContextImpl debuggerContextImpl) {
        block4: {
            SuspendContextImpl suspendContextImpl = debuggerContextImpl.getSuspendContext();
            try {
                try {
                    if (suspendContextImpl == null || debuggerContextImpl.getThreadProxy() == suspendContextImpl.getThread()) break block4;
                }
                catch (IllegalStateException illegalStateException) {
                    throw DebuggerSession.b(illegalStateException);
                }
                return DebuggerBundle.message((String)"status.paused.in.another.thread", (Object[])new Object[0]);
            }
            catch (IllegalStateException illegalStateException) {
                throw DebuggerSession.b(illegalStateException);
            }
        }
        return null;
    }

    public static boolean enableBreakpointsDuringEvaluation() {
        return Registry.is((String)"debugger.enable.breakpoints.during.evaluation");
    }

    public void sessionResumed() {
        XDebugSession xDebugSession = this.getXDebugSession();
        try {
            if (xDebugSession != null) {
                xDebugSession.sessionResumed();
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
    }

    @Nullable
    public XDebugSession getXDebugSession() {
        XDebugSession xDebugSession;
        JavaDebugProcess javaDebugProcess = this.d.getXdebugProcess();
        try {
            xDebugSession = javaDebugProcess != null ? javaDebugProcess.getSession() : null;
        }
        catch (IllegalStateException illegalStateException) {
            throw DebuggerSession.b(illegalStateException);
        }
        return xDebugSession;
    }

    static /* synthetic */ Logger access$100() {
        return k;
    }

    static /* synthetic */ DebuggerSessionState access$302(DebuggerSession debuggerSession, DebuggerSessionState debuggerSessionState) {
        debuggerSession.j = debuggerSessionState;
        return debuggerSession.j;
    }

    static /* synthetic */ int access$600(DebuggerSession debuggerSession) {
        return debuggerSession.a;
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }

    private class MyEvaluationListener
    implements EvaluationListener {
        private MyEvaluationListener() {
        }

        @Override
        public void evaluationStarted(SuspendContextImpl suspendContextImpl) {
            DebuggerSession.this.e = true;
        }

        @Override
        public void evaluationFinished(SuspendContextImpl suspendContextImpl) {
            DebuggerSession.this.e = false;
        }
    }

    private class MyDebugProcessListener
    extends DebugProcessAdapterImpl {
        private final DebugProcessImpl a;

        public MyDebugProcessListener(DebugProcessImpl debugProcessImpl) {
            this.a = debugProcessImpl;
        }

        @Override
        public void connectorIsReady() {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                String string;
                RemoteConnection remoteConnection = this.a.getConnection();
                String string2 = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string3 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                try {
                    string = remoteConnection.isServerMode() ? DebuggerBundle.message((String)"status.listening", (Object[])new Object[]{string2, string3}) : DebuggerBundle.message((String)"status.connecting", (Object[])new Object[]{string2, string3});
                }
                catch (ObjectCollectedException objectCollectedException) {
                    throw MyDebugProcessListener.b(objectCollectedException);
                }
                String string4 = string;
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.b, State.WAITING_ATTACH, Event.START_WAIT_ATTACH, string4);
            });
        }

        /*
         * Could not resolve type clashes
         * Unable to fully structure code
         */
        @Override
        public void paused(final SuspendContextImpl var1_1) {
            block57: {
                block52: {
                    block55: {
                        block49: {
                            block51: {
                                block50: {
                                    DebuggerSession.access$100().debug("paused");
                                    var2_2 = var1_1.getThread();
                                    if (!this.a(var1_1)) {
                                        DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, e(), ()V)((MyDebugProcessListener)this));
                                        var3_3 = var1_1.getThread();
                                        if (var3_3 != null) {
                                            var4_4 = DebuggerUtilsEx.getEventDescriptors(var1_1);
                                            try {
                                                if (!var4_4.isEmpty()) {
                                                    XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"status.breakpoint.reached.in.thread", (Object[])new Object[]{var3_3.name()}), DebuggerBundle.message((String)"status.breakpoint.reached.in.thread.switch", (Object[])new Object[0]), NotificationType.INFORMATION, new NotificationListener(){

                                                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent hyperlinkEvent) {
                                                            try {
                                                                if (notification == null) {
                                                                    1.a(0);
                                                                }
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw 1.a(illegalArgumentException);
                                                            }
                                                            try {
                                                                if (hyperlinkEvent == null) {
                                                                    1.a(1);
                                                                }
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw 1.a(illegalArgumentException);
                                                            }
                                                            try {
                                                                if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                                                                    notification.expire();
                                                                    DebuggerSession.this.switchContext(var1_1);
                                                                }
                                                            }
                                                            catch (IllegalArgumentException illegalArgumentException) {
                                                                throw 1.a(illegalArgumentException);
                                                            }
                                                        }

                                                        /*
                                                         * Exception decompiling
                                                         */
                                                        private static /* synthetic */ void a(int var0) {
                                                            /*
                                                             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                                                             * 
                                                             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
                                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                                                             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                                                             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                                                             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                                                             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                                                             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                                                             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                                                             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                                                             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                                                             *     at org.benf.cfr.reader.Main.main(Main.java:54)
                                                             */
                                                            throw new IllegalStateException("Decompilation failed");
                                                        }

                                                        private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                                                            return illegalArgumentException;
                                                        }
                                                    }).notify(DebuggerSession.this.getProject());
                                                }
                                            }
                                            catch (ObjectCollectedException v0) {
                                                throw MyDebugProcessListener.b(v0);
                                            }
                                        }
                                        try {
                                            if (((SuspendManagerImpl)this.a.getSuspendManager()).getPausedContexts().size() > 1) {
                                                return;
                                            }
                                        }
                                        catch (ObjectCollectedException v1) {
                                            throw MyDebugProcessListener.b(v1);
                                        }
                                        var2_2 = (ThreadReferenceProxyImpl)DebuggerSession.access$500(DebuggerSession.this).get();
                                    } else {
                                        DebuggerSession.this.setSteppingThrough((ThreadReferenceProxyImpl)var2_2);
                                    }
                                    if (var2_2 != null) break block49;
                                    try {
                                        block54: {
                                            v2 = DebuggerSession.access$100();
                                            if (var1_1.getSuspendPolicy() != 2) break block50;
                                            break block54;
                                            catch (ObjectCollectedException v3) {
                                                throw MyDebugProcessListener.b(v3);
                                            }
                                        }
                                        v4 = true;
                                        break block51;
                                    }
                                    catch (ObjectCollectedException v5) {
                                        throw MyDebugProcessListener.b(v5);
                                    }
                                }
                                v4 = false;
                            }
                            v2.assertTrue(v4);
                            var4_4 = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                            if (var4_4 != null) {
                                var2_2 = var4_4.getThread();
                            }
                            if (var2_2 == null) {
                                var5_8 = DebuggerSession.this.getProcess().getVirtualMachineProxy().allThreads();
                                for (Object var7_12 : var5_8) {
                                    if (!ThreadState.isEDT((String)var7_12.name())) continue;
                                    var2_2 = var7_12;
                                    break;
                                }
                                if (var2_2 == null) {
                                    var6_9 = var5_8.iterator();
                                    while (var6_9.hasNext()) {
                                        var2_2 = var7_12 = var6_9.next();
                                        try {
                                            if (var2_2.status() != 1) continue;
                                            break;
                                        }
                                        catch (ObjectCollectedException v6) {
                                            throw MyDebugProcessListener.b(v6);
                                        }
                                    }
                                }
                            }
                            var5_8 = null;
                            if (var2_2 != null) {
                                try {
                                    try {
                                        while (!var2_2.isSuspended()) {
                                            TimeoutUtil.sleep((long)10L);
                                        }
                                    }
                                    catch (ObjectCollectedException v7) {
                                        throw MyDebugProcessListener.b(v7);
                                    }
                                    try {
                                        v8 = var2_2.frameCount() > 0 ? var2_2.frame(0) : null;
                                    }
                                    catch (ObjectCollectedException v9) {
                                        throw MyDebugProcessListener.b(v9);
                                    }
                                    var5_8 = v8;
                                }
                                catch (ObjectCollectedException var6_10) {
                                    var5_8 = null;
                                }
                                catch (EvaluateException var6_11) {
                                    var5_8 = null;
                                    DebuggerSession.access$100().error((Throwable)var6_11);
                                }
                            }
                            var3_3 = new SimpleStackFrameContext((StackFrameProxy)var5_8, this.a);
                            break block55;
                        }
                        var3_3 = var1_1;
                    }
                    if (var2_2 == null) break block52;
                    try {
                        var4_5 = var2_2.frameCount();
                        if (var4_5 == 0) ** GOTO lbl96
                        try {
                            block56: {
                                if (var4_5 > DebuggerSession.access$600(DebuggerSession.this)) break block52;
                                break block56;
                                catch (ObjectCollectedException v10) {
                                    throw MyDebugProcessListener.b(v10);
                                }
                            }
                            DebuggerSession.this.resetIgnoreStepFiltersFlag();
                        }
                        catch (ObjectCollectedException v11) {
                            throw MyDebugProcessListener.b(v11);
                        }
                    }
                    catch (EvaluateException var4_6) {
                        DebuggerSession.access$100().info((Throwable)var4_6);
                        DebuggerSession.this.resetIgnoreStepFiltersFlag();
                    }
                }
                if ((var4_7 = ContextUtil.getSourcePosition((StackFrameContext)var3_3)) == null) break block57;
                var5_8 = DebuggerUtilsEx.getEventDescriptors(var1_1);
                var6_9 = var1_1.getDebugProcess().getRequestsManager();
                var7_12 = var4_7.getFile();
                var8_13 = var7_12 instanceof PsiCompiledElement;
                for (Pair var10_15 : var5_8) {
                    block53: {
                        block58: {
                            var11_16 = (Breakpoint)var10_15.getFirst();
                            if (!(var11_16 instanceof LineBreakpoint)) continue;
                            var12_17 = ((BreakpointWithHighlighter)var11_16).getSourcePosition();
                            if (var12_17 == null) ** GOTO lbl127
                            if (var8_13) break block53;
                            break block58;
                            catch (ObjectCollectedException v12) {
                                throw MyDebugProcessListener.b(v12);
                            }
                        }
                        try {
                            block59: {
                                if (var12_17.getLine() == var4_7.getLine()) break block53;
                                break block59;
                                catch (ObjectCollectedException v13) {
                                    throw MyDebugProcessListener.b(v13);
                                }
                            }
                            var6_9.deleteRequest(var11_16);
                            var6_9.setInvalid(var11_16, DebuggerBundle.message((String)"error.invalid.breakpoint.source.changed", (Object[])new Object[0]));
                            var11_16.updateUI();
                            continue;
                        }
                        catch (ObjectCollectedException v14) {
                            throw MyDebugProcessListener.b(v14);
                        }
                    }
                    if (!var8_13) continue;
                    var4_7 = var12_17;
                    var13_18 = var3_3.getFrameProxy();
                    try {
                        try {
                            v15 = var13_18 != null ? var13_18.location().declaringType().name() : "";
                        }
                        catch (ObjectCollectedException v16) {
                            throw MyDebugProcessListener.b(v16);
                        }
                        var14_19 = v15;
                    }
                    catch (EvaluateException var15_20) {
                        var14_19 = "";
                    }
                    var6_9.setInvalid(var11_16, DebuggerBundle.message((String)"error.invalid.breakpoint.source.not.found", (Object[])new Object[]{var14_19}));
                    var11_16.updateUI();
                }
            }
            var5_8 = DebuggerContextImpl.createDebuggerContext(DebuggerSession.this, var1_1, (ThreadReferenceProxyImpl)var2_2, null);
            try {
                if (var1_1.getThread() == var2_2) {
                    var5_8.setPositionCache(var4_7);
                }
            }
            catch (ObjectCollectedException v17) {
                throw MyDebugProcessListener.b(v17);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), (Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.debugger.impl.DebuggerContextImpl ), ()V)((MyDebugProcessListener)this, var5_8));
        }

        private boolean a(SuspendContextImpl suspendContextImpl) {
            SuspendContextImpl suspendContextImpl2;
            ThreadReferenceProxyImpl threadReferenceProxyImpl;
            block17: {
                boolean bl2;
                block19: {
                    block18: {
                        block16: {
                            threadReferenceProxyImpl = suspendContextImpl.getThread();
                            try {
                                block15: {
                                    try {
                                        try {
                                            if (threadReferenceProxyImpl == null || suspendContextImpl.getSuspendPolicy() == 2) break block15;
                                        }
                                        catch (ObjectCollectedException objectCollectedException) {
                                            throw MyDebugProcessListener.b(objectCollectedException);
                                        }
                                        if (!DebuggerSession.this.isSteppingThrough(threadReferenceProxyImpl)) break block16;
                                    }
                                    catch (ObjectCollectedException objectCollectedException) {
                                        throw MyDebugProcessListener.b(objectCollectedException);
                                    }
                                }
                                return true;
                            }
                            catch (ObjectCollectedException objectCollectedException) {
                                throw MyDebugProcessListener.b(objectCollectedException);
                            }
                        }
                        suspendContextImpl2 = DebuggerSession.this.getContextManager().getContext().getSuspendContext();
                        try {
                            try {
                                if (suspendContextImpl2 != null) break block17;
                                if (DebuggerSession.this.c.get() != null) break block18;
                            }
                            catch (ObjectCollectedException objectCollectedException) {
                                throw MyDebugProcessListener.b(objectCollectedException);
                            }
                            bl2 = true;
                            break block19;
                        }
                        catch (ObjectCollectedException objectCollectedException) {
                            throw MyDebugProcessListener.b(objectCollectedException);
                        }
                    }
                    bl2 = false;
                }
                return bl2;
            }
            if (DebuggerSession.enableBreakpointsDuringEvaluation()) {
                boolean bl3;
                block21: {
                    block20: {
                        ThreadReferenceProxyImpl threadReferenceProxyImpl2 = suspendContextImpl2.getThread();
                        try {
                            try {
                                if (threadReferenceProxyImpl2 != null && !Comparing.equal((Object)threadReferenceProxyImpl2.getThreadReference(), (Object)threadReferenceProxyImpl.getThreadReference())) break block20;
                            }
                            catch (ObjectCollectedException objectCollectedException) {
                                throw MyDebugProcessListener.b(objectCollectedException);
                            }
                            bl3 = true;
                            break block21;
                        }
                        catch (ObjectCollectedException objectCollectedException) {
                            throw MyDebugProcessListener.b(objectCollectedException);
                        }
                    }
                    bl3 = false;
                }
                return bl3;
            }
            return false;
        }

        @Override
        public void resumed(SuspendContextImpl suspendContextImpl) {
            DebuggerContextImpl debuggerContextImpl;
            block14: {
                block11: {
                    ThreadReferenceProxyImpl threadReferenceProxyImpl;
                    SuspendContextImpl suspendContextImpl2;
                    DebuggerSession debuggerSession;
                    block13: {
                        SuspendContextImpl suspendContextImpl3;
                        block12: {
                            ThreadReferenceProxyImpl threadReferenceProxyImpl2;
                            block10: {
                                suspendContextImpl3 = DebuggerSession.this.getProcess().getSuspendManager().getPausedContext();
                                threadReferenceProxyImpl2 = null;
                                try {
                                    try {
                                        try {
                                            if (suspendContextImpl3 == null || suspendContextImpl == null) break block10;
                                        }
                                        catch (ObjectCollectedException objectCollectedException) {
                                            throw MyDebugProcessListener.b(objectCollectedException);
                                        }
                                        if (suspendContextImpl.getSuspendPolicy() != 1) break block10;
                                    }
                                    catch (ObjectCollectedException objectCollectedException) {
                                        throw MyDebugProcessListener.b(objectCollectedException);
                                    }
                                    if (!DebuggerSession.this.isSteppingThrough(suspendContextImpl.getThread())) break block10;
                                }
                                catch (ObjectCollectedException objectCollectedException) {
                                    throw MyDebugProcessListener.b(objectCollectedException);
                                }
                                threadReferenceProxyImpl2 = suspendContextImpl.getThread();
                            }
                            try {
                                try {
                                    if (suspendContextImpl3 == null) break block11;
                                    debuggerSession = DebuggerSession.this;
                                    suspendContextImpl2 = suspendContextImpl3;
                                    if (threadReferenceProxyImpl2 == null) break block12;
                                }
                                catch (ObjectCollectedException objectCollectedException) {
                                    throw MyDebugProcessListener.b(objectCollectedException);
                                }
                                threadReferenceProxyImpl = threadReferenceProxyImpl2;
                                break block13;
                            }
                            catch (ObjectCollectedException objectCollectedException) {
                                throw MyDebugProcessListener.b(objectCollectedException);
                            }
                        }
                        threadReferenceProxyImpl = suspendContextImpl3.getThread();
                    }
                    debuggerContextImpl = DebuggerContextImpl.createDebuggerContext(debuggerSession, suspendContextImpl2, threadReferenceProxyImpl, null);
                    break block14;
                }
                debuggerContextImpl = null;
            }
            DebuggerContextImpl debuggerContextImpl2 = debuggerContextImpl;
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                block3: {
                    block2: {
                        try {
                            if (debuggerContextImpl2 == null) break block2;
                            DebuggerSession.this.getContextManager().setState(debuggerContextImpl2, State.PAUSED, Event.CONTEXT, DebuggerSession.a(debuggerContextImpl2));
                            break block3;
                        }
                        catch (ObjectCollectedException objectCollectedException) {
                            throw MyDebugProcessListener.b(objectCollectedException);
                        }
                    }
                    DebuggerSession.this.getContextManager().setState(DebuggerSession.this.b, State.RUNNING, Event.CONTEXT, null);
                }
            });
        }

        @Override
        public void processAttached(DebugProcessImpl debugProcessImpl) {
            RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
            String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
            String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
            String string3 = DebuggerBundle.message((String)"status.connected", (Object[])new Object[]{string, string2});
            debugProcessImpl.printToConsole(string3 + "\n");
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> DebuggerSession.this.getContextManager().setState(DebuggerSession.this.b, State.RUNNING, Event.ATTACHED, string3));
        }

        @Override
        public void attachException(RunProfileState runProfileState, ExecutionException executionException, RemoteConnection remoteConnection) {
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                String string = "";
                if (runProfileState instanceof RemoteState) {
                    string = DebuggerBundle.message((String)"status.connect.failed", (Object[])new Object[]{DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection), DebuggerBundle.getTransportName((RemoteConnection)remoteConnection)});
                }
                string = string + executionException.getMessage();
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.b, State.STOPPED, Event.DETACHED, string);
            });
        }

        @Override
        public void processDetached(DebugProcessImpl debugProcessImpl, boolean bl2) {
            ProcessHandler processHandler;
            if (!bl2 && (processHandler = debugProcessImpl.getProcessHandler()) != null) {
                RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                processHandler.notifyTextAvailable(DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string, string2}) + "\n", ProcessOutputTypes.SYSTEM);
            }
            DebuggerInvocationUtil.invokeLater(DebuggerSession.this.getProject(), () -> {
                RemoteConnection remoteConnection = DebuggerSession.this.getProcess().getConnection();
                String string = DebuggerBundle.getAddressDisplayName((RemoteConnection)remoteConnection);
                String string2 = DebuggerBundle.getTransportName((RemoteConnection)remoteConnection);
                DebuggerSession.this.getContextManager().setState(DebuggerSession.this.b, State.STOPPED, Event.DETACHED, DebuggerBundle.message((String)"status.disconnected", (Object[])new Object[]{string, string2}));
            });
            DebuggerSession.this.clearSteppingThrough();
        }

        @Override
        public void threadStarted(DebugProcess debugProcess, ThreadReference threadReference) {
            this.a();
        }

        @Override
        public void threadStopped(DebugProcess debugProcess, ThreadReference threadReference) {
            block7: {
                this.a();
                ThreadReferenceProxyImpl threadReferenceProxyImpl = (ThreadReferenceProxyImpl)DebuggerSession.this.c.get();
                try {
                    try {
                        if (threadReferenceProxyImpl == null || threadReferenceProxyImpl.getThreadReference() != threadReference) break block7;
                    }
                    catch (ObjectCollectedException objectCollectedException) {
                        throw MyDebugProcessListener.b(objectCollectedException);
                    }
                    DebuggerSession.this.clearSteppingThrough();
                }
                catch (ObjectCollectedException objectCollectedException) {
                    throw MyDebugProcessListener.b(objectCollectedException);
                }
            }
            DebugProcessImpl debugProcessImpl = (DebugProcessImpl)debugProcess;
            try {
                if (debugProcessImpl.getRequestsManager().getFilterThread() == threadReference) {
                    DebuggerManagerEx.getInstanceEx(debugProcess.getProject()).getBreakpointManager().applyThreadFilter(debugProcessImpl, null);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw MyDebugProcessListener.b(objectCollectedException);
            }
        }

        private void a() {
            try {
                if (!DebuggerSession.this.myUpdateAlarm.isDisposed()) {
                    DebuggerSession.this.myUpdateAlarm.cancelAllRequests();
                    DebuggerSession.this.myUpdateAlarm.addRequest(() -> {
                        DebuggerStateManager debuggerStateManager = DebuggerSession.this.getContextManager();
                        debuggerStateManager.fireStateChanged(debuggerStateManager.getContext(), Event.THREADS_REFRESH);
                    }, 100, ModalityState.NON_MODAL);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                throw MyDebugProcessListener.b(objectCollectedException);
            }
        }

        private /* synthetic */ void a(DebuggerContextImpl debuggerContextImpl) {
            DebuggerSession.this.getContextManager().setState(debuggerContextImpl, State.PAUSED, Event.PAUSE, DebuggerSession.a(debuggerContextImpl));
        }

        private /* synthetic */ void e() {
            DebuggerSession.this.getContextManager().fireStateChanged(DebuggerSession.this.getContextManager().getContext(), Event.THREADS_REFRESH);
        }

        private static ObjectCollectedException b(ObjectCollectedException objectCollectedException) {
            return objectCollectedException;
        }
    }

    private static class DebuggerSessionState {
        final State myState;
        final String myDescription;

        public DebuggerSessionState(State state, String string) {
            this.myState = state;
            this.myDescription = string;
        }
    }

    /*
     * Exception performing whole class analysis ignored.
     */
    private class MyDebuggerStateManager
    extends DebuggerStateManager {
        private DebuggerContextImpl b;

        MyDebuggerStateManager() {
            this.b = DebuggerSession.this.b;
        }

        @Override
        @NotNull
        public DebuggerContextImpl getContext() {
            DebuggerContextImpl debuggerContextImpl;
            try {
                debuggerContextImpl = this.b;
                if (debuggerContextImpl == null) {
                    MyDebuggerStateManager.b(0);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw MyDebuggerStateManager.b(illegalStateException);
            }
            return debuggerContextImpl;
        }

        @Override
        public void setState(final @NotNull DebuggerContextImpl debuggerContextImpl, State state, Event event, String string) {
            block12: {
                Runnable runnable;
                block11: {
                    boolean bl2;
                    Logger logger;
                    block10: {
                        block9: {
                            try {
                                if (debuggerContextImpl == null) {
                                    MyDebuggerStateManager.b(1);
                                }
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw MyDebuggerStateManager.b(illegalStateException);
                            }
                            ApplicationManager.getApplication().assertIsDispatchThread();
                            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
                            try {
                                try {
                                    logger = DebuggerSession.access$100();
                                    if (debuggerSession != DebuggerSession.this && debuggerSession != null) break block9;
                                }
                                catch (IllegalStateException illegalStateException) {
                                    throw MyDebuggerStateManager.b(illegalStateException);
                                }
                                bl2 = true;
                                break block10;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw MyDebuggerStateManager.b(illegalStateException);
                            }
                        }
                        bl2 = false;
                    }
                    logger.assertTrue(bl2);
                    runnable = () -> {
                        try {
                            if (debuggerContextImpl == null) {
                                MyDebuggerStateManager.b(2);
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw MyDebuggerStateManager.b(illegalStateException);
                        }
                        try {
                            DebuggerSession.access$100().assertTrue(this.b.isInitialised());
                            this.b = debuggerContextImpl;
                            if (DebuggerSession.access$100().isDebugEnabled()) {
                                DebuggerSession.access$100().debug("DebuggerSession state = " + (Object)((Object)state) + ", event = " + (Object)((Object)event));
                            }
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw MyDebuggerStateManager.b(illegalStateException);
                        }
                        DebuggerSession.access$202(DebuggerSession.this, false);
                        DebuggerSession.access$302(DebuggerSession.this, new DebuggerSessionState(state, string));
                        this.fireStateChanged(debuggerContextImpl, event);
                    };
                    try {
                        if (debuggerContextImpl.getSuspendContext() != null) break block11;
                        runnable.run();
                        break block12;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw MyDebuggerStateManager.b(illegalStateException);
                    }
                }
                DebuggerSession.this.getProcess().getManagerThread().schedule(new SuspendContextCommandImpl(debuggerContextImpl.getSuspendContext()){

                    @Override
                    public PrioritizedTask.Priority getPriority() {
                        return PrioritizedTask.Priority.HIGH;
                    }

                    @Override
                    public void contextAction(@NotNull SuspendContextImpl suspendContextImpl) throws Exception {
                        try {
                            if (suspendContextImpl == null) {
                                1.b(0);
                            }
                        }
                        catch (Exception exception) {
                            throw 1.c(exception);
                        }
                        debuggerContextImpl.initCaches();
                        DebuggerInvocationUtil.swingInvokeLater(DebuggerSession.this.getProject(), runnable);
                    }

                    private static /* synthetic */ void b(int n2) {
                        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/impl/DebuggerSession$MyDebuggerStateManager$1", "contextAction"));
                    }

                    private static Exception c(Exception exception) {
                        return exception;
                    }
                });
            }
        }

        /*
         * Exception decompiling
         */
        private static /* synthetic */ void b(int var0) {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        private static IllegalStateException b(IllegalStateException illegalStateException) {
            return illegalStateException;
        }
    }

    public static enum Event {
        ATTACHED,
        DETACHED,
        RESUME,
        STEP,
        PAUSE,
        REFRESH,
        CONTEXT,
        START_WAIT_ATTACH,
        DISPOSE,
        REFRESH_WITH_STACK,
        THREADS_REFRESH;

    }

    public static enum State {
        STOPPED,
        RUNNING,
        WAITING_ATTACH,
        PAUSED,
        WAIT_EVALUATION,
        DISPOSED;

    }
}

