/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.impl.DebuggerManagerListener;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.impl.MultiProcessCommand;
import com.intellij.debugger.impl.ReloadClassesWorker;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.AbstractProjectComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.HashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class HotSwapManager
extends AbstractProjectComponent {
    private final Map<DebuggerSession, Long> b = new HashMap();
    private static final String a = ".class";

    public HotSwapManager(Project project2, DebuggerManagerEx debuggerManagerEx) {
        super(project2);
        debuggerManagerEx.addDebuggerManagerListener(new DebuggerManagerListener(){

            @Override
            public void sessionCreated(DebuggerSession debuggerSession) {
                HotSwapManager.this.b.put(debuggerSession, System.currentTimeMillis());
            }

            @Override
            public void sessionRemoved(DebuggerSession debuggerSession) {
                HotSwapManager.this.b.remove(debuggerSession);
            }
        });
    }

    @NotNull
    public String getComponentName() {
        String string;
        try {
            string = "HotSwapManager";
            if ("HotSwapManager" == null) {
                HotSwapManager.a(0);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw HotSwapManager.b(illegalStateException);
        }
        return string;
    }

    private long a(DebuggerSession debuggerSession) {
        long l2;
        Long l3 = this.b.get(debuggerSession);
        try {
            l2 = l3 != null ? l3 : 0L;
        }
        catch (IllegalStateException illegalStateException) {
            throw HotSwapManager.b(illegalStateException);
        }
        return l2;
    }

    void setTimeStamp(DebuggerSession debuggerSession, long l2) {
        this.b.put(debuggerSession, l2);
    }

    public Map<String, HotSwapFile> scanForModifiedClasses(DebuggerSession debuggerSession, HotSwapProgress hotSwapProgress) {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        long l2 = this.a(debuggerSession);
        HashMap hashMap = new HashMap();
        ArrayList arrayList = new ArrayList();
        ApplicationManager.getApplication().runReadAction(() -> {
            List list2 = OrderEnumerator.orderEntries((Project)this.myProject).withoutSdk().withoutLibraries().getPathsList().getRootDirs();
            for (VirtualFile virtualFile : list2) {
                arrayList.add(new File(virtualFile.getPath()));
            }
        });
        for (File file : arrayList) {
            String string = FileUtil.toCanonicalPath((String)file.getPath());
            HotSwapManager.a(file, string, string + "/", (Map<String, HotSwapFile>)hashMap, hotSwapProgress, l2);
        }
        return hashMap;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean a(File var0, String var1_1, String var2_2, Map<String, HotSwapFile> var3_3, HotSwapProgress var4_4, long var5_5) {
        block13: {
            block12: {
                block14: {
                    try {
                        if (var4_4.isCancelled()) {
                            return false;
                        }
                    }
                    catch (IllegalStateException v0) {
                        throw HotSwapManager.b(v0);
                    }
                    var7_6 = var0.listFiles();
                    if (var7_6 == null) break block14;
                    for (File var11_11 : var7_6) {
                        try {
                            if (HotSwapManager.a(var11_11, var1_1 + "/" + var11_11.getName(), var2_2, var3_3, var4_4, var5_5)) continue;
                            return false;
                        }
                        catch (IllegalStateException v1) {
                            throw HotSwapManager.b(v1);
                        }
                    }
                    break block13;
                }
                try {
                    try {
                        if (!SystemInfo.isFileSystemCaseSensitive) break block12;
                        if (!StringUtil.endsWith((CharSequence)var1_1, (CharSequence)".class")) break block13;
                        ** GOTO lbl29
                    }
                    catch (IllegalStateException v2) {
                        throw HotSwapManager.b(v2);
                    }
                }
                catch (IllegalStateException v3) {
                    throw HotSwapManager.b(v3);
                }
            }
            try {
                if (!StringUtil.endsWithIgnoreCase((String)var1_1, (String)".class")) break block13;
lbl29:
                // 2 sources

                if (var0.lastModified() <= var5_5) break block13;
            }
            catch (IllegalStateException v4) {
                throw HotSwapManager.b(v4);
            }
            var4_4.setText(DebuggerBundle.message((String)"progress.hotswap.scanning.path", (Object[])new Object[]{var1_1}));
            var8_8 = var1_1.substring(var2_2.length(), var1_1.length() - ".class".length()).replace('/', '.');
            var3_3.put(var8_8, new HotSwapFile(var0));
        }
        return true;
    }

    public static HotSwapManager getInstance(Project project2) {
        return (HotSwapManager)((Object)project2.getComponent(HotSwapManager.class));
    }

    private void a(DebuggerSession debuggerSession, Map<String, HotSwapFile> map, HotSwapProgress hotSwapProgress) {
        block3: {
            long l2;
            block2: {
                l2 = System.currentTimeMillis();
                try {
                    new ReloadClassesWorker(debuggerSession, hotSwapProgress).reloadClasses(map);
                    if (!hotSwapProgress.isCancelled()) break block2;
                    debuggerSession.setModifiedClassesScanRequired(true);
                    break block3;
                }
                catch (IllegalStateException illegalStateException) {
                    throw HotSwapManager.b(illegalStateException);
                }
            }
            this.setTimeStamp(debuggerSession, l2);
        }
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> findModifiedClasses(List<DebuggerSession> list, Map<String, List<String>> map) {
        java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>> hashMap = new java.util.HashMap<DebuggerSession, Map<String, HotSwapFile>>();
        ArrayList<Pair> arrayList = new ArrayList<Pair>();
        for (DebuggerSession object : list) {
            arrayList.add(new Pair((Object)object, (Object)HotSwapManager.getInstance(object.getProject()).a(object)));
        }
        for (Map.Entry entry : map.entrySet()) {
            File file = new File((String)entry.getKey());
            for (String string : (List)entry.getValue()) {
                try {
                    try {
                        if (!(SystemInfo.isFileSystemCaseSensitive ? StringUtil.endsWith((CharSequence)string, (CharSequence)a) : StringUtil.endsWithIgnoreCase((String)string, (String)a))) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw HotSwapManager.b(illegalStateException);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw HotSwapManager.b(illegalStateException);
                }
                String string2 = string.substring(0, string.length() - a.length()).replace('/', '.');
                HotSwapFile hotSwapFile = new HotSwapFile(new File(file, string));
                long l2 = hotSwapFile.file.lastModified();
                for (Pair pair2 : arrayList) {
                    DebuggerSession debuggerSession2 = (DebuggerSession)pair2.first;
                    try {
                        if (l2 <= (Long)pair2.second) continue;
                        hashMap.computeIfAbsent(debuggerSession2, debuggerSession -> new java.util.HashMap()).put(string2, hotSwapFile);
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw HotSwapManager.b(illegalStateException);
                    }
                }
            }
        }
        return hashMap;
    }

    public static Map<DebuggerSession, Map<String, HotSwapFile>> scanForModifiedClasses(List<DebuggerSession> list, final HotSwapProgress hotSwapProgress) {
        HashMap hashMap = new HashMap();
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        hotSwapProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : list) {
            try {
                if (!debuggerSession.isAttached()) continue;
                multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl((Map)hashMap){
                    final /* synthetic */ Map val$modifiedClasses;
                    {
                        this.val$modifiedClasses = map;
                    }

                    @Override
                    protected void action() throws Exception {
                        hotSwapProgress.setDebuggerSession(debuggerSession);
                        Map<String, HotSwapFile> map = HotSwapManager.getInstance(hotSwapProgress.getProject()).scanForModifiedClasses(debuggerSession, hotSwapProgress);
                        try {
                            if (!map.isEmpty()) {
                                this.val$modifiedClasses.put(debuggerSession, map);
                            }
                        }
                        catch (Exception exception) {
                            throw 2.b(exception);
                        }
                    }

                    private static Exception b(Exception exception) {
                        return exception;
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                throw HotSwapManager.b(illegalStateException);
            }
        }
        hotSwapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.scanning.classes", (Object[])new Object[0]));
        multiProcessCommand.run();
        if (hotSwapProgress.isCancelled()) {
            for (final DebuggerSession debuggerSession : list) {
                debuggerSession.setModifiedClassesScanRequired(true);
            }
            return new HashMap();
        }
        return hashMap;
    }

    public static void reloadModifiedClasses(final Map<DebuggerSession, Map<String, HotSwapFile>> map, final HotSwapProgress hotSwapProgress) {
        MultiProcessCommand multiProcessCommand = new MultiProcessCommand();
        hotSwapProgress.setCancelWorker(() -> multiProcessCommand.cancel());
        for (final DebuggerSession debuggerSession : map.keySet()) {
            multiProcessCommand.addCommand(debuggerSession.getProcess(), new DebuggerCommandImpl(){

                @Override
                protected void action() throws Exception {
                    hotSwapProgress.setDebuggerSession(debuggerSession);
                    HotSwapManager.getInstance(hotSwapProgress.getProject()).a(debuggerSession, (Map)map.get(debuggerSession), hotSwapProgress);
                }

                @Override
                protected void commandCancelled() {
                    debuggerSession.setModifiedClassesScanRequired(true);
                }
            });
        }
        hotSwapProgress.setTitle(DebuggerBundle.message((String)"progress.hotswap.reloading", (Object[])new Object[0]));
        multiProcessCommand.run();
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/debugger/impl/HotSwapManager", "getComponentName"));
    }

    private static IllegalStateException b(IllegalStateException illegalStateException) {
        return illegalStateException;
    }
}

