/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.impl;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.actions.ThreadDumpAction;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.HotSwapFile;
import com.intellij.debugger.impl.HotSwapProgress;
import com.intellij.debugger.jdi.ThreadReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.debugger.ui.breakpoints.BreakpointManager;
import com.intellij.debugger.ui.breakpoints.StackCapturingLineBreakpoint;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.unscramble.ThreadState;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.concurrency.Semaphore;
import com.intellij.xdebugger.XDebugSession;
import com.sun.jdi.ReferenceType;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.LambdaMetafactory;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import javax.swing.SwingUtilities;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nullable;

class ReloadClassesWorker {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.impl.ReloadClassesWorker");
    private final DebuggerSession a;
    private final HotSwapProgress b;

    public ReloadClassesWorker(DebuggerSession debuggerSession, HotSwapProgress hotSwapProgress) {
        this.a = debuggerSession;
        this.b = hotSwapProgress;
    }

    private DebugProcessImpl a() {
        return this.a.getProcess();
    }

    private void c(Throwable throwable) {
        block19: {
            block24: {
                block23: {
                    block22: {
                        block21: {
                            block20: {
                                block18: {
                                    try {
                                        if (throwable.getMessage() != null) {
                                            this.b.addMessage(this.a, 4, throwable.getMessage());
                                        }
                                    }
                                    catch (ProcessCanceledException processCanceledException) {
                                        throw ReloadClassesWorker.b(processCanceledException);
                                    }
                                    try {
                                        if (throwable instanceof ProcessCanceledException) {
                                            this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"error.operation.canceled", (Object[])new Object[0]));
                                            return;
                                        }
                                    }
                                    catch (ProcessCanceledException processCanceledException) {
                                        throw ReloadClassesWorker.b(processCanceledException);
                                    }
                                    try {
                                        if (!(throwable instanceof UnsupportedOperationException)) break block18;
                                        this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.operation.not.supported.by.vm", (Object[])new Object[0]));
                                        break block19;
                                    }
                                    catch (ProcessCanceledException processCanceledException) {
                                        throw ReloadClassesWorker.b(processCanceledException);
                                    }
                                }
                                try {
                                    if (!(throwable instanceof NoClassDefFoundError)) break block20;
                                    this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.def.not.found", (Object[])new Object[]{throwable.getLocalizedMessage()}));
                                    break block19;
                                }
                                catch (ProcessCanceledException processCanceledException) {
                                    throw ReloadClassesWorker.b(processCanceledException);
                                }
                            }
                            try {
                                if (!(throwable instanceof VerifyError)) break block21;
                                this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.verification.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
                                break block19;
                            }
                            catch (ProcessCanceledException processCanceledException) {
                                throw ReloadClassesWorker.b(processCanceledException);
                            }
                        }
                        try {
                            if (!(throwable instanceof UnsupportedClassVersionError)) break block22;
                            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.unsupported.class.version", (Object[])new Object[]{throwable.getLocalizedMessage()}));
                            break block19;
                        }
                        catch (ProcessCanceledException processCanceledException) {
                            throw ReloadClassesWorker.b(processCanceledException);
                        }
                    }
                    try {
                        if (!(throwable instanceof ClassFormatError)) break block23;
                        this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.format.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
                        break block19;
                    }
                    catch (ProcessCanceledException processCanceledException) {
                        throw ReloadClassesWorker.b(processCanceledException);
                    }
                }
                try {
                    if (!(throwable instanceof ClassCircularityError)) break block24;
                    this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.class.circularity.error", (Object[])new Object[]{throwable.getLocalizedMessage()}));
                    break block19;
                }
                catch (ProcessCanceledException processCanceledException) {
                    throw ReloadClassesWorker.b(processCanceledException);
                }
            }
            this.b.addMessage(this.a, 4, DebuggerBundle.message((String)"error.exception.while.reloading", (Object[])new Object[]{throwable.getClass().getName(), throwable.getLocalizedMessage()}));
        }
    }

    /*
     * Could not resolve type clashes
     * Unable to fully structure code
     */
    public void reloadClasses(Map<String, HotSwapFile> var1_1) {
        block39: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (var1_1 == null) ** GOTO lbl9
            try {
                block45: {
                    if (var1_1.size() != 0) break block39;
                    break block45;
                    catch (IOException v0) {
                        throw ReloadClassesWorker.b(v0);
                    }
                }
                this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"status.hotswap.loaded.classes.up.to.date", (Object[])new Object[0]));
                return;
            }
            catch (IOException v1) {
                throw ReloadClassesWorker.b(v1);
            }
        }
        var2_2 = this.a();
        var3_3 = var2_2.getVirtualMachineProxy();
        var4_4 = var2_2.getProject();
        var5_5 = DebuggerManagerEx.getInstanceEx(var4_4).getBreakpointManager();
        try {
            var5_5.disableBreakpoints(var2_2);
            StackCapturingLineBreakpoint.deleteAll(var2_2);
            if (ReloadClassesWorker.c.isDebugEnabled()) {
                ReloadClassesWorker.c.debug("Threads before hotswap:\n", new Object[]{StreamEx.of(ThreadDumpAction.buildThreadStates(var3_3)).map((Function<ThreadState, String>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, getStackTrace(), (Lcom/intellij/unscramble/ThreadState;)Ljava/lang/String;)()).joining((CharSequence)"\n")});
            }
        }
        catch (IOException v2) {
            throw ReloadClassesWorker.b(v2);
        }
        try {
            if (Registry.is((String)"debugger.resume.yourkit.threads")) {
                var3_3.allThreads().stream().filter((Predicate<ThreadReferenceProxyImpl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isResumeOnHotSwap(), (Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;)Z)()).filter((Predicate<ThreadReferenceProxyImpl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Z, isSuspended(), (Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;)Z)()).forEach((Consumer<ThreadReferenceProxyImpl>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)V, a(com.intellij.debugger.jdi.ThreadReferenceProxyImpl ), (Lcom/intellij/debugger/jdi/ThreadReferenceProxyImpl;)V)());
            }
        }
        catch (IOException v3) {
            throw ReloadClassesWorker.b(v3);
        }
        try {
            block44: {
                block43: {
                    block42: {
                        var6_6 = new RedefineProcessor(var3_3);
                        var7_8 = 0;
                        for (Object var9_14 : var1_1.entrySet()) {
                            block41: {
                                block40: {
                                    if (var2_2.isDetached()) break;
                                    try {
                                        if (var2_2.isDetaching()) {
                                            break;
                                        }
                                        break block40;
                                        catch (IOException v4) {
                                            throw ReloadClassesWorker.b(v4);
                                        }
                                    }
                                    catch (IOException v5) {
                                        throw ReloadClassesWorker.b(v5);
                                    }
                                }
                                if (var6_6.getProcessedClassesCount() != 0) break block41;
                                try {
                                    if (this.b.isCancelled()) {
                                        break;
                                    }
                                    break block41;
                                    catch (IOException v6) {
                                        throw ReloadClassesWorker.b(v6);
                                    }
                                }
                                catch (IOException v7) {
                                    throw ReloadClassesWorker.b(v7);
                                }
                            }
                            ++var7_8;
                            var10_16 = var9_14.getKey();
                            try {
                                if (var10_16 != null) {
                                    this.b.setText(var10_16);
                                    this.b.setFraction((double)var7_8 / (double)var1_1.size());
                                }
                            }
                            catch (IOException v8) {
                                throw ReloadClassesWorker.b(v8);
                            }
                            try {
                                var6_6.processClass(var10_16, var9_14.getValue().file);
                            }
                            catch (IOException var11_17) {
                                this.a(var10_16, var11_17);
                            }
                        }
                        try {
                            if (var6_6.getProcessedClassesCount() != 0 || !this.b.isCancelled()) break block42;
                        }
                        catch (IOException v9) {
                            throw ReloadClassesWorker.b(v9);
                        }
                        return;
                    }
                    var6_6.processPending();
                    this.b.setFraction(1.0);
                    var8_11 = var6_6.getPartiallyRedefinedClassesCount();
                    try {
                        if (var8_11 != 0) break block43;
                        this.b.addMessage(this.a, 3, DebuggerBundle.message((String)"status.classes.reloaded", (Object[])new Object[]{var6_6.getProcessedClassesCount()}));
                        break block44;
                    }
                    catch (IOException v10) {
                        throw ReloadClassesWorker.b(v10);
                    }
                }
                var9_14 = DebuggerBundle.message((String)"status.classes.not.all.versions.reloaded", (Object[])new Object[]{var8_11, var6_6.getProcessedClassesCount()});
                this.b.addMessage(this.a, 5, (String)var9_14);
            }
            ReloadClassesWorker.c.debug("classes reloaded");
        }
        catch (Throwable var6_7) {
            this.c(var6_7);
        }
        var2_2.onHotSwapFinished();
        var6_6 = this.a.getContextManager().getContext();
        var7_9 = var6_6.getSuspendContext();
        if (var7_9 != null) {
            var8_12 = var7_9.getActiveExecutionStack();
            try {
                if (var8_12 != null) {
                    var8_12.initTopFrame();
                }
            }
            catch (IOException v11) {
                throw ReloadClassesWorker.b(v11);
            }
        }
        var8_13 = new Semaphore();
        var8_13.down();
        SwingUtilities.invokeLater((Runnable)LambdaMetafactory.metafactory(null, null, null, ()V, a(com.intellij.openapi.project.Project com.intellij.debugger.ui.breakpoints.BreakpointManager com.intellij.debugger.engine.DebugProcessImpl com.intellij.util.concurrency.Semaphore ), ()V)((ReloadClassesWorker)this, (Project)var4_4, (BreakpointManager)var5_5, (DebugProcessImpl)var2_2, (Semaphore)var8_13));
        var8_13.waitFor();
        if (!var4_4.isDisposed()) {
            try {
                var5_5.enableBreakpoints(var2_2);
                StackCapturingLineBreakpoint.createAll(var2_2);
            }
            catch (Exception var9_15) {
                this.c(var9_15);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void a(String string, @Nullable Exception exception) {
        String string2;
        block6: {
            string2 = null;
            if (exception != null) {
                string2 = exception.getLocalizedMessage();
            }
            try {
                if (string2 != null && string2.length() != 0) break block6;
            }
            catch (ProcessCanceledException processCanceledException) {
                throw ReloadClassesWorker.b(processCanceledException);
            }
            string2 = DebuggerBundle.message((String)"error.io.error", (Object[])new Object[0]);
        }
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            stringBuilder.append(string).append(" : ").append(string2);
            this.b.addMessage(this.a, 4, stringBuilder.toString());
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private /* synthetic */ void a(Project project2, BreakpointManager breakpointManager, DebugProcessImpl debugProcessImpl, Semaphore semaphore) {
        block12: {
            try {
                block13: {
                    if (project2.isDisposed()) break block12;
                    try {
                        block14: {
                            breakpointManager.reloadBreakpoints();
                            debugProcessImpl.getRequestsManager().clearWarnings();
                            if (!c.isDebugEnabled()) break block13;
                            break block14;
                            catch (Throwable throwable) {
                                throw ReloadClassesWorker.b(throwable);
                            }
                        }
                        c.debug("requests updated");
                        c.debug("time stamp set");
                    }
                    catch (Throwable throwable) {
                        throw ReloadClassesWorker.b(throwable);
                    }
                }
                this.a.refresh(false);
                XDebugSession xDebugSession = this.a.getXDebugSession();
                try {
                    if (xDebugSession != null) {
                        xDebugSession.rebuildViews();
                    }
                }
                catch (Throwable throwable) {
                    throw ReloadClassesWorker.b(throwable);
                }
            }
            catch (Throwable throwable) {
                c.error(throwable);
            }
            finally {
                semaphore.up();
            }
        }
    }

    private static /* synthetic */ void a(ThreadReferenceProxyImpl threadReferenceProxyImpl) {
        IntStream.range(0, threadReferenceProxyImpl.getSuspendCount()).forEach(n2 -> threadReferenceProxyImpl.resume());
    }

    private static Throwable b(Throwable throwable) {
        return throwable;
    }

    private static class RedefineProcessor {
        private static final int a = 100;
        private final VirtualMachineProxyImpl b;
        private final Map<ReferenceType, byte[]> e = new HashMap<ReferenceType, byte[]>();
        private int d;
        private int c;

        public RedefineProcessor(VirtualMachineProxyImpl virtualMachineProxyImpl) {
            this.b = virtualMachineProxyImpl;
        }

        /*
         * Loose catch block
         */
        public void processClass(String string, File file) throws Throwable {
            byte[] byArray;
            List<ReferenceType> list;
            block17: {
                block16: {
                    list = this.b.classesByName(string);
                    try {
                        if (list.isEmpty()) {
                            return;
                        }
                    }
                    catch (Throwable throwable) {
                        throw RedefineProcessor.b(throwable);
                    }
                    byArray = FileUtil.loadFileBytes((File)file);
                    if (list.size() != 1) break block17;
                    try {
                        block18: {
                            this.e.put(list.get(0), byArray);
                            if (this.e.size() < 100) break block16;
                            break block18;
                            catch (Throwable throwable) {
                                throw RedefineProcessor.b(throwable);
                            }
                        }
                        this.a();
                    }
                    catch (Throwable throwable) {
                        throw RedefineProcessor.b(throwable);
                    }
                }
                return;
            }
            int n2 = 0;
            Throwable throwable = null;
            for (ReferenceType referenceType : list) {
                try {
                    this.b.redefineClasses(Collections.singletonMap(referenceType, byArray));
                    ++n2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                }
            }
            try {
                if (n2 == 0) {
                    throw throwable;
                }
            }
            catch (Throwable throwable3) {
                throw RedefineProcessor.b(throwable3);
            }
            try {
                if (n2 < list.size()) {
                    ++this.c;
                }
            }
            catch (Throwable throwable4) {
                throw RedefineProcessor.b(throwable4);
            }
            ++this.d;
        }

        private void a() throws Throwable {
            try {
                this.b.redefineClasses(this.e);
                this.d += this.e.size();
            }
            finally {
                this.e.clear();
            }
        }

        public void processPending() throws Throwable {
            try {
                if (this.e.size() > 0) {
                    this.a();
                }
            }
            catch (Throwable throwable) {
                throw RedefineProcessor.b(throwable);
            }
        }

        public int getProcessedClassesCount() {
            return this.d;
        }

        public int getPartiallyRedefinedClassesCount() {
            return this.c;
        }

        private static Throwable b(Throwable throwable) {
            return throwable;
        }
    }
}

