/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.jdi;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.jdi.ThreadReferenceProxy;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.jdi.ObjectReferenceProxyImpl;
import com.intellij.debugger.jdi.StackFrameProxyImpl;
import com.intellij.debugger.jdi.ThreadGroupReferenceProxyImpl;
import com.intellij.debugger.jdi.VirtualMachineProxyImpl;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.ThreeState;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.InternalException;
import com.sun.jdi.InvalidStackFrameException;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.StackFrame;
import com.sun.jdi.ThreadGroupReference;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

/*
 * Exception performing whole class analysis ignored.
 */
public final class ThreadReferenceProxyImpl
extends ObjectReferenceProxyImpl
implements ThreadReferenceProxy {
    private static final Logger f = Logger.getInstance((String)"#com.intellij.debugger.jdi.ThreadReferenceProxyImpl");
    private String h;
    private int i = -1;
    private final LinkedList<StackFrameProxyImpl> k = new LinkedList();
    private List<StackFrameProxyImpl> l = null;
    private ThreadGroupReferenceProxyImpl j;
    private ThreeState g = ThreeState.UNSURE;
    public static final Comparator<ThreadReferenceProxyImpl> ourComparator = (threadReferenceProxyImpl, threadReferenceProxyImpl2) -> {
        int n2 = Comparing.compare((boolean)threadReferenceProxyImpl2.isSuspended(), (boolean)threadReferenceProxyImpl.isSuspended());
        try {
            if (n2 == 0) {
                return threadReferenceProxyImpl.name().compareToIgnoreCase(threadReferenceProxyImpl2.name());
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw ThreadReferenceProxyImpl.b(objectCollectedException);
        }
        return n2;
    };

    public ThreadReferenceProxyImpl(VirtualMachineProxyImpl virtualMachineProxyImpl, ThreadReference threadReference) {
        super(virtualMachineProxyImpl, threadReference);
    }

    public ThreadReference getThreadReference() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        return (ThreadReference)this.getObjectReference();
    }

    @NotNull
    public VirtualMachineProxyImpl getVirtualMachine() {
        VirtualMachineProxyImpl virtualMachineProxyImpl;
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            virtualMachineProxyImpl = (VirtualMachineProxyImpl)this.myTimer;
            if (virtualMachineProxyImpl == null) {
                ThreadReferenceProxyImpl.c(0);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw ThreadReferenceProxyImpl.b(objectCollectedException);
        }
        return virtualMachineProxyImpl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String name() {
        try {
            this.checkValid();
            if (this.h != null) return this.h;
            try {
                this.h = this.getThreadReference().name();
                return this.h;
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.h = "";
                return this.h;
            }
            catch (IllegalThreadStateException illegalThreadStateException) {
                this.h = "zombie";
                return this.h;
            }
        }
        catch (InternalException internalException) {
            throw ThreadReferenceProxyImpl.b(internalException);
        }
    }

    public int getSuspendCount() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            return this.getThreadReference().suspendCount();
        }
        catch (ObjectCollectedException objectCollectedException) {
            return 0;
        }
    }

    public void suspend() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().suspend();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        this.clearCaches();
    }

    @Override
    @NonNls
    public String toString() {
        try {
            return this.name() + ": " + DebuggerUtilsEx.getThreadStatusText(this.status());
        }
        catch (ObjectCollectedException objectCollectedException) {
            return "[thread collected]";
        }
    }

    public void resume() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (f.isDebugEnabled()) {
                f.debug("before resume" + threadReference);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw ThreadReferenceProxyImpl.b(objectCollectedException);
        }
        this.getVirtualMachineProxy().clearCaches();
        try {
            threadReference.resume();
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
    }

    @Override
    protected void clearCaches() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.h = null;
        this.l = null;
        this.i = -1;
        super.clearCaches();
    }

    public int status() {
        try {
            return this.getThreadReference().status();
        }
        catch (ObjectCollectedException | IllegalThreadStateException runtimeException) {
            return 0;
        }
    }

    public ThreadGroupReferenceProxyImpl threadGroupProxy() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.j == null) {
            ThreadGroupReference threadGroupReference;
            try {
                threadGroupReference = this.getThreadReference().threadGroup();
            }
            catch (ObjectCollectedException objectCollectedException) {
                threadGroupReference = null;
            }
            this.j = this.getVirtualMachineProxy().getThreadGroupReferenceProxy(threadGroupReference);
        }
        return this.j;
    }

    public int frameCount() throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        this.checkValid();
        if (this.i == -1) {
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.i = threadReference.frameCount();
            }
            catch (ObjectCollectedException objectCollectedException) {
                this.i = 0;
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                boolean bl2;
                try {
                    bl2 = threadReference.isSuspended();
                }
                catch (Throwable throwable) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
                }
                try {
                    if (!bl2) {
                        throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
                    }
                }
                catch (ObjectCollectedException objectCollectedException) {
                    throw ThreadReferenceProxyImpl.b(objectCollectedException);
                }
                this.i = 0;
            }
            catch (InternalException internalException) {
                f.info((Throwable)internalException);
                this.i = 0;
            }
        }
        return this.i;
    }

    @NotNull
    public List<StackFrameProxyImpl> forceFrames() throws EvaluateException {
        List<StackFrameProxyImpl> list;
        block11: {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            ThreadReference threadReference = this.getThreadReference();
            try {
                this.checkValid();
                if (this.l != null) break block11;
                try {
                    List<StackFrame> list2 = threadReference.frames();
                    this.i = list2.size();
                    this.l = new ArrayList<StackFrameProxyImpl>(this.i);
                    this.k.clear();
                    int n2 = 0;
                    for (StackFrame stackFrame : list2) {
                        StackFrameProxyImpl stackFrameProxyImpl = new StackFrameProxyImpl(this, stackFrame, this.i - n2);
                        this.l.add(stackFrameProxyImpl);
                        this.k.addFirst(stackFrameProxyImpl);
                        ++n2;
                    }
                }
                catch (IncompatibleThreadStateException | InternalException exception) {
                    throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
                }
            }
            catch (ObjectCollectedException objectCollectedException) {
                List<StackFrameProxyImpl> list3;
                try {
                    list3 = Collections.emptyList();
                    if (list3 == null) {
                        ThreadReferenceProxyImpl.c(1);
                    }
                }
                catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    throw ThreadReferenceProxyImpl.b(incompatibleThreadStateException);
                }
                return list3;
            }
        }
        try {
            list = this.l;
            if (list == null) {
                ThreadReferenceProxyImpl.c(2);
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw ThreadReferenceProxyImpl.b(incompatibleThreadStateException);
        }
        return list;
    }

    @NotNull
    public List<StackFrameProxyImpl> frames() throws EvaluateException {
        List<StackFrameProxyImpl> list;
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            try {
                this.checkValid();
                if (this.l == null) {
                    this.a(threadReference);
                    this.l = ContainerUtil.reverse(new ArrayList(this.k.subList(0, this.frameCount())));
                }
            }
            catch (EvaluateException evaluateException) {
                throw ThreadReferenceProxyImpl.b((Exception)((Object)evaluateException));
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            List<StackFrameProxyImpl> list2;
            try {
                list2 = Collections.emptyList();
                if (list2 == null) {
                    ThreadReferenceProxyImpl.c(3);
                }
            }
            catch (ObjectCollectedException objectCollectedException2) {
                throw ThreadReferenceProxyImpl.b(objectCollectedException2);
            }
            return list2;
        }
        try {
            list = this.l;
            if (list == null) {
                ThreadReferenceProxyImpl.c(4);
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw ThreadReferenceProxyImpl.b(objectCollectedException);
        }
        return list;
    }

    private void a(@NotNull ThreadReference threadReference) throws EvaluateException {
        try {
            if (threadReference == null) {
                ThreadReferenceProxyImpl.c(5);
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw ThreadReferenceProxyImpl.b(incompatibleThreadStateException);
        }
        int n2 = this.frameCount();
        if (this.k.size() < n2) {
            List<StackFrame> list;
            try {
                list = threadReference.frames(0, n2 - this.k.size());
            }
            catch (IncompatibleThreadStateException | InternalException exception) {
                throw EvaluateExceptionUtil.createEvaluateException((Throwable)exception);
            }
            int n3 = this.k.size() + 1;
            ListIterator<StackFrame> listIterator = list.listIterator(n2 - this.k.size());
            try {
                while (listIterator.hasPrevious()) {
                    this.k.add(new StackFrameProxyImpl(this, listIterator.previous(), n3));
                    ++n3;
                }
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                throw ThreadReferenceProxyImpl.b(incompatibleThreadStateException);
            }
        }
        try {
            while (this.k.size() > n2) {
                this.k.removeLast();
            }
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw ThreadReferenceProxyImpl.b(incompatibleThreadStateException);
        }
    }

    public StackFrameProxyImpl frame(int n2) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        ThreadReference threadReference = this.getThreadReference();
        try {
            if (!threadReference.isSuspended()) {
                return null;
            }
        }
        catch (EvaluateException evaluateException) {
            throw ThreadReferenceProxyImpl.b((Exception)((Object)evaluateException));
        }
        try {
            this.a(threadReference);
            int n3 = this.frameCount();
            if (n3 == 0) {
                return null;
            }
            return this.k.get(n3 - n2 - 1);
        }
        catch (ObjectCollectedException | IllegalThreadStateException runtimeException) {
            return null;
        }
    }

    public void popFrames(StackFrameProxyImpl stackFrameProxyImpl) throws EvaluateException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().popFrames(stackFrameProxyImpl.getStackFrame());
        }
        catch (InvalidStackFrameException | ObjectCollectedException runtimeException) {
        }
        catch (InternalException internalException) {
            try {
                if (internalException.errorCode() == 32) {
                    throw EvaluateExceptionUtil.createEvaluateException((String)DebuggerBundle.message((String)"drop.frame.error.no.information", (Object[])new Object[0]));
                }
            }
            catch (InvalidStackFrameException invalidStackFrameException) {
                throw ThreadReferenceProxyImpl.b(invalidStackFrameException);
            }
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)internalException);
        }
        catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            throw EvaluateExceptionUtil.createEvaluateException((Throwable)incompatibleThreadStateException);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void forceEarlyReturn(Value value) throws ClassNotLoadedException, IncompatibleThreadStateException, InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().forceEarlyReturn(value);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public void stop(ObjectReference objectReference) throws InvalidTypeException {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        try {
            this.getThreadReference().stop(objectReference);
        }
        finally {
            this.clearCaches();
            this.getVirtualMachineProxy().clearCaches();
        }
    }

    public boolean isSuspended() throws ObjectCollectedException {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            return this.getThreadReference().isSuspended();
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            f.info((Throwable)illegalThreadStateException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isAtBreakpoint() {
        try {
            return this.getThreadReference().isAtBreakpoint();
        }
        catch (InternalException internalException) {
            f.info((Throwable)internalException);
        }
        catch (ObjectCollectedException objectCollectedException) {
            // empty catch block
        }
        return false;
    }

    public boolean isResumeOnHotSwap() {
        try {
            DebuggerManagerThreadImpl.assertIsManagerThread();
            if (this.g == ThreeState.UNSURE) {
                this.g = ThreeState.fromBoolean((boolean)this.name().startsWith("YJPAgent-"));
            }
        }
        catch (ObjectCollectedException objectCollectedException) {
            throw ThreadReferenceProxyImpl.b(objectCollectedException);
        }
        return this.g.toBoolean();
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void c(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

