/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.settings.CaptureConfigurable;
import com.intellij.debugger.settings.CapturePoint;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import one.util.streamex.StreamEx;

public class CaptureSettingsProvider {
    private static final List<AgentCapturePoint> b = new ArrayList<AgentCapturePoint>();
    private static final List<AgentInsertPoint> e = new ArrayList<AgentInsertPoint>();
    private static final List<CapturePoint> d;
    private static final KeyProvider a;
    private static final KeyProvider c;

    public static List<AgentPoint> getPoints() {
        List list = ContainerUtil.concat(b, e);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list = ContainerUtil.concat((List)list, CaptureSettingsProvider.b());
        }
        return list;
    }

    public static List<CapturePoint> getIdeInsertPoints() {
        List list = Collections.unmodifiableList(d);
        if (Registry.is((String)"debugger.capture.points.agent.annotations")) {
            list = ContainerUtil.concat(list, (List)StreamEx.of(CaptureSettingsProvider.b()).select(AgentInsertPoint.class).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList());
        }
        return list;
    }

    private static List<AgentPoint> b() {
        return (List)ReadAction.compute(() -> {
            ArrayList arrayList = new ArrayList();
            CaptureConfigurable.processCaptureAnnotations((bl2, psiModifierListOwner) -> {
                AgentPoint agentPoint;
                String string;
                Object object;
                KeyProvider keyProvider;
                PsiMethod psiMethod;
                block11: {
                    PsiParameter psiParameter;
                    if (psiModifierListOwner instanceof PsiMethod) {
                        psiMethod = (PsiMethod)psiModifierListOwner;
                        keyProvider = a;
                    } else if (psiModifierListOwner instanceof PsiParameter) {
                        psiParameter = (PsiParameter)psiModifierListOwner;
                        psiMethod = (PsiMethod)psiParameter.getDeclarationScope();
                        keyProvider = CaptureSettingsProvider.a(psiMethod.getParameterList().getParameterIndex(psiParameter));
                    } else {
                        return;
                    }
                    psiParameter = psiModifierListOwner.getModifierList();
                    if (psiParameter != null && (object = psiParameter.findAnnotation(CaptureConfigurable.getAnnotationName(bl2))) != null) {
                        string = object.findAttributeValue("keyExpression");
                        try {
                            try {
                                if (string == null || "\"\"".equals(string.getText())) break block11;
                            }
                            catch (RuntimeException runtimeException) {
                                throw CaptureSettingsProvider.b(runtimeException);
                            }
                            return;
                        }
                        catch (RuntimeException runtimeException) {
                            throw CaptureSettingsProvider.b(runtimeException);
                        }
                    }
                }
                object = JVMNameUtil.getNonAnonymousClassName(psiMethod.getContainingClass()).replaceAll("\\.", "/");
                string = JVMNameUtil.getJVMMethodName(psiMethod);
                try {
                    agentPoint = bl2 != false ? new AgentCapturePoint((String)object, string, keyProvider) : new AgentInsertPoint((String)object, string, keyProvider);
                }
                catch (RuntimeException runtimeException) {
                    throw CaptureSettingsProvider.b(runtimeException);
                }
                AgentPoint agentPoint2 = agentPoint;
                arrayList.add(agentPoint2);
            });
            return arrayList;
        });
    }

    private static KeyProvider a(int n2) {
        return new StringKeyProvider(Integer.toString(n2));
    }

    private static void b(String string, String string2, KeyProvider keyProvider) {
        b.add(new AgentCapturePoint(string, string2, keyProvider));
    }

    private static void a(String string, String string2, KeyProvider keyProvider) {
        e.add(new AgentInsertPoint(string, string2, keyProvider));
    }

    static {
        a = new StringKeyProvider("this");
        c = CaptureSettingsProvider.a(0);
        CaptureSettingsProvider.b("javax/swing/SwingUtilities", "invokeLater", c);
        CaptureSettingsProvider.a("java/awt/event/InvocationEvent", "dispatch", new FieldKeyProvider("java/awt/event/InvocationEvent", "runnable", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.b("java/lang/Thread", "start", a);
        CaptureSettingsProvider.a("java/lang/Thread", "run", a);
        CaptureSettingsProvider.b("java/util/concurrent/ExecutorService", "submit", c);
        CaptureSettingsProvider.a("java/util/concurrent/Executors$RunnableAdapter", "call", new FieldKeyProvider("java/util/concurrent/Executors$RunnableAdapter", "task", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.b("java/util/concurrent/ThreadPoolExecutor", "execute", c);
        CaptureSettingsProvider.a("java/util/concurrent/FutureTask", "run", a);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "supplyAsync", c);
        AgentInsertPoint agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncSupply", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncSupply", "fn", "Ljava/util/function/Supplier;"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        e.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "runAsync", c);
        agentInsertPoint2 = new AgentInsertPoint("java/util/concurrent/CompletableFuture$AsyncRun", "run", new FieldKeyProvider("java/util/concurrent/CompletableFuture$AsyncRun", "fn", "Ljava/lang/Runnable;"));
        agentInsertPoint2.myInsertPoint.myInsertMethodName = "run$$$capture";
        agentInsertPoint2.myInsertPoint.myInsertKeyExpression = "f";
        e.add(agentInsertPoint2);
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenAcceptAsync", c);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniAccept", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniAccept", "fn", "Ljava/util/function/Consumer;"));
        CaptureSettingsProvider.b("java/util/concurrent/CompletableFuture", "thenRunAsync", c);
        CaptureSettingsProvider.a("java/util/concurrent/CompletableFuture$UniRun", "tryFire", new FieldKeyProvider("java/util/concurrent/CompletableFuture$UniRun", "fn", "Ljava/lang/Runnable;"));
        CaptureSettingsProvider.b("io/netty/util/concurrent/SingleThreadEventExecutor", "addTask", c);
        CaptureSettingsProvider.a("io/netty/util/concurrent/AbstractEventExecutor", "safeExecute", c);
        CaptureSettingsProvider.b("scala/concurrent/impl/Future$PromiseCompletingRunnable", "<init>", a);
        CaptureSettingsProvider.a("scala/concurrent/impl/Future$PromiseCompletingRunnable", "run", a);
        CaptureSettingsProvider.b("scala/concurrent/impl/CallbackRunnable", "<init>", a);
        CaptureSettingsProvider.a("scala/concurrent/impl/CallbackRunnable", "run", a);
        CaptureSettingsProvider.b("akka/actor/ScalaActorRef", "$bang", c);
        CaptureSettingsProvider.b("akka/actor/RepointableActorRef", "$bang", c);
        CaptureSettingsProvider.b("akka/actor/LocalActorRef", "$bang", c);
        CaptureSettingsProvider.a("akka/actor/Actor$class", "aroundReceive", CaptureSettingsProvider.a(2));
        d = StreamEx.of(e).map(agentInsertPoint -> agentInsertPoint.myInsertPoint).nonNull().toList();
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    private static class FieldKeyProvider
    implements KeyProvider {
        private final String c;
        private final String b;
        private final String a;

        public FieldKeyProvider(String string, String string2, String string3) {
            this.c = string;
            this.b = string2;
            this.a = string3;
        }

        @Override
        public String asString() {
            return this.c + " " + this.b + " " + this.a;
        }
    }

    private static class StringKeyProvider
    implements KeyProvider {
        private final String a;

        public StringKeyProvider(String string) {
            this.a = string;
        }

        @Override
        public String asString() {
            return this.a;
        }
    }

    public static interface KeyProvider {
        public String asString();
    }

    public static class AgentInsertPoint
    extends AgentPoint {
        public final CapturePoint myInsertPoint = new CapturePoint();

        public AgentInsertPoint(String string, String string2, KeyProvider keyProvider) {
            super(string, string2, keyProvider);
            this.myInsertPoint.myInsertClassName = string.replaceAll("/", ".");
            this.myInsertPoint.myInsertMethodName = string2;
            if (this.myKey instanceof FieldKeyProvider) {
                this.myInsertPoint.myInsertKeyExpression = ((FieldKeyProvider)this.myKey).b;
            } else {
                String string3 = keyProvider.asString();
                try {
                    this.myInsertPoint.myInsertKeyExpression = "param_" + Integer.parseInt(string3);
                }
                catch (NumberFormatException numberFormatException) {
                    this.myInsertPoint.myInsertKeyExpression = string3;
                }
            }
        }

        @Override
        public boolean isCapture() {
            return false;
        }
    }

    public static class AgentCapturePoint
    extends AgentPoint {
        public AgentCapturePoint(String string, String string2, KeyProvider keyProvider) {
            super(string, string2, keyProvider);
        }

        @Override
        public boolean isCapture() {
            return true;
        }
    }

    public static abstract class AgentPoint {
        public final String myClassName;
        public final String myMethodName;
        public final KeyProvider myKey;
        public static final String SEPARATOR = " ";

        public AgentPoint(String string, String string2, KeyProvider keyProvider) {
            assert (!string.contains(".")) : "Classname should not contain . here";
            this.myClassName = string;
            this.myMethodName = string2;
            this.myKey = keyProvider;
        }

        public abstract boolean isCapture();
    }
}

