/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.settings.DataBinding;
import com.intellij.util.ReflectionUtil;
import java.lang.reflect.Field;
import org.jetbrains.annotations.NonNls;

public abstract class FieldDataBinding
implements DataBinding {
    private final String a;

    protected FieldDataBinding(@NonNls String string) {
        this.a = string;
    }

    @Override
    public final void loadData(Object object) {
        try {
            Field field = this.a(object);
            this.doLoadData(object, field);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public final void saveData(Object object) {
        try {
            Field field = this.a(object);
            this.doSaveData(object, field);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    @Override
    public boolean isModified(Object object) {
        try {
            Field field = this.a(object);
            return this.isModified(object, field);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException.getMessage(), illegalAccessException);
        }
    }

    protected abstract void doLoadData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract void doSaveData(Object var1, Field var2) throws IllegalAccessException;

    protected abstract boolean isModified(Object var1, Field var2) throws IllegalAccessException;

    private Field a(Object object) {
        try {
            return ReflectionUtil.findField(object.getClass(), null, (String)this.a);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new RuntimeException(DebuggerBundle.message((String)"error.field.not.found.in.class", (Object[])new Object[]{this.a, object.getClass().getName()}));
        }
    }
}

