/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.settings;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerContext;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluateExceptionUtil;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.settings.RendererConfiguration;
import com.intellij.debugger.ui.impl.watch.ArrayElementDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.DebuggerTreeNode;
import com.intellij.debugger.ui.tree.ValueDescriptor;
import com.intellij.debugger.ui.tree.render.ArrayRenderer;
import com.intellij.debugger.ui.tree.render.CachedEvaluator;
import com.intellij.debugger.ui.tree.render.ChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ClassRenderer;
import com.intellij.debugger.ui.tree.render.CompoundReferenceRenderer;
import com.intellij.debugger.ui.tree.render.CompoundTypeRenderer;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.debugger.ui.tree.render.EnumerationChildrenRenderer;
import com.intellij.debugger.ui.tree.render.ExpressionChildrenRenderer;
import com.intellij.debugger.ui.tree.render.HexRenderer;
import com.intellij.debugger.ui.tree.render.LabelRenderer;
import com.intellij.debugger.ui.tree.render.NodeRenderer;
import com.intellij.debugger.ui.tree.render.NodeRendererSettingsListener;
import com.intellij.debugger.ui.tree.render.PrimitiveRenderer;
import com.intellij.debugger.ui.tree.render.ReferenceRenderer;
import com.intellij.debugger.ui.tree.render.Renderer;
import com.intellij.debugger.ui.tree.render.ToStringRenderer;
import com.intellij.debugger.ui.tree.render.ValueLabelRenderer;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.util.EventDispatcher;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.InternalIterator;
import com.sun.jdi.Value;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.List;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="NodeRendererSettings", storages={@Storage(value="debugger.renderers.xml")})
public class NodeRendererSettings
implements PersistentStateComponent<Element> {
    @NonNls
    private static final String h = "Reference renderer";
    @NonNls
    public static final String RENDERER_TAG = "Renderer";
    @NonNls
    private static final String d = "ID";
    private final EventDispatcher<NodeRendererSettingsListener> c = EventDispatcher.create(NodeRendererSettingsListener.class);
    private RendererConfiguration b = new RendererConfiguration(this);
    private final PrimitiveRenderer e = new PrimitiveRenderer();
    private final ArrayRenderer g = new ArrayRenderer();
    private final ClassRenderer a = new ClassRenderer();
    private final HexRenderer m = new HexRenderer();
    private final ToStringRenderer f = new ToStringRenderer();
    private final NodeRenderer[] k = new NodeRenderer[]{this.createCompoundReferenceRenderer("Map", "java.util.Map", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("entrySet().toArray()", "!isEmpty()", this.g)), this.createCompoundReferenceRenderer("Map.Entry", "java.util.Map$Entry", new MapEntryLabelRenderer(), NodeRendererSettings.createEnumerationChildrenRenderer(new String[][]{{"key", "getKey()"}, {"value", "getValue()"}})), new ListObjectRenderer(this, this.g), this.createCompoundReferenceRenderer("Collection", "java.util.Collection", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", this.g))};
    @NonNls
    private static final String j = "HEX_VIEW_ENABLED";
    @NonNls
    private static final String l = "ALTERNATIVE_COLLECTION_VIEW_ENABLED";
    @NonNls
    private static final String i = "CustomRenderers";

    public NodeRendererSettings() {
        this.m.setEnabled(false);
        this.f.setEnabled(true);
        this.setAlternateCollectionViewsEnabled(true);
    }

    public static NodeRendererSettings getInstance() {
        return (NodeRendererSettings)ServiceManager.getService(NodeRendererSettings.class);
    }

    public void setAlternateCollectionViewsEnabled(boolean bl2) {
        for (NodeRenderer nodeRenderer : this.k) {
            nodeRenderer.setEnabled(bl2);
        }
    }

    public boolean areAlternateCollectionViewsEnabled() {
        return this.k[0].isEnabled();
    }

    public boolean equals(Object object) {
        try {
            if (!(object instanceof NodeRendererSettings)) {
                return false;
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        return DebuggerUtilsEx.elementsEqual(this.getState(), ((NodeRendererSettings)object).getState());
    }

    public void addListener(NodeRendererSettingsListener nodeRendererSettingsListener, Disposable disposable) {
        this.c.addListener((EventListener)nodeRendererSettingsListener, disposable);
    }

    public Element getState() {
        Element element = new Element("NodeRendererSettings");
        try {
            if (this.m.isEnabled()) {
                JDOMExternalizerUtil.writeField((Element)element, (String)j, (String)"true");
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        try {
            if (!this.areAlternateCollectionViewsEnabled()) {
                JDOMExternalizerUtil.writeField((Element)element, (String)l, (String)"false");
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        try {
            element.addContent(this.writeRenderer(this.f));
            element.addContent(this.writeRenderer(this.a));
            element.addContent(this.writeRenderer(this.e));
            if (this.b.getRendererCount() > 0) {
                Element element2 = new Element(i);
                element.addContent(element2);
                this.b.writeExternal(element2);
            }
        }
        catch (WriteExternalException writeExternalException) {
            // empty catch block
        }
        return element;
    }

    /*
     * Loose catch block
     */
    public void loadState(Element element) {
        String string = JDOMExternalizerUtil.readField((Element)element, (String)j);
        try {
            if (string != null) {
                this.m.setEnabled(Boolean.parseBoolean(string));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        String string2 = JDOMExternalizerUtil.readField((Element)element, (String)l);
        try {
            if (string2 != null) {
                this.setAlternateCollectionViewsEnabled(Boolean.parseBoolean(string2));
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        for (Element element2 : element.getChildren(RENDERER_TAG)) {
            String string3 = element2.getAttributeValue(d);
            try {
                if (string3 == null) {
                    continue;
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
            }
            try {
                block24: {
                    if (!"ToStringRenderer".equals(string3)) break block24;
                    try {
                        block25: {
                            this.f.readExternal(element2);
                            if (this.f.isEnabled()) continue;
                            break block25;
                            catch (InvalidDataException invalidDataException) {
                                throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
                            }
                        }
                        this.f.setEnabled(true);
                        this.f.setOnDemand(true);
                        continue;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
                    }
                }
                try {
                    if ("ClassRenderer".equals(string3)) {
                        this.a.readExternal(element2);
                        continue;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
                }
                try {
                    if (!"PrimitiveRenderer".equals(string3)) continue;
                    this.e.readExternal(element2);
                }
                catch (InvalidDataException invalidDataException) {
                    throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
                }
            }
            catch (InvalidDataException invalidDataException) {
            }
        }
        Element element3 = element.getChild(i);
        try {
            if (element3 != null) {
                this.b.readExternal(element3);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        ((NodeRendererSettingsListener)this.c.getMulticaster()).renderersChanged();
    }

    public RendererConfiguration getCustomRenderers() {
        return this.b;
    }

    public void setCustomRenderers(@NotNull RendererConfiguration rendererConfiguration) {
        block7: {
            try {
                if (rendererConfiguration == null) {
                    NodeRendererSettings.a(0);
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            RendererConfiguration rendererConfiguration2 = this.b;
            try {
                try {
                    this.b = rendererConfiguration;
                    if (rendererConfiguration2 != null && rendererConfiguration2.equals(rendererConfiguration)) break block7;
                }
                catch (WriteExternalException writeExternalException) {
                    throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
                }
                this.fireRenderersChanged();
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
        }
    }

    public PrimitiveRenderer getPrimitiveRenderer() {
        return this.e;
    }

    public ArrayRenderer getArrayRenderer() {
        return this.g;
    }

    public ClassRenderer getClassRenderer() {
        return this.a;
    }

    public HexRenderer getHexRenderer() {
        return this.m;
    }

    public ToStringRenderer getToStringRenderer() {
        return this.f;
    }

    public NodeRenderer[] getAlternateCollectionRenderers() {
        return this.k;
    }

    public void fireRenderersChanged() {
        ((NodeRendererSettingsListener)this.c.getMulticaster()).renderersChanged();
    }

    public List<NodeRenderer> getAllRenderers() {
        ArrayList<NodeRenderer> arrayList = new ArrayList<NodeRenderer>();
        this.b.iterateRenderers((InternalIterator<NodeRenderer>)((InternalIterator)nodeRenderer -> {
            arrayList.add((NodeRenderer)nodeRenderer);
            return true;
        }));
        Collections.addAll(arrayList, NodeRenderer.EP_NAME.getExtensions());
        arrayList.add(this.m);
        arrayList.add(this.e);
        Collections.addAll(arrayList, this.k);
        arrayList.add(this.f);
        arrayList.add(this.g);
        arrayList.add(this.a);
        return arrayList;
    }

    public Renderer readRenderer(Element element) throws InvalidDataException {
        try {
            if (element == null) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        try {
            if (!RENDERER_TAG.equals(element.getName())) {
                throw new InvalidDataException("Cannot read renderer - tag name is not 'Renderer'");
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        String string = element.getAttributeValue(d);
        try {
            if (string == null) {
                throw new InvalidDataException("unknown renderer ID: " + string);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        Renderer renderer = this.createRenderer(string);
        try {
            if (renderer == null) {
                throw new InvalidDataException("unknown renderer ID: " + string);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)invalidDataException));
        }
        renderer.readExternal(element);
        return renderer;
    }

    public Element writeRenderer(Renderer renderer) throws WriteExternalException {
        Element element = new Element(RENDERER_TAG);
        try {
            if (renderer != null) {
                element.setAttribute(d, renderer.getUniqueId());
                renderer.writeExternal(element);
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        return element;
    }

    public Renderer createRenderer(String string) {
        block31: {
            try {
                if ("ClassRenderer".equals(string)) {
                    return this.a;
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if ("ArrayRenderer".equals(string)) {
                    return this.g;
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if ("PrimitiveRenderer".equals(string)) {
                    return this.e;
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if ("HexRenderer".equals(string)) {
                    return this.m;
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if (string.equals("ExpressionChildrenRenderer")) {
                    return new ExpressionChildrenRenderer();
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if (string.equals("LabelRenderer")) {
                    return new LabelRenderer();
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if (string.equals("EnumerationChildrenRenderer")) {
                    return new EnumerationChildrenRenderer();
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                if (string.equals("ToStringRenderer")) {
                    return this.f;
                }
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            try {
                try {
                    if (!string.equals("CompoundNodeRenderer") && !string.equals(h)) break block31;
                }
                catch (WriteExternalException writeExternalException) {
                    throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
                }
                return this.createCompoundReferenceRenderer("unnamed", "java.lang.Object", null, null);
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
        }
        try {
            if (string.equals("CompoundTypeRenderer")) {
                return this.createCompoundTypeRenderer("unnamed", "java.lang.Object", null, null);
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        return null;
    }

    public CompoundTypeRenderer createCompoundTypeRenderer(@NonNls String string, @NonNls String string2, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundTypeRenderer compoundTypeRenderer = new CompoundTypeRenderer(this, string, valueLabelRenderer, childrenRenderer);
        compoundTypeRenderer.setClassName(string2);
        return compoundTypeRenderer;
    }

    public CompoundReferenceRenderer createCompoundReferenceRenderer(@NonNls String string, @NonNls String string2, ValueLabelRenderer valueLabelRenderer, ChildrenRenderer childrenRenderer) {
        CompoundReferenceRenderer compoundReferenceRenderer = new CompoundReferenceRenderer(this, string, valueLabelRenderer, childrenRenderer);
        compoundReferenceRenderer.setClassName(string2);
        return compoundReferenceRenderer;
    }

    private static ExpressionChildrenRenderer a(String string, String string2, ArrayRenderer arrayRenderer) {
        ExpressionChildrenRenderer expressionChildrenRenderer = NodeRendererSettings.createExpressionChildrenRenderer(string, string2);
        expressionChildrenRenderer.setPredictedRenderer(arrayRenderer);
        return expressionChildrenRenderer;
    }

    public static ExpressionChildrenRenderer createExpressionChildrenRenderer(@NonNls String string, @NonNls String string2) {
        ExpressionChildrenRenderer expressionChildrenRenderer = new ExpressionChildrenRenderer();
        try {
            expressionChildrenRenderer.setChildrenExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string, "", (FileType)StdFileTypes.JAVA));
            if (string2 != null) {
                expressionChildrenRenderer.setChildrenExpandable(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string2, "", (FileType)StdFileTypes.JAVA));
            }
        }
        catch (WriteExternalException writeExternalException) {
            throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
        }
        return expressionChildrenRenderer;
    }

    public static EnumerationChildrenRenderer createEnumerationChildrenRenderer(@NonNls String[][] stringArray) {
        EnumerationChildrenRenderer enumerationChildrenRenderer;
        block3: {
            enumerationChildrenRenderer = new EnumerationChildrenRenderer();
            try {
                if (stringArray == null || stringArray.length <= 0) break block3;
            }
            catch (WriteExternalException writeExternalException) {
                throw NodeRendererSettings.b((RuntimeException)((Object)writeExternalException));
            }
            ArrayList<EnumerationChildrenRenderer.ChildInfo> arrayList = new ArrayList<EnumerationChildrenRenderer.ChildInfo>(stringArray.length);
            for (String[] stringArray2 : stringArray) {
                arrayList.add(new EnumerationChildrenRenderer.ChildInfo(stringArray2[0], new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, stringArray2[1], "", (FileType)StdFileTypes.JAVA), false));
            }
            enumerationChildrenRenderer.setChildren(arrayList);
        }
        return enumerationChildrenRenderer;
    }

    private static LabelRenderer a(final @NonNls String string, @NonNls String string2, final @NonNls String string3) {
        LabelRenderer labelRenderer = new LabelRenderer(){

            @Override
            public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
                String string2;
                block12: {
                    block11: {
                        string2 = super.calcLabel(valueDescriptor, evaluationContext, descriptorLabelListener);
                        try {
                            try {
                                if (string != null || string3 != null) break block11;
                            }
                            catch (EvaluateException evaluateException) {
                                throw 1.a(evaluateException);
                            }
                            return string2;
                        }
                        catch (EvaluateException evaluateException) {
                            throw 1.a(evaluateException);
                        }
                    }
                    try {
                        try {
                            if (string == null || string3 == null) break block12;
                        }
                        catch (EvaluateException evaluateException) {
                            throw 1.a(evaluateException);
                        }
                        return string + string2 + string3;
                    }
                    catch (EvaluateException evaluateException) {
                        throw 1.a(evaluateException);
                    }
                }
                try {
                    if (string != null) {
                        return string + string2;
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw 1.a(evaluateException);
                }
                return string2 + string3;
            }

            private static EvaluateException a(EvaluateException evaluateException) {
                return evaluateException;
            }
        };
        labelRenderer.setLabelExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string2, "", (FileType)StdFileTypes.JAVA));
        return labelRenderer;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "customRenderers", "com/intellij/debugger/settings/NodeRendererSettings", "setCustomRenderers"));
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }

    private static class DescriptorUpdater
    implements DescriptorLabelListener {
        private final ValueDescriptor a;
        @Nullable
        private ValueDescriptorImpl c;
        @Nullable
        private ValueDescriptorImpl b;
        private final DescriptorLabelListener d;

        private DescriptorUpdater(ValueDescriptor valueDescriptor, DescriptorLabelListener descriptorLabelListener) {
            this.a = valueDescriptor;
            this.d = descriptorLabelListener;
        }

        public void setKeyDescriptor(@Nullable ValueDescriptorImpl valueDescriptorImpl) {
            this.c = valueDescriptorImpl;
        }

        public void setValueDescriptor(@Nullable ValueDescriptorImpl valueDescriptorImpl) {
            this.b = valueDescriptorImpl;
        }

        @Override
        public void labelChanged() {
            this.a.setValueLabel(DescriptorUpdater.constructLabelText(DescriptorUpdater.a(this.c), DescriptorUpdater.a(this.b)));
            this.d.labelChanged();
        }

        static String constructLabelText(String string, String string2) {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append('\"').append(string).append("\" -> ");
            if (!StringUtil.isEmpty((String)string2)) {
                stringBuilder.append('\"').append(string2).append('\"');
            }
            return stringBuilder.toString();
        }

        private static String a(ValueDescriptorImpl valueDescriptorImpl) {
            return valueDescriptorImpl == null ? "null" : valueDescriptorImpl.getValueLabel();
        }
    }

    private static class ListObjectRenderer
    extends CompoundReferenceRenderer {
        public ListObjectRenderer(NodeRendererSettings nodeRendererSettings, ArrayRenderer arrayRenderer) {
            super(nodeRendererSettings, "List", NodeRendererSettings.a(" size = ", "size()", null), NodeRendererSettings.a("toArray()", "!isEmpty()", arrayRenderer));
            this.setClassName("java.util.List");
        }

        @Override
        public PsiElement getChildValueExpression(DebuggerTreeNode debuggerTreeNode, DebuggerContext debuggerContext) throws EvaluateException {
            LOG.assertTrue(debuggerTreeNode.getDescriptor() instanceof ArrayElementDescriptorImpl);
            try {
                return this.getChildValueExpression("this.get(" + ((ArrayElementDescriptorImpl)debuggerTreeNode.getDescriptor()).getIndex() + ")", debuggerTreeNode, debuggerContext);
            }
            catch (IncorrectOperationException incorrectOperationException) {
                return super.getChildValueExpression(debuggerTreeNode, debuggerContext);
            }
        }
    }

    private static class MapEntryLabelRenderer
    extends ReferenceRenderer
    implements ValueLabelRenderer {
        private static final Computable<String> c = () -> "null";
        private final MyCachedEvaluator b = new MyCachedEvaluator();
        private final MyCachedEvaluator d = new MyCachedEvaluator();

        private MapEntryLabelRenderer() {
            super("java.util.Map$Entry");
            this.b.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getKey()", "", (FileType)StdFileTypes.JAVA));
            this.d.setReferenceExpression(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "this.getValue()", "", (FileType)StdFileTypes.JAVA));
        }

        @Override
        public Icon calcValueIcon(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            return null;
        }

        @Override
        public String calcLabel(ValueDescriptor valueDescriptor, EvaluationContext evaluationContext, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            DescriptorUpdater descriptorUpdater = new DescriptorUpdater(valueDescriptor, descriptorLabelListener);
            Value value = valueDescriptor.getValue();
            Pair<Computable<String>, ValueDescriptorImpl> pair2 = this.a(evaluationContext, value, this.b, descriptorUpdater);
            Pair<Computable<String>, ValueDescriptorImpl> pair3 = this.a(evaluationContext, value, this.d, descriptorUpdater);
            descriptorUpdater.setKeyDescriptor((ValueDescriptorImpl)pair2.second);
            descriptorUpdater.setValueDescriptor((ValueDescriptorImpl)pair3.second);
            return DescriptorUpdater.constructLabelText((String)((Computable)pair2.first).compute(), (String)((Computable)pair3.first).compute());
        }

        private Pair<Computable<String>, ValueDescriptorImpl> a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator, DescriptorLabelListener descriptorLabelListener) throws EvaluateException {
            Value value2 = this.a(evaluationContext, value, myCachedEvaluator);
            if (value2 != null) {
                WatchItemDescriptor watchItemDescriptor = new WatchItemDescriptor(evaluationContext.getProject(), myCachedEvaluator.getReferenceExpression(), value2);
                watchItemDescriptor.setShowIdLabel(false);
                return new Pair(() -> {
                    watchItemDescriptor.updateRepresentation((EvaluationContextImpl)evaluationContext, descriptorLabelListener);
                    return watchItemDescriptor.getValueLabel();
                }, (Object)watchItemDescriptor);
            }
            return new Pair(c, null);
        }

        @Override
        public String getUniqueId() {
            return "MapEntry renderer";
        }

        private Value a(EvaluationContext evaluationContext, Value value, MyCachedEvaluator myCachedEvaluator) throws EvaluateException {
            DebugProcess debugProcess = evaluationContext.getDebugProcess();
            try {
                if (value == null) {
                    return null;
                }
            }
            catch (EvaluateException evaluateException) {
                throw MapEntryLabelRenderer.a(evaluateException);
            }
            try {
                ExpressionEvaluator expressionEvaluator = myCachedEvaluator.getEvaluator(debugProcess.getProject());
                try {
                    if (!debugProcess.isAttached()) {
                        throw EvaluateExceptionUtil.PROCESS_EXITED;
                    }
                }
                catch (EvaluateException evaluateException) {
                    throw MapEntryLabelRenderer.a(evaluateException);
                }
                EvaluationContext evaluationContext2 = evaluationContext.createEvaluationContext(value);
                return expressionEvaluator.evaluate(evaluationContext2);
            }
            catch (EvaluateException evaluateException) {
                throw new EvaluateException(DebuggerBundle.message((String)"error.unable.to.evaluate.expression", (Object[])new Object[0]) + " " + evaluateException.getMessage(), (Throwable)evaluateException);
            }
        }

        private static EvaluateException a(EvaluateException evaluateException) {
            return evaluateException;
        }

        private class MyCachedEvaluator
        extends CachedEvaluator {
            private MyCachedEvaluator() {
            }

            @Override
            protected String getClassName() {
                return MapEntryLabelRenderer.this.getClassName();
            }

            @Override
            public ExpressionEvaluator getEvaluator(Project project2) throws EvaluateException {
                return super.getEvaluator(project2);
            }
        }
    }
}

