/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui;

import com.intellij.codeInsight.hint.HintUtil;
import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.CodeFragmentFactory;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.evaluation.expression.EvaluatorBuilderImpl;
import com.intellij.debugger.engine.evaluation.expression.ExpressionEvaluator;
import com.intellij.debugger.engine.events.DebuggerContextCommandImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.impl.EditorTextProvider;
import com.intellij.debugger.impl.PrioritizedTask;
import com.intellij.debugger.ui.DebuggerTreeCreatorImpl;
import com.intellij.debugger.ui.impl.DebuggerTreeRenderer;
import com.intellij.debugger.ui.impl.InspectDebuggerTree;
import com.intellij.debugger.ui.impl.watch.NodeDescriptorImpl;
import com.intellij.debugger.ui.impl.watch.WatchItemDescriptor;
import com.intellij.debugger.ui.tree.render.DescriptorLabelListener;
import com.intellij.lang.Language;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CustomShortcutSet;
import com.intellij.openapi.actionSystem.ShortcutSet;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.JVMElementFactories;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.ui.SimpleColoredText;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.IncorrectOperationException;
import com.intellij.xdebugger.impl.evaluate.quick.common.AbstractValueHint;
import com.intellij.xdebugger.impl.evaluate.quick.common.ValueHintType;
import com.sun.jdi.Method;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.Value;
import java.awt.Point;
import java.lang.invoke.LambdaMetafactory;
import javax.swing.JComponent;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueHint
extends AbstractValueHint {
    private static final Logger b = Logger.getInstance((String)"#com.intellij.debugger.ui.ValueHint");
    private PsiElement c = null;
    private Value a = null;

    private ValueHint(Project project2, Editor editor, Point point, ValueHintType valueHintType, PsiElement psiElement, TextRange textRange) {
        super(project2, editor, point, valueHintType, textRange);
        this.c = psiElement;
    }

    public static ValueHint createValueHint(Project project2, Editor editor, Point point, ValueHintType valueHintType) {
        Trinity<PsiElement, TextRange, Value> trinity = ValueHint.a(project2, editor, point, valueHintType);
        ValueHint valueHint = new ValueHint(project2, editor, point, valueHintType, (PsiElement)trinity.getFirst(), (TextRange)trinity.getSecond());
        valueHint.a = (Value)trinity.getThird();
        return valueHint;
    }

    protected boolean canShowHint() {
        boolean bl2;
        try {
            bl2 = this.c != null;
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw ValueHint.b((Exception)((Object)incorrectOperationException));
        }
        return bl2;
    }

    @Nullable
    private ExpressionEvaluator a(DebuggerContextImpl debuggerContextImpl) throws EvaluateException {
        try {
            if (this.c instanceof PsiExpression) {
                return EvaluatorBuilderImpl.getInstance().build(this.c, debuggerContextImpl.getSourcePosition());
            }
        }
        catch (EvaluateException evaluateException) {
            throw ValueHint.b((Exception)((Object)evaluateException));
        }
        TextWithImportsImpl textWithImportsImpl = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, this.c.getText());
        CodeFragmentFactory codeFragmentFactory = DebuggerUtilsEx.findAppropriateCodeFragmentFactory(textWithImportsImpl, this.c);
        JavaCodeFragment javaCodeFragment = codeFragmentFactory.createCodeFragment((TextWithImports)textWithImportsImpl, this.c.getContext(), this.getProject());
        return codeFragmentFactory.getEvaluatorBuilder().build((PsiElement)javaCodeFragment, debuggerContextImpl.getSourcePosition());
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void evaluateAndShowHint() {
        DebuggerContextImpl debuggerContextImpl;
        block7: {
            debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
            DebuggerSession debuggerSession = debuggerContextImpl.getDebuggerSession();
            if (debuggerSession == null) return;
            try {
                if (debuggerSession.isPaused()) break block7;
                return;
                catch (EvaluateException evaluateException) {
                    throw ValueHint.b((Exception)((Object)evaluateException));
                }
            }
            catch (EvaluateException evaluateException) {
                throw ValueHint.b((Exception)((Object)evaluateException));
            }
        }
        try {
            final ExpressionEvaluator expressionEvaluator = this.a(debuggerContextImpl);
            if (expressionEvaluator == null) {
                return;
            }
            debuggerContextImpl.getDebugProcess().getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                @Override
                public PrioritizedTask.Priority getPriority() {
                    return PrioritizedTask.Priority.HIGH;
                }

                /*
                 * Unable to fully structure code
                 */
                @Override
                public void threadAction(@NotNull SuspendContextImpl var1_1) {
                    block15: {
                        try {
                            if (var1_1 == null) {
                                1.c(0);
                            }
                        }
                        catch (EvaluateException v0) {
                            throw 1.a(v0);
                        }
                        try {
                            block13: {
                                block14: {
                                    block16: {
                                        var2_2 = debuggerContextImpl.createEvaluationContext();
                                        var3_4 = (String)ReadAction.compute((ThrowableComputable)(ThrowableComputable)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, a(), ()Ljava/lang/String;)(this));
                                        var4_5 = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, var3_4);
                                        try {
                                            v1 = ValueHint.access$000(ValueHint.this) != null ? ValueHint.access$000(ValueHint.this) : expressionEvaluator.evaluate((EvaluationContext)var2_2);
                                        }
                                        catch (EvaluateException v2) {
                                            throw 1.a(v2);
                                        }
                                        var5_6 = v1;
                                        var6_7 = new WatchItemDescriptor(ValueHint.this.getProject(), (TextWithImports)var4_5, var5_6);
                                        if (!ValueHint.access$100(var5_6)) ** GOTO lbl24
                                        if (ValueHint.access$200(ValueHint.this) != ValueHintType.MOUSE_OVER_HINT) break block13;
                                        break block16;
                                        catch (EvaluateException v3) {
                                            throw 1.a(v3);
                                        }
                                    }
                                    try {
                                        block17: {
                                            if (ValueHint.access$300(ValueHint.this) != ValueHintType.MOUSE_OVER_HINT) break block14;
                                            break block17;
                                            catch (EvaluateException v4) {
                                                throw 1.a(v4);
                                            }
                                        }
                                        var6_7.setRenderer(DebugProcessImpl.getDefaultRenderer(var5_6));
                                    }
                                    catch (EvaluateException v5) {
                                        throw 1.a(v5);
                                    }
                                }
                                var6_7.updateRepresentation(var2_2, new DescriptorLabelListener(){

                                    @Override
                                    public void labelChanged() {
                                        if (ValueHint.this.getCurrentRange() != null && (ValueHint.this.getType() != ValueHintType.MOUSE_OVER_HINT || var6_7.isValueValid())) {
                                            SimpleColoredText simpleColoredText = DebuggerTreeRenderer.getDescriptorText(debuggerContextImpl, var6_7, true);
                                            if (ValueHint.a(var5_6)) {
                                                simpleColoredText.append(" (" + DebuggerBundle.message((String)"active.tooltip.suggestion", (Object[])new Object[0]) + ")", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                                            }
                                            ValueHint.this.a(simpleColoredText, var6_7);
                                        }
                                    }
                                });
                                break block15;
                            }
                            ValueHint.access$700(ValueHint.this, var3_4, var6_7);
                        }
                        catch (EvaluateException var2_3) {
                            ValueHint.access$800().debug((Throwable)var2_3);
                        }
                    }
                }

                private /* synthetic */ String a() throws RuntimeException {
                    return ValueHint.this.c.getText();
                }

                private static /* synthetic */ void c(int n2) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/ValueHint$1", "threadAction"));
                }

                private static EvaluateException a(EvaluateException evaluateException) {
                    return evaluateException;
                }
            });
            return;
        }
        catch (EvaluateException evaluateException) {
            b.debug((Throwable)evaluateException);
        }
    }

    private void a(String string, NodeDescriptorImpl nodeDescriptorImpl) {
        DebuggerTreeCreatorImpl debuggerTreeCreatorImpl = new DebuggerTreeCreatorImpl(this.getProject());
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> this.showTreePopup(debuggerTreeCreatorImpl, Pair.create((Object)nodeDescriptorImpl, (Object)string)));
    }

    private static boolean a(Value value) {
        boolean bl2;
        block5: {
            block4: {
                try {
                    try {
                        if (value == null || value instanceof PrimitiveValue) break block4;
                    }
                    catch (IncorrectOperationException incorrectOperationException) {
                        throw ValueHint.b((Exception)((Object)incorrectOperationException));
                    }
                    bl2 = true;
                    break block5;
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw ValueHint.b((Exception)((Object)incorrectOperationException));
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    private void a(SimpleColoredText simpleColoredText, final WatchItemDescriptor watchItemDescriptor) {
        DebuggerInvocationUtil.invokeLater(this.getProject(), () -> {
            block8: {
                JComponent jComponent;
                block10: {
                    block9: {
                        try {
                            if (this.isHintHidden()) break block8;
                            if (ValueHint.a(watchItemDescriptor.getValue())) break block9;
                        }
                        catch (IncorrectOperationException incorrectOperationException) {
                            throw ValueHint.b((Exception)((Object)incorrectOperationException));
                        }
                        jComponent = HintUtil.createInformationLabel((SimpleColoredText)simpleColoredText);
                        break block10;
                    }
                    jComponent = this.createExpandableHintComponent(simpleColoredText, () -> {
                        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.getProject()).getContext();
                        final DebugProcessImpl debugProcessImpl = debuggerContextImpl.getDebugProcess();
                        debugProcessImpl.getManagerThread().schedule(new DebuggerContextCommandImpl(debuggerContextImpl){

                            @Override
                            public void threadAction(@NotNull SuspendContextImpl suspendContextImpl) {
                                try {
                                    if (suspendContextImpl == null) {
                                        2.c(0);
                                    }
                                }
                                catch (RuntimeException runtimeException) {
                                    throw 2.b(runtimeException);
                                }
                                watchItemDescriptor.setRenderer(debugProcessImpl.getAutoRenderer(watchItemDescriptor));
                                String string = (String)ReadAction.compute(() -> ValueHint.this.c.getText());
                                ValueHint.this.a(string, watchItemDescriptor);
                            }

                            private static /* synthetic */ void c(int n2) {
                                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "suspendContext", "com/intellij/debugger/ui/ValueHint$2", "threadAction"));
                            }

                            private static RuntimeException b(RuntimeException runtimeException) {
                                return runtimeException;
                            }
                        });
                    });
                }
                try {
                    if (!this.showHint(jComponent)) {
                        return;
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw ValueHint.b((Exception)((Object)incorrectOperationException));
                }
                try {
                    if (this.getType() == ValueHintType.MOUSE_CLICK_HINT) {
                        HintUtil.createInformationLabel((SimpleColoredText)simpleColoredText).requestFocusInWindow();
                    }
                }
                catch (IncorrectOperationException incorrectOperationException) {
                    throw ValueHint.b((Exception)((Object)incorrectOperationException));
                }
            }
        });
    }

    public static InspectDebuggerTree createInspectTree(NodeDescriptorImpl nodeDescriptorImpl, Project project2) {
        final InspectDebuggerTree inspectDebuggerTree = new InspectDebuggerTree(project2);
        final AnAction anAction = ActionManager.getInstance().getAction("Debugger.SetValue");
        anAction.registerCustomShortcutSet((ShortcutSet)new CustomShortcutSet(KeyStroke.getKeyStroke(113, 0)), (JComponent)((Object)inspectDebuggerTree));
        Disposer.register((Disposable)inspectDebuggerTree, (Disposable)new Disposable(){

            public void dispose() {
                anAction.unregisterCustomShortcutSet((JComponent)((Object)inspectDebuggerTree));
            }
        });
        inspectDebuggerTree.setInspectDescriptor(nodeDescriptorImpl);
        DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(project2).getContext();
        inspectDebuggerTree.rebuild(debuggerContextImpl);
        return inspectDebuggerTree;
    }

    @Nullable
    private static Pair<PsiElement, TextRange> a(PsiElement psiElement, boolean bl2) {
        EditorTextProvider editorTextProvider = (EditorTextProvider)EditorTextProvider.EP.forLanguage(psiElement.getLanguage());
        try {
            if (editorTextProvider != null) {
                return editorTextProvider.findExpression(psiElement, bl2);
            }
        }
        catch (IncorrectOperationException incorrectOperationException) {
            throw ValueHint.b((Exception)((Object)incorrectOperationException));
        }
        return null;
    }

    private static Trinity<PsiElement, TextRange, Value> a(Project project2, Editor editor, Point point, ValueHintType valueHintType) {
        Ref ref = Ref.create(null);
        Ref ref2 = Ref.create(null);
        Ref ref3 = Ref.create(null);
        PsiDocumentManager.getInstance((Project)project2).commitAndRunReadAction(() -> ValueHint.a(editor, point, project2, valueHintType, ref, ref2, ref3));
        return Trinity.create((Object)ref.get(), (Object)ref2.get(), (Object)ref3.get());
    }

    /*
     * Unable to fully structure code
     */
    private static /* synthetic */ void a(Editor var0, Point var1_1, Project var2_2, ValueHintType var3_3, Ref var4_4, Ref var5_5, Ref var6_6) {
        block53: {
            block47: {
                block46: {
                    block45: {
                        block42: {
                            block44: {
                                block43: {
                                    block51: {
                                        block50: {
                                            block49: {
                                                block41: {
                                                    var7_7 = ValueHint.calculateOffset((Editor)var0, (Point)var1_1);
                                                    var8_8 = PsiDocumentManager.getInstance((Project)var2_2).getPsiFile(var0.getDocument());
                                                    if (var8_8 == null) ** GOTO lbl10
                                                    try {
                                                        block48: {
                                                            if (var8_8.isValid()) break block41;
                                                            break block48;
                                                            catch (IncorrectOperationException v0) {
                                                                throw ValueHint.b((Exception)v0);
                                                            }
                                                        }
                                                        return;
                                                    }
                                                    catch (IncorrectOperationException v1) {
                                                        throw ValueHint.b((Exception)v1);
                                                    }
                                                }
                                                var9_9 = var0.getSelectionModel().getSelectionStart();
                                                var10_10 = var0.getSelectionModel().getSelectionEnd();
                                                if (var3_3 == ValueHintType.MOUSE_CLICK_HINT) ** GOTO lbl24
                                                if (var3_3 != ValueHintType.MOUSE_ALT_OVER_HINT) break block42;
                                                break block49;
                                                catch (IncorrectOperationException v2) {
                                                    throw ValueHint.b((Exception)v2);
                                                }
                                            }
                                            if (var9_9 > var7_7) break block42;
                                            break block50;
                                            catch (IncorrectOperationException v3) {
                                                throw ValueHint.b((Exception)v3);
                                            }
                                        }
                                        if (var7_7 > var10_10) break block42;
                                        break block51;
                                        catch (IncorrectOperationException v4) {
                                            throw ValueHint.b((Exception)v4);
                                        }
                                    }
                                    try {
                                        block52: {
                                            if (var9_9 <= 0) break block43;
                                            break block52;
                                            catch (IncorrectOperationException v5) {
                                                throw ValueHint.b((Exception)v5);
                                            }
                                        }
                                        v6 = var8_8.findElementAt(var9_9 - 1);
                                        break block44;
                                    }
                                    catch (IncorrectOperationException v7) {
                                        throw ValueHint.b((Exception)v7);
                                    }
                                }
                                v6 = var8_8.findElementAt(var9_9);
                            }
                            var11_11 = v6;
                            try {
                                var12_12 = var0.getSelectionModel().getSelectedText();
                                try {
                                    if (var12_12 == null || var11_11 == null) break block42;
                                }
                                catch (IncorrectOperationException v8) {
                                    throw ValueHint.b((Exception)v8);
                                }
                                var13_14 = JVMElementFactories.getFactory((Language)var11_11.getLanguage(), (Project)var2_2);
                                if (var13_14 == null) {
                                    return;
                                }
                                var4_4.set((Object)var13_14.createExpressionFromText(var12_12, var11_11));
                                var5_5.set((Object)new TextRange(var0.getSelectionModel().getSelectionStart(), var0.getSelectionModel().getSelectionEnd()));
                            }
                            catch (IncorrectOperationException var12_13) {
                                // empty catch block
                            }
                        }
                        if (var5_5.get() != null) break block53;
                        var11_11 = var8_8.findElementAt(var7_7);
                        try {
                            if (var11_11 == null) {
                                return;
                            }
                        }
                        catch (IncorrectOperationException v9) {
                            throw ValueHint.b((Exception)v9);
                        }
                        if (var3_3 == ValueHintType.MOUSE_CLICK_HINT) ** GOTO lbl82
                        try {
                            block54: {
                                if (var3_3 != ValueHintType.MOUSE_ALT_OVER_HINT) break block45;
                                break block54;
                                catch (IncorrectOperationException v10) {
                                    throw ValueHint.b((Exception)v10);
                                }
                            }
                            v11 = true;
                            break block46;
                        }
                        catch (IncorrectOperationException v12) {
                            throw ValueHint.b((Exception)v12);
                        }
                    }
                    v11 = false;
                }
                var12_12 = ValueHint.a(var11_11, v11);
                try {
                    if (var12_12 != null || var3_3 != ValueHintType.MOUSE_OVER_HINT) break block47;
                }
                catch (IncorrectOperationException v13) {
                    throw ValueHint.b((Exception)v13);
                }
                var13_14 = DebuggerManagerEx.getInstanceEx(var2_2).getContext().getDebuggerSession();
                try {
                    if (var13_14 == null || !var13_14.isPaused()) break block47;
                }
                catch (IncorrectOperationException v14) {
                    throw ValueHint.b((Exception)v14);
                }
                var14_15 = var13_14.getProcess().getLastExecutedMethod();
                if (var14_15 != null && (var15_16 = (Method)var14_15.getFirst()) != null) {
                    var16_17 = ValueHint.a(var11_11, true);
                    try {
                        if (var16_17 == null || !(var16_17.getFirst() instanceof PsiMethodCallExpression)) break block47;
                    }
                    catch (IncorrectOperationException v15) {
                        throw ValueHint.b((Exception)v15);
                    }
                    var17_18 = (PsiMethodCallExpression)var16_17.getFirst();
                    var18_19 = var17_18.resolveMethod();
                    if (var18_19 != null) {
                        var19_20 = JVMNameUtil.getJVMSignature(var18_19);
                        try {
                            try {
                                if (!var15_16.name().equals(var18_19.getName()) || !var15_16.signature().equals(var19_20.getName(var13_14.getProcess()))) break block47;
                            }
                            catch (IncorrectOperationException v16) {
                                throw ValueHint.b((Exception)v16);
                            }
                            var12_12 = var16_17;
                            var6_6.set(var14_15.getSecond());
                        }
                        catch (EvaluateException var20_21) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                if (var12_12 == null) {
                    return;
                }
            }
            catch (IncorrectOperationException v17) {
                throw ValueHint.b((Exception)v17);
            }
            var4_4.set(var12_12.getFirst());
            var5_5.set(var12_12.getSecond());
        }
    }

    static /* synthetic */ Value access$000(ValueHint valueHint) {
        return valueHint.a;
    }

    static /* synthetic */ ValueHintType access$200(ValueHint valueHint) {
        return valueHint.getType();
    }

    static /* synthetic */ ValueHintType access$300(ValueHint valueHint) {
        return valueHint.getType();
    }

    static /* synthetic */ Logger access$800() {
        return b;
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

