/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.engine.BreakpointStepMethodFilter;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerContextListener;
import com.intellij.debugger.impl.DebuggerManagerImpl;
import com.intellij.debugger.impl.DebuggerSession;
import com.intellij.debugger.ui.JavaDebuggerSupport;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointDefaults;
import com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter;
import com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint;
import com.intellij.debugger.ui.breakpoints.FieldBreakpoint;
import com.intellij.debugger.ui.breakpoints.JavaBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaExceptionBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaFieldBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaLineBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.JavaWildcardMethodBreakpointType;
import com.intellij.debugger.ui.breakpoints.LineBreakpoint;
import com.intellij.debugger.ui.breakpoints.MethodBreakpoint;
import com.intellij.debugger.ui.breakpoints.RunToCursorBreakpoint;
import com.intellij.debugger.ui.breakpoints.StepIntoBreakpoint;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMUtil;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.psi.PsiField;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointListener;
import com.intellij.xdebugger.breakpoints.XBreakpointManager;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.intellij.xdebugger.impl.DebuggerSupport;
import com.intellij.xdebugger.impl.XDebuggerManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointManagerImpl;
import com.intellij.xdebugger.impl.breakpoints.XDependentBreakpointManager;
import com.intellij.xdebugger.impl.breakpoints.XLineBreakpointImpl;
import com.sun.jdi.InternalException;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import javax.swing.SwingUtilities;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;
import org.jetbrains.java.debugger.breakpoints.properties.JavaMethodBreakpointProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public class BreakpointManager {
    private static final Logger i;
    @NonNls
    private static final String k = "master_breakpoint";
    @NonNls
    private static final String c = "slave_breakpoint";
    @NonNls
    private static final String f = "default_suspend_policy";
    @NonNls
    private static final String j = "default_condition_enabled";
    @NonNls
    private static final String b = "breakpoint_rules";
    private static final String d = "converted";
    private final Project e;
    private final Map<String, String> h;
    private final StartupManager a;
    private final Map<String, Element> g;
    static final /* synthetic */ boolean $assertionsDisabled;

    public BreakpointManager(@NotNull Project project2, @NotNull StartupManager startupManager, @NotNull DebuggerManagerImpl debuggerManagerImpl) {
        if (project2 == null) {
            BreakpointManager.a(0);
        }
        if (startupManager == null) {
            BreakpointManager.a(1);
        }
        if (debuggerManagerImpl == null) {
            BreakpointManager.a(2);
        }
        this.h = new LinkedHashMap<String, String>();
        this.g = new LinkedHashMap<String, Element>();
        this.e = project2;
        this.a = startupManager;
        debuggerManagerImpl.getContextManager().addListener(new DebuggerContextListener(){
            private DebuggerSession a;

            @Override
            public void changeEvent(@NotNull DebuggerContextImpl debuggerContextImpl, DebuggerSession.Event event) {
                block11: {
                    try {
                        if (debuggerContextImpl == null) {
                            1.a(0);
                        }
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 1.a(illegalArgumentException);
                    }
                    if (event == DebuggerSession.Event.ATTACHED) {
                        for (XBreakpoint xBreakpoint : BreakpointManager.this.a().getAllBreakpoints()) {
                            try {
                                if (!BreakpointManager.a(xBreakpoint)) continue;
                                break;
                            }
                            catch (IllegalArgumentException illegalArgumentException) {
                                throw 1.a(illegalArgumentException);
                            }
                        }
                    }
                    try {
                        try {
                            if (debuggerContextImpl.getDebuggerSession() == this.a && event != DebuggerSession.Event.DETACHED) break block11;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            throw 1.a(illegalArgumentException);
                        }
                        BreakpointManager.this.updateBreakpointsUI();
                        this.a = debuggerContextImpl.getDebuggerSession();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw 1.a(illegalArgumentException);
                    }
                }
            }

            private static /* synthetic */ void a(int n2) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "newContext", "com/intellij/debugger/ui/breakpoints/BreakpointManager$1", "changeEvent"));
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
    }

    private static boolean a(XBreakpoint xBreakpoint) {
        block6: {
            XBreakpointProperties xBreakpointProperties = xBreakpoint.getProperties();
            try {
                try {
                    try {
                        if (!xBreakpoint.isEnabled() || !(xBreakpointProperties instanceof JavaMethodBreakpointProperties)) break block6;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BreakpointManager.b(illegalStateException);
                    }
                    if (((JavaMethodBreakpointProperties)xBreakpointProperties).EMULATED) break block6;
                }
                catch (IllegalStateException illegalStateException) {
                    throw BreakpointManager.b(illegalStateException);
                }
                XDebuggerManagerImpl.NOTIFICATION_GROUP.createNotification(DebuggerBundle.message((String)"method.breakpoints.slowness.warning", (Object[])new Object[0]), MessageType.WARNING).notify(((XBreakpointBase)xBreakpoint).getProject());
                return true;
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
        }
        return false;
    }

    public void init() {
        XBreakpointManager xBreakpointManager = XDebuggerManager.getInstance((Project)this.e).getBreakpointManager();
        xBreakpointManager.addBreakpointListener(new XBreakpointListener<XBreakpoint<?>>(){

            public void breakpointAdded(@NotNull XBreakpoint<?> xBreakpoint) {
                try {
                    if (xBreakpoint == null) {
                        2.a(0);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
                Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
                try {
                    if (breakpoint != null) {
                        BreakpointManager.addBreakpoint(breakpoint);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
            }

            public void breakpointChanged(@NotNull XBreakpoint xBreakpoint) {
                try {
                    if (xBreakpoint == null) {
                        2.a(1);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
                Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
                try {
                    if (breakpoint != null) {
                        BreakpointManager.this.fireBreakpointChanged(breakpoint);
                    }
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    throw 2.a(illegalArgumentException);
                }
            }

            /*
             * Exception decompiling
             */
            private static /* synthetic */ void a(int var0) {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 1[SWITCH]
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }

            private static IllegalArgumentException a(IllegalArgumentException illegalArgumentException) {
                return illegalArgumentException;
            }
        });
    }

    private XBreakpointManager a() {
        return XDebuggerManager.getInstance((Project)this.e).getBreakpointManager();
    }

    public void editBreakpoint(Breakpoint breakpoint, Editor editor) {
        DebuggerInvocationUtil.swingInvokeLater(this.e, () -> {
            RangeHighlighter rangeHighlighter;
            XBreakpoint xBreakpoint = breakpoint.myXBreakpoint;
            if (xBreakpoint instanceof XLineBreakpointImpl && (rangeHighlighter = ((XLineBreakpointImpl)xBreakpoint).getHighlighter()) != null) {
                GutterIconRenderer gutterIconRenderer = rangeHighlighter.getGutterIconRenderer();
                try {
                    if (gutterIconRenderer != null) {
                        DebuggerSupport.getDebuggerSupport(JavaDebuggerSupport.class).getEditBreakpointAction().editBreakpoint(this.e, editor, breakpoint.myXBreakpoint, gutterIconRenderer);
                    }
                }
                catch (IllegalStateException illegalStateException) {
                    throw BreakpointManager.b(illegalStateException);
                }
            }
        });
    }

    public void setBreakpointDefaults(Key<? extends Breakpoint> key, BreakpointDefaults breakpointDefaults) {
        Class clazz = null;
        if (LineBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaLineBreakpointType.class;
        } else if (MethodBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaMethodBreakpointType.class;
        } else if (FieldBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaFieldBreakpointType.class;
        } else if (ExceptionBreakpoint.CATEGORY.toString().equals(key.toString())) {
            clazz = JavaExceptionBreakpointType.class;
        }
        if (clazz != null) {
            XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
            ((XBreakpointManagerImpl)this.a()).getBreakpointDefaults(xBreakpointType).setSuspendPolicy(Breakpoint.transformSuspendPolicy(breakpointDefaults.getSuspendPolicy()));
        }
    }

    @Nullable
    public RunToCursorBreakpoint addRunToCursorBreakpoint(@NotNull XSourcePosition xSourcePosition, boolean bl2) {
        try {
            if (xSourcePosition == null) {
                BreakpointManager.a(3);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return RunToCursorBreakpoint.create(this.e, xSourcePosition, bl2);
    }

    @Nullable
    public StepIntoBreakpoint addStepIntoBreakpoint(@NotNull BreakpointStepMethodFilter breakpointStepMethodFilter) {
        try {
            if (breakpointStepMethodFilter == null) {
                BreakpointManager.a(4);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return StepIntoBreakpoint.create(this.e, breakpointStepMethodFilter);
    }

    @Nullable
    public LineBreakpoint addLineBreakpoint(Document document, int n2) {
        try {
            ApplicationManager.getApplication().assertIsDispatchThread();
            if (!LineBreakpoint.canAddLineBreakpoint(this.e, document, n2)) {
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        XLineBreakpoint xLineBreakpoint = this.a(JavaLineBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        try {
            if (breakpoint instanceof LineBreakpoint) {
                BreakpointManager.addBreakpoint(breakpoint);
                return (LineBreakpoint)breakpoint;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return null;
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(@NotNull Document document, int n2) {
        try {
            if (document == null) {
                BreakpointManager.a(5);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        PsiField psiField = FieldBreakpoint.findField(this.e, document, n2);
        try {
            if (psiField == null) {
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        int n3 = document.getLineNumber(n2);
        try {
            if (document.getLineNumber(psiField.getNameIdentifier().getTextOffset()) < n3) {
                return null;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return this.addFieldBreakpoint(document, n3, psiField.getName());
    }

    @Nullable
    public FieldBreakpoint addFieldBreakpoint(Document document, int n2, String string) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaFieldBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        if (breakpoint instanceof FieldBreakpoint) {
            FieldBreakpoint fieldBreakpoint = (FieldBreakpoint)breakpoint;
            fieldBreakpoint.setFieldName(string);
            BreakpointManager.addBreakpoint(breakpoint);
            return fieldBreakpoint;
        }
        return null;
    }

    @Nullable
    public ExceptionBreakpoint addExceptionBreakpoint(@NotNull String string, String string2) {
        try {
            if (string == null) {
                BreakpointManager.a(6);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        ApplicationManager.getApplication().assertIsDispatchThread();
        JavaExceptionBreakpointType javaExceptionBreakpointType = (JavaExceptionBreakpointType)XDebuggerUtil.getInstance().findBreakpointType(JavaExceptionBreakpointType.class);
        return (ExceptionBreakpoint)WriteAction.compute(() -> {
            try {
                if (string == null) {
                    BreakpointManager.a(18);
                }
            }
            catch (RuntimeException runtimeException) {
                throw BreakpointManager.b(runtimeException);
            }
            XBreakpoint xBreakpoint = XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addBreakpoint((XBreakpointType)javaExceptionBreakpointType, (XBreakpointProperties)new JavaExceptionBreakpointProperties(string, string2));
            Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint(xBreakpoint);
            if (breakpoint instanceof ExceptionBreakpoint) {
                ExceptionBreakpoint exceptionBreakpoint = (ExceptionBreakpoint)breakpoint;
                exceptionBreakpoint.setQualifiedName(string);
                exceptionBreakpoint.setPackageName(string2);
                BreakpointManager.addBreakpoint(exceptionBreakpoint);
                i.debug("ExceptionBreakpoint Added");
                return exceptionBreakpoint;
            }
            return null;
        });
    }

    @Nullable
    public MethodBreakpoint addMethodBreakpoint(Document document, int n2) {
        ApplicationManager.getApplication().assertIsDispatchThread();
        XLineBreakpoint xLineBreakpoint = this.a(JavaMethodBreakpointType.class, document, n2);
        Breakpoint breakpoint = BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
        try {
            if (breakpoint instanceof MethodBreakpoint) {
                BreakpointManager.addBreakpoint(breakpoint);
                return (MethodBreakpoint)breakpoint;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return null;
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Document document, int n2) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
        return (XLineBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addLineBreakpoint((XLineBreakpointType)xBreakpointType, virtualFile.getUrl(), n2, ((XLineBreakpointType)xBreakpointType).createBreakpointProperties(virtualFile, n2)));
    }

    @Nullable
    public <T extends BreakpointWithHighlighter> T findBreakpoint(Document document, int n2, @Nullable Key<T> key) {
        for (Breakpoint breakpoint : this.getBreakpoints()) {
            try {
                block9: {
                    try {
                        try {
                            try {
                                if (!(breakpoint instanceof BreakpointWithHighlighter) || !((BreakpointWithHighlighter)breakpoint).isAt(document, n2)) continue;
                            }
                            catch (IllegalStateException illegalStateException) {
                                throw BreakpointManager.b(illegalStateException);
                            }
                            if (key == null) break block9;
                        }
                        catch (IllegalStateException illegalStateException) {
                            throw BreakpointManager.b(illegalStateException);
                        }
                        if (!key.equals(breakpoint.getCategory())) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BreakpointManager.b(illegalStateException);
                    }
                }
                return (T)((BreakpointWithHighlighter)breakpoint);
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
        }
        return null;
    }

    public void readExternal(@NotNull Element element) {
        try {
            if (element == null) {
                BreakpointManager.a(7);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        this.g.clear();
        for (Element element2 : element.getChildren()) {
            this.g.put(element2.getName(), JDOMUtil.internElement((Element)element2));
        }
        try {
            if (!this.e.isDefault()) {
                this.a.runWhenProjectIsInitialized(() -> {
                    try {
                        if (element == null) {
                            BreakpointManager.a(17);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BreakpointManager.b(illegalStateException);
                    }
                    this.b(element);
                });
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
    }

    private void b(@NotNull Element element) {
        try {
            if (element == null) {
                BreakpointManager.a(8);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        ApplicationManager.getApplication().runReadAction(() -> {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        });
        this.h.clear();
        Element element2 = element.getChild("ui_properties");
        if (element2 != null) {
            List list = element2.getChildren("property");
            for (Object e2 : list) {
                Element element3 = (Element)e2;
                String string = element3.getAttributeValue("name");
                String string2 = element3.getAttributeValue("value");
                try {
                    try {
                        if (string == null || string2 == null) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BreakpointManager.b(illegalStateException);
                    }
                    this.h.put(string, string2);
                }
                catch (IllegalStateException illegalStateException) {
                    throw BreakpointManager.b(illegalStateException);
                }
            }
        }
    }

    private Breakpoint a(String string, Element element) throws InvalidDataException {
        XLineBreakpoint xLineBreakpoint;
        block12: {
            block10: {
                block11: {
                    xLineBreakpoint = null;
                    if (string.equals(LineBreakpoint.CATEGORY.toString())) {
                        xLineBreakpoint = this.a(JavaLineBreakpointType.class, element);
                    } else {
                        try {
                            if (!string.equals(MethodBreakpoint.CATEGORY.toString())) break block10;
                            if (element.getAttribute("url") == null) break block11;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointManager.b((Exception)((Object)invalidDataException));
                        }
                        xLineBreakpoint = this.a(JavaMethodBreakpointType.class, element);
                    }
                    break block12;
                }
                xLineBreakpoint = this.a(JavaWildcardMethodBreakpointType.class);
                break block12;
            }
            if (string.equals(FieldBreakpoint.CATEGORY.toString())) {
                xLineBreakpoint = this.a(JavaFieldBreakpointType.class, element);
            } else if (string.equals(ExceptionBreakpoint.CATEGORY.toString())) {
                xLineBreakpoint = this.a(JavaExceptionBreakpointType.class);
            }
        }
        try {
            if (xLineBreakpoint == null) {
                throw new IllegalStateException("Unknown breakpoint category " + string);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointManager.b((Exception)((Object)invalidDataException));
        }
        return BreakpointManager.getJavaBreakpoint((XBreakpoint)xLineBreakpoint);
    }

    private <B extends XBreakpoint<?>> XBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz) {
        XBreakpointType xBreakpointType = XDebuggerUtil.getInstance().findBreakpointType(clazz);
        return (XBreakpoint)WriteAction.compute(() -> XDebuggerManager.getInstance((Project)this.e).getBreakpointManager().addBreakpoint(xBreakpointType, xBreakpointType.createProperties()));
    }

    private <B extends XBreakpoint<?>> XLineBreakpoint a(Class<? extends XBreakpointType<B, ?>> clazz, Element element) throws InvalidDataException {
        int n2;
        String string = element.getAttributeValue("url");
        VirtualFile virtualFile = VirtualFileManager.getInstance().findFileByUrl(string);
        try {
            if (virtualFile == null) {
                throw new InvalidDataException(DebuggerBundle.message((String)"error.breakpoint.file.not.found", (Object[])new Object[]{string}));
            }
        }
        catch (Exception exception) {
            throw BreakpointManager.b(exception);
        }
        Document document = FileDocumentManager.getInstance().getDocument(virtualFile);
        try {
            if (document == null) {
                throw new InvalidDataException(DebuggerBundle.message((String)"error.cannot.load.breakpoint.file", (Object[])new Object[]{string}));
            }
        }
        catch (Exception exception) {
            throw BreakpointManager.b(exception);
        }
        try {
            n2 = Integer.parseInt(element.getAttributeValue("line"));
        }
        catch (Exception exception) {
            throw new InvalidDataException("Line number is invalid for breakpoint");
        }
        return this.a(clazz, document, n2);
    }

    public static void addBreakpoint(@NotNull Breakpoint breakpoint) {
        block7: {
            try {
                if (breakpoint == null) {
                    BreakpointManager.a(9);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            try {
                try {
                    if ($assertionsDisabled || breakpoint.myXBreakpoint.getUserData(Breakpoint.DATA_KEY) == breakpoint) break block7;
                }
                catch (IllegalStateException illegalStateException) {
                    throw BreakpointManager.b(illegalStateException);
                }
                throw new AssertionError();
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
        }
        breakpoint.updateUI();
        BreakpointManager.a(breakpoint.myXBreakpoint);
    }

    public void removeBreakpoint(@Nullable Breakpoint breakpoint) {
        try {
            if (breakpoint == null) {
                return;
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        WriteAction.run(() -> this.a().removeBreakpoint(breakpoint.myXBreakpoint));
    }

    public void writeExternal(@NotNull Element element) {
        try {
            if (element == null) {
                BreakpointManager.a(10);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        for (Element element2 : this.g.values()) {
            Element element3 = element2.clone();
            try {
                if (element3.getAttribute("converted") == null) {
                    element3.setAttribute("converted", "true");
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            element.addContent(element3);
        }
    }

    @NotNull
    public List<Breakpoint> getBreakpoints() {
        List list;
        try {
            list = (List)ReadAction.compute(() -> ContainerUtil.mapNotNull((Object[])this.a().getAllBreakpoints(), BreakpointManager::getJavaBreakpoint));
            if (list == null) {
                BreakpointManager.a(11);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        return list;
    }

    @Nullable
    public static Breakpoint getJavaBreakpoint(@Nullable XBreakpoint xBreakpoint) {
        Breakpoint breakpoint;
        block5: {
            try {
                if (xBreakpoint == null) {
                    return null;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            breakpoint = (Breakpoint)xBreakpoint.getUserData(Breakpoint.DATA_KEY);
            try {
                if (breakpoint != null || !(xBreakpoint.getType() instanceof JavaBreakpointType)) break block5;
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            Project project2 = ((XBreakpointBase)xBreakpoint).getProject();
            breakpoint = ((JavaBreakpointType)xBreakpoint.getType()).createJavaBreakpoint(project2, xBreakpoint);
            xBreakpoint.putUserData(Breakpoint.DATA_KEY, breakpoint);
        }
        return breakpoint;
    }

    public void disableBreakpoints(@NotNull DebugProcessImpl debugProcessImpl) {
        try {
            if (debugProcessImpl == null) {
                BreakpointManager.a(12);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        List<Breakpoint> list = this.getBreakpoints();
        if (!list.isEmpty()) {
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            for (Breakpoint breakpoint : list) {
                breakpoint.markVerified(requestManagerImpl.isVerified(breakpoint));
                requestManagerImpl.deleteRequest(breakpoint);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    public void enableBreakpoints(DebugProcessImpl debugProcessImpl) {
        List<Breakpoint> list = this.getBreakpoints();
        if (!list.isEmpty()) {
            for (Breakpoint breakpoint : list) {
                breakpoint.markVerified(false);
                breakpoint.createRequest(debugProcessImpl);
            }
            SwingUtilities.invokeLater(this::updateBreakpointsUI);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void applyThreadFilter(@NotNull DebugProcessImpl debugProcessImpl, @Nullable ThreadReference threadReference) {
        RequestManagerImpl requestManagerImpl;
        block15: {
            try {
                if (debugProcessImpl == null) {
                    BreakpointManager.a(13);
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            requestManagerImpl = debugProcessImpl.getRequestsManager();
            ThreadReference threadReference2 = requestManagerImpl.getFilterThread();
            try {
                if (Comparing.equal((Object)threadReference, (Object)threadReference2)) {
                    return;
                }
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            try {
                requestManagerImpl.setFilterThread(threadReference);
                if (threadReference != null && threadReference2 == null) break block15;
            }
            catch (IllegalStateException illegalStateException) {
                throw BreakpointManager.b(illegalStateException);
            }
            List<Breakpoint> list = this.getBreakpoints();
            for (Breakpoint breakpoint : list) {
                try {
                    try {
                        if (!LineBreakpoint.CATEGORY.equals(breakpoint.getCategory()) && !MethodBreakpoint.CATEGORY.equals(breakpoint.getCategory())) continue;
                    }
                    catch (IllegalStateException illegalStateException) {
                        throw BreakpointManager.b(illegalStateException);
                    }
                    requestManagerImpl.deleteRequest(breakpoint);
                    breakpoint.createRequest(debugProcessImpl);
                }
                catch (IllegalStateException illegalStateException) {
                    throw BreakpointManager.b(illegalStateException);
                }
            }
            return;
        }
        EventRequestManager eventRequestManager = requestManagerImpl.getVMRequestManager();
        try {
            if (eventRequestManager == null) return;
            BreakpointManager.a(eventRequestManager.breakpointRequests(), (T breakpointRequest) -> breakpointRequest.addThreadFilter(threadReference));
            BreakpointManager.a(eventRequestManager.methodEntryRequests(), (T methodEntryRequest) -> methodEntryRequest.addThreadFilter(threadReference));
            BreakpointManager.a(eventRequestManager.methodExitRequests(), (T methodExitRequest) -> methodExitRequest.addThreadFilter(threadReference));
            return;
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
    }

    private static <T extends EventRequest> void a(@NotNull List<T> list, Consumer<T> consumer) {
        try {
            if (list == null) {
                BreakpointManager.a(14);
            }
        }
        catch (InternalException internalException) {
            throw BreakpointManager.b(internalException);
        }
        for (EventRequest eventRequest : list) {
            try {
                boolean bl2 = eventRequest.isEnabled();
                try {
                    if (bl2) {
                        eventRequest.disable();
                    }
                }
                catch (InternalException internalException) {
                    throw BreakpointManager.b(internalException);
                }
                try {
                    consumer.accept(eventRequest);
                    if (!bl2) continue;
                    eventRequest.enable();
                }
                catch (InternalException internalException) {
                    throw BreakpointManager.b(internalException);
                }
            }
            catch (InternalException | InvalidRequestStateException runtimeException) {
                i.info((Throwable)runtimeException);
            }
        }
    }

    public void updateBreakpointsUI() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::updateUI);
    }

    public void reloadBreakpoints() {
        ApplicationManager.getApplication().assertIsDispatchThread();
        this.getBreakpoints().forEach(Breakpoint::reload);
    }

    public void fireBreakpointChanged(Breakpoint breakpoint) {
        breakpoint.reload();
        breakpoint.updateUI();
    }

    @Nullable
    public Breakpoint findMasterBreakpoint(@NotNull Breakpoint breakpoint) {
        try {
            if (breakpoint == null) {
                BreakpointManager.a(15);
            }
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        XDependentBreakpointManager xDependentBreakpointManager = ((XBreakpointManagerImpl)this.a()).getDependentBreakpointManager();
        return BreakpointManager.getJavaBreakpoint(xDependentBreakpointManager.getMasterBreakpoint(breakpoint.myXBreakpoint));
    }

    public String getProperty(String string) {
        return this.h.get(string);
    }

    public String setProperty(String string, String string2) {
        return this.h.put(string, string2);
    }

    static {
        boolean bl2;
        try {
            bl2 = !BreakpointManager.class.desiredAssertionStatus();
        }
        catch (IllegalStateException illegalStateException) {
            throw BreakpointManager.b(illegalStateException);
        }
        $assertionsDisabled = bl2;
        i = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointManager");
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void a(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

