/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerInvocationUtil;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.JVMNameUtil;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerContextImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.jsp.JspFile;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XLineBreakpoint;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.request.BreakpointRequest;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.breakpoints.properties.JavaBreakpointProperties;

/*
 * Exception performing whole class analysis ignored.
 */
public abstract class BreakpointWithHighlighter<P extends JavaBreakpointProperties>
extends Breakpoint<P> {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.BreakpointWithHighlighter");
    @Nullable
    private SourcePosition d;
    private boolean i;
    private volatile Icon f;
    @Nullable
    private String e;
    @Nullable
    private String h;
    @Nullable
    private String g;

    protected abstract void createRequestForPreparedClass(DebugProcessImpl var1, ReferenceType var2);

    protected abstract Icon getDisabledIcon(boolean var1);

    protected abstract Icon getInvalidIcon(boolean var1);

    protected Icon getSetIcon(boolean bl2) {
        return null;
    }

    protected abstract Icon getVerifiedIcon(boolean var1);

    protected abstract Icon getVerifiedWarningsIcon(boolean var1);

    @Override
    public Icon getIcon() {
        return this.f;
    }

    @Override
    @Nullable
    public String getClassName() {
        return this.e;
    }

    @Override
    @Nullable
    public String getShortClassName() {
        block4: {
            SourcePosition sourcePosition = this.getSourcePosition();
            try {
                try {
                    if (sourcePosition == null || !(sourcePosition.getFile() instanceof JspFile)) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                return this.getClassName();
            }
            catch (InvalidDataException invalidDataException) {
                throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
            }
        }
        return super.getShortClassName();
    }

    @Override
    @Nullable
    public String getPackageName() {
        return this.h;
    }

    @Nullable
    public BreakpointWithHighlighter init() {
        try {
            if (!this.isValid()) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        try {
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                this.updateUI();
                this.c();
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return this;
    }

    private void b(@Nullable DebugProcessImpl debugProcessImpl) {
        this.f = this.c(debugProcessImpl);
        this.e = JVMNameUtil.getSourcePositionClassDisplayName(debugProcessImpl, this.getSourcePosition());
        this.h = JVMNameUtil.getSourcePositionPackageDisplayName(debugProcessImpl, this.getSourcePosition());
    }

    private Icon c(@Nullable DebugProcessImpl debugProcessImpl) {
        boolean bl2;
        boolean bl3;
        block28: {
            block29: {
                boolean bl4;
                RequestManagerImpl requestManagerImpl;
                block27: {
                    block26: {
                        boolean bl5;
                        block25: {
                            block24: {
                                try {
                                    try {
                                        if (debugProcessImpl == null || !this.isMuted(debugProcessImpl)) break block24;
                                    }
                                    catch (InvalidDataException invalidDataException) {
                                        throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                                    }
                                    bl5 = true;
                                    break block25;
                                }
                                catch (InvalidDataException invalidDataException) {
                                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                                }
                            }
                            bl5 = false;
                        }
                        bl3 = bl5;
                        try {
                            if (!this.isEnabled()) {
                                return this.getDisabledIcon(bl3);
                            }
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                        try {
                            this.g = "";
                            if (!this.isValid()) {
                                return this.getInvalidIcon(bl3);
                            }
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                        try {
                            if (debugProcessImpl == null) {
                                return this.getSetIcon(bl3);
                            }
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                        requestManagerImpl = debugProcessImpl.getRequestsManager();
                        try {
                            try {
                                if (!this.myCachedVerifiedState && !requestManagerImpl.isVerified(this)) break block26;
                            }
                            catch (InvalidDataException invalidDataException) {
                                throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                            }
                            bl4 = true;
                            break block27;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                    }
                    bl4 = false;
                }
                bl2 = bl4;
                String string = requestManagerImpl.getWarning(this);
                try {
                    try {
                        if (string == null) break block28;
                        this.g = string;
                        if (bl2) break block29;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                    }
                    return this.getInvalidIcon(bl3);
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
            }
            return this.getVerifiedWarningsIcon(bl3);
        }
        try {
            if (bl2) {
                return this.getVerifiedIcon(bl3);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return this.getSetIcon(bl3);
    }

    protected BreakpointWithHighlighter(@NotNull Project project2, XBreakpoint xBreakpoint) {
        if (project2 == null) {
            BreakpointWithHighlighter.b(0);
        }
        super(project2, xBreakpoint);
        this.i = true;
        this.f = this.getSetIcon(false);
        ApplicationManager.getApplication().runReadAction(this::reload);
    }

    @Override
    public boolean isValid() {
        return BreakpointWithHighlighter.isPositionValid(this.myXBreakpoint.getSourcePosition());
    }

    protected static boolean isPositionValid(@Nullable XSourcePosition xSourcePosition) {
        return (Boolean)ReadAction.compute(() -> {
            boolean bl2;
            block5: {
                block4: {
                    try {
                        try {
                            if (xSourcePosition == null || !xSourcePosition.getFile().isValid()) break block4;
                        }
                        catch (RuntimeException runtimeException) {
                            throw BreakpointWithHighlighter.b(runtimeException);
                        }
                        bl2 = true;
                        break block5;
                    }
                    catch (RuntimeException runtimeException) {
                        throw BreakpointWithHighlighter.b(runtimeException);
                    }
                }
                bl2 = false;
            }
            return bl2;
        });
    }

    @Nullable
    public SourcePosition getSourcePosition() {
        return this.d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public String getDescription() {
        ClassFilter[] classFilterArray;
        Object[] objectArray;
        StringBuilder stringBuilder = StringBuilderSpinAllocator.alloc();
        try {
            try {
                stringBuilder.append(this.getDisplayName());
                if (this.isCountFilterEnabled()) {
                    stringBuilder.append("&nbsp;<br>&nbsp;");
                    stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.pass.count", (Object[])new Object[0])).append(": ");
                    stringBuilder.append(this.getCountFilter());
                }
            }
            catch (InvalidDataException invalidDataException) {
                throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
            }
            if (this.isClassFiltersEnabled()) {
                stringBuilder.append("&nbsp;<br>&nbsp;");
                stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.class.filters", (Object[])new Object[0])).append(": ");
                for (ClassFilter classFilter : objectArray = this.getClassFilters()) {
                    stringBuilder.append(classFilter.getPattern()).append(" ");
                }
            }
            if (this.isInstanceFiltersEnabled()) {
                stringBuilder.append("&nbsp;<br>&nbsp;");
                stringBuilder.append(DebuggerBundle.message((String)"breakpoint.property.name.instance.filters", (Object[])new Object[0]));
                for (ClassFilter classFilter : objectArray = this.getInstanceFilters()) {
                    stringBuilder.append(Long.toString(classFilter.getId())).append(" ");
                }
            }
            objectArray = stringBuilder.toString();
        }
        catch (Throwable throwable) {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
            throw throwable;
        }
        try {
            StringBuilderSpinAllocator.dispose((StringBuilder)stringBuilder);
            classFilterArray = objectArray;
            if (objectArray == null) {
                BreakpointWithHighlighter.b(1);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return classFilterArray;
    }

    @Override
    public void reload() {
        try {
            ApplicationManager.getApplication().assertReadAccessAllowed();
            this.d = DebuggerUtilsEx.toSourcePosition(this.myXBreakpoint.getSourcePosition(), this.myProject);
            if (this.d != null) {
                this.reload(this.d.getFile());
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
    }

    @Nullable
    static BreakpointRequest createLocationBreakpointRequest(@NotNull FilteredRequestor filteredRequestor, @Nullable Location location, @NotNull DebugProcessImpl debugProcessImpl) {
        try {
            if (filteredRequestor == null) {
                BreakpointWithHighlighter.b(2);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        try {
            if (debugProcessImpl == null) {
                BreakpointWithHighlighter.b(3);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        if (location != null) {
            RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
            BreakpointRequest breakpointRequest = requestManagerImpl.createBreakpointRequest(filteredRequestor, location);
            requestManagerImpl.enableRequest(breakpointRequest);
            return breakpointRequest;
        }
        return null;
    }

    @Override
    public void createRequest(@NotNull DebugProcessImpl debugProcessImpl) {
        block12: {
            block11: {
                try {
                    if (debugProcessImpl == null) {
                        BreakpointWithHighlighter.b(4);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                try {
                    DebuggerManagerThreadImpl.assertIsManagerThread();
                    if (!this.shouldCreateRequest(debugProcessImpl)) {
                        return;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                try {
                    if (!this.isValid()) {
                        return;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                SourcePosition sourcePosition = this.getSourcePosition();
                try {
                    if (sourcePosition == null) break block11;
                    this.createOrWaitPrepare(debugProcessImpl, sourcePosition);
                    break block12;
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
            }
            c.error("Unable to create request for breakpoint with null position: " + this.toString() + " at " + this.myXBreakpoint.getSourcePosition());
        }
        this.updateUI();
    }

    protected boolean isMuted(@NotNull DebugProcessImpl debugProcessImpl) {
        try {
            if (debugProcessImpl == null) {
                BreakpointWithHighlighter.b(5);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return debugProcessImpl.areBreakpointsMuted();
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
        DebugProcessImpl debugProcessImpl = (DebugProcessImpl)debugProcess;
        try {
            if (this.shouldCreateRequest(debugProcessImpl, true)) {
                this.createRequestForPreparedClass(debugProcessImpl, referenceType);
                this.updateUI();
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
    }

    @Override
    public final void updateUI() {
        block4: {
            try {
                try {
                    if (this.isVisible() && !ApplicationManager.getApplication().isUnitTestMode()) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                return;
            }
            catch (InvalidDataException invalidDataException) {
                throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
            }
        }
        DebuggerInvocationUtil.swingInvokeLater(this.myProject, () -> {
            block8: {
                DebugProcessImpl debugProcessImpl;
                block7: {
                    try {
                        if (!this.isValid()) {
                            return;
                        }
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                    }
                    DebuggerContextImpl debuggerContextImpl = DebuggerManagerEx.getInstanceEx(this.myProject).getContext();
                    debugProcessImpl = debuggerContextImpl.getDebugProcess();
                    try {
                        try {
                            if (debugProcessImpl != null && debugProcessImpl.isAttached()) break block7;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                        this.b(null);
                        this.c();
                        break block8;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                    }
                }
                debugProcessImpl.getManagerThread().invoke(new DebuggerCommandImpl(){

                    @Override
                    protected void action() throws Exception {
                        ApplicationManager.getApplication().runReadAction(() -> {
                            if (!BreakpointWithHighlighter.this.myProject.isDisposed()) {
                                BreakpointWithHighlighter.this.b(debugProcessImpl);
                            }
                        });
                        DebuggerInvocationUtil.swingInvokeLater(BreakpointWithHighlighter.this.myProject, () -> BreakpointWithHighlighter.this.c());
                    }
                });
            }
        });
    }

    private void c() {
        block4: {
            try {
                try {
                    if (!this.isVisible() || !this.isValid()) break block4;
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                XDebuggerManager.getInstance((Project)this.myProject).getBreakpointManager().updateBreakpointPresentation((XLineBreakpoint)this.myXBreakpoint, this.getIcon(), this.g);
            }
            catch (InvalidDataException invalidDataException) {
                throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
            }
        }
    }

    public boolean isAt(@NotNull Document document, int n2) {
        boolean bl2;
        block10: {
            block9: {
                try {
                    if (document == null) {
                        BreakpointWithHighlighter.b(6);
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
                VirtualFile virtualFile = FileDocumentManager.getInstance().getFile(document);
                int n3 = document.getLineNumber(n2);
                XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
                try {
                    try {
                        try {
                            if (xSourcePosition == null || xSourcePosition.getLine() != n3) break block9;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                        }
                        if (!xSourcePosition.getFile().equals(virtualFile)) break block9;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                    }
                    bl2 = true;
                    break block10;
                }
                catch (InvalidDataException invalidDataException) {
                    throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
                }
            }
            bl2 = false;
        }
        return bl2;
    }

    protected void reload(PsiFile psiFile) {
    }

    @Override
    public PsiClass getPsiClass() {
        SourcePosition sourcePosition = this.getSourcePosition();
        return BreakpointWithHighlighter.getPsiClassAt(sourcePosition);
    }

    protected static PsiClass getPsiClassAt(@Nullable SourcePosition sourcePosition) {
        return (PsiClass)ReadAction.compute(() -> JVMNameUtil.getClassAt(sourcePosition));
    }

    @Override
    public abstract Key<? extends BreakpointWithHighlighter> getCategory();

    protected boolean isVisible() {
        return this.i;
    }

    public void setVisible(boolean bl2) {
        this.i = bl2;
    }

    @Nullable
    public Document getDocument() {
        PsiFile psiFile = DebuggerUtilsEx.getPsiFile(this.myXBreakpoint.getSourcePosition(), this.myProject);
        try {
            if (psiFile != null) {
                return PsiDocumentManager.getInstance((Project)this.myProject).getDocument(psiFile);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return null;
    }

    public int getLineIndex() {
        int n2;
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        try {
            n2 = xSourcePosition != null ? xSourcePosition.getLine() : -1;
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return n2;
    }

    protected String getFileName() {
        String string;
        XSourcePosition xSourcePosition = this.myXBreakpoint.getSourcePosition();
        try {
            string = xSourcePosition != null ? xSourcePosition.getFile().getName() : "";
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        return string;
    }

    @Override
    public void readExternal(@NotNull Element element) throws InvalidDataException {
        try {
            if (element == null) {
                BreakpointWithHighlighter.b(7);
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        super.readExternal(element);
        String string = element.getAttributeValue("class");
        try {
            if (string != null) {
                this.e = string;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
        String string2 = element.getAttributeValue("package");
        try {
            if (string2 != null) {
                this.h = string2;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw BreakpointWithHighlighter.b((RuntimeException)((Object)invalidDataException));
        }
    }

    public String toString() {
        return (String)ReadAction.compute(() -> "<html><body>" + this.getDescription() + "</body>" + "</html>");
    }

    /*
     * Exception decompiling
     */
    private static /* synthetic */ void b(int var0) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 6[SWITCH]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1050)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static RuntimeException b(RuntimeException runtimeException) {
        return runtimeException;
    }
}

