/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.DebuggerBundle;
import com.intellij.debugger.DebuggerManagerEx;
import com.intellij.debugger.SourcePosition;
import com.intellij.debugger.engine.DebugProcess;
import com.intellij.debugger.engine.DebugProcessImpl;
import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.DebuggerUtils;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.debugger.engine.evaluation.EvaluateException;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.requests.RequestManagerImpl;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.BreakpointCategory;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.Key;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.Mirror;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.event.ExceptionEvent;
import com.sun.jdi.event.LocatableEvent;
import javax.swing.Icon;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.java.debugger.breakpoints.properties.JavaExceptionBreakpointProperties;

public class ExceptionBreakpoint
extends Breakpoint<JavaExceptionBreakpointProperties> {
    private static final Logger c = Logger.getInstance((String)"#com.intellij.debugger.ui.breakpoints.ExceptionBreakpoint");
    protected static final String READ_NO_CLASS_NAME = DebuggerBundle.message((String)"error.absent.exception.breakpoint.class.name", (Object[])new Object[0]);
    @NonNls
    public static final Key<ExceptionBreakpoint> CATEGORY = BreakpointCategory.lookup("exception_breakpoints");

    public ExceptionBreakpoint(Project project2, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
    }

    @Override
    public Key<? extends ExceptionBreakpoint> getCategory() {
        return CATEGORY;
    }

    protected ExceptionBreakpoint(Project project2, String string, String string2, XBreakpoint<JavaExceptionBreakpointProperties> xBreakpoint) {
        super(project2, xBreakpoint);
        this.setQualifiedName(string);
        if (string2 == null) {
            this.setPackageName(ExceptionBreakpoint.a(string));
        } else {
            this.setPackageName(string2);
        }
    }

    private static String a(String string) {
        String string2;
        try {
            if (string == null) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
        }
        int n2 = string.lastIndexOf(46);
        try {
            string2 = n2 >= 0 ? string.substring(0, n2) : "";
        }
        catch (InvalidDataException invalidDataException) {
            throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
        }
        return string2;
    }

    @Override
    public String getClassName() {
        return this.a();
    }

    @Override
    public String getPackageName() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName;
    }

    @Override
    public PsiClass getPsiClass() {
        return (PsiClass)ReadAction.compute(() -> {
            PsiClass psiClass;
            try {
                psiClass = this.a() != null ? DebuggerUtils.findClass((String)this.a(), (Project)this.myProject, (GlobalSearchScope)GlobalSearchScope.allScope((Project)this.myProject)) : null;
            }
            catch (RuntimeException runtimeException) {
                throw ExceptionBreakpoint.c(runtimeException);
            }
            return psiClass;
        });
    }

    @Override
    public String getDisplayName() {
        return DebuggerBundle.message((String)"breakpoint.exception.breakpoint.display.name", (Object[])new Object[]{this.a()});
    }

    @Override
    public Icon getIcon() {
        if (!this.isEnabled()) {
            Icon icon;
            Breakpoint breakpoint = DebuggerManagerEx.getInstanceEx(this.myProject).getBreakpointManager().findMasterBreakpoint(this);
            try {
                icon = breakpoint == null ? AllIcons.Debugger.Db_disabled_exception_breakpoint : AllIcons.Debugger.Db_dep_exception_breakpoint;
            }
            catch (InvalidDataException invalidDataException) {
                throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
            }
            return icon;
        }
        return AllIcons.Debugger.Db_exception_breakpoint;
    }

    @Override
    public void reload() {
    }

    @Override
    public void createRequest(DebugProcessImpl debugProcessImpl) {
        block6: {
            SourcePosition sourcePosition;
            block5: {
                try {
                    DebuggerManagerThreadImpl.assertIsManagerThread();
                    if (!this.shouldCreateRequest(debugProcessImpl)) {
                        return;
                    }
                }
                catch (InvalidDataException invalidDataException) {
                    throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
                }
                sourcePosition = (SourcePosition)ReadAction.compute(() -> {
                    SourcePosition sourcePosition;
                    PsiClass psiClass = DebuggerUtils.findClass((String)this.a(), (Project)this.myProject, (GlobalSearchScope)debugProcessImpl.getSearchScope());
                    try {
                        sourcePosition = psiClass != null ? SourcePosition.createFromElement((PsiElement)psiClass) : null;
                    }
                    catch (RuntimeException runtimeException) {
                        throw ExceptionBreakpoint.c(runtimeException);
                    }
                    return sourcePosition;
                });
                try {
                    if (sourcePosition != null) break block5;
                    this.createOrWaitPrepare(debugProcessImpl, this.a());
                    break block6;
                }
                catch (InvalidDataException invalidDataException) {
                    throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
                }
            }
            this.createOrWaitPrepare(debugProcessImpl, sourcePosition);
        }
    }

    @Override
    public void processClassPrepare(DebugProcess debugProcess, ReferenceType referenceType) {
        block5: {
            DebugProcessImpl debugProcessImpl = (DebugProcessImpl)debugProcess;
            if (this.shouldCreateRequest(debugProcessImpl, true)) {
                block6: {
                    RequestManagerImpl requestManagerImpl = debugProcessImpl.getRequestsManager();
                    try {
                        try {
                            requestManagerImpl.enableRequest(requestManagerImpl.createExceptionRequest(this, referenceType, this.c(), this.b()));
                            if (!c.isDebugEnabled()) break block5;
                            if (referenceType == null) break block6;
                        }
                        catch (InvalidDataException invalidDataException) {
                            throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
                        }
                        c.debug("Created exception request for reference type " + referenceType.name());
                        break block5;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
                    }
                }
                c.debug("Created exception request for reference type null");
            }
        }
    }

    @Override
    protected ObjectReference getThisObject(SuspendContextImpl suspendContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        try {
            if (locatableEvent instanceof ExceptionEvent) {
                return ((ExceptionEvent)locatableEvent).exception();
            }
        }
        catch (EvaluateException evaluateException) {
            throw ExceptionBreakpoint.c((Exception)((Object)evaluateException));
        }
        return super.getThisObject(suspendContextImpl, locatableEvent);
    }

    @Override
    public String getEventMessage(LocatableEvent locatableEvent) {
        String string;
        Mirror mirror;
        String string2;
        try {
            string2 = this.a() != null ? this.a() : "java.lang.Throwable";
        }
        catch (Exception exception) {
            throw ExceptionBreakpoint.c(exception);
        }
        String string3 = string2;
        String string4 = null;
        if (locatableEvent instanceof ExceptionEvent) {
            mirror = (ExceptionEvent)locatableEvent;
            try {
                string3 = mirror.exception().type().name();
                string4 = mirror.thread().name();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        mirror = locatableEvent.location();
        String string5 = DebuggerUtilsEx.getLocationMethodQName((Location)mirror);
        try {
            String string6 = mirror.sourceName();
            int n2 = DebuggerUtilsEx.getLineNumber((Location)mirror, false);
            string = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info", (Object[])new Object[]{string6, n2});
        }
        catch (AbsentInformationException absentInformationException) {
            string = DebuggerBundle.message((String)"exception.breakpoint.console.message.location.info.absent", (Object[])new Object[0]);
        }
        try {
            if (string4 != null) {
                return DebuggerBundle.message((String)"exception.breakpoint.console.message.with.thread.info", (Object[])new Object[]{string3, string4, string5, string});
            }
        }
        catch (Exception exception) {
            throw ExceptionBreakpoint.c(exception);
        }
        return DebuggerBundle.message((String)"exception.breakpoint.console.message", (Object[])new Object[]{string3, string5, string});
    }

    @Override
    public boolean evaluateCondition(EvaluationContextImpl evaluationContextImpl, LocatableEvent locatableEvent) throws EvaluateException {
        block6: {
            try {
                if (!((JavaExceptionBreakpointProperties)((Object)this.getProperties())).isCatchFiltersEnabled() || !(locatableEvent instanceof ExceptionEvent)) break block6;
            }
            catch (EvaluateException evaluateException) {
                throw ExceptionBreakpoint.c((Exception)((Object)evaluateException));
            }
            Location location = ((ExceptionEvent)locatableEvent).catchLocation();
            try {
                try {
                    if (location == null || ExceptionBreakpoint.typeMatchesClassFilters(location.declaringType().name(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassFilters(), ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).getCatchClassExclusionFilters())) break block6;
                }
                catch (EvaluateException evaluateException) {
                    throw ExceptionBreakpoint.c((Exception)((Object)evaluateException));
                }
                return false;
            }
            catch (EvaluateException evaluateException) {
                throw ExceptionBreakpoint.c((Exception)((Object)evaluateException));
            }
        }
        return super.evaluateCondition(evaluationContextImpl, locatableEvent);
    }

    @Override
    public boolean isValid() {
        return true;
    }

    @Override
    public PsiElement getEvaluationElement() {
        try {
            if (this.getClassName() == null) {
                return null;
            }
        }
        catch (InvalidDataException invalidDataException) {
            throw ExceptionBreakpoint.c((Exception)((Object)invalidDataException));
        }
        return JavaPsiFacade.getInstance((Project)this.myProject).findClass(this.getClassName(), GlobalSearchScope.allScope((Project)this.myProject));
    }

    @Override
    public void readExternal(Element element) throws InvalidDataException {
        String string;
        ExceptionBreakpoint exceptionBreakpoint;
        super.readExternal(element);
        String string2 = element.getAttributeValue("package_name");
        try {
            exceptionBreakpoint = this;
            string = string2 != null ? string2 : ExceptionBreakpoint.a(string2);
        }
        catch (Exception exception) {
            throw ExceptionBreakpoint.c(exception);
        }
        exceptionBreakpoint.setPackageName(string);
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"NOTIFY_CAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT = Boolean.valueOf(JDOMExternalizerUtil.readField((Element)element, (String)"NOTIFY_UNCAUGHT"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string3 = element.getAttributeValue("class_name");
        try {
            this.setQualifiedName(string3);
            if (string3 == null) {
                throw new InvalidDataException(READ_NO_CLASS_NAME);
            }
        }
        catch (Exception exception) {
            throw ExceptionBreakpoint.c(exception);
        }
    }

    private boolean c() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_CAUGHT;
    }

    private boolean b() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).NOTIFY_UNCAUGHT;
    }

    private String a() {
        return ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName;
    }

    void setQualifiedName(String string) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myQualifiedName = string;
    }

    void setPackageName(String string) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).myPackageName = string;
    }

    public void setCatchFiltersEnabled(boolean bl2) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchFiltersEnabled(bl2);
    }

    public void setCatchClassFilters(ClassFilter[] classFilterArray) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassFilters(classFilterArray);
    }

    public void setCatchClassExclusionFilters(ClassFilter[] classFilterArray) {
        ((JavaExceptionBreakpointProperties)((Object)this.getProperties())).setCatchClassExclusionFilters(classFilterArray);
    }

    private static Exception c(Exception exception) {
        return exception;
    }
}

