/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.ui.breakpoints;

import com.intellij.debugger.InstanceFilter;
import com.intellij.debugger.engine.evaluation.CodeFragmentKind;
import com.intellij.debugger.engine.evaluation.TextWithImports;
import com.intellij.debugger.engine.evaluation.TextWithImportsImpl;
import com.intellij.debugger.engine.events.SuspendContextCommandImpl;
import com.intellij.debugger.engine.requests.LocatableEventRequestor;
import com.intellij.debugger.impl.DebuggerUtilsEx;
import com.intellij.debugger.ui.breakpoints.Breakpoint;
import com.intellij.debugger.ui.breakpoints.FilteredRequestor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.DefaultJDOMExternalizer;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.JDOMExternalizerUtil;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.ui.classFilter.ClassFilter;
import com.intellij.xdebugger.impl.XDebuggerHistoryManager;
import com.intellij.xdebugger.impl.breakpoints.XBreakpointBase;
import com.sun.jdi.event.LocatableEvent;
import java.util.ArrayList;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class FilteredRequestorImpl
implements JDOMExternalizable,
FilteredRequestor {
    public String SUSPEND_POLICY;
    public boolean SUSPEND;
    public boolean COUNT_FILTER_ENABLED;
    public int COUNT_FILTER;
    public boolean CONDITION_ENABLED;
    private TextWithImports a;
    public boolean CLASS_FILTERS_ENABLED;
    private ClassFilter[] g;
    private ClassFilter[] h;
    public boolean INSTANCE_FILTERS_ENABLED;
    private InstanceFilter[] f;
    @NonNls
    private static final String e = "filter";
    @NonNls
    private static final String d = "exclusion_filter";
    @NonNls
    private static final String b = "instance_id";
    @NonNls
    private static final String c = "CONDITION";
    protected final Project myProject;

    public FilteredRequestorImpl(@NotNull Project project2) {
        if (project2 == null) {
            FilteredRequestorImpl.a(0);
        }
        this.SUSPEND_POLICY = "SuspendAll";
        this.SUSPEND = true;
        this.COUNT_FILTER_ENABLED = false;
        this.COUNT_FILTER = 0;
        this.CONDITION_ENABLED = false;
        this.CLASS_FILTERS_ENABLED = false;
        this.g = ClassFilter.EMPTY_ARRAY;
        this.h = ClassFilter.EMPTY_ARRAY;
        this.INSTANCE_FILTERS_ENABLED = false;
        this.f = InstanceFilter.EMPTY_ARRAY;
        this.myProject = project2;
        this.a = new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, "");
    }

    @Override
    public InstanceFilter[] getInstanceFilters() {
        return this.f;
    }

    public void setInstanceFilters(InstanceFilter[] instanceFilterArray) {
        InstanceFilter[] instanceFilterArray2;
        try {
            FilteredRequestorImpl filteredRequestorImpl = this;
            instanceFilterArray2 = instanceFilterArray != null ? instanceFilterArray : InstanceFilter.EMPTY_ARRAY;
        }
        catch (InvalidDataException invalidDataException) {
            throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
        }
        filteredRequestorImpl.f = instanceFilterArray2;
    }

    @Override
    public String getSuspendPolicy() {
        String string;
        try {
            string = this.SUSPEND ? this.SUSPEND_POLICY : "SuspendNone";
        }
        catch (InvalidDataException invalidDataException) {
            throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
        }
        return string;
    }

    @Override
    public final ClassFilter[] getClassFilters() {
        return this.g;
    }

    public final void setClassFilters(ClassFilter[] classFilterArray) {
        ClassFilter[] classFilterArray2;
        try {
            FilteredRequestorImpl filteredRequestorImpl = this;
            classFilterArray2 = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
        }
        catch (InvalidDataException invalidDataException) {
            throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
        }
        filteredRequestorImpl.g = classFilterArray2;
    }

    @Override
    public ClassFilter[] getClassExclusionFilters() {
        return this.h;
    }

    public void setClassExclusionFilters(ClassFilter[] classFilterArray) {
        ClassFilter[] classFilterArray2;
        try {
            FilteredRequestorImpl filteredRequestorImpl = this;
            classFilterArray2 = classFilterArray != null ? classFilterArray : ClassFilter.EMPTY_ARRAY;
        }
        catch (InvalidDataException invalidDataException) {
            throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
        }
        filteredRequestorImpl.h = classFilterArray2;
    }

    public void readTo(Element element, Breakpoint breakpoint) throws InvalidDataException {
        block8: {
            block7: {
                block6: {
                    try {
                        this.readExternal(element);
                        if (!this.SUSPEND) break block6;
                        breakpoint.setSuspendPolicy(this.SUSPEND_POLICY);
                        break block7;
                    }
                    catch (InvalidDataException invalidDataException) {
                        throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
                    }
                }
                breakpoint.setSuspendPolicy("SuspendNone");
            }
            try {
                try {
                    breakpoint.setCountFilterEnabled(this.COUNT_FILTER_ENABLED);
                    breakpoint.setCountFilter(this.COUNT_FILTER);
                    breakpoint.setCondition(this.a);
                    ((XBreakpointBase)breakpoint.myXBreakpoint).setConditionEnabled(this.CONDITION_ENABLED);
                    if (this.a == null || this.a.isEmpty()) break block8;
                }
                catch (InvalidDataException invalidDataException) {
                    throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
                }
                XDebuggerHistoryManager.getInstance((Project)this.myProject).addRecentExpression("breakpointCondition", TextWithImportsImpl.toXExpression(this.a));
            }
            catch (InvalidDataException invalidDataException) {
                throw FilteredRequestorImpl.b((Exception)((Object)invalidDataException));
            }
        }
        breakpoint.setClassFiltersEnabled(this.CLASS_FILTERS_ENABLED);
        breakpoint.setClassFilters(this.getClassFilters());
        breakpoint.setClassExclusionFilters(this.getClassExclusionFilters());
        breakpoint.setInstanceFiltersEnabled(this.INSTANCE_FILTERS_ENABLED);
        breakpoint.setInstanceFilters(this.getInstanceFilters());
    }

    public void readExternal(Element element) throws InvalidDataException {
        InstanceFilter[] instanceFilterArray;
        try {
            DefaultJDOMExternalizer.readExternal((Object)this, (Element)element);
            if ("SuspendNone".equals(this.SUSPEND_POLICY)) {
                this.SUSPEND = false;
                this.SUSPEND_POLICY = "SuspendAll";
            }
        }
        catch (Exception exception) {
            throw FilteredRequestorImpl.b(exception);
        }
        String string = JDOMExternalizerUtil.readField((Element)element, (String)c);
        try {
            if (string != null) {
                this.setCondition(new TextWithImportsImpl(CodeFragmentKind.EXPRESSION, string));
            }
        }
        catch (Exception exception) {
            throw FilteredRequestorImpl.b(exception);
        }
        this.g = DebuggerUtilsEx.readFilters(element.getChildren(e));
        this.h = DebuggerUtilsEx.readFilters(element.getChildren(d));
        ClassFilter[] classFilterArray = DebuggerUtilsEx.readFilters(element.getChildren(b));
        ArrayList<InstanceFilter> arrayList = new ArrayList<InstanceFilter>(classFilterArray.length);
        for (ClassFilter classFilter : classFilterArray) {
            try {
                arrayList.add(InstanceFilter.create(classFilter));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        try {
            FilteredRequestorImpl filteredRequestorImpl = this;
            instanceFilterArray = arrayList.isEmpty() ? InstanceFilter.EMPTY_ARRAY : arrayList.toArray(new InstanceFilter[arrayList.size()]);
        }
        catch (Exception exception) {
            throw FilteredRequestorImpl.b(exception);
        }
        filteredRequestorImpl.f = instanceFilterArray;
    }

    public void writeExternal(Element element) throws WriteExternalException {
        DefaultJDOMExternalizer.writeExternal((Object)this, (Element)element);
        JDOMExternalizerUtil.writeField((Element)element, (String)c, (String)this.getCondition().toExternalForm());
        DebuggerUtilsEx.writeFilters(element, e, this.g);
        DebuggerUtilsEx.writeFilters(element, d, this.h);
        DebuggerUtilsEx.writeFilters(element, b, InstanceFilter.createClassFilters(this.f));
    }

    public TextWithImports getCondition() {
        return this.a;
    }

    public void setCondition(TextWithImports textWithImports) {
        this.a = textWithImports;
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public boolean isCountFilterEnabled() {
        return this.COUNT_FILTER_ENABLED;
    }

    @Override
    public int getCountFilter() {
        return this.COUNT_FILTER;
    }

    @Override
    public boolean isClassFiltersEnabled() {
        return this.CLASS_FILTERS_ENABLED;
    }

    @Override
    public boolean isInstanceFiltersEnabled() {
        return this.INSTANCE_FILTERS_ENABLED;
    }

    @Override
    public boolean processLocatableEvent(SuspendContextCommandImpl suspendContextCommandImpl, LocatableEvent locatableEvent) throws LocatableEventRequestor.EventProcessingException {
        return false;
    }

    private static /* synthetic */ void a(int n2) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "project", "com/intellij/debugger/ui/breakpoints/FilteredRequestorImpl", "<init>"));
    }

    private static Exception b(Exception exception) {
        return exception;
    }
}

